/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.pooled.impl;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BasicResponseHandler;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.pooled.PooledBoltConnectionProvider;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.PullSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.bolt.connection.values.Value;

public class PooledBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final PooledBoltConnectionProvider provider;
    private final Runnable releaseRunnable;
    private final Runnable purgeRunnable;
    private CompletableFuture<Void> closeFuture;

    public PooledBoltConnection(BoltConnection delegate, PooledBoltConnectionProvider provider, Runnable releaseRunnable, Runnable purgeRunnable) {
        this.delegate = Objects.requireNonNull(delegate);
        this.provider = Objects.requireNonNull(provider);
        this.releaseRunnable = Objects.requireNonNull(releaseRunnable);
        this.purgeRunnable = Objects.requireNonNull(purgeRunnable);
    }

    public CompletionStage<BoltConnection> onLoop() {
        return this.delegate.onLoop();
    }

    public CompletionStage<BoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.delegate.route(databaseName, impersonatedUser, bookmarks).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.delegate.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, txType, notificationConfig).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.delegate.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, parameters, txTimeout, txMetadata, notificationConfig).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> run(String query, Map<String, Value> parameters) {
        return this.delegate.run(query, parameters).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> pull(long qid, long request) {
        return this.delegate.pull(qid, request).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> discard(long qid, long number) {
        return this.delegate.discard(qid, number).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> commit() {
        return this.delegate.commit().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> rollback() {
        return this.delegate.rollback().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> reset() {
        return this.delegate.reset().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> logoff() {
        return this.delegate.logoff().thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> logon(AuthToken authToken) {
        return this.delegate.logon(authToken).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.delegate.telemetry(telemetryApi).thenApply(ignored -> this);
    }

    public CompletionStage<BoltConnection> clear() {
        return this.delegate.clear();
    }

    public CompletionStage<Void> flush(final ResponseHandler handler) {
        return this.delegate.flush(new ResponseHandler(){

            public void onError(Throwable throwable) {
                BoltFailureException boltFailureException;
                if (throwable instanceof BoltFailureException && "Neo.ClientError.Security.AuthorizationExpired".equals((boltFailureException = (BoltFailureException)throwable).code())) {
                    PooledBoltConnection.this.provider.onExpired();
                }
                handler.onError(throwable);
            }

            public void onBeginSummary(BeginSummary summary) {
                handler.onBeginSummary(summary);
            }

            public void onRunSummary(RunSummary summary) {
                handler.onRunSummary(summary);
            }

            public void onRecord(Value[] fields) {
                handler.onRecord(fields);
            }

            public void onPullSummary(PullSummary summary) {
                handler.onPullSummary(summary);
            }

            public void onDiscardSummary(DiscardSummary summary) {
                handler.onDiscardSummary(summary);
            }

            public void onCommitSummary(CommitSummary summary) {
                handler.onCommitSummary(summary);
            }

            public void onRollbackSummary(RollbackSummary summary) {
                handler.onRollbackSummary(summary);
            }

            public void onResetSummary(ResetSummary summary) {
                handler.onResetSummary(summary);
            }

            public void onRouteSummary(RouteSummary summary) {
                handler.onRouteSummary(summary);
            }

            public void onLogoffSummary(LogoffSummary summary) {
                handler.onLogoffSummary(summary);
            }

            public void onLogonSummary(LogonSummary summary) {
                handler.onLogonSummary(summary);
            }

            public void onTelemetrySummary(TelemetrySummary summary) {
                handler.onTelemetrySummary(summary);
            }

            public void onIgnored() {
                handler.onIgnored();
            }

            public void onComplete() {
                handler.onComplete();
            }
        }).whenComplete((ignored, throwable) -> {
            if (throwable != null && this.delegate.state() == BoltConnectionState.CLOSED) {
                this.purgeRunnable.run();
            }
        });
    }

    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason).whenComplete((closeResult, closeThrowable) -> this.purgeRunnable.run());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        boolean close = false;
        PooledBoltConnection pooledBoltConnection = this;
        synchronized (pooledBoltConnection) {
            if (this.closeFuture == null) {
                this.closeFuture = new CompletableFuture();
                close = true;
            }
            closeFuture = this.closeFuture;
        }
        if (close) {
            if (this.delegate.state() == BoltConnectionState.CLOSED) {
                this.purgeRunnable.run();
                closeFuture.complete(null);
                return closeFuture;
            }
            if (this.delegate.state() == BoltConnectionState.ERROR) {
                this.purgeRunnable.run();
                closeFuture.complete(null);
                return closeFuture;
            }
            BasicResponseHandler resetHandler = new BasicResponseHandler();
            this.delegate.reset().thenCompose(boltConnection -> boltConnection.flush((ResponseHandler)resetHandler)).thenCompose(ignored -> resetHandler.summaries()).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    this.delegate.close().whenComplete((closeResult, closeThrowable) -> this.purgeRunnable.run());
                } else {
                    CompletableFuture.completedStage(null).whenComplete((ignoredResult, nothing) -> this.releaseRunnable.run());
                }
                closeFuture.complete(null);
            });
        }
        return closeFuture;
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    public BoltConnectionState state() {
        return this.delegate.state();
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }

    public BoltConnection delegate() {
        return this.delegate;
    }
}

