/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.routed.impl.cluster;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.BoltConnectionParameters;
import org.neo4j.bolt.connection.BoltConnectionSource;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.bolt.connection.routed.ClusterCompositionLookupResult;
import org.neo4j.bolt.connection.routed.Rediscovery;
import org.neo4j.bolt.connection.routed.impl.cluster.ClusterRoutingTable;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableHandler;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableHandlerImpl;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableRegistry;
import org.neo4j.bolt.connection.routed.impl.util.FutureUtil;

public class RoutingTableRegistryImpl
implements RoutingTableRegistry {
    private static final Supplier<IllegalStateException> PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER = () -> new IllegalStateException("Pending database name encountered.");
    private final ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers;
    private final Map<Principal, CompletionStage<DatabaseName>> principalToDatabaseNameStage;
    private final RoutingTableHandlerFactory factory;
    private final System.Logger log;
    private final Clock clock;
    private final Function<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> connectionSourceGetter;
    private final Rediscovery rediscovery;

    public RoutingTableRegistryImpl(Function<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> connectionSourceGetter, Rediscovery rediscovery, Clock clock, LoggingProvider logging, long routingTablePurgeDelayMs, Consumer<Set<BoltServerAddress>> addressesToRetainConsumer) {
        this(new ConcurrentHashMap<DatabaseName, RoutingTableHandler>(), new RoutingTableHandlerFactory(connectionSourceGetter, rediscovery, clock, logging, routingTablePurgeDelayMs, addressesToRetainConsumer), clock, connectionSourceGetter, rediscovery, logging);
    }

    RoutingTableRegistryImpl(ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers, RoutingTableHandlerFactory factory, Clock clock, Function<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> connectionSourceGetter, Rediscovery rediscovery, LoggingProvider logging) {
        Objects.requireNonNull(rediscovery, "rediscovery must not be null");
        this.factory = factory;
        this.routingTableHandlers = routingTableHandlers;
        this.principalToDatabaseNameStage = new HashMap<Principal, CompletionStage<DatabaseName>>();
        this.clock = clock;
        this.connectionSourceGetter = connectionSourceGetter;
        this.rediscovery = rediscovery;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public CompletionStage<RoutingTableHandler> ensureRoutingTable(CompletableFuture<DatabaseName> databaseNameFuture, RoutedBoltConnectionParameters parameters, ImmutableObservation parentObservation) {
        RoutingTableHandler handler;
        if (!databaseNameFuture.isDone() && parameters.homeDatabaseHint() != null && (handler = (RoutingTableHandler)this.routingTableHandlers.get(DatabaseName.database((String)parameters.homeDatabaseHint()))) != null && !handler.isStaleFor(parameters.accessMode())) {
            return CompletableFuture.completedFuture(handler);
        }
        return this.ensureDatabaseNameIsCompleted(databaseNameFuture, parameters, parentObservation).thenCompose(ctxAndHandler -> {
            RoutingTableHandler handler = ctxAndHandler.handler() != null ? ctxAndHandler.handler() : this.getOrCreate(FutureUtil.joinNowOrElseThrow(ctxAndHandler.databaseNameFuture(), PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER));
            return handler.ensureRoutingTable(parameters, parentObservation).thenApply(ignored -> handler);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<ConnectionContextAndHandler> ensureDatabaseNameIsCompleted(CompletableFuture<DatabaseName> databaseNameFutureS, RoutedBoltConnectionParameters parameters, ImmutableObservation parentObservation) {
        CompletionStage<ConnectionContextAndHandler> contextAndHandlerStage;
        if (databaseNameFutureS.isDone()) {
            contextAndHandlerStage = CompletableFuture.completedFuture(new ConnectionContextAndHandler(databaseNameFutureS, parameters.accessMode(), parameters.bookmarks(), null));
        } else {
            RoutingTableRegistryImpl routingTableRegistryImpl = this;
            synchronized (routingTableRegistryImpl) {
                if (databaseNameFutureS.isDone()) {
                    contextAndHandlerStage = CompletableFuture.completedFuture(new ConnectionContextAndHandler(databaseNameFutureS, parameters.accessMode(), parameters.bookmarks(), null));
                } else {
                    Principal principal = new Principal(parameters.impersonatedUser());
                    CompletionStage<DatabaseName> databaseNameStage = this.principalToDatabaseNameStage.get(principal);
                    AtomicReference handlerRef = new AtomicReference();
                    if (databaseNameStage == null) {
                        CompletableFuture<DatabaseName> databaseNameFuture = new CompletableFuture<DatabaseName>();
                        this.principalToDatabaseNameStage.put(principal, databaseNameFuture);
                        databaseNameStage = databaseNameFuture;
                        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseName.defaultDatabase(), this.clock, new BoltServerAddress[0]);
                        this.rediscovery.lookupClusterComposition(routingTable, this.connectionSourceGetter, parameters, parentObservation).thenCompose(compositionLookupResult -> {
                            DatabaseName databaseName = DatabaseName.database((String)compositionLookupResult.getClusterComposition().databaseName());
                            RoutingTableHandler handler = this.getOrCreate(databaseName);
                            handlerRef.set(handler);
                            return handler.updateRoutingTable((ClusterCompositionLookupResult)compositionLookupResult).thenApply(ignored -> databaseName);
                        }).whenComplete((databaseName, throwable) -> {
                            RoutingTableRegistryImpl routingTableRegistryImpl = this;
                            synchronized (routingTableRegistryImpl) {
                                this.principalToDatabaseNameStage.remove(principal);
                            }
                        }).whenComplete((databaseName, throwable) -> {
                            if (throwable != null) {
                                databaseNameFuture.completeExceptionally((Throwable)throwable);
                            } else {
                                databaseNameFuture.complete((DatabaseName)databaseName);
                            }
                        });
                    }
                    contextAndHandlerStage = databaseNameStage.thenApply(databaseName -> {
                        RoutingTableRegistryImpl routingTableRegistryImpl = this;
                        synchronized (routingTableRegistryImpl) {
                            databaseNameFutureS.complete((DatabaseName)databaseName);
                        }
                        return new ConnectionContextAndHandler(databaseNameFutureS, parameters.accessMode(), parameters.bookmarks(), (RoutingTableHandler)handlerRef.get());
                    });
                }
            }
        }
        return contextAndHandlerStage;
    }

    @Override
    public Set<BoltServerAddress> allServers() {
        return this.routingTableHandlers.values().stream().flatMap(tableHandler -> tableHandler.servers().stream()).collect(Collectors.toSet());
    }

    @Override
    public void remove(DatabaseName databaseName) {
        this.routingTableHandlers.remove(databaseName);
        this.log.log(System.Logger.Level.DEBUG, "Routing table handler for database '%s' is removed.", databaseName.description());
    }

    @Override
    public void removeAged() {
        this.routingTableHandlers.forEach((databaseName, handler) -> {
            if (handler.isRoutingTableAged()) {
                this.log.log(System.Logger.Level.INFO, "Routing table handler for database '%s' is removed because it has not been used for a long time. Routing table: %s", databaseName.description(), handler.routingTable());
                this.routingTableHandlers.remove(databaseName);
            }
        });
    }

    @Override
    public Optional<RoutingTableHandler> getRoutingTableHandler(DatabaseName databaseName) {
        return Optional.ofNullable((RoutingTableHandler)this.routingTableHandlers.get(databaseName));
    }

    public boolean contains(DatabaseName databaseName) {
        return this.routingTableHandlers.containsKey(databaseName);
    }

    private RoutingTableHandler getOrCreate(DatabaseName databaseName) {
        return this.routingTableHandlers.computeIfAbsent(databaseName, name -> {
            RoutingTableHandler handler = this.factory.newInstance((DatabaseName)name, this);
            this.log.log(System.Logger.Level.DEBUG, "Routing table handler for database '%s' is added.", databaseName.description());
            return handler;
        });
    }

    static class RoutingTableHandlerFactory {
        private final Function<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> connectionSourceGetter;
        private final Rediscovery rediscovery;
        private final LoggingProvider logging;
        private final Clock clock;
        private final long routingTablePurgeDelayMs;
        private final Consumer<Set<BoltServerAddress>> addressesToRetainConsumer;

        RoutingTableHandlerFactory(Function<BoltServerAddress, BoltConnectionSource<BoltConnectionParameters>> connectionSourceGetter, Rediscovery rediscovery, Clock clock, LoggingProvider logging, long routingTablePurgeDelayMs, Consumer<Set<BoltServerAddress>> addressesToRetainConsumer) {
            this.connectionSourceGetter = connectionSourceGetter;
            this.rediscovery = rediscovery;
            this.clock = clock;
            this.logging = logging;
            this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
            this.addressesToRetainConsumer = addressesToRetainConsumer;
        }

        RoutingTableHandler newInstance(DatabaseName databaseName, RoutingTableRegistry allTables) {
            ClusterRoutingTable routingTable = new ClusterRoutingTable(databaseName, this.clock, new BoltServerAddress[0]);
            return new RoutingTableHandlerImpl(routingTable, this.rediscovery, this.connectionSourceGetter, allTables, this.logging, this.routingTablePurgeDelayMs, this.addressesToRetainConsumer);
        }
    }

    private record ConnectionContextAndHandler(CompletableFuture<DatabaseName> databaseNameFuture, AccessMode mode, Set<String> rediscoveryBookmarks, RoutingTableHandler handler) {
    }

    private record Principal(String id) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Principal principal = (Principal)o;
            return Objects.equals(this.id, principal.id);
        }
    }
}

