/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.connection.Scheme;

public class RoutingContext {
    public static final RoutingContext EMPTY = new RoutingContext();
    private static final String ROUTING_ADDRESS_KEY = "address";
    private final Map<String, String> context;
    private final boolean isServerRoutingEnabled;

    private RoutingContext() {
        this.isServerRoutingEnabled = true;
        this.context = Collections.emptyMap();
    }

    public RoutingContext(URI uri) {
        this.isServerRoutingEnabled = Scheme.isRoutingScheme(uri.getScheme());
        this.context = Collections.unmodifiableMap(RoutingContext.parseParameters(uri));
    }

    public boolean isDefined() {
        return this.context.size() > 1;
    }

    public Map<String, String> toMap() {
        return this.context;
    }

    public boolean isServerRoutingEnabled() {
        return this.isServerRoutingEnabled;
    }

    public String toString() {
        return "RoutingContext" + String.valueOf(this.context) + " isServerRoutingEnabled=" + this.isServerRoutingEnabled;
    }

    private static Map<String, String> parseParameters(URI uri) {
        String[] pairs;
        String query = uri.getQuery();
        String address = uri.getPort() == -1 ? String.format("%s:%s", uri.getHost(), 7687) : String.format("%s:%s", uri.getHost(), uri.getPort());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(ROUTING_ADDRESS_KEY, address);
        if (query == null || query.isEmpty()) {
            return parameters;
        }
        for (String pair : pairs = query.split("&")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Invalid parameters: '" + pair + "' in URI '" + String.valueOf(uri) + "'");
            }
            String previousValue = parameters.put(RoutingContext.trimAndVerifyKey(keyValue[0], uri), RoutingContext.trimAndVerify(keyValue[1], "value", uri));
            if (previousValue == null) continue;
            throw new IllegalArgumentException("Duplicated query parameters with key '" + previousValue + "' in URI '" + String.valueOf(uri) + "'");
        }
        return parameters;
    }

    private static String trimAndVerifyKey(String s, URI uri) {
        String trimmed = RoutingContext.trimAndVerify(s, "key", uri);
        if (trimmed.equals(ROUTING_ADDRESS_KEY)) {
            throw new IllegalArgumentException("The key 'address' is reserved for routing context.");
        }
        return trimmed;
    }

    private static String trimAndVerify(String string, String name, URI uri) {
        String result = string.trim();
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Illegal empty " + name + " in URI query '" + String.valueOf(uri) + "'");
        }
        return result;
    }
}

