/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.clirr.core.ApiDifference;
import org.codehaus.mojo.clirr.ApiDifferenceFilter;
import org.codehaus.mojo.clirr.JavaTypeRepository;
import org.codehaus.mojo.clirr.MessageCodeFilter;

public class SkipDeprecatedFilter
implements ApiDifferenceFilter {
    private JavaTypeRepository originalClasses;
    public static MessageCodeFilter DEPRECATATED_FILTER = new MessageCodeFilter(new HashSet<Integer>(), (Set<Integer>)new HashSet<Integer>(){
        {
            this.add(MessageCodeFilter.Codes.METHOD_REMOVED);
            this.add(MessageCodeFilter.Codes.METHOD_DECREASED_VISIBILITY);
            this.add(MessageCodeFilter.Codes.CLASS_REMOVED);
            this.add(MessageCodeFilter.Codes.CLASS_DECREASED_VISIBILITY);
            this.add(MessageCodeFilter.Codes.FIELD_REMOVED);
            this.add(MessageCodeFilter.Codes.FIELD_DECREASED_VISIBILITY);
        }
    });

    public SkipDeprecatedFilter(JavaTypeRepository origClasses) {
        this.originalClasses = origClasses;
    }

    @Override
    public boolean shouldInclude(ApiDifference apiDiff) {
        try {
            Field field;
            Method method;
            Class<?> clazz;
            if (apiDiff.getAffectedMethod() == null && apiDiff.getAffectedField() == null ? (clazz = this.originalClasses.get(apiDiff.getAffectedClass())).getAnnotation(Deprecated.class) != null : (apiDiff.getAffectedMethod() != null ? (method = this.originalClasses.getMethod(apiDiff.getAffectedClass(), apiDiff.getAffectedMethod())).getAnnotation(Deprecated.class) != null : (field = this.originalClasses.getField(apiDiff.getAffectedClass(), apiDiff.getAffectedField())).getAnnotation(Deprecated.class) != null)) {
                return DEPRECATATED_FILTER.shouldInclude(apiDiff);
            }
            return true;
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }
}

