/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.HashSet;
import java.util.Set;

@XStreamAlias(value="artifact")
public class ArtifactWithLicenses {
    @XStreamAsAttribute
    @XStreamAlias(value="id")
    private String artifactId;
    @XStreamAsAttribute
    @XStreamAlias(value="name")
    private String name;
    @XStreamImplicit(itemFieldName="license")
    private Set<String> licenses;

    public ArtifactWithLicenses() {
        this.licenses = new HashSet<String>();
    }

    public ArtifactWithLicenses(String artifactId) {
        this.artifactId = artifactId;
        this.licenses = new HashSet<String>();
    }

    public ArtifactWithLicenses(String artifactId, Set<String> licenses) {
        this.artifactId = artifactId;
        this.licenses = licenses;
    }

    public ArtifactWithLicenses(String artifactId, String name) {
        this.licenses = new HashSet<String>();
        this.artifactId = artifactId;
        this.name = name;
    }

    public void combineWith(ArtifactWithLicenses other) {
        this.licenses.addAll(other.getLicenses());
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Set<String> getLicenses() {
        return this.licenses;
    }

    public void addLicense(String license) {
        this.licenses.add(license);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setLicenses(Set<String> licenses) {
        this.licenses = licenses;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactWithLicenses other = (ArtifactWithLicenses)obj;
        return !(this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId));
    }
}

