/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.caniuse;

import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.caniuse.Neo4j;
import org.neo4j.caniuse.Neo4jDeploymentType;
import org.neo4j.caniuse.Neo4jEdition;
import org.neo4j.caniuse.Neo4jVersion;
import org.neo4j.caniuse.Neo4jVersionParser;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/neo4j/caniuse/Neo4jDetector;", "", "<init>", "()V", "detect", "Lorg/neo4j/caniuse/Neo4j;", "driver", "Lorg/neo4j/driver/Driver;", "parseDeploymentType", "Lorg/neo4j/caniuse/Neo4jDeploymentType;", "rawVersion", "", "parseEdition", "Lorg/neo4j/caniuse/Neo4jEdition;", "rawEdition", "caniuse-neo4j-detection"})
public final class Neo4jDetector {
    @NotNull
    public static final Neo4jDetector INSTANCE = new Neo4jDetector();

    private Neo4jDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Neo4j detect(@NotNull Driver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        AutoCloseable autoCloseable = (AutoCloseable)driver.session();
        Throwable throwable = null;
        try {
            Session session = (Session)autoCloseable;
            boolean bl = false;
            Map params = MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"Neo4j Kernel"));
            Result result = session.run("CALL dbms.components() YIELD name, edition, versions WHERE name = $name RETURN edition, versions[0] AS version LIMIT 1", params);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"run(...)");
            Result result2 = result;
            Record record = result2.single();
            String rawVersion = record.get("version").asString();
            Intrinsics.checkNotNull((Object)rawVersion);
            Neo4jVersion neo4jVersion = Neo4jVersionParser.INSTANCE.parse(rawVersion);
            String string = record.get("edition").asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            Neo4j neo4j = new Neo4j(neo4jVersion, INSTANCE.parseEdition(string), INSTANCE.parseDeploymentType(rawVersion));
            return neo4j;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Neo4jDeploymentType parseDeploymentType(String rawVersion) {
        if (StringsKt.endsWith$default((String)rawVersion, (String)"-aura", (boolean)false, (int)2, null)) {
            return Neo4jDeploymentType.AURA;
        }
        return Neo4jDeploymentType.SELF_MANAGED;
    }

    private final Neo4jEdition parseEdition(String rawEdition) {
        String string = rawEdition.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String edition = string;
        if (Intrinsics.areEqual((Object)edition, (Object)"enterprise")) {
            return Neo4jEdition.ENTERPRISE;
        }
        return Neo4jEdition.COMMUNITY;
    }
}

