/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.caniuse;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.neo4j.caniuse.Neo4jVersion;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lorg/neo4j/caniuse/Neo4jVersionParser;", "", "<init>", "()V", "parse", "Lorg/neo4j/caniuse/Neo4jVersion;", "version", "", "parseMinor", "", "buffer", "parsePatch", "caniuse-neo4j-detection"})
public final class Neo4jVersionParser {
    @NotNull
    public static final Neo4jVersionParser INSTANCE = new Neo4jVersionParser();

    private Neo4jVersionParser() {
    }

    @NotNull
    public final Neo4jVersion parse(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        int major = -1;
        int minor = -1;
        int patch = -1;
        String buffer = "";
        char[] cArray = version.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            if (c != '.') {
                buffer = buffer + c;
                continue;
            }
            if (major == -1) {
                try {
                    major = Integer.parseInt(buffer, CharsKt.checkRadix((int)10));
                }
                catch (NumberFormatException numberFormatException) {
                    return Neo4jVersion.Companion.getLATEST();
                }
            } else if (minor == -1) {
                try {
                    minor = this.parseMinor(buffer);
                }
                catch (NumberFormatException numberFormatException) {
                    return Neo4jVersion.Companion.getLATEST();
                }
            } else {
                return Neo4jVersion.Companion.getLATEST();
            }
            buffer = "";
        }
        if (((CharSequence)buffer).length() == 0) {
            return Neo4jVersion.Companion.getLATEST();
        }
        if (minor == -1) {
            try {
                minor = this.parseMinor(buffer);
            }
            catch (NumberFormatException numberFormatException) {
                return Neo4jVersion.Companion.getLATEST();
            }
        }
        try {
            patch = this.parsePatch(buffer);
        }
        catch (NumberFormatException numberFormatException) {
            return Neo4jVersion.Companion.getLATEST();
        }
        if (major == -1 || minor == -1) {
            return Neo4jVersion.Companion.getLATEST();
        }
        if (patch == -1) {
            return new Neo4jVersion(major, minor, 0, 4, null);
        }
        return new Neo4jVersion(major, minor, patch);
    }

    private final int parseMinor(String buffer) {
        return Integer.parseInt(StringsKt.replace$default((String)buffer, (String)"-aura", (String)"", (boolean)false, (int)4, null), CharsKt.checkRadix((int)10));
    }

    private final int parsePatch(String buffer) {
        int patch = 0;
        int end = StringsKt.indexOf$default((CharSequence)buffer, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (end == -1) {
            end = buffer.length();
        }
        String string = buffer.substring(0, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        patch = Integer.parseInt(string, CharsKt.checkRadix((int)10));
        return patch;
    }
}

