/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.provider.Arguments;
import org.neo4j.configuration.helpers.RemoteUri;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.InstanceModeConstraint;
import org.neo4j.dbms.systemgraph.SeedRestoreUntil;
import org.neo4j.dbms.systemgraph.SystemDatabaseMode;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.logging.Level;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.DurationValue;

@ImpermanentDbmsExtension
public abstract class BaseTopologyGraphDbmsModelIT {
    @Inject
    protected DatabaseManagementService managementService;
    @Inject
    protected GraphDatabaseService db;
    protected Transaction tx;

    @BeforeEach
    void before() {
        this.tx = this.db.beginTx();
        this.createModel(this.tx);
    }

    @AfterEach
    void after() {
        this.tx.commit();
        this.tx.close();
    }

    protected abstract void createModel(Transaction var1);

    protected ServerId newInstance(Consumer<InstanceNodeBuilder> setup) {
        return this.newInstance(setup, false);
    }

    protected ServerId newRemovedInstance(Consumer<InstanceNodeBuilder> setup) {
        return this.newInstance(setup, true);
    }

    protected NamedDatabaseId newDatabase(Consumer<DatabaseNodeBuilder> setup) {
        return this.newDatabase(setup, false);
    }

    protected NamedDatabaseId newDeletedDatabase(Consumer<DatabaseNodeBuilder> setup) {
        return this.newDatabase(setup, true);
    }

    public static ServerId serverId(int seed) {
        Random rng = new Random(seed);
        return new ServerId(new UUID(rng.nextLong(), rng.nextLong()));
    }

    public static Set<ServerId> serverIds(int from, int until) {
        return IntStream.range(from, until).mapToObj(BaseTopologyGraphDbmsModelIT::serverId).collect(Collectors.toSet());
    }

    protected void connect(NamedDatabaseId databaseId, ServerId serverId, TopologyGraphDbmsModel.HostedOnMode mode, boolean initial, boolean wasHostedOn) {
        this.connect(databaseId, serverId, mode, initial, wasHostedOn, mode == TopologyGraphDbmsModel.HostedOnMode.RAFT ? UUID.randomUUID() : null);
    }

    protected void connect(NamedDatabaseId databaseId, ServerId serverId, TopologyGraphDbmsModel.HostedOnMode mode, boolean initial, boolean wasHostedOn, UUID raftMemberId) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(databaseId, tx);
            Node instance = this.findInstance(serverId, tx);
            Relationship relationship = this.mergeHostOn(wasHostedOn, database, instance);
            relationship.setProperty("mode", (Object)mode.modeName());
            if (initial) {
                relationship.setProperty("bootstrapper", (Object)true);
            }
            if (mode == TopologyGraphDbmsModel.HostedOnMode.RAFT && raftMemberId != null) {
                relationship.setProperty("raftMemberId", (Object)raftMemberId.toString());
            }
            tx.commit();
        }
    }

    private Relationship mergeHostOn(boolean wasHostedOn, Node database, Node instance) {
        try (Stream stream = database.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HOSTED_ON_RELATIONSHIP, TopologyGraphDbmsModel.WAS_HOSTED_ON_RELATIONSHIP}).stream();){
            stream.filter(rel -> Objects.equals(rel.getEndNode(), instance)).forEach(Entity::delete);
        }
        RelationshipType nextRelLabel = wasHostedOn ? TopologyGraphDbmsModel.WAS_HOSTED_ON_RELATIONSHIP : TopologyGraphDbmsModel.HOSTED_ON_RELATIONSHIP;
        return database.createRelationshipTo(instance, nextRelLabel);
    }

    protected void disconnect(NamedDatabaseId databaseId, ServerId serverId, boolean replaceWithWas) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(databaseId, tx);
            Node instance = this.findInstance(serverId, tx);
            try (Stream relationships = database.getRelationships(new RelationshipType[]{TopologyGraphDbmsModel.HOSTED_ON_RELATIONSHIP}).stream();){
                relationships.filter(rel -> rel.getEndNode().equals((Object)instance)).forEach(rel -> {
                    if (replaceWithWas) {
                        Relationship was = database.createRelationshipTo(instance, TopologyGraphDbmsModel.WAS_HOSTED_ON_RELATIONSHIP);
                        was.setProperty("mode", rel.getProperty("mode"));
                    }
                    rel.delete();
                });
            }
            tx.commit();
        }
    }

    protected void databaseDelete(NamedDatabaseId id) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(id, tx);
            database.setProperty("update_id", (Object)((Long)database.getProperty("update_id") + 1L));
            database.addLabel(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL);
            database.removeLabel(TopologyGraphDbmsModel.DATABASE_LABEL);
            tx.commit();
        }
    }

    protected void databaseSetState(NamedDatabaseId id, TopologyGraphDbmsModel.DatabaseStatus state) {
        try (Transaction tx = this.db.beginTx();){
            Node database = this.findDatabase(id, tx);
            database.setProperty("update_id", (Object)((Long)database.getProperty("update_id") + 1L));
            database.setProperty("status", (Object)state.statusName());
            tx.commit();
        }
    }

    protected void databaseIncreaseUpdateId(NamedDatabaseId ... ids) {
        try (Transaction tx = this.db.beginTx();){
            for (NamedDatabaseId id : ids) {
                Node database = this.findDatabase(id, tx);
                database.setProperty("update_id", (Object)((Long)database.getProperty("update_id") + 1L));
            }
            tx.commit();
        }
    }

    private NamedDatabaseId newDatabase(Consumer<DatabaseNodeBuilder> setup, boolean deleted) {
        try (Transaction tx = this.db.beginTx();){
            DatabaseNodeBuilder builder = new DatabaseNodeBuilder(tx, deleted);
            setup.accept(builder);
            NamedDatabaseId namedDatabaseId = builder.commit();
            return namedDatabaseId;
        }
    }

    private ServerId newInstance(Consumer<InstanceNodeBuilder> setup, boolean removed) {
        try (Transaction tx = this.db.beginTx();){
            InstanceNodeBuilder builder = new InstanceNodeBuilder(tx, removed);
            setup.accept(builder);
            ServerId serverId = builder.commit();
            return serverId;
        }
    }

    private Node findInstance(ServerId serverId, Transaction tx) {
        return Optional.ofNullable(tx.findNode(TopologyGraphDbmsModel.INSTANCE_LABEL, "uuid", (Object)serverId.uuid().toString())).orElseGet(() -> tx.findNode(TopologyGraphDbmsModel.REMOVED_INSTANCE_LABEL, "uuid", (Object)serverId.uuid().toString()));
    }

    private Node findDatabase(NamedDatabaseId databaseId, Transaction tx) {
        return Optional.ofNullable(tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "uuid", (Object)databaseId.databaseId().uuid().toString())).orElseGet(() -> tx.findNode(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL, "uuid", (Object)databaseId.databaseId().uuid().toString()));
    }

    protected Node createInternalReferenceForDatabase(Transaction tx, String name, boolean primary, NamedDatabaseId databaseId) {
        return this.createInternalReferenceForDatabase(tx, "system-root", name, primary, databaseId);
    }

    protected Node createInternalReferenceForDatabase(Transaction tx, String namespace, String name, boolean primary, NamedDatabaseId databaseId) {
        Node databaseNode = this.findDatabase(databaseId, tx);
        Node referenceNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        referenceNode.setProperty("primary", (Object)primary);
        referenceNode.setProperty("name", (Object)new NormalizedDatabaseName(name).name());
        referenceNode.setProperty("namespace", (Object)namespace);
        referenceNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
        return referenceNode;
    }

    protected Node createExternalReferenceForDatabase(Transaction tx, String name, String targetName, RemoteUri uri, UUID uuid) {
        Node referenceNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.REMOTE_DATABASE_LABEL, TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        referenceNode.setProperty("primary", (Object)false);
        referenceNode.setProperty("namespace", (Object)"system-root");
        referenceNode.setProperty("name", (Object)new NormalizedDatabaseName(name).name());
        referenceNode.setProperty("target_name", (Object)new NormalizedDatabaseName(targetName).name());
        String uriString = String.format("%s://%s", uri.getScheme(), uri.getAddresses().get(0));
        referenceNode.setProperty("url", (Object)uriString);
        referenceNode.setProperty("version", (Object)uuid.toString());
        referenceNode.setProperty("username", (Object)"username");
        referenceNode.setProperty("password", (Object)"password".getBytes());
        referenceNode.setProperty("iv", (Object)"i_vector".getBytes());
        return referenceNode;
    }

    protected Node createExternalReferenceForDatabase(Transaction tx, String namespace, String name, String targetName, RemoteUri uri, UUID uuid) {
        Node referenceNode = this.createExternalReferenceForDatabase(tx, name, targetName, uri, uuid);
        referenceNode.setProperty("namespace", (Object)namespace);
        return referenceNode;
    }

    protected Node createDriverSettingsForExternalAlias(Transaction tx, Node externalRefNode, DriverSettings driverSettings) {
        Node settingsNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DRIVER_SETTINGS_LABEL});
        driverSettings.isSslEnforced().ifPresent(enabled -> settingsNode.setProperty(DriverSettings.Keys.SSL_ENFORCED.toString(), enabled));
        driverSettings.connectionTimeout().ifPresent(timeout -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_TIMEOUT.toString(), timeout));
        driverSettings.connectionMaxLifetime().ifPresent(lifetime -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_MAX_LIFETIME.toString(), lifetime));
        driverSettings.connectionPoolAcquisitionTimeout().ifPresent(timeout -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_POOL_ACQUISITION_TIMEOUT.toString(), timeout));
        driverSettings.connectionPoolIdleTest().ifPresent(test -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_POOL_IDLE_TEST.toString(), test));
        driverSettings.connectionPoolMaxSize().ifPresent(size -> settingsNode.setProperty(DriverSettings.Keys.CONNECTION_POOL_MAX_SIZE.toString(), size));
        driverSettings.loggingLevel().ifPresent(level -> settingsNode.setProperty(DriverSettings.Keys.LOGGING_LEVEL.toString(), (Object)level.toString()));
        externalRefNode.createRelationshipTo(settingsNode, TopologyGraphDbmsModel.CONNECTS_WITH_RELATIONSHIP);
        return settingsNode;
    }

    protected Node createPropertiesForAlias(Transaction tx, Node aliasNode, Map<String, Object> properties) {
        Node propertiesNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.ALIAS_PROPERTIES_LABEL});
        properties.forEach((arg_0, arg_1) -> ((Node)propertiesNode).setProperty(arg_0, arg_1));
        aliasNode.createRelationshipTo(propertiesNode, TopologyGraphDbmsModel.PROPERTIES_RELATIONSHIP);
        return propertiesNode;
    }

    protected static Stream<Arguments> aliasProperties() {
        return Stream.of(Arguments.of((Object[])new Object[]{Map.of()}), Arguments.of((Object[])new Object[]{Map.of("key1", "string", "key2", 123L)}));
    }

    protected static Stream<Arguments> driverSettings() {
        DriverSettings completeSettings = DriverSettings.builder().withSslEnforced(true).withConnectionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(10L))).withConnectionPoolAcquisitionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(1L))).withConnectionMaxLifeTime(DurationValue.duration((Duration)Duration.ofSeconds(300L))).withConnectionPoolIdleTest(DurationValue.duration((Duration)Duration.ofSeconds(1L))).withConnectionPoolMaxSize(0).withLoggingLevel(Level.INFO).build();
        DriverSettings missingSettings = DriverSettings.builder().withSslEnforced(false).withLoggingLevel(Level.DEBUG).build();
        DriverSettings missingOtherSettings = DriverSettings.builder().withConnectionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(10L))).withConnectionPoolAcquisitionTimeout(DurationValue.duration((Duration)Duration.ofSeconds(1L))).withConnectionMaxLifeTime(DurationValue.duration((Duration)Duration.ofSeconds(300L))).withConnectionPoolIdleTest(DurationValue.duration((Duration)Duration.ofSeconds(1L))).build();
        return Stream.of(Arguments.of((Object[])new Object[]{"complete", completeSettings}), Arguments.of((Object[])new Object[]{"missing", missingSettings}), Arguments.of((Object[])new Object[]{"missingOther", missingOtherSettings}));
    }

    protected void createVersionNode() {
        try (Transaction tx = this.db.beginTx();){
            Node versionNode = tx.createNode(new Label[]{SystemGraphComponent.VERSION_LABEL});
            versionNode.setProperty(ComponentVersion.DBMS_RUNTIME_COMPONENT.name(), (Object)DbmsRuntimeVersion.GLORIOUS_FUTURE.getVersion());
            Node configNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.TOPOLOGY_GRAPH_CONFIG_LABEL});
            configNode.setProperty("default_number_of_primaries", (Object)9L);
            configNode.setProperty("default_number_of_secondaries", (Object)10L);
            configNode.setProperty("default_database", (Object)"bar");
            configNode.setProperty("auto_enable_free_servers", (Object)false);
            tx.commit();
        }
    }

    protected static class DatabaseNodeBuilder {
        Transaction tx;
        Node node;

        public DatabaseNodeBuilder(Transaction tx, boolean deleted) {
            this.tx = tx;
            this.node = tx.createNode(new Label[]{deleted ? TopologyGraphDbmsModel.DELETED_DATABASE_LABEL : TopologyGraphDbmsModel.DATABASE_LABEL});
        }

        public DatabaseNodeBuilder withDatabase(String databaseName) {
            return this.withDatabase(DatabaseIdFactory.from((String)new NormalizedDatabaseName(databaseName).name(), (UUID)UUID.randomUUID()));
        }

        public DatabaseNodeBuilder withDatabase(NamedDatabaseId namedDatabaseId) {
            this.node.setProperty("name", (Object)namedDatabaseId.name());
            this.node.setProperty("uuid", (Object)namedDatabaseId.databaseId().uuid().toString());
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.ONLINE.statusName());
            this.node.setProperty("update_id", (Object)0L);
            return this;
        }

        public DatabaseNodeBuilder withStoreFormat(String storeFormat) {
            this.node.setProperty("creation_store_format", (Object)storeFormat);
            return this;
        }

        public DatabaseNodeBuilder asStopped() {
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.OFFLINE.statusName());
            return this;
        }

        public DatabaseNodeBuilder asDefault() {
            this.node.setProperty("default", (Object)true);
            return this;
        }

        public DatabaseNodeBuilder asVirtual() {
            this.node.addLabel(TopologyGraphDbmsModel.COMPOSITE_DATABASE_LABEL);
            this.node.setProperty("virtual", (Object)true);
            return this;
        }

        public DatabaseNodeBuilder withStoreIdParts(long creationTime, long random) {
            this.node.setProperty("created_at", (Object)ZonedDateTime.ofInstant(Instant.ofEpochMilli(creationTime), ZoneId.systemDefault()));
            this.node.setProperty("store_random_id", (Object)random);
            return this;
        }

        public DatabaseNodeBuilder withAllocationNumbers(int primaries, int secondaries) {
            this.node.setProperty("primaries", (Object)primaries);
            this.node.setProperty("secondaries", (Object)secondaries);
            return this;
        }

        public DatabaseNodeBuilder withDesignatedSeeder(ServerId designatedSeeder) {
            this.node.setProperty("designated_seeder", (Object)designatedSeeder.uuid().toString());
            return this;
        }

        public DatabaseNodeBuilder withSeedingServers(Set<ServerId> seedingServers) {
            String[] servers = (String[])seedingServers.stream().map(serverId -> serverId.uuid().toString()).toArray(String[]::new);
            this.node.setProperty("seeding_servers", (Object)servers);
            return this;
        }

        public DatabaseNodeBuilder withDeletedDatabaseKeepProperty(Set<ServerId> serversKeepingData) {
            this.node.setProperty("keep_data", serversKeepingData.stream().map(id -> id.uuid().toString()).toArray(String[]::new));
            return this;
        }

        public DatabaseNodeBuilder withDumpDatabaseProperty() {
            this.node.setProperty("dump_data", (Object)true);
            return this;
        }

        public DatabaseNodeBuilder withSeedingParameters(String uri, byte[] password, byte[] iv, String config, SeedRestoreUntil seedRestoreUntil) {
            this.node.setProperty("seedURI", (Object)uri);
            this.node.setProperty("seedCredentialsEncrypted", (Object)password);
            this.node.setProperty("seedCredentialsIv", (Object)iv);
            this.node.setProperty("seedConfig", (Object)config);
            seedRestoreUntil.txId().ifPresentOrElse(txId -> this.node.setProperty("seedRestoreUntil", txId), () -> seedRestoreUntil.dateTime().ifPresent(dateTime -> this.node.setProperty("seedRestoreUntil", dateTime)));
            return this;
        }

        public DatabaseNodeBuilder withShards(NamedDatabaseId ... databaseIds) {
            int index = 0;
            for (NamedDatabaseId databaseId : databaseIds) {
                Node otherDatabase = this.tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "uuid", (Object)databaseId.databaseId().uuid().toString());
                Relationship relationship = this.node.createRelationshipTo(otherDatabase, TopologyGraphDbmsModel.HAS_SHARD);
                relationship.setProperty("index", (Object)index++);
            }
            return this;
        }

        public NamedDatabaseId commit() {
            NamedDatabaseId id = DatabaseIdFactory.from((String)((String)this.node.getProperty("name")), (UUID)UUID.fromString((String)this.node.getProperty("uuid")));
            this.tx.commit();
            return id;
        }
    }

    protected static class InstanceNodeBuilder {
        Transaction tx;
        Node node;

        public InstanceNodeBuilder(Transaction tx, boolean removed) {
            this.tx = tx;
            this.node = tx.createNode(new Label[]{removed ? TopologyGraphDbmsModel.REMOVED_INSTANCE_LABEL : TopologyGraphDbmsModel.INSTANCE_LABEL});
        }

        public InstanceNodeBuilder withInstance() {
            return this.withInstance(new ServerId(UUID.randomUUID()));
        }

        public InstanceNodeBuilder withInstance(ServerId serverId) {
            this.node.setProperty("uuid", (Object)serverId.uuid().toString());
            this.node.setProperty("modeConstraint", (Object)InstanceModeConstraint.PRIMARY.name());
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.InstanceStatus.ENABLED.name());
            return this;
        }

        public InstanceNodeBuilder withInstance(ServerId serverId, String name) {
            this.node.setProperty("uuid", (Object)serverId.uuid().toString());
            this.node.setProperty("modeConstraint", (Object)InstanceModeConstraint.PRIMARY.name());
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.InstanceStatus.ENABLED.name());
            this.node.setProperty("name", (Object)name);
            return this;
        }

        public InstanceNodeBuilder withModeConstraint(InstanceModeConstraint modeConstraint) {
            this.node.setProperty("modeConstraint", (Object)modeConstraint.name());
            return this;
        }

        public InstanceNodeBuilder withComponentVersions(Map<SystemGraphComponent.Name, Integer> versions) {
            Node versionsNode = this.tx.createNode(new Label[]{TopologyGraphDbmsModel.SUPPORTED_COMPONENT_VERSIONS_LABEL});
            this.node.createRelationshipTo(versionsNode, TopologyGraphDbmsModel.LATEST_SUPPORTED_COMPONENT_VERSIONS_RELATIONSHIP);
            versions.forEach((key, value) -> versionsNode.setProperty(key.name(), value));
            return this;
        }

        public InstanceNodeBuilder withAutoSystemDatabaseMode(SystemDatabaseMode systemDatabaseMode) {
            this.node.setProperty("auto_system_database_mode", (Object)systemDatabaseMode.name());
            return this;
        }

        public InstanceNodeBuilder asDeallocating() {
            this.node.setProperty("status", (Object)TopologyGraphDbmsModel.InstanceStatus.DEALLOCATING.name());
            return this;
        }

        public ServerId commit() {
            this.node.setProperty("discovered_at", (Object)ZonedDateTime.now());
            ServerId id = new ServerId(UUID.fromString((String)this.node.getProperty("uuid")));
            this.tx.commit();
            return id;
        }
    }
}

