/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

public final class RecoveryHelpers {
    private RecoveryHelpers() {
    }

    public static void removeLastCheckpointRecordFromLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile(dbLayout, fs, config, false);
    }

    public static void removeLastCheckpointRecordFromLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config, boolean throwOnNoCheckpoint) throws IOException {
        LogFiles logFiles = RecoveryHelpers.buildLogFiles(dbLayout, fs, config);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        Optional latestCheckpoint = checkpointFile.findLatestCheckpoint();
        latestCheckpoint.ifPresentOrElse(checkpointInfo -> {
            LogPosition entryPosition = checkpointInfo.checkpointEntryPosition();
            try (StoreChannel storeChannel = fs.write(checkpointFile.getLogFileForVersion(entryPosition.getLogVersion()));){
                storeChannel.truncate(entryPosition.getByteOffset());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, () -> {
            if (throwOnNoCheckpoint) {
                throw new RuntimeException("No checkpoint found");
            }
        });
    }

    public static void removeLastCheckpointRecordFromLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile(dbLayout, fs, null);
    }

    public static void throwingRemoveLastCheckpointRecordFromLogFile(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        RecoveryHelpers.removeLastCheckpointRecordFromLogFile(dbLayout, fs, null, true);
    }

    public static boolean logsContainCheckpoint(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        Optional<CheckpointInfo> latestCheckpoint = RecoveryHelpers.getLatestCheckpointInfo(dbLayout, fs, null);
        return latestCheckpoint.isPresent();
    }

    public static CheckpointInfo getLatestCheckpoint(DatabaseLayout dbLayout, FileSystemAbstraction fs) throws IOException {
        return RecoveryHelpers.getLatestCheckpoint(dbLayout, fs, null);
    }

    public static CheckpointInfo getLatestCheckpoint(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        Optional<CheckpointInfo> latestCheckpoint = RecoveryHelpers.getLatestCheckpointInfo(dbLayout, fs, config);
        return latestCheckpoint.orElseThrow();
    }

    public static boolean runRecovery(DatabaseLayout layout, FileSystemAbstraction fileSystem, Config config) throws IOException {
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler((SystemNanoClock)Clocks.nanoClock());){
            boolean bl;
            block12: {
                PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (Config)config, (JobScheduler)jobScheduler, (PageCacheTracer)PageCacheTracer.NULL);
                try {
                    bl = Recovery.performRecovery((Recovery.Context)Recovery.contextWithNoLogTail((FileSystemAbstraction)fileSystem, (PageCache)pageCache, (DatabaseTracers)DatabaseTracers.EMPTY, (Config)config, (DatabaseLayout)layout, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (IOController)IOController.DISABLED, (InternalLogProvider)NullLogProvider.getInstance(), (KernelVersionProvider)KernelVersionProvider.THROWING_PROVIDER));
                    if (pageCache == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pageCache != null) {
                        try {
                            pageCache.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pageCache.close();
            }
            return bl;
        }
    }

    private static Optional<CheckpointInfo> getLatestCheckpointInfo(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        LogFiles logFiles = RecoveryHelpers.buildLogFiles(dbLayout, fs, config);
        CheckpointFile checkpointFile = logFiles.getCheckpointFile();
        return checkpointFile.findLatestCheckpoint();
    }

    private static LogFiles buildLogFiles(DatabaseLayout dbLayout, FileSystemAbstraction fs, Config config) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)dbLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)fs).withConfig(config).build();
    }
}

