/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.test.extension.DbmsSupportController;

public class DbmsSupportExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        if (DbmsSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            DbmsSupportController controller = new DbmsSupportController(context);
            controller.startDbms();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (DbmsSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            DbmsSupportController controller = new DbmsSupportController(context);
            controller.startDbms();
        }
    }

    public void afterEach(ExtensionContext context) {
        if (DbmsSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            DbmsSupportController.remove(context).shutdown();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (DbmsSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            DbmsSupportController.remove(context).shutdown();
        }
    }

    private static TestInstance.Lifecycle getLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
    }
}

