/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexSettingsKeys;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class FulltextIndexProceduresUtil {
    public static final String SHOW_FULLTEXT_INDEXES = "SHOW FULLTEXT INDEXES";
    public static final String DROP = "CALL db.index.fulltext.drop(\"%s\")";
    public static final String LIST_AVAILABLE_ANALYZERS = "CALL db.index.fulltext.listAvailableAnalyzers()";
    public static final String DB_AWAIT_INDEX = "CALL db.awaitIndex(\"%s\")";
    public static final String QUERY_NODES = "CALL db.index.fulltext.queryNodes(\"%s\", \"%s\")";
    public static final String QUERY_RELS = "CALL db.index.fulltext.queryRelationships(\"%s\", \"%s\")";
    public static final String AWAIT_REFRESH = "CALL db.index.fulltext.awaitEventuallyConsistentIndexRefresh()";
    public static final String NODE_CREATE = "CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )";
    public static final String RELATIONSHIP_CREATE = "CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)";
    public static final String NODE_CREATE_WITH_CONFIG = "CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s, %s)";
    public static final String RELATIONSHIP_CREATE_WITH_CONFIG = "CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s, %s)";

    private FulltextIndexProceduresUtil() {
    }

    public static String asStrList(String ... args) {
        if (args.length == 0) {
            return "[]";
        }
        return Arrays.stream(args).collect(Collectors.joining("\", \"", "[\"", "\"]"));
    }

    public static Map<String, Value> asProcedureConfigMap(String analyzer, boolean eventuallyConsistent) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("analyzer", (Value)Values.stringValue((String)analyzer));
        map.put("eventually_consistent", (Value)Values.booleanValue((boolean)eventuallyConsistent));
        return map;
    }

    public static Map<String, Value> asConfigMap(String analyzer, boolean eventuallyConsistent) {
        return Map.of(FulltextIndexSettingsKeys.ANALYZER, Values.stringValue((String)analyzer), FulltextIndexSettingsKeys.EVENTUALLY_CONSISTENT, Values.booleanValue((boolean)eventuallyConsistent));
    }

    public static String asConfigString(Map<String, Value> configMap) {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        configMap.forEach((k, v) -> joiner.add(k + ": \"" + v.asObject() + "\""));
        return joiner.toString();
    }
}

