/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.nio.file.Path;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.time.SystemNanoClock;

public final class AdversarialPageCacheGraphDatabaseFactory {
    private AdversarialPageCacheGraphDatabaseFactory() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static DatabaseManagementServiceBuilder create(Path homeDir, final FileSystemAbstraction fs, final Adversary adversary) {
        return new TestDatabaseManagementServiceBuilder(homeDir){

            @Override
            protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
                return new DatabaseManagementServiceFactory(DbmsInfo.COMMUNITY, CommunityEditionModule::new){

                    protected GlobalModule createGlobalModule(Config config, ExternalDependencies dependencies) {
                        return new GlobalModule(config, this.dbmsInfo, dependencies){

                            protected FileSystemAbstraction createFileSystemAbstraction() {
                                return fs;
                            }

                            protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, JobScheduler jobScheduler, SystemNanoClock clock, MemoryPools memoryPools) {
                                PageCache pageCache = super.createPageCache(fileSystem, config, logging, tracers, jobScheduler, clock, memoryPools);
                                return new AdversarialPageCache(pageCache, adversary);
                            }
                        };
                    }
                }.build(config, dependencies);
            }
        };
    }
}

