/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.BuiltInDelegatingIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class FailingGenericNativeIndexProviderFactory
extends BuiltInDelegatingIndexProviderFactory {
    public static final String INITIAL_STATE_FAILURE_MESSAGE = "Override initial state as failed";
    public static final String POPULATION_FAILURE_MESSAGE = "Fail on update during population";
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("failing-provider", "0.1");
    private final EnumSet<FailureType> failureTypes;

    public FailingGenericNativeIndexProviderFactory(FailureType ... failureTypes) {
        super((AbstractIndexProviderFactory<?>)new GenericNativeIndexProviderFactory(), DESCRIPTOR);
        if (failureTypes.length == 0) {
            throw new IllegalArgumentException("At least one failure type, otherwise there's no point in this provider");
        }
        this.failureTypes = EnumSet.of(failureTypes[0], Arrays.copyOfRange(failureTypes, 1, failureTypes.length));
    }

    @Override
    public IndexProvider newInstance(ExtensionContext context, BuiltInDelegatingIndexProviderFactory.Dependencies dependencies) {
        final IndexProvider actualProvider = super.newInstance(context, dependencies);
        return new IndexProvider.Delegating(actualProvider){

            public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup) {
                IndexPopulator actualPopulator = actualProvider.getPopulator(descriptor, samplingConfig, bufferFactory, memoryTracker, tokenNameLookup);
                if (FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.POPULATION)) {
                    return new IndexPopulator.Delegating(actualPopulator){

                        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
                            throw new RuntimeException(FailingGenericNativeIndexProviderFactory.POPULATION_FAILURE_MESSAGE);
                        }
                    };
                }
                return actualPopulator;
            }

            public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
                final IndexAccessor actualAccessor = actualProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup);
                return new IndexAccessor.Delegating(actualAccessor){

                    public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
                        IndexUpdater actualUpdater = actualAccessor.newUpdater(mode, cursorContext);
                        return new DelegatingIndexUpdater(actualUpdater){

                            public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
                                if (!FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.SKIP_ONLINE_UPDATES)) {
                                    super.process(update);
                                }
                            }
                        };
                    }
                };
            }

            public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext) {
                return FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? FailingGenericNativeIndexProviderFactory.INITIAL_STATE_FAILURE_MESSAGE : actualProvider.getPopulationFailure(descriptor, cursorContext);
            }

            public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext) {
                return FailingGenericNativeIndexProviderFactory.this.failureTypes.contains((Object)FailureType.INITIAL_STATE) ? InternalIndexState.FAILED : actualProvider.getInitialState(descriptor, cursorContext);
            }
        };
    }

    public static enum FailureType {
        POPULATION,
        INITIAL_STATE,
        SKIP_ONLINE_UPDATES;

    }
}

