/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.dbms.DatabaseState;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.kernel.database.NamedDatabaseId;

public class StubDatabaseStateService
implements DatabaseStateService {
    private final Map<NamedDatabaseId, DatabaseState> databaseStates;
    private final Function<NamedDatabaseId, DatabaseState> unknownFactory;

    public StubDatabaseStateService(Function<NamedDatabaseId, DatabaseState> unknownFactory) {
        this.unknownFactory = unknownFactory;
        this.databaseStates = Collections.emptyMap();
    }

    public StubDatabaseStateService(Map<NamedDatabaseId, DatabaseState> databaseStates, Function<NamedDatabaseId, DatabaseState> unknownFactory) {
        this.databaseStates = databaseStates;
        this.unknownFactory = unknownFactory;
    }

    public DatabaseState stateOfDatabase(NamedDatabaseId namedDatabaseId) {
        DatabaseState state = this.databaseStates.get(namedDatabaseId);
        return state == null ? this.unknownFactory.apply(namedDatabaseId) : state;
    }

    public Optional<Throwable> causeOfFailure(NamedDatabaseId namedDatabaseId) {
        return Optional.ofNullable(this.databaseStates.get(namedDatabaseId)).flatMap(DatabaseState::failure);
    }

    public Map<NamedDatabaseId, DatabaseState> stateOfAllDatabases() {
        return Map.copyOf(this.databaseStates);
    }
}

