/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.lexer;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.neo4j.cypher.internal.util.InputPosition;

public class UnicodeEscapeReplacementReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final String cypher;
    private int srcPos;
    private OffsetTableBuilder offsetTable = null;
    boolean escaped = false;

    private UnicodeEscapeReplacementReader(String cypher) {
        this.cypher = cypher;
    }

    public static Result read(String cypher) throws IOException {
        return UnicodeEscapeReplacementReader.read(cypher, 4096);
    }

    public static Result read(String cypher, int maxBuffer) throws IOException {
        CodePointBuffer.Builder antlrBuffer = CodePointBuffer.builder((int)cypher.length());
        CharBuffer cb = CharBuffer.allocate(Math.min(maxBuffer, cypher.length()));
        try (UnicodeEscapeReplacementReader reader = new UnicodeEscapeReplacementReader(cypher);){
            while (reader.read(cb.clear()) != -1) {
                antlrBuffer.append(cb.flip());
            }
            CodePointCharStream charStream = CodePointCharStream.fromBuffer((CodePointBuffer)antlrBuffer.build(), (String)"<unknown>");
            Result result = new Result((CharStream)charStream, reader.offsetTable());
            return result;
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.srcPos >= this.cypher.length()) {
            return -1;
        }
        return this.doRead(cbuf, off, len);
    }

    private int doRead(char[] cbuf, int off, int len) {
        int srcPos;
        boolean isReplacement;
        String src = this.cypher;
        int srcEnd = src.length();
        int destPos = off;
        int destEnd = off + len;
        boolean escaped = this.escaped;
        OffsetTableBuilder offsetTable = this.offsetTable;
        for (srcPos = this.srcPos; srcPos < srcEnd && destPos < destEnd; srcPos += isReplacement ? 6 : 1) {
            boolean isHighSurrogate;
            char c = src.charAt(srcPos);
            boolean bl = isReplacement = !escaped && c == '\\' && this.peek(srcPos + 1) == 'u';
            if (isReplacement) {
                c = this.parseUnicodeReplacement(srcPos);
            }
            if ((isHighSurrogate = Character.isHighSurrogate(c)) && destPos + 1 == destEnd && srcPos + 1 < srcEnd && len > 1) break;
            if (offsetTable != null || isReplacement || isHighSurrogate) {
                offsetTable = this.updateOffsetTable(srcPos, c);
            }
            escaped = !escaped && !isReplacement && c == '\\';
            cbuf[destPos++] = c;
        }
        this.srcPos = srcPos;
        this.escaped = escaped;
        return destPos - off;
    }

    private char peek(int pos) {
        return pos < this.cypher.length() ? this.cypher.charAt(pos) : (char)'\u0000';
    }

    private OffsetTableBuilder updateOffsetTable(int charPos, char destChar) {
        if (this.offsetTable == null) {
            this.offsetTable = new OffsetTableBuilder(this.inputPositionAt(charPos), this.cypher.charAt(charPos), destChar);
        } else {
            this.offsetTable.updateOffsets(charPos, this.cypher.charAt(charPos), destChar);
        }
        return this.offsetTable;
    }

    private InputPosition inputPositionAt(int pos) {
        int line = 1;
        int col = 1;
        for (int i = 0; i < pos && i < this.cypher.length(); ++i) {
            char c = this.cypher.charAt(i);
            if (c == '\n' || c == '\r' && this.peek(i + 1) != '\n') {
                ++line;
                col = 0;
            }
            ++col;
        }
        return InputPosition.apply((int)pos, (int)line, (int)col);
    }

    private char parseUnicodeReplacement(int charPos) {
        String hexString = this.cypher.substring(Math.min(charPos + 2, this.cypher.length()), Math.min(charPos + 6, this.cypher.length()));
        try {
            return (char)Integer.parseInt(hexString, 16);
        }
        catch (Exception e) {
            InputPosition pos = this.inputPositionAt(charPos + 2);
            String m = "Invalid input '%s': expected four hexadecimal digits specifying a unicode character";
            throw new InvalidUnicodeLiteral(m.formatted(hexString), pos.offset(), pos.line(), pos.column());
        }
    }

    public int[] offsetTable() {
        if (this.offsetTable != null) {
            this.offsetTable.updateOffsets(this.srcPos, ' ', ' ');
        }
        return this.offsetTable != null ? this.offsetTable.offsets.toArray() : null;
    }

    @Override
    public void close() {
    }

    private static class OffsetTableBuilder {
        IntArrayList offsets = new IntArrayList();
        char lastSrcChar;
        char lastDestChar;

        OffsetTableBuilder(InputPosition start, char srcChar, char destChar) {
            this.offsets.addAll(new int[]{start.offset(), start.line(), start.column()});
            this.lastSrcChar = srcChar;
            this.lastDestChar = destChar;
        }

        void updateOffsets(int charPos, char srcChar, char destChar) {
            int line = this.offsets.get(this.offsets.size() - 2);
            int col = this.offsets.getLast() + charPos - this.offsets.get(this.offsets.size() - 3);
            if (this.lastSrcChar == '\n' || this.lastSrcChar == '\r' && srcChar != '\n') {
                ++line;
                col = 1;
            }
            if (!Character.isHighSurrogate(this.lastDestChar) || !Character.isLowSurrogate(destChar)) {
                this.offsets.addAll(new int[]{charPos, line, col});
            }
            this.lastSrcChar = srcChar;
            this.lastDestChar = destChar;
        }
    }

    public record Result(CharStream charStream, int[] offsetTable) {
    }

    public static class InvalidUnicodeLiteral
    extends RuntimeException {
        public final int offset;
        public final int line;
        public final int column;

        private InvalidUnicodeLiteral(String message, int offset, int line, int column) {
            super(message);
            this.offset = offset;
            this.line = line;
            this.column = column;
        }
    }
}

