/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory.neo4j.completion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntervalSet;

public class CodeCompletionCore {
    private Set<Integer> ignoredTokens = new HashSet<Integer>();
    private Set<Integer> preferredRules = new HashSet<Integer>();
    private Parser parser;
    private ATN atn;
    private Vocabulary vocabulary;
    private String[] ruleNames;
    private List<Token> tokens;
    private int tokenStartIndex = 0;
    private int statesProcessed = 0;
    private final Map<Integer, Map<Integer, Set<Integer>>> shortcutMap = new HashMap<Integer, Map<Integer, Set<Integer>>>();
    private final CandidatesCollection candidates = new CandidatesCollection();
    private static final Map<String, Map<Integer, FollowSetsHolder>> followSetsByATN = new HashMap<String, Map<Integer, FollowSetsHolder>>();

    public CodeCompletionCore(Parser parser, Set<Integer> preferredRules2, Set<Integer> ignoredTokens) {
        this.parser = parser;
        this.atn = parser.getATN();
        this.vocabulary = parser.getVocabulary();
        this.ruleNames = parser.getRuleNames();
        if (preferredRules2 != null) {
            this.preferredRules = preferredRules2;
        }
        if (ignoredTokens != null) {
            this.ignoredTokens = ignoredTokens;
        }
    }

    public Set<Integer> getPreferredRules() {
        return Collections.unmodifiableSet(this.preferredRules);
    }

    public void setPreferredRules(Set<Integer> preferredRules2) {
        this.preferredRules = new HashSet<Integer>(preferredRules2);
    }

    public CandidatesCollection collectCandidates(int caretTokenIndex, ParserRuleContext context) {
        Token token;
        this.shortcutMap.clear();
        this.candidates.rules.clear();
        this.candidates.tokens.clear();
        this.statesProcessed = 0;
        this.tokenStartIndex = context != null ? context.start.getTokenIndex() : 0;
        TokenStream tokenStream = this.parser.getInputStream();
        int currentIndex = tokenStream.index();
        tokenStream.seek(this.tokenStartIndex);
        this.tokens = new LinkedList<Token>();
        int offset = 1;
        do {
            token = tokenStream.LT(offset++);
            this.tokens.add(token);
        } while (token.getTokenIndex() < caretTokenIndex && token.getType() != -1);
        tokenStream.seek(currentIndex);
        LinkedList<Integer> callStack = new LinkedList<Integer>();
        int startRule = context != null ? context.getRuleIndex() : 0;
        this.processRule((ATNState)this.atn.ruleToStartState[startRule], 0, callStack, "\n");
        tokenStream.seek(currentIndex);
        for (int ruleId : this.preferredRules) {
            Map<Integer, Set<Integer>> shortcut = this.shortcutMap.get(ruleId);
            if (shortcut == null || shortcut.isEmpty()) continue;
            int startToken = Collections.max(shortcut.keySet());
            Set<Integer> endSet = shortcut.get(startToken);
            int endToken = endSet.isEmpty() ? this.tokens.size() - 1 : (Integer)Collections.max((Collection)shortcut.get(startToken));
            int startOffset = this.tokens.get(startToken).getStartIndex();
            int endOffset = this.tokens.get(endToken).getType() == -1 ? this.tokens.get(endToken).getStartIndex() : this.tokens.get(endToken - 1).getStopIndex() + 1;
            List<Integer> ruleStartStop = Arrays.asList(startOffset, endOffset);
            this.candidates.rulePositions.put(ruleId, ruleStartStop);
        }
        return this.candidates;
    }

    private boolean checkPredicate(PredicateTransition transition) {
        return transition.getPredicate().eval((Recognizer)this.parser, (RuleContext)ParserRuleContext.EMPTY);
    }

    private boolean translateToRuleIndex(List<Integer> ruleStack) {
        if (this.preferredRules.isEmpty()) {
            return false;
        }
        for (int i = 0; i < ruleStack.size(); ++i) {
            if (!this.preferredRules.contains(ruleStack.get(i))) continue;
            LinkedList<Integer> path = new LinkedList<Integer>(ruleStack.subList(0, i));
            boolean addNew = true;
            for (Map.Entry<Integer, List<Integer>> entry : this.candidates.rules.entrySet()) {
                if (!entry.getKey().equals(ruleStack.get(i)) || entry.getValue().size() != path.size() || !path.equals(entry.getValue())) continue;
                addNew = false;
                break;
            }
            if (addNew) {
                this.candidates.rules.put(ruleStack.get(i), path);
            }
            return true;
        }
        return false;
    }

    private List<Integer> getFollowingTokens(Transition initialTransition) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        LinkedList seen = new LinkedList();
        LinkedList<ATNState> pipeline = new LinkedList<ATNState>();
        pipeline.add(initialTransition.target);
        while (!pipeline.isEmpty()) {
            ATNState state = (ATNState)pipeline.removeLast();
            for (Transition transition : state.getTransitions()) {
                if (transition.getSerializationType() != 5) continue;
                if (!transition.isEpsilon()) {
                    List list = transition.label().toList();
                    if (list.size() != 1 || this.ignoredTokens.contains(list.get(0))) continue;
                    result.addLast((Integer)list.get(0));
                    pipeline.addLast(transition.target);
                    continue;
                }
                pipeline.addLast(transition.target);
            }
        }
        return result;
    }

    private LinkedList<FollowSetWithPath> determineFollowSets(ATNState start, ATNState stop) {
        LinkedList<FollowSetWithPath> result = new LinkedList<FollowSetWithPath>();
        HashSet<ATNState> seen = new HashSet<ATNState>();
        LinkedList<Integer> ruleStack = new LinkedList<Integer>();
        this.collectFollowSets(start, stop, result, seen, ruleStack);
        return result;
    }

    private void collectFollowSets(ATNState s, ATNState stopState, LinkedList<FollowSetWithPath> followSets, Set<ATNState> seen, LinkedList<Integer> ruleStack) {
        if (seen.contains(s)) {
            return;
        }
        seen.add(s);
        if (s.equals((Object)stopState) || s.getStateType() == 7) {
            FollowSetWithPath set = new FollowSetWithPath();
            set.intervals = IntervalSet.of((int)-2);
            set.path = new LinkedList<Integer>(ruleStack);
            set.following = new LinkedList<Integer>();
            followSets.addLast(set);
            return;
        }
        for (Transition transition : s.getTransitions()) {
            if (transition.getSerializationType() == 3) {
                RuleTransition ruleTransition = (RuleTransition)transition;
                if (ruleStack.indexOf(ruleTransition.target.ruleIndex) != -1) continue;
                ruleStack.addLast(ruleTransition.target.ruleIndex);
                this.collectFollowSets(transition.target, stopState, followSets, seen, ruleStack);
                ruleStack.removeLast();
                continue;
            }
            if (transition.getSerializationType() == 4) {
                if (!this.checkPredicate((PredicateTransition)transition)) continue;
                this.collectFollowSets(transition.target, stopState, followSets, seen, ruleStack);
                continue;
            }
            if (transition.isEpsilon()) {
                this.collectFollowSets(transition.target, stopState, followSets, seen, ruleStack);
                continue;
            }
            if (transition.getSerializationType() == 9) {
                FollowSetWithPath set = new FollowSetWithPath();
                set.intervals = IntervalSet.of((int)1, (int)this.atn.maxTokenType);
                set.path = new LinkedList<Integer>(ruleStack);
                set.following = new LinkedList<Integer>();
                followSets.addLast(set);
                continue;
            }
            IntervalSet label = transition.label();
            if (label == null || label.size() <= 0) continue;
            if (transition.getSerializationType() == 8) {
                label = label.complement((IntSet)IntervalSet.of((int)1, (int)this.atn.maxTokenType));
            }
            FollowSetWithPath set = new FollowSetWithPath();
            set.intervals = label;
            set.path = new LinkedList<Integer>(ruleStack);
            set.following = this.getFollowingTokens(transition);
            followSets.addLast(set);
        }
    }

    private Set<Integer> processRule(ATNState startState, int tokenIndex, LinkedList<Integer> callStack, String indentation) {
        FollowSetsHolder followSets;
        Map<Integer, Set<Integer>> positionMap = this.shortcutMap.get(startState.ruleIndex);
        if (positionMap == null) {
            positionMap = new HashMap<Integer, Set<Integer>>();
            this.shortcutMap.put(startState.ruleIndex, positionMap);
        } else if (positionMap.containsKey(tokenIndex)) {
            return positionMap.get(tokenIndex);
        }
        HashSet<Integer> result = new HashSet<Integer>();
        Map<Integer, FollowSetsHolder> setsPerState = followSetsByATN.get(this.parser.getClass().getName());
        if (setsPerState == null) {
            setsPerState = new HashMap<Integer, FollowSetsHolder>();
            followSetsByATN.put(this.parser.getClass().getName(), setsPerState);
        }
        if ((followSets = setsPerState.get(startState.stateNumber)) == null) {
            followSets = new FollowSetsHolder();
            setsPerState.put(startState.stateNumber, followSets);
            RuleStopState stop = this.atn.ruleToStopState[startState.ruleIndex];
            followSets.sets = this.determineFollowSets(startState, (ATNState)stop);
            IntervalSet combined = new IntervalSet(new int[0]);
            for (FollowSetWithPath set : followSets.sets) {
                combined.addAll((IntSet)set.intervals);
            }
            followSets.combined = combined;
        }
        callStack.addLast(startState.ruleIndex);
        int currentSymbol = this.tokens.get(tokenIndex).getType();
        if (tokenIndex >= this.tokens.size() - 1) {
            if (this.preferredRules.contains(startState.ruleIndex)) {
                this.translateToRuleIndex(callStack);
            } else {
                for (FollowSetWithPath set : followSets.sets) {
                    LinkedList<Integer> fullPath = new LinkedList<Integer>(callStack);
                    fullPath.addAll(set.path);
                    if (this.translateToRuleIndex(fullPath)) continue;
                    Iterator iterator = set.intervals.toList().iterator();
                    while (iterator.hasNext()) {
                        int symbol = (Integer)iterator.next();
                        if (this.ignoredTokens.contains(symbol)) continue;
                        if (!this.candidates.tokens.containsKey(symbol)) {
                            this.candidates.tokens.put(symbol, set.following);
                            continue;
                        }
                        if (this.candidates.tokens.get(symbol).equals(set.following)) continue;
                        this.candidates.tokens.put(symbol, new LinkedList());
                    }
                }
            }
            callStack.removeLast();
            return result;
        }
        if (!followSets.combined.contains(-2) && !followSets.combined.contains(currentSymbol)) {
            callStack.removeLast();
            return result;
        }
        LinkedList<PipelineEntry> statePipeline = new LinkedList<PipelineEntry>();
        statePipeline.add(new PipelineEntry(startState, tokenIndex));
        block12: while (!statePipeline.isEmpty()) {
            Transition[] transitions;
            PipelineEntry currentEntry = (PipelineEntry)statePipeline.removeLast();
            ++this.statesProcessed;
            currentSymbol = this.tokens.get(currentEntry.tokenIndex).getType();
            boolean atCaret = currentEntry.tokenIndex >= this.tokens.size() - 1;
            switch (currentEntry.state.getStateType()) {
                case 2: {
                    indentation = (String)indentation + "  ";
                    break;
                }
                case 7: {
                    result.add(currentEntry.tokenIndex);
                    continue block12;
                }
            }
            block13: for (Transition transition : transitions = currentEntry.state.getTransitions()) {
                switch (transition.getSerializationType()) {
                    case 3: {
                        Set<Integer> endStatus = this.processRule(transition.target, currentEntry.tokenIndex, callStack, (String)indentation);
                        Iterator<Integer> iterator = endStatus.iterator();
                        while (iterator.hasNext()) {
                            Integer position = iterator.next();
                            statePipeline.addLast(new PipelineEntry(((RuleTransition)transition).followState, position));
                        }
                        continue block13;
                    }
                    case 4: {
                        if (!this.checkPredicate((PredicateTransition)transition)) continue block13;
                        statePipeline.addLast(new PipelineEntry(transition.target, currentEntry.tokenIndex));
                        continue block13;
                    }
                    case 9: {
                        if (atCaret) {
                            if (this.translateToRuleIndex(callStack)) continue block13;
                            for (Integer token : IntervalSet.of((int)1, (int)this.atn.maxTokenType).toList()) {
                                if (this.ignoredTokens.contains(token)) continue;
                                this.candidates.tokens.put(token, new LinkedList());
                            }
                            continue block13;
                        }
                        statePipeline.addLast(new PipelineEntry(transition.target, currentEntry.tokenIndex + 1));
                        continue block13;
                    }
                    default: {
                        if (transition.isEpsilon()) {
                            statePipeline.addLast(new PipelineEntry(transition.target, currentEntry.tokenIndex));
                            continue block13;
                        }
                        IntervalSet set = transition.label();
                        if (set == null || set.size() <= 0) continue block13;
                        if (transition.getSerializationType() == 8) {
                            set = set.complement((IntSet)IntervalSet.of((int)1, (int)this.atn.maxTokenType));
                        }
                        if (atCaret) {
                            if (this.translateToRuleIndex(callStack)) continue block13;
                            List list = set.toList();
                            boolean addFollowing = list.size() == 1;
                            for (Integer symbol : list) {
                                if (this.ignoredTokens.contains(symbol)) continue;
                                if (addFollowing) {
                                    this.candidates.tokens.put(symbol, this.getFollowingTokens(transition));
                                    continue;
                                }
                                this.candidates.tokens.put(symbol, new LinkedList());
                            }
                            continue block13;
                        }
                        if (!set.contains(currentSymbol)) continue block13;
                        statePipeline.addLast(new PipelineEntry(transition.target, currentEntry.tokenIndex + 1));
                    }
                }
            }
        }
        callStack.removeLast();
        positionMap.put(tokenIndex, result);
        return result;
    }

    public static class CandidatesCollection {
        public Map<Integer, List<Integer>> tokens = new HashMap<Integer, List<Integer>>();
        public Map<Integer, List<Integer>> rules = new HashMap<Integer, List<Integer>>();
        public Map<Integer, List<Integer>> rulePositions = new HashMap<Integer, List<Integer>>();

        public String toString() {
            return "CandidatesCollection{tokens=" + this.tokens + ", rules=" + this.rules + ", ruleStrings=" + this.rulePositions + "}";
        }
    }

    public static class FollowSetWithPath {
        public IntervalSet intervals;
        public List<Integer> path;
        public List<Integer> following;
    }

    public static class FollowSetsHolder {
        public List<FollowSetWithPath> sets;
        public IntervalSet combined;
    }

    public static class PipelineEntry {
        ATNState state;
        Integer tokenIndex;

        public PipelineEntry(ATNState state, Integer tokenIndex) {
            this.state = state;
            this.tokenIndex = tokenIndex;
        }
    }
}

