/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.deprecation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeprecatedChars {
    private static final char[] DEPRECATED_CHARS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '$', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00ad', '\u0600', '\u0601', '\u0602', '\u0603', '\u0604', '\u0605', '\u061c', '\u06dd', '\u070f', '\u08e2', '\u180e', '\u200b', '\u200c', '\u200d', '\u200e', '\u200f', '\u202a', '\u202b', '\u202c', '\u202d', '\u202e', '\u2060', '\u2061', '\u2062', '\u2063', '\u2064', '\u2066', '\u2067', '\u2068', '\u2069', '\u206a', '\u206b', '\u206c', '\u206d', '\u206e', '\u206f', '\u2e2f', '\ufeff', '\ufff9', '\ufffa', '\ufffb'};
    private static final char SAFE_FROM = '%';
    private static final char SAFE_TO = '~';

    private DeprecatedChars() {
    }

    public static boolean containsDeprecatedChar(String s) {
        int codepoint;
        int length = s.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            if (!DeprecatedChars.isDeprecated(codepoint)) continue;
            return true;
        }
        return false;
    }

    public static List<Character> deprecatedChars(String s) {
        ArrayList<Character> result = new ArrayList<Character>(1);
        for (char deprecated : DEPRECATED_CHARS) {
            if (s.indexOf(deprecated) == -1) continue;
            result.add(Character.valueOf(deprecated));
        }
        return result;
    }

    private static boolean isDeprecated(int c) {
        if (c >= 37 && c <= 126) {
            return false;
        }
        for (char deprecated : DEPRECATED_CHARS) {
            if (deprecated != c) continue;
            return true;
        }
        return false;
    }

    static {
        Arrays.sort(DEPRECATED_CHARS);
        for (char deprecated : DEPRECATED_CHARS) {
            if (deprecated < '%' || deprecated > '~') continue;
            throw new IllegalStateException("safeFrom/safeTo is incorrect");
        }
    }
}

