/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.v25.ast.factory;

import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionName;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.ast.SyntaxChecker;
import org.neo4j.cypher.internal.parser.ast.util.Util$;
import org.neo4j.cypher.internal.parser.common.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.parser.v25.Cypher25Parser;
import org.neo4j.cypher.internal.parser.v25.ast.factory.Cypher25SyntaxChecker$;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.CypherExceptionFactory;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import org.neo4j.internal.helpers.NameUtil;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\r]a\u0001\u0002\u0017.\u0005yB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0015B-\t\u000b)\u0004A\u0011I6\t\u000bA\u0004A\u0011I9\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u0013\u0005e\u0005!%A\u0005\n\u0005m\u0005bBA[\u0001\u0011%\u0011q\u0017\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0005\u0003\u001bDq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0003\u0002\u0001!IAa\u0001\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!1\u0006\u0001\u0005\n\t5\u0002b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003d\u0001!IA!\u001a\t\u000f\t=\u0004\u0001\"\u0003\u0003r!9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BD\u0001\u0011%!\u0011\u0012\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u00038\u0002!IA!/\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!q\u001a\u0001\u0005\n\tE\u0007b\u0002Bn\u0001\u0011%!Q\u001c\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005k<qAa@.\u0011\u0003\u0019\tA\u0002\u0004-[!\u000511\u0001\u0005\u0007'\u001a\"\taa\u0003\t\u0013\r5aE1A\u0005\n\r=\u0001\u0002CB\tM\u0001\u0006IA!\u0004\t\u0013\rMaE1A\u0005\n\r=\u0001\u0002CB\u000bM\u0001\u0006IA!\u0004\u0003+\rK\b\u000f[3seU\u001a\u0016P\u001c;bq\u000eCWmY6fe*\u0011afL\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0001\u0014'A\u0002bgRT!AM\u001a\u0002\u0007Y\u0014TG\u0003\u00025k\u00051\u0001/\u0019:tKJT!AN\u001c\u0002\u0011%tG/\u001a:oC2T!\u0001O\u001d\u0002\r\rL\b\u000f[3s\u0015\tQ4(A\u0003oK>$$NC\u0001=\u0003\ry'oZ\u0002\u0001'\r\u0001qh\u0012\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bA\u0001\\1oO*\tA)\u0001\u0003kCZ\f\u0017B\u0001$B\u0005\u0019y%M[3diB\u0011\u0001JS\u0007\u0002\u0013*\u0011\u0001gM\u0005\u0003\u0017&\u0013QbU=oi\u0006D8\t[3dW\u0016\u0014\u0018\u0001E3yG\u0016\u0004H/[8o\r\u0006\u001cGo\u001c:z!\tq\u0015+D\u0001P\u0015\t\u0001V'\u0001\u0003vi&d\u0017B\u0001*P\u0005Y\u0019\u0015\u0010\u001d5fe\u0016C8-\u001a9uS>tg)Y2u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0002V/B\u0011a\u000bA\u0007\u0002[!)AJ\u0001a\u0001\u001b\u00069q,\u001a:s_J\u001c\bc\u0001.eO:\u00111,\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=v\na\u0001\u0010:p_Rt\u0014\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t\u001c\u0017a\u00029bG.\fw-\u001a\u0006\u0002A&\u0011QM\u001a\u0002\u0004'\u0016\f(B\u00012d!\tQ\u0006.\u0003\u0002jM\nIQ\t_2faRLwN\\\u0001\u0007KJ\u0014xN]:\u0016\u00031\u00042A\u00173n!\tQf.\u0003\u0002pM\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u000em&\u001c\u0018\u000e\u001e+fe6Lg.\u00197\u0015\u0005I4\bCA:u\u001b\u0005\u0019\u0017BA;d\u0005\u0011)f.\u001b;\t\u000b],\u0001\u0019\u0001=\u0002\t9|G-\u001a\t\u0004s\u0006\u0015Q\"\u0001>\u000b\u0005md\u0018\u0001\u0002;sK\u0016T!! @\u0002\u000fI,h\u000e^5nK*\u0019q0!\u0001\u0002\u0005Y$$bAA\u0002w\u0005)\u0011M\u001c;me&\u0019\u0011q\u0001>\u0003\u0019Q+'/\\5oC2tu\u000eZ3\u0002\u001dYL7/\u001b;FeJ|'OT8eKR\u0019!/!\u0004\t\r]4\u0001\u0019AA\b!\rI\u0018\u0011C\u0005\u0004\u0003'Q(!C#se>\u0014hj\u001c3f\u00039)g\u000e^3s\u000bZ,'/\u001f*vY\u0016$2A]A\r\u0011\u001d\tYb\u0002a\u0001\u0003;\t1a\u0019;y!\u0011\ty\"!\t\u000e\u0003qL1!a\t}\u0005E\u0001\u0016M]:feJ+H.Z\"p]R,\u0007\u0010^\u0001\u000eKbLG/\u0012<fef\u0014V\u000f\\3\u0015\u0007I\fI\u0003C\u0004\u0002\u001c!\u0001\r!!\b\u0002\u000b\rDWmY6\u0015\t\u0005=\u0012Q\u0007\t\u0004g\u0006E\u0012bAA\u001aG\n9!i\\8mK\u0006t\u0007bBA\u000e\u0013\u0001\u0007\u0011QD\u0001\u000eS:\u0004X\u000f\u001e)pg&$\u0018n\u001c8\u0015\t\u0005m\u0012\u0011\t\t\u0004\u001d\u0006u\u0012bAA \u001f\ni\u0011J\u001c9viB{7/\u001b;j_:Dq!a\u0011\u000b\u0001\u0004\t)%\u0001\u0004ts6\u0014w\u000e\u001c\t\u0005\u0003?\t9%C\u0002\u0002Jq\u0014Q\u0001V8lK:\f\u0001#\u001a:s_J|e\u000eR;qY&\u001c\u0017\r^3\u0015\u000fI\fy%a\u0015\u0002h!9\u0011\u0011K\u0006A\u0002\u0005\u0015\u0013!\u0002;pW\u0016t\u0007bBA+\u0017\u0001\u0007\u0011qK\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0003\u0002Z\u0005\u0005d\u0002BA.\u0003;\u0002\"\u0001X2\n\u0007\u0005}3-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\n)G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?\u001a\u0007bBA5\u0017\u0001\u0007\u0011qF\u0001\bSN\u0004\u0016M]1n\u0003M)'O]8s\u001f:$U\u000f\u001d7jG\u0006$Xm\u0011;y+\u0011\ty'!!\u0015\u000fI\f\t(!&\u0002\u0018\"9\u00111\u0004\u0007A\u0002\u0005M\u0004CBA;\u0003s\ni(\u0004\u0002\u0002x)\u0011\u0001kQ\u0005\u0005\u0003w\n9H\u0001\u0003MSN$\b\u0003BA@\u0003\u0003c\u0001\u0001B\u0004\u0002\u00042\u0011\r!!\"\u0003\u0003Q\u000bB!a\"\u0002\u000eB\u00191/!#\n\u0007\u0005-5MA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0015\u0011S\u0007\u0002g%\u0019\u00111S\u001a\u0003\u0015\u0005\u001bHOU;mK\u000e#\b\u0010C\u0004\u0002V1\u0001\r!a\u0016\t\u0013\u0005%D\u0002%AA\u0002\u0005=\u0012!H3se>\u0014xJ\u001c#va2L7-\u0019;f\u0007RDH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005u\u00151W\u000b\u0003\u0003?SC!a\f\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.\u000e\f!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0002\u00046\u0011\r!!\"\u0002)\u0015\u0014(o\u001c:P]\u0012+\b\u000f\\5dCR,'+\u001e7f+\u0011\tI,a1\u0015\u000fI\fY,a2\u0002J\"9\u0011Q\u0018\bA\u0002\u0005}\u0016A\u00029be\u0006l7\u000f\u0005\u0004\u0002v\u0005e\u0014\u0011\u0019\t\u0005\u0003\u007f\n\u0019\rB\u0004\u0002\u0004:\u0011\r!!2\u0012\t\u0005\u001d\u0015Q\u0004\u0005\b\u0003+r\u0001\u0019AA,\u0011%\tIG\u0004I\u0001\u0002\u0004\ty#\u0001\u0010feJ|'o\u00148EkBd\u0017nY1uKJ+H.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011QTAh\t\u001d\t\u0019i\u0004b\u0001\u0003\u000b\fa$\u001a:s_J|e.\u00117jCNt\u0015-\\3D_:$\u0018-\u001b8j]\u001e$u\u000e^:\u0015\u0007I\f)\u000eC\u0004\u0002XB\u0001\r!!7\u0002\u0019\u0005d\u0017.Y:fg:\u000bW.Z:\u0011\r\u0005U\u0014\u0011PAn!\u0011\ti.a?\u000f\t\u0005}\u0017q\u001f\b\u0005\u0003C\f)P\u0004\u0003\u0002d\u0006Mh\u0002BAs\u0003ctA!a:\u0002p:!\u0011\u0011^Aw\u001d\ra\u00161^\u0005\u0002y%\u0011!hO\u0005\u0003qeJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\r\tI0M\u0001\u000f\u0007f\u0004\b.\u001a:3kA\u000b'o]3s\u0013\u0011\ti0a@\u0003GMKXNY8mS\u000e\fE.[1t\u001d\u0006lWm\u0014:QCJ\fW.\u001a;fe\u000e{g\u000e^3yi*\u0019\u0011\u0011`\u0019\u0002W\u0015\u0014(o\u001c:P]\u0006c\u0017.Y:OC6,7i\u001c8uC&t\u0017N\\4U_>l\u0015M\\=D_6\u0004xN\\3oiN$\u0012B\u001dB\u0003\u0005\u0013\u0011\u0019Ba\u0006\t\u000f\u0005]\u0017\u00031\u0001\u0003\bA!!\fZAn\u0011\u001d\u0011Y!\u0005a\u0001\u0005\u001b\tQ\"\\1y\u0007>l\u0007o\u001c8f]R\u001c\bcA:\u0003\u0010%\u0019!\u0011C2\u0003\u0007%sG\u000fC\u0004\u0003\u0016E\u0001\r!a\u0016\u0002\u001b\u0015\u0014(o\u001c:UK6\u0004H.\u0019;f\u0011\u001d\u0011I\"\u0005a\u0001\u0003/\nqaY8oi\u0016DH/A\u0013dQ\u0016\u001c7nU;ccV,'/_%o)J\fgn]1di&|gn\u001d)be\u0006lW\r^3sgR\u0019!Oa\b\t\u000f\u0005m!\u00031\u0001\u0003\"A!!1\u0005B\u0014\u001d\u0011\u0011)#a>\u000e\u0003EJAA!\u000b\u0002\u0000\n93+\u001e2rk\u0016\u0014\u00180\u00138Ue\u0006t7/Y2uS>t7\u000fU1sC6,G/\u001a:t\u0007>tG/\u001a=u\u0003A\u0019\u0007.Z2l\u0007J,\u0017\r^3BY&\f7\u000fF\u0002s\u0005_Aq!a\u0007\u0014\u0001\u0004\u0011\t\u0004\u0005\u0003\u0003$\tM\u0012\u0002\u0002B\u001b\u0003\u007f\u0014!c\u0011:fCR,\u0017\t\\5bg\u000e{g\u000e^3yi\u0006y1\r[3dW\u0006cG/\u001a:BY&\f7\u000fF\u0002s\u0005wAq!a\u0007\u0015\u0001\u0004\u0011i\u0004\u0005\u0003\u0003$\t}\u0012\u0002\u0002B!\u0003\u007f\u0014\u0011#\u00117uKJ\fE.[1t\u0007>tG/\u001a=u\u0003\u0005\u001a\u0007.Z2l'fl'm\u001c7jG\u0006c\u0017.Y:OC6,wJ\u001d)be\u0006lW\r^3s)\r\u0011(q\t\u0005\b\u00037)\u0002\u0019\u0001B%!\u0011\u0011\u0019#a?\u0002\u001f\rDWmY6De\u0016\fG/Z+tKJ$2A\u001dB(\u0011\u001d\tYB\u0006a\u0001\u0005#\u0002BAa\t\u0003T%!!QKA\u0000\u0005E\u0019%/Z1uKV\u001bXM]\"p]R,\u0007\u0010^\u0001\u000fG\",7m[!mi\u0016\u0014Xk]3s)\r\u0011(1\f\u0005\b\u000379\u0002\u0019\u0001B/!\u0011\u0011\u0019Ca\u0018\n\t\t\u0005\u0014q \u0002\u0011\u00032$XM]+tKJ\u001cuN\u001c;fqR\f\u0011c\u00195fG.\fE\u000e\u001c)sSZLG.Z4f)\r\u0011(q\r\u0005\b\u00037A\u0002\u0019\u0001B5!\u0011\u0011\u0019Ca\u001b\n\t\t5\u0014q \u0002\u0014\u00032d\u0007K]5wS2,w-Z\"p]R,\u0007\u0010^\u0001\u000eG\",7m[$m_\n\u0004\u0016M\u001d;\u0015\u0007I\u0014\u0019\bC\u0004\u0002\u001ce\u0001\rA!\u001e\u0011\t\t\r\"qO\u0005\u0005\u0005s\nyPA\bHY>\u0014\u0007+\u0019:u\u0007>tG/\u001a=u\u0003U\u0019\u0007.Z2l\u0007J,\u0017\r^3D_:\u001cHO]1j]R$2A\u001dB@\u0011\u001d\tYB\u0007a\u0001\u0005\u0003\u0003BAa\t\u0003\u0004&!!QQA\u0000\u0005]\u0019%/Z1uK\u000e{gn\u001d;sC&tGoQ8oi\u0016DH/A\rdQ\u0016\u001c7.\u00128dY>\u001cX\r\u001a)s_B,'\u000f^=MSN$Hc\u0001:\u0003\f\"9\u00111D\u000eA\u0002\t5\u0005\u0003\u0002B\u0012\u0005\u001fKAA!%\u0002\u0000\nYRI\\2m_N,G\r\u0015:pa\u0016\u0014H/\u001f'jgR\u001cuN\u001c;fqR\fQb\u00195fG.$v\u000e]8m_\u001eLHc\u0001:\u0003\u0018\"9\u00111\u0004\u000fA\u0002\te\u0005\u0003\u0002B\u0012\u00057KAA!(\u0002\u0000\nyAk\u001c9pY><\u0017pQ8oi\u0016DH/\u0001\ndQ\u0016\u001c7.\u00117uKJ$\u0015\r^1cCN,Gc\u0001:\u0003$\"9\u00111D\u000fA\u0002\t\u0015\u0006\u0003\u0002B\u0012\u0005OKAA!+\u0002\u0000\n!\u0012\t\u001c;fe\u0012\u000bG/\u00192bg\u0016\u001cuN\u001c;fqR\f!d\u00195fG.\fE\u000e^3s\t\u0006$\u0018MY1tKR{\u0007o\u001c7pOf$2A\u001dBX\u0011\u001d\tYB\ba\u0001\u0005c\u0003BAa\t\u00034&!!QWA\u0000\u0005q\tE\u000e^3s\t\u0006$\u0018MY1tKR{\u0007o\u001c7pOf\u001cuN\u001c;fqR\fac\u00195fG.\u001c%/Z1uK2{wn[;q\u0013:$W\r\u001f\u000b\u0004e\nm\u0006bBA\u000e?\u0001\u0007!Q\u0018\t\u0005\u0005G\u0011y,\u0003\u0003\u0003B\u0006}(\u0001G\"sK\u0006$X\rT8pWV\u0004\u0018J\u001c3fq\u000e{g\u000e^3yi\u0006\u00112\r[3dW&s7/\u001a:u!\u0006$H/\u001a:o)\r\u0011(q\u0019\u0005\b\u00037\u0001\u0003\u0019\u0001Be!\u0011\u0011\u0019Ca3\n\t\t5\u0017q \u0002\u0015\u0013:\u001cXM\u001d;QCR$XM\u001d8D_:$X\r\u001f;\u00027\rDWmY6J]N,'\u000f\u001e'bE\u0016d7i\u001c8kk:\u001cG/[8o)\r\u0011(1\u001b\u0005\b\u00037\t\u0003\u0019\u0001Bk!\u0011\u0011\u0019Ca6\n\t\te\u0017q \u0002!\u0013:\u001cXM\u001d;O_\u0012,G*\u00192fY\u0016C\bO]3tg&|gnQ8oi\u0016DH/A\fdQ\u0016\u001c7NR;oGRLwN\\%om>\u001c\u0017\r^5p]R\u0019!Oa8\t\u000f\u0005m!\u00051\u0001\u0003bB!!1\u0005Br\u0013\u0011\u0011)/a@\u00033\u0019+hn\u0019;j_:LeN^8dCRLwN\\\"p]R,\u0007\u0010^\u0001\u000eG\",7m\u001b+za\u0016\u0004\u0016M\u001d;\u0015\u0007I\u0014Y\u000fC\u0004\u0002\u001c\r\u0002\rA!<\u0011\t\t\r\"q^\u0005\u0005\u0005c\fyPA\bUsB,\u0007+\u0019:u\u0007>tG/\u001a=u\u0003\u0005\u001a\u0007.Z2l\t\u00164\u0017-\u001e7u\u0019\u0006tw-^1hKN\u0003XmY5gS\u000e\fG/[8o)\r\u0011(q\u001f\u0005\b\u00037!\u0003\u0019\u0001B}!\u0011\u0011\u0019Ca?\n\t\tu\u0018q \u0002$\t\u00164\u0017-\u001e7u\u0019\u0006tw-^1hKN\u0003XmY5gS\u000e\fG/[8o\u0007>tG/\u001a=u\u0003U\u0019\u0015\u0010\u001d5feJ*4+\u001f8uCb\u001c\u0005.Z2lKJ\u0004\"A\u0016\u0014\u0014\u0007\u0019\u001a)\u0001E\u0002t\u0007\u000fI1a!\u0003d\u0005\u0019\te.\u001f*fMR\u00111\u0011A\u0001\u001a\u001b\u0006Cv,\u0011'J\u0003N{f*Q'F?\u000e{U\nU(O\u000b:#6+\u0006\u0002\u0003\u000e\u0005QR*\u0011-`\u00032K\u0015iU0O\u00036+ulQ(N!>sUI\u0014+TA\u0005aR*\u0011-`\t\u0006#\u0016IQ!T\u000b~s\u0015)T#`\u0007>k\u0005k\u0014(F\u001dR\u001b\u0016!H'B1~#\u0015\tV!C\u0003N+uLT!N\u000b~\u001bu*\u0014)P\u001d\u0016sEk\u0015\u0011")
public final class Cypher25SyntaxChecker
implements SyntaxChecker {
    private final CypherExceptionFactory exceptionFactory;
    private Seq<Exception> _errors;

    public Seq<Throwable> errors() {
        return this._errors;
    }

    public void visitTerminal(TerminalNode node) {
    }

    public void visitErrorNode(ErrorNode node) {
    }

    public void enterEveryRule(ParserRuleContext ctx) {
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        int n = ctx.getRuleIndex();
        switch (n) {
            case 48: {
                this.checkSubqueryInTransactionsParameters((Cypher25Parser.SubqueryInTransactionsParametersContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 184: {
                this.checkCreateConstraint((Cypher25Parser.CreateConstraintContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 197: {
                this.checkEnclosedPropertyList((Cypher25Parser.EnclosedPropertyListContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 192: {
                this.checkCreateLookupIndex((Cypher25Parser.CreateLookupIndexContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 220: {
                this.checkCreateUser((Cypher25Parser.CreateUserContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 224: {
                this.checkAlterUser((Cypher25Parser.AlterUserContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 243: {
                this.checkAllPrivilege((Cypher25Parser.AllPrivilegeContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 291: {
                this.checkTopology((Cypher25Parser.TopologyContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 299: {
                this.checkAlterDatabase((Cypher25Parser.AlterDatabaseContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 301: {
                this.checkAlterDatabaseTopology((Cypher25Parser.AlterDatabaseTopologyContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 311: {
                this.checkCreateAlias((Cypher25Parser.CreateAliasContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 313: {
                this.checkAlterAlias((Cypher25Parser.AlterAliasContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 274: {
                this.checkGlobPart((Cypher25Parser.GlobPartContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 57: {
                this.checkInsertPattern((Cypher25Parser.InsertPatternContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 90: {
                this.checkInsertLabelConjunction((Cypher25Parser.InsertNodeLabelExpressionContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 139: {
                this.checkFunctionInvocation((Cypher25Parser.FunctionInvocationContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 146: {
                this.checkTypePart((Cypher25Parser.TypePartContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 324: {
                this.checkSymbolicAliasNameOrParameter((Cypher25Parser.SymbolicAliasNameOrParameterContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
            case 296: {
                this.checkDefaultLanguageSpecification((Cypher25Parser.DefaultLanguageSpecificationContext)Util$.MODULE$.cast((Object)ctx));
                return;
            }
        }
    }

    public boolean check(ParserRuleContext ctx) {
        this.exitEveryRule(ctx);
        return this._errors.isEmpty();
    }

    private InputPosition inputPosition(Token symbol) {
        return InputPosition$.MODULE$.apply(symbol.getStartIndex(), symbol.getLine(), symbol.getCharPositionInLine() + 1);
    }

    private void errorOnDuplicate(Token token, String description, boolean isParam) {
        if (isParam) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.duplicateClauseParameter(description, this.inputPosition(token)));
            return;
        }
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Duplicate " + description + " clause", this.inputPosition(token)));
    }

    private <T extends AstRuleCtx> void errorOnDuplicateCtx(java.util.List<T> ctx, String description, boolean isParam) {
        if (ctx.size() > 1) {
            this.errorOnDuplicate(Util$.MODULE$.nodeChild((AstRuleCtx)ctx.get(1), 0).getSymbol(), description, isParam);
            return;
        }
    }

    private <T extends AstRuleCtx> boolean errorOnDuplicateCtx$default$3() {
        return false;
    }

    private <T extends ParserRuleContext> void errorOnDuplicateRule(java.util.List<T> params, String description, boolean isParam) {
        if (params.size() > 1) {
            this.errorOnDuplicate(((ParserRuleContext)params.get((int)1)).start, description, isParam);
            return;
        }
    }

    private <T extends ParserRuleContext> boolean errorOnDuplicateRule$default$3() {
        return false;
    }

    private void errorOnAliasNameContainingDots(java.util.List<Cypher25Parser.SymbolicAliasNameOrParameterContext> aliasesNames) {
        if (aliasesNames.size() > 0) {
            Cypher25Parser.SymbolicAliasNameOrParameterContext aliasName = aliasesNames.get(0);
            if (aliasName.symbolicAliasName() != null && aliasName.symbolicAliasName().symbolicNameString().size() > Cypher25SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v25$ast$factory$Cypher25SyntaxChecker$$MAX_ALIAS_NAME_COMPONENTS()) {
                Token start = ((ParserRuleContext)aliasName.symbolicAliasName().symbolicNameString().get(0)).getStart();
                String prettyName = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aliasName.symbolicAliasName().symbolicNameString()).asScala().map((Function1 & Serializable)x0$1 -> {
                    Cypher25Parser.SymbolicNameStringContext symbolicNameStringContext = x0$1;
                    if (symbolicNameStringContext.unescapedSymbolicNameString() != null) {
                        return symbolicNameStringContext.unescapedSymbolicNameString().ast;
                    }
                    if (symbolicNameStringContext.escapedSymbolicNameString() != null) {
                        return NameUtil.forceEscapeName((String)((String)symbolicNameStringContext.escapedSymbolicNameString().ast()));
                    }
                    return "";
                })).mkString(".");
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidNameTooManyComponents("Invalid input `%s` for name. Expected name to contain at most two components separated by `.`.", "name", Cypher25SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v25$ast$factory$Cypher25SyntaxChecker$$MAX_ALIAS_NAME_COMPONENTS(), prettyName, this.inputPosition(start)));
                return;
            }
            return;
        }
    }

    private void errorOnAliasNameContainingTooManyComponents(Seq<Cypher25Parser.SymbolicAliasNameOrParameterContext> aliasesNames, int maxComponents, String errorTemplate, String context) {
        if (aliasesNames.nonEmpty()) {
            Seq literalAliasNames = (Seq)aliasesNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cypher25SyntaxChecker.$anonfun$errorOnAliasNameContainingTooManyComponents$1(x$1)));
            literalAliasNames.foreach((Function1 & Serializable)aliasName -> {
                Cypher25SyntaxChecker.$anonfun$errorOnAliasNameContainingTooManyComponents$2(this, maxComponents, errorTemplate, context, aliasName);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void checkSubqueryInTransactionsParameters(Cypher25Parser.SubqueryInTransactionsParametersContext ctx) {
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsBatchParameters(), "OF ROWS", true);
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsErrorParameters(), "ON ERROR", true);
        this.errorOnDuplicateRule(ctx.subqueryInTransactionsReportParameters(), "REPORT STATUS", true);
    }

    private void checkCreateAlias(Cypher25Parser.CreateAliasContext ctx) {
        if (ctx.stringOrParameter() != null) {
            if (ctx.AT() != null || ctx.USER() != null || ctx.PASSWORD() != null || ctx.DRIVER() != null || !ctx.defaultLanguageSpecification().isEmpty()) {
                this.errorOnAliasNameContainingDots(java.util.List.of(ctx.aliasName().symbolicAliasNameOrParameter(), ctx.aliasTargetName().symbolicAliasNameOrParameter()));
                return;
            }
            return;
        }
    }

    private void checkAlterAlias(Cypher25Parser.AlterAliasContext ctx) {
        java.util.List aliasTargets = ctx.alterAliasTarget();
        boolean hasUrl = !aliasTargets.isEmpty() && ((Cypher25Parser.AlterAliasTargetContext)aliasTargets.get(0)).AT() != null;
        java.util.List usernames = ctx.alterAliasUser();
        java.util.List passwords = ctx.alterAliasPassword();
        java.util.List driverSettings = ctx.alterAliasDriver();
        java.util.List defaultLanguages = ctx.defaultLanguageSpecification();
        if (!(!hasUrl && usernames.isEmpty() && passwords.isEmpty() && driverSettings.isEmpty() && defaultLanguages.isEmpty())) {
            this.errorOnAliasNameContainingDots(java.util.List.of(ctx.aliasName().symbolicAliasNameOrParameter()));
        }
        this.errorOnDuplicateCtx(driverSettings, "DRIVER", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(usernames, "USER", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(passwords, "PASSWORD", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(ctx.alterAliasProperties(), "PROPERTIES", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(aliasTargets, "TARGET", this.errorOnDuplicateCtx$default$3());
        this.errorOnDuplicateCtx(defaultLanguages, "DEFAULT LANGUAGE", this.errorOnDuplicateCtx$default$3());
    }

    private void checkSymbolicAliasNameOrParameter(Cypher25Parser.SymbolicAliasNameOrParameterContext ctx) {
        int n = ctx.getParent().getRuleIndex();
        switch (n) {
            case 287: {
                this.errorOnAliasNameContainingTooManyComponents((Seq<Cypher25Parser.SymbolicAliasNameOrParameterContext>)new .colon.colon((Object)ctx, (List)Nil$.MODULE$), Cypher25SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v25$ast$factory$Cypher25SyntaxChecker$$MAX_DATABASE_NAME_COMPONENTS(), "Invalid input `%s` for database name. Expected name to contain at most one component.", "database name");
                return;
            }
            case 286: {
                return;
            }
        }
        this.errorOnAliasNameContainingTooManyComponents((Seq<Cypher25Parser.SymbolicAliasNameOrParameterContext>)new .colon.colon((Object)ctx, (List)Nil$.MODULE$), Cypher25SyntaxChecker$.MODULE$.org$neo4j$cypher$internal$parser$v25$ast$factory$Cypher25SyntaxChecker$$MAX_ALIAS_NAME_COMPONENTS(), "Invalid input `%s` for name. Expected name to contain at most two components separated by `.`.", "name");
    }

    private void checkCreateUser(Cypher25Parser.CreateUserContext ctx) {
        this.errorOnDuplicateRule(ctx.userStatus(), "SET STATUS {SUSPENDED|ACTIVE}", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.homeDatabase(), "SET HOME DATABASE", this.errorOnDuplicateRule$default$3());
    }

    private void checkAlterUser(Cypher25Parser.AlterUserContext ctx) {
        this.errorOnDuplicateRule(ctx.userStatus(), "SET STATUS {SUSPENDED|ACTIVE}", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.homeDatabase(), "SET HOME DATABASE", this.errorOnDuplicateRule$default$3());
    }

    private void checkAllPrivilege(Cypher25Parser.AllPrivilegeContext ctx) {
        Cypher25Parser.AllPrivilegeTypeContext privilegeType = ctx.allPrivilegeType();
        Cypher25Parser.AllPrivilegeTargetContext privilegeTarget = ctx.allPrivilegeTarget();
        if (privilegeType != null) {
            Tuple2 tuple2;
            Some privilege = privilegeType.GRAPH() != null ? new Some((Object)"GRAPH") : (privilegeType.DBMS() != null ? new Some((Object)"DBMS") : (privilegeType.DATABASE() != null ? new Some((Object)"DATABASE") : None$.MODULE$));
            Cypher25Parser.AllPrivilegeTargetContext allPrivilegeTargetContext = privilegeTarget;
            if (allPrivilegeTargetContext instanceof Cypher25Parser.DefaultTargetContext) {
                Some some;
                String string;
                Cypher25Parser.DefaultTargetContext defaultTargetContext = (Cypher25Parser.DefaultTargetContext)allPrivilegeTargetContext;
                Some some2 = privilege;
                tuple2 = some2 instanceof Some && "DBMS".equals(string = (String)(some = some2).value()) ? new Tuple2((Object)"HOME", (Object)defaultTargetContext.HOME().getSymbol()) : (defaultTargetContext.GRAPH() != null ? new Tuple2((Object)"GRAPH", (Object)defaultTargetContext.GRAPH().getSymbol()) : new Tuple2((Object)"DATABASE", (Object)defaultTargetContext.DATABASE().getSymbol()));
            } else if (allPrivilegeTargetContext instanceof Cypher25Parser.DatabaseVariableTargetContext) {
                Cypher25Parser.DatabaseVariableTargetContext databaseVariableTargetContext = (Cypher25Parser.DatabaseVariableTargetContext)allPrivilegeTargetContext;
                tuple2 = databaseVariableTargetContext.DATABASE() != null ? new Tuple2((Object)"DATABASE", (Object)databaseVariableTargetContext.DATABASE().getSymbol()) : new Tuple2((Object)"DATABASES", (Object)databaseVariableTargetContext.DATABASES().getSymbol());
            } else if (allPrivilegeTargetContext instanceof Cypher25Parser.GraphVariableTargetContext) {
                Cypher25Parser.GraphVariableTargetContext graphVariableTargetContext = (Cypher25Parser.GraphVariableTargetContext)allPrivilegeTargetContext;
                tuple2 = graphVariableTargetContext.GRAPH() != null ? new Tuple2((Object)"GRAPH", (Object)graphVariableTargetContext.GRAPH().getSymbol()) : new Tuple2((Object)"GRAPHS", (Object)graphVariableTargetContext.GRAPHS().getSymbol());
            } else if (allPrivilegeTargetContext instanceof Cypher25Parser.DBMSTargetContext) {
                Cypher25Parser.DBMSTargetContext dBMSTargetContext = (Cypher25Parser.DBMSTargetContext)allPrivilegeTargetContext;
                tuple2 = new Tuple2((Object)"DBMS", (Object)dBMSTargetContext.DBMS().getSymbol());
            } else {
                throw new IllegalStateException("Unexpected privilege all command");
            }
            Tuple2 target = tuple2;
            Tuple2 tuple22 = new Tuple2((Object)privilege, (Object)target);
            if (tuple22 != null) {
                Option option = (Option)tuple22._1();
                Tuple2 tuple23 = (Tuple2)tuple22._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String privilege2 = (String)some.value();
                    if (tuple23 != null) {
                        String target2 = (String)tuple23._1();
                        Token symbol = (Token)tuple23._2();
                        if (!target2.startsWith(privilege2)) {
                            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Invalid input '" + target2 + "': expected \"" + privilege2 + "\"", this.inputPosition(symbol)));
                            return;
                        }
                        return;
                    }
                }
            }
            return;
        }
    }

    private void checkGlobPart(Cypher25Parser.GlobPartContext ctx) {
        if (ctx.DOT() == null) {
            Cypher25Parser.GlobContext globContext;
            Cypher25Parser.GlobRecursiveContext globRecursiveContext;
            RuleContext ruleContext = ctx.parent.parent;
            if (ruleContext instanceof Cypher25Parser.GlobRecursiveContext && (globRecursiveContext = (Cypher25Parser.GlobRecursiveContext)ruleContext).globPart().escapedSymbolicNameString() != null) {
                this.addError$1(ctx);
            } else if (ruleContext instanceof Cypher25Parser.GlobContext && (globContext = (Cypher25Parser.GlobContext)ruleContext).escapedSymbolicNameString() != null) {
                this.addError$1(ctx);
            }
            return;
        }
    }

    private void checkCreateConstraint(Cypher25Parser.CreateConstraintContext ctx) {
        Cypher25Parser.ConstraintTypeContext constraintTypeContext = ctx.constraintType();
        if (constraintTypeContext instanceof Cypher25Parser.ConstraintIsUniqueContext) {
            Cypher25Parser.ConstraintIsUniqueContext constraintIsUniqueContext = (Cypher25Parser.ConstraintIsUniqueContext)constraintTypeContext;
            if (ctx.commandNodePattern() != null && (constraintIsUniqueContext.RELATIONSHIP() != null || constraintIsUniqueContext.REL() != null)) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidInputException("node pattern", ConstraintType.REL_UNIQUE.description(), (List)new .colon.colon((Object)"relationship patterns", (List)Nil$.MODULE$), "'" + ConstraintType.REL_UNIQUE.description() + "' does not allow node patterns", this.inputPosition(ctx.commandNodePattern().getStart())));
            }
            if (ctx.commandRelPattern() != null && constraintIsUniqueContext.NODE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidInputException("relationship pattern", ConstraintType.NODE_UNIQUE.description(), (List)new .colon.colon((Object)"node patterns", (List)Nil$.MODULE$), "'" + ConstraintType.NODE_UNIQUE.description() + "' does not allow relationship patterns", this.inputPosition(ctx.commandRelPattern().getStart())));
                return;
            }
            return;
        }
        if (constraintTypeContext instanceof Cypher25Parser.ConstraintKeyContext) {
            Cypher25Parser.ConstraintKeyContext constraintKeyContext = (Cypher25Parser.ConstraintKeyContext)constraintTypeContext;
            if (ctx.commandNodePattern() != null && (constraintKeyContext.RELATIONSHIP() != null || constraintKeyContext.REL() != null)) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidInputException("node pattern", ConstraintType.REL_KEY.description(), (List)new .colon.colon((Object)"relationship patterns", (List)Nil$.MODULE$), "'" + ConstraintType.REL_KEY.description() + "' does not allow node patterns", this.inputPosition(ctx.commandNodePattern().getStart())));
            }
            if (ctx.commandRelPattern() != null && constraintKeyContext.NODE() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidInputException("relationship pattern", ConstraintType.NODE_KEY.description(), (List)new .colon.colon((Object)"node patterns", (List)Nil$.MODULE$), "'" + ConstraintType.NODE_KEY.description() + "' does not allow relationship patterns", this.inputPosition(ctx.commandRelPattern().getStart())));
                return;
            }
            return;
        }
        if (constraintTypeContext instanceof Cypher25Parser.ConstraintTypedContext ? true : constraintTypeContext instanceof Cypher25Parser.ConstraintIsNotNullContext) {
            return;
        }
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Constraint type is not recognized", this.inputPosition(ctx.constraintType().getStart())));
    }

    private void checkEnclosedPropertyList(Cypher25Parser.EnclosedPropertyListContext ctx) {
        if (ctx.property().size() > 1 && ctx.getParent() != null) {
            Cypher25Parser.DropConstraintContext dropConstraintContext;
            Token secondProperty = ctx.property((int)1).start;
            ParserRuleContext parserRuleContext = ctx.getParent().getParent();
            if (parserRuleContext instanceof Cypher25Parser.ConstraintTypedContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.unsupportedMultiplePropertiesInConstraint("IS TYPED", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher25Parser.ConstraintIsNotNullContext) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.unsupportedMultiplePropertiesInConstraint("IS NOT NULL", this.inputPosition(secondProperty)));
                return;
            }
            if (parserRuleContext instanceof Cypher25Parser.DropConstraintContext && (dropConstraintContext = (Cypher25Parser.DropConstraintContext)parserRuleContext).EXISTS() != null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.unsupportedMultiplePropertiesInConstraint("EXISTS", this.inputPosition(secondProperty)));
                return;
            }
            return;
        }
    }

    private void checkTopology(Cypher25Parser.TopologyContext ctx) {
        this.errorOnDuplicateRule(ctx.primaryTopology(), "PRIMARY", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.secondaryTopology(), "SECONDARY", this.errorOnDuplicateRule$default$3());
    }

    private void checkAlterDatabase(Cypher25Parser.AlterDatabaseContext ctx) {
        if (!ctx.REMOVE().isEmpty()) {
            ArraySeq keyNames = Util$.MODULE$.astSeq(ctx.symbolicNameString(), Util$.MODULE$.astSeq$default$2(), ClassTag$.MODULE$.apply(String.class));
            Set keySet = (Set)Set$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            keyNames.foreach((Function1 & Serializable)k -> {
                Cypher25SyntaxChecker.$anonfun$checkAlterDatabase$1(this, keySet, ctx, i, k);
                return BoxedUnit.UNIT;
            });
        }
        if (!ctx.alterDatabaseOption().isEmpty()) {
            ArraySeq optionCtxs = Util$.MODULE$.astSeq(ctx.alterDatabaseOption(), Util$.MODULE$.astSeq$default$2(), ClassTag$.MODULE$.apply(Map.class));
            ArraySeq keyNames = (ArraySeq)optionCtxs.flatMap((Function1 & Serializable)m -> {
                if (m != null) {
                    return m.keys();
                }
                return (Iterable)package$.MODULE$.Seq().empty();
            });
            Set keySet = (Set)Set$.MODULE$.empty();
            IntRef i = IntRef.create((int)0);
            keyNames.foreach((Function1 & Serializable)k -> {
                Cypher25SyntaxChecker.$anonfun$checkAlterDatabase$3(this, keySet, ctx, i, k);
                return BoxedUnit.UNIT;
            });
        }
        this.errorOnDuplicateCtx(ctx.alterDatabaseAccess(), "ACCESS", this.errorOnDuplicateCtx$default$3());
        java.util.List topology = ctx.alterDatabaseTopology();
        this.errorOnDuplicateCtx(topology, "TOPOLOGY", this.errorOnDuplicateCtx$default$3());
    }

    private void checkAlterDatabaseTopology(Cypher25Parser.AlterDatabaseTopologyContext ctx) {
        this.errorOnDuplicateRule(ctx.primaryTopology(), "PRIMARY", this.errorOnDuplicateRule$default$3());
        this.errorOnDuplicateRule(ctx.secondaryTopology(), "SECONDARY", this.errorOnDuplicateRule$default$3());
    }

    private void checkCreateLookupIndex(Cypher25Parser.CreateLookupIndexContext ctx) {
        Cypher25Parser.SymbolicNameStringContext functionName = ctx.symbolicNameString();
        Cypher25Parser.LookupIndexRelPatternContext relPattern = ctx.lookupIndexRelPattern();
        String string = functionName.getText().toUpperCase();
        String string2 = "EACH";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (relPattern != null && relPattern.EACH() == null) {
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Missing function name for the LOOKUP INDEX", this.inputPosition(ctx.LPAREN().getSymbol())));
                return;
            }
        }
    }

    private void checkInsertPattern(Cypher25Parser.InsertPatternContext ctx) {
        if (ctx.EQ() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Named patterns are not allowed in `INSERT`. Use `CREATE` instead or remove the name.", Util$.MODULE$.pos((ParserRuleContext)Util$.MODULE$.ctxChild((AstRuleCtx)ctx, 0))));
            return;
        }
    }

    private void checkInsertLabelConjunction(Cypher25Parser.InsertNodeLabelExpressionContext ctx) {
        boolean firstIsColon;
        java.util.List colons = ctx.COLON();
        boolean bl = firstIsColon = Util$.MODULE$.nodeChild((AstRuleCtx)ctx, 0).getSymbol().getType() == 44;
        if (firstIsColon && colons.size() > 1) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.", this.inputPosition(((TerminalNode)colons.get(1)).getSymbol())));
            return;
        }
        if (!firstIsColon && colons.size() > 0) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Colon `:` conjunction is not allowed in INSERT. Use `CREATE` or conjunction with ampersand `&` instead.", this.inputPosition(((TerminalNode)colons.get(0)).getSymbol())));
            return;
        }
    }

    private void checkFunctionInvocation(Cypher25Parser.FunctionInvocationContext ctx) {
        FunctionName functionName = (FunctionName)ctx.functionName().ast();
        String string = functionName.name();
        String string2 = "normalize";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (functionName.namespace().parts().isEmpty() && ctx.functionArgument().size() == 2) {
                Expression normalForm = (Expression)ctx.functionArgument(1).expression().ast();
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidNormalForm((ASTNode)normalForm));
                return;
            }
        }
        String string3 = functionName.name();
        String string4 = "vector";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            if (functionName.namespace().parts().isEmpty() && ctx.functionArgument().size() == 3) {
                Expression coordinateType = (Expression)ctx.functionArgument(2).expression().ast();
                this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidVectorType((ASTNode)coordinateType));
                return;
            }
        }
    }

    private void checkTypePart(Cypher25Parser.TypePartContext ctx) {
        Object cypherType = ctx.typeName().ast;
        if (cypherType instanceof ClosedDynamicUnionType && ctx.typeNullability() != null) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidNotNullClosedDynamicUnion(Util$.MODULE$.pos((ParserRuleContext)ctx.typeNullability())));
            return;
        }
    }

    private void checkDefaultLanguageSpecification(Cypher25Parser.DefaultLanguageSpecificationContext ctx) {
        String versionNumberStr = ctx.UNSIGNED_DECIMAL_INTEGER().getText();
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])CypherVersion.values()), (Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.versionName.equals(versionNumberStr)));
        if (option instanceof Some) {
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.invalidInputException(versionNumberStr, "Cypher version", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CypherVersion.values()), (Function1 & Serializable)x$2 -> x$2.description, ClassTag$.MODULE$.apply(String.class))).toList(), "Invalid Cypher version '" + versionNumberStr + "'. Valid Cypher versions are: " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CypherVersion.values()), (Function1 & Serializable)x$3 -> x$3.versionName, ClassTag$.MODULE$.apply(String.class))).mkString(", "), Util$.MODULE$.pos(ctx.UNSIGNED_DECIMAL_INTEGER())));
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$errorOnAliasNameContainingTooManyComponents$1(Cypher25Parser.SymbolicAliasNameOrParameterContext x$1) {
        return x$1.symbolicAliasName() != null;
    }

    public static final /* synthetic */ int $anonfun$errorOnAliasNameContainingTooManyComponents$3(int x0$1, List x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int count = tuple2._1$mcI$sp();
            List list = (List)tuple2._2();
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                Cypher25Parser.SymbolicNameStringContext a = (Cypher25Parser.SymbolicNameStringContext)colon2.head();
                List list2 = colon2.next$access$1();
                if (list2 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list2;
                    Cypher25Parser.SymbolicNameStringContext b = (Cypher25Parser.SymbolicNameStringContext)colon3.head();
                    List list3 = colon3.next$access$1();
                    if (Nil$.MODULE$.equals(list3) && (a.escapedSymbolicNameString() != null || b.escapedSymbolicNameString() != null)) {
                        return count + 1;
                    }
                }
            }
        }
        if (tuple2 != null) {
            int count = tuple2._1$mcI$sp();
            return count;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$errorOnAliasNameContainingTooManyComponents$2(Cypher25SyntaxChecker $this, int maxComponents$1, String errorTemplate$1, String context$1, Cypher25Parser.SymbolicAliasNameOrParameterContext aliasName) {
        List nameComponents = CollectionConverters$.MODULE$.ListHasAsScala(aliasName.symbolicAliasName().symbolicNameString()).asScala().toList();
        int componentCount = BoxesRunTime.unboxToInt((Object)nameComponents.sliding(2, 1).foldLeft((Object)BoxesRunTime.boxToInteger((int)1), (Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)Cypher25SyntaxChecker.$anonfun$errorOnAliasNameContainingTooManyComponents$3(BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (componentCount > maxComponents$1) {
            Token start = ((ParserRuleContext)aliasName.symbolicAliasName().symbolicNameString().get(0)).getStart();
            String prettyName = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aliasName.symbolicAliasName().symbolicNameString()).asScala().map((Function1 & Serializable)x0$2 -> {
                Cypher25Parser.SymbolicNameStringContext symbolicNameStringContext = x0$2;
                if (symbolicNameStringContext.unescapedSymbolicNameString() != null) {
                    return symbolicNameStringContext.unescapedSymbolicNameString().ast;
                }
                if (symbolicNameStringContext.escapedSymbolicNameString() != null) {
                    return NameUtil.forceEscapeName((String)((String)symbolicNameStringContext.escapedSymbolicNameString().ast()));
                }
                return "";
            })).mkString(".");
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.invalidNameTooManyComponents(errorTemplate$1, context$1, maxComponents$1, prettyName, $this.inputPosition(start)));
            return;
        }
    }

    private final void addError$1(Cypher25Parser.GlobPartContext ctx$1) {
        this._errors = (Seq)this._errors.$colon$plus((Object)this.exceptionFactory.syntaxException("Each part of the glob (a block of text up until a dot) must either be fully escaped or not escaped at all.", this.inputPosition(ctx$1.start)));
    }

    public static final /* synthetic */ void $anonfun$checkAlterDatabase$1(Cypher25SyntaxChecker $this, Set keySet$1, Cypher25Parser.AlterDatabaseContext ctx$2, IntRef i$1, String k) {
        if (keySet$1.contains((Object)k)) {
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException("Duplicate 'REMOVE OPTION " + k + "' clause", Util$.MODULE$.pos((ParserRuleContext)ctx$2.symbolicNameString(i$1.elem))));
            return;
        }
        keySet$1.addOne((Object)k);
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkAlterDatabase$3(Cypher25SyntaxChecker $this, Set keySet$2, Cypher25Parser.AlterDatabaseContext ctx$2, IntRef i$2, String k) {
        if (keySet$2.contains((Object)k)) {
            $this._errors = (Seq)$this._errors.$colon$plus((Object)$this.exceptionFactory.syntaxException("Duplicate 'SET OPTION " + k + "' clause", Util$.MODULE$.pos((ParserRuleContext)ctx$2.alterDatabaseOption(i$2.elem))));
            return;
        }
        keySet$2.addOne((Object)k);
        ++i$2.elem;
    }

    public Cypher25SyntaxChecker(CypherExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
        this._errors = (Seq)package$.MODULE$.Seq().empty();
    }
}

