/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated from org/neo4j/cypher/internal/parser/v6/Cypher6Parser.g4 by ANTLR 4.13.1
package org.neo4j.cypher.internal.parser.v6;

import java.util.List;
import org.antlr.v4.runtime.*;
import org.antlr.v4.runtime.atn.*;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.*;
import org.antlr.v4.runtime.tree.*;

@SuppressWarnings({"all", "warnings", "unchecked", "unused", "cast", "CheckReturnValue"})
public class Cypher6Parser extends Parser {
    static {
        RuntimeMetaData.checkVersion("4.13.1", RuntimeMetaData.VERSION);
    }

    protected static final DFA[] _decisionToDFA;
    protected static final PredictionContextCache _sharedContextCache = new PredictionContextCache();
    public static final int SPACE = 1,
            SINGLE_LINE_COMMENT = 2,
            MULTI_LINE_COMMENT = 3,
            DECIMAL_DOUBLE = 4,
            UNSIGNED_DECIMAL_INTEGER = 5,
            UNSIGNED_HEX_INTEGER = 6,
            UNSIGNED_OCTAL_INTEGER = 7,
            STRING_LITERAL1 = 8,
            STRING_LITERAL2 = 9,
            ESCAPED_SYMBOLIC_NAME = 10,
            ACCESS = 11,
            ACTIVE = 12,
            ADMIN = 13,
            ADMINISTRATOR = 14,
            ALIAS = 15,
            ALIASES = 16,
            ALL_SHORTEST_PATHS = 17,
            ALL = 18,
            ALTER = 19,
            AND = 20,
            ANY = 21,
            ARRAY = 22,
            AS = 23,
            ASC = 24,
            ASCENDING = 25,
            ASSIGN = 26,
            AT = 27,
            AUTH = 28,
            BAR = 29,
            BINDINGS = 30,
            BOOL = 31,
            BOOLEAN = 32,
            BOOSTED = 33,
            BOTH = 34,
            BREAK = 35,
            BTREE = 36,
            BUILT = 37,
            BY = 38,
            CALL = 39,
            CASE = 40,
            CHANGE = 41,
            CIDR = 42,
            COLLECT = 43,
            COLON = 44,
            COLONCOLON = 45,
            COMMA = 46,
            COMMAND = 47,
            COMMANDS = 48,
            COMPOSITE = 49,
            CONCURRENT = 50,
            CONSTRAINT = 51,
            CONSTRAINTS = 52,
            CONTAINS = 53,
            COPY = 54,
            CONTINUE = 55,
            COUNT = 56,
            CREATE = 57,
            CSV = 58,
            CURRENT = 59,
            DATA = 60,
            DATABASE = 61,
            DATABASES = 62,
            DATE = 63,
            DATETIME = 64,
            DBMS = 65,
            DEALLOCATE = 66,
            DEFAULT = 67,
            DEFINED = 68,
            DELETE = 69,
            DENY = 70,
            DESC = 71,
            DESCENDING = 72,
            DESTROY = 73,
            DETACH = 74,
            DIFFERENT = 75,
            DOLLAR = 76,
            DISTINCT = 77,
            DIVIDE = 78,
            DOT = 79,
            DOTDOT = 80,
            DOUBLEBAR = 81,
            DRIVER = 82,
            DROP = 83,
            DRYRUN = 84,
            DUMP = 85,
            DURATION = 86,
            EACH = 87,
            EDGE = 88,
            ENABLE = 89,
            ELEMENT = 90,
            ELEMENTS = 91,
            ELSE = 92,
            ENCRYPTED = 93,
            END = 94,
            ENDS = 95,
            EQ = 96,
            EXECUTABLE = 97,
            EXECUTE = 98,
            EXIST = 99,
            EXISTENCE = 100,
            EXISTS = 101,
            ERROR = 102,
            FAIL = 103,
            FALSE = 104,
            FIELDTERMINATOR = 105,
            FINISH = 106,
            FLOAT = 107,
            FOR = 108,
            FOREACH = 109,
            FROM = 110,
            FULLTEXT = 111,
            FUNCTION = 112,
            FUNCTIONS = 113,
            GE = 114,
            GRANT = 115,
            GRAPH = 116,
            GRAPHS = 117,
            GROUP = 118,
            GROUPS = 119,
            GT = 120,
            HEADERS = 121,
            HOME = 122,
            ID = 123,
            IF = 124,
            IMPERSONATE = 125,
            IMMUTABLE = 126,
            IN = 127,
            INDEX = 128,
            INDEXES = 129,
            INF = 130,
            INFINITY = 131,
            INSERT = 132,
            INT = 133,
            INTEGER = 134,
            IS = 135,
            JOIN = 136,
            KEY = 137,
            LABEL = 138,
            LABELS = 139,
            AMPERSAND = 140,
            EXCLAMATION_MARK = 141,
            LBRACKET = 142,
            LCURLY = 143,
            LE = 144,
            LEADING = 145,
            LIMITROWS = 146,
            LIST = 147,
            LOAD = 148,
            LOCAL = 149,
            LOOKUP = 150,
            LPAREN = 151,
            LT = 152,
            MANAGEMENT = 153,
            MAP = 154,
            MATCH = 155,
            MERGE = 156,
            MINUS = 157,
            PERCENT = 158,
            INVALID_NEQ = 159,
            NEQ = 160,
            NAME = 161,
            NAMES = 162,
            NAN = 163,
            NFC = 164,
            NFD = 165,
            NFKC = 166,
            NFKD = 167,
            NEW = 168,
            NODE = 169,
            NODETACH = 170,
            NODES = 171,
            NONE = 172,
            NORMALIZE = 173,
            NORMALIZED = 174,
            NOT = 175,
            NOTHING = 176,
            NOWAIT = 177,
            NULL = 178,
            OF = 179,
            ON = 180,
            ONLY = 181,
            OPTIONAL = 182,
            OPTIONS = 183,
            OPTION = 184,
            OR = 185,
            ORDER = 186,
            PASSWORD = 187,
            PASSWORDS = 188,
            PATH = 189,
            PATHS = 190,
            PLAINTEXT = 191,
            PLUS = 192,
            PLUSEQUAL = 193,
            POINT = 194,
            POPULATED = 195,
            POW = 196,
            PRIMARY = 197,
            PRIMARIES = 198,
            PRIVILEGE = 199,
            PRIVILEGES = 200,
            PROCEDURE = 201,
            PROCEDURES = 202,
            PROPERTIES = 203,
            PROPERTY = 204,
            PROVIDER = 205,
            PROVIDERS = 206,
            QUESTION = 207,
            RANGE = 208,
            RBRACKET = 209,
            RCURLY = 210,
            READ = 211,
            REALLOCATE = 212,
            REDUCE = 213,
            RENAME = 214,
            REGEQ = 215,
            REL = 216,
            RELATIONSHIP = 217,
            RELATIONSHIPS = 218,
            REMOVE = 219,
            REPEATABLE = 220,
            REPLACE = 221,
            REPORT = 222,
            REQUIRE = 223,
            REQUIRED = 224,
            RETURN = 225,
            REVOKE = 226,
            ROLE = 227,
            ROLES = 228,
            ROW = 229,
            ROWS = 230,
            RPAREN = 231,
            SCAN = 232,
            SEC = 233,
            SECOND = 234,
            SECONDARY = 235,
            SECONDARIES = 236,
            SECONDS = 237,
            SEEK = 238,
            SEMICOLON = 239,
            SERVER = 240,
            SERVERS = 241,
            SET = 242,
            SETTING = 243,
            SETTINGS = 244,
            SHORTEST_PATH = 245,
            SHORTEST = 246,
            SHOW = 247,
            SIGNED = 248,
            SINGLE = 249,
            SKIPROWS = 250,
            START = 251,
            STARTS = 252,
            STATUS = 253,
            STOP = 254,
            STRING = 255,
            SUPPORTED = 256,
            SUSPENDED = 257,
            TARGET = 258,
            TERMINATE = 259,
            TEXT = 260,
            THEN = 261,
            TIME = 262,
            TIMES = 263,
            TIMESTAMP = 264,
            TIMEZONE = 265,
            TO = 266,
            TOPOLOGY = 267,
            TRAILING = 268,
            TRANSACTION = 269,
            TRANSACTIONS = 270,
            TRAVERSE = 271,
            TRIM = 272,
            TRUE = 273,
            TYPE = 274,
            TYPED = 275,
            TYPES = 276,
            UNION = 277,
            UNIQUE = 278,
            UNIQUENESS = 279,
            UNWIND = 280,
            URL = 281,
            USE = 282,
            USER = 283,
            USERS = 284,
            USING = 285,
            VALUE = 286,
            VARCHAR = 287,
            VECTOR = 288,
            VERTEX = 289,
            WAIT = 290,
            WHEN = 291,
            WHERE = 292,
            WITH = 293,
            WITHOUT = 294,
            WRITE = 295,
            XOR = 296,
            YIELD = 297,
            ZONE = 298,
            ZONED = 299,
            IDENTIFIER = 300,
            ARROW_LINE = 301,
            ARROW_LEFT_HEAD = 302,
            ARROW_RIGHT_HEAD = 303,
            ErrorChar = 304;
    public static final int RULE_statements = 0,
            RULE_statement = 1,
            RULE_regularQuery = 2,
            RULE_singleQuery = 3,
            RULE_clause = 4,
            RULE_useClause = 5,
            RULE_graphReference = 6,
            RULE_finishClause = 7,
            RULE_returnClause = 8,
            RULE_returnBody = 9,
            RULE_returnItem = 10,
            RULE_returnItems = 11,
            RULE_orderItem = 12,
            RULE_ascToken = 13,
            RULE_descToken = 14,
            RULE_orderBy = 15,
            RULE_skip = 16,
            RULE_limit = 17,
            RULE_whereClause = 18,
            RULE_withClause = 19,
            RULE_createClause = 20,
            RULE_insertClause = 21,
            RULE_setClause = 22,
            RULE_setItem = 23,
            RULE_removeClause = 24,
            RULE_removeItem = 25,
            RULE_deleteClause = 26,
            RULE_matchClause = 27,
            RULE_matchMode = 28,
            RULE_hint = 29,
            RULE_mergeClause = 30,
            RULE_mergeAction = 31,
            RULE_unwindClause = 32,
            RULE_callClause = 33,
            RULE_procedureName = 34,
            RULE_procedureArgument = 35,
            RULE_procedureResultItem = 36,
            RULE_loadCSVClause = 37,
            RULE_foreachClause = 38,
            RULE_subqueryClause = 39,
            RULE_subqueryScope = 40,
            RULE_subqueryInTransactionsParameters = 41,
            RULE_subqueryInTransactionsBatchParameters = 42,
            RULE_subqueryInTransactionsErrorParameters = 43,
            RULE_subqueryInTransactionsReportParameters = 44,
            RULE_patternList = 45,
            RULE_insertPatternList = 46,
            RULE_pattern = 47,
            RULE_insertPattern = 48,
            RULE_quantifier = 49,
            RULE_anonymousPattern = 50,
            RULE_shortestPathPattern = 51,
            RULE_patternElement = 52,
            RULE_selector = 53,
            RULE_groupToken = 54,
            RULE_pathToken = 55,
            RULE_pathPatternNonEmpty = 56,
            RULE_nodePattern = 57,
            RULE_insertNodePattern = 58,
            RULE_parenthesizedPath = 59,
            RULE_nodeLabels = 60,
            RULE_nodeLabelsIs = 61,
            RULE_dynamicExpression = 62,
            RULE_dynamicLabelType = 63,
            RULE_labelType = 64,
            RULE_relType = 65,
            RULE_labelOrRelType = 66,
            RULE_properties = 67,
            RULE_relationshipPattern = 68,
            RULE_insertRelationshipPattern = 69,
            RULE_leftArrow = 70,
            RULE_arrowLine = 71,
            RULE_rightArrow = 72,
            RULE_pathLength = 73,
            RULE_labelExpression = 74,
            RULE_labelExpression4 = 75,
            RULE_labelExpression4Is = 76,
            RULE_labelExpression3 = 77,
            RULE_labelExpression3Is = 78,
            RULE_labelExpression2 = 79,
            RULE_labelExpression2Is = 80,
            RULE_labelExpression1 = 81,
            RULE_labelExpression1Is = 82,
            RULE_insertNodeLabelExpression = 83,
            RULE_insertRelationshipLabelExpression = 84,
            RULE_expression = 85,
            RULE_expression11 = 86,
            RULE_expression10 = 87,
            RULE_expression9 = 88,
            RULE_expression8 = 89,
            RULE_expression7 = 90,
            RULE_comparisonExpression6 = 91,
            RULE_normalForm = 92,
            RULE_expression6 = 93,
            RULE_expression5 = 94,
            RULE_expression4 = 95,
            RULE_expression3 = 96,
            RULE_expression2 = 97,
            RULE_postFix = 98,
            RULE_property = 99,
            RULE_dynamicProperty = 100,
            RULE_propertyExpression = 101,
            RULE_dynamicPropertyExpression = 102,
            RULE_expression1 = 103,
            RULE_literal = 104,
            RULE_caseExpression = 105,
            RULE_caseAlternative = 106,
            RULE_extendedCaseExpression = 107,
            RULE_extendedCaseAlternative = 108,
            RULE_extendedWhen = 109,
            RULE_listComprehension = 110,
            RULE_patternComprehension = 111,
            RULE_reduceExpression = 112,
            RULE_listItemsPredicate = 113,
            RULE_normalizeFunction = 114,
            RULE_trimFunction = 115,
            RULE_patternExpression = 116,
            RULE_shortestPathExpression = 117,
            RULE_parenthesizedExpression = 118,
            RULE_mapProjection = 119,
            RULE_mapProjectionElement = 120,
            RULE_countStar = 121,
            RULE_existsExpression = 122,
            RULE_countExpression = 123,
            RULE_collectExpression = 124,
            RULE_numberLiteral = 125,
            RULE_signedIntegerLiteral = 126,
            RULE_listLiteral = 127,
            RULE_propertyKeyName = 128,
            RULE_parameter = 129,
            RULE_parameterName = 130,
            RULE_functionInvocation = 131,
            RULE_functionArgument = 132,
            RULE_functionName = 133,
            RULE_namespace = 134,
            RULE_variable = 135,
            RULE_nonEmptyNameList = 136,
            RULE_type = 137,
            RULE_typePart = 138,
            RULE_typeName = 139,
            RULE_typeNullability = 140,
            RULE_typeListSuffix = 141,
            RULE_command = 142,
            RULE_createCommand = 143,
            RULE_dropCommand = 144,
            RULE_showCommand = 145,
            RULE_showCommandYield = 146,
            RULE_yieldItem = 147,
            RULE_yieldSkip = 148,
            RULE_yieldLimit = 149,
            RULE_yieldClause = 150,
            RULE_commandOptions = 151,
            RULE_terminateCommand = 152,
            RULE_composableCommandClauses = 153,
            RULE_composableShowCommandClauses = 154,
            RULE_showIndexCommand = 155,
            RULE_showIndexType = 156,
            RULE_showIndexesEnd = 157,
            RULE_showConstraintCommand = 158,
            RULE_showConstraintEntity = 159,
            RULE_constraintExistType = 160,
            RULE_showConstraintsEnd = 161,
            RULE_showProcedures = 162,
            RULE_showFunctions = 163,
            RULE_functionToken = 164,
            RULE_executableBy = 165,
            RULE_showFunctionsType = 166,
            RULE_showTransactions = 167,
            RULE_terminateTransactions = 168,
            RULE_showSettings = 169,
            RULE_settingToken = 170,
            RULE_namesAndClauses = 171,
            RULE_stringsOrExpression = 172,
            RULE_commandNodePattern = 173,
            RULE_commandRelPattern = 174,
            RULE_createConstraint = 175,
            RULE_constraintType = 176,
            RULE_dropConstraint = 177,
            RULE_createIndex = 178,
            RULE_createIndex_ = 179,
            RULE_createFulltextIndex = 180,
            RULE_fulltextNodePattern = 181,
            RULE_fulltextRelPattern = 182,
            RULE_createLookupIndex = 183,
            RULE_lookupIndexNodePattern = 184,
            RULE_lookupIndexRelPattern = 185,
            RULE_dropIndex = 186,
            RULE_propertyList = 187,
            RULE_enclosedPropertyList = 188,
            RULE_alterCommand = 189,
            RULE_renameCommand = 190,
            RULE_grantCommand = 191,
            RULE_denyCommand = 192,
            RULE_revokeCommand = 193,
            RULE_userNames = 194,
            RULE_roleNames = 195,
            RULE_roleToken = 196,
            RULE_enableServerCommand = 197,
            RULE_alterServer = 198,
            RULE_renameServer = 199,
            RULE_dropServer = 200,
            RULE_showServers = 201,
            RULE_allocationCommand = 202,
            RULE_deallocateDatabaseFromServers = 203,
            RULE_reallocateDatabases = 204,
            RULE_createRole = 205,
            RULE_dropRole = 206,
            RULE_renameRole = 207,
            RULE_showRoles = 208,
            RULE_grantRole = 209,
            RULE_revokeRole = 210,
            RULE_createUser = 211,
            RULE_dropUser = 212,
            RULE_renameUser = 213,
            RULE_alterCurrentUser = 214,
            RULE_alterUser = 215,
            RULE_removeNamedProvider = 216,
            RULE_password = 217,
            RULE_passwordOnly = 218,
            RULE_passwordExpression = 219,
            RULE_passwordChangeRequired = 220,
            RULE_userStatus = 221,
            RULE_homeDatabase = 222,
            RULE_setAuthClause = 223,
            RULE_userAuthAttribute = 224,
            RULE_showUsers = 225,
            RULE_showCurrentUser = 226,
            RULE_showSupportedPrivileges = 227,
            RULE_showPrivileges = 228,
            RULE_showRolePrivileges = 229,
            RULE_showUserPrivileges = 230,
            RULE_privilegeAsCommand = 231,
            RULE_privilegeToken = 232,
            RULE_privilege = 233,
            RULE_allPrivilege = 234,
            RULE_allPrivilegeType = 235,
            RULE_allPrivilegeTarget = 236,
            RULE_createPrivilege = 237,
            RULE_createPrivilegeForDatabase = 238,
            RULE_createNodePrivilegeToken = 239,
            RULE_createRelPrivilegeToken = 240,
            RULE_createPropertyPrivilegeToken = 241,
            RULE_actionForDBMS = 242,
            RULE_dropPrivilege = 243,
            RULE_loadPrivilege = 244,
            RULE_showPrivilege = 245,
            RULE_setPrivilege = 246,
            RULE_passwordToken = 247,
            RULE_removePrivilege = 248,
            RULE_writePrivilege = 249,
            RULE_databasePrivilege = 250,
            RULE_dbmsPrivilege = 251,
            RULE_dbmsPrivilegeExecute = 252,
            RULE_adminToken = 253,
            RULE_procedureToken = 254,
            RULE_indexToken = 255,
            RULE_constraintToken = 256,
            RULE_transactionToken = 257,
            RULE_userQualifier = 258,
            RULE_executeFunctionQualifier = 259,
            RULE_executeProcedureQualifier = 260,
            RULE_settingQualifier = 261,
            RULE_globs = 262,
            RULE_glob = 263,
            RULE_globRecursive = 264,
            RULE_globPart = 265,
            RULE_qualifiedGraphPrivilegesWithProperty = 266,
            RULE_qualifiedGraphPrivileges = 267,
            RULE_labelsResource = 268,
            RULE_propertiesResource = 269,
            RULE_nonEmptyStringList = 270,
            RULE_graphQualifier = 271,
            RULE_graphQualifierToken = 272,
            RULE_relToken = 273,
            RULE_elementToken = 274,
            RULE_nodeToken = 275,
            RULE_databaseScope = 276,
            RULE_graphScope = 277,
            RULE_createCompositeDatabase = 278,
            RULE_createDatabase = 279,
            RULE_primaryTopology = 280,
            RULE_primaryToken = 281,
            RULE_secondaryTopology = 282,
            RULE_secondaryToken = 283,
            RULE_dropDatabase = 284,
            RULE_alterDatabase = 285,
            RULE_alterDatabaseAccess = 286,
            RULE_alterDatabaseTopology = 287,
            RULE_alterDatabaseOption = 288,
            RULE_startDatabase = 289,
            RULE_stopDatabase = 290,
            RULE_waitClause = 291,
            RULE_secondsToken = 292,
            RULE_showDatabase = 293,
            RULE_createAlias = 294,
            RULE_dropAlias = 295,
            RULE_alterAlias = 296,
            RULE_alterAliasTarget = 297,
            RULE_alterAliasUser = 298,
            RULE_alterAliasPassword = 299,
            RULE_alterAliasDriver = 300,
            RULE_alterAliasProperties = 301,
            RULE_showAliases = 302,
            RULE_symbolicNameOrStringParameter = 303,
            RULE_commandNameExpression = 304,
            RULE_symbolicNameOrStringParameterList = 305,
            RULE_symbolicAliasNameList = 306,
            RULE_symbolicAliasNameOrParameter = 307,
            RULE_symbolicAliasName = 308,
            RULE_stringListLiteral = 309,
            RULE_stringList = 310,
            RULE_stringLiteral = 311,
            RULE_stringOrParameterExpression = 312,
            RULE_stringOrParameter = 313,
            RULE_mapOrParameter = 314,
            RULE_map = 315,
            RULE_symbolicNameString = 316,
            RULE_escapedSymbolicNameString = 317,
            RULE_unescapedSymbolicNameString = 318,
            RULE_symbolicLabelNameString = 319,
            RULE_unescapedLabelSymbolicNameString = 320,
            RULE_endOfFile = 321;

    private static String[] makeRuleNames() {
        return new String[] {
            "statements",
            "statement",
            "regularQuery",
            "singleQuery",
            "clause",
            "useClause",
            "graphReference",
            "finishClause",
            "returnClause",
            "returnBody",
            "returnItem",
            "returnItems",
            "orderItem",
            "ascToken",
            "descToken",
            "orderBy",
            "skip",
            "limit",
            "whereClause",
            "withClause",
            "createClause",
            "insertClause",
            "setClause",
            "setItem",
            "removeClause",
            "removeItem",
            "deleteClause",
            "matchClause",
            "matchMode",
            "hint",
            "mergeClause",
            "mergeAction",
            "unwindClause",
            "callClause",
            "procedureName",
            "procedureArgument",
            "procedureResultItem",
            "loadCSVClause",
            "foreachClause",
            "subqueryClause",
            "subqueryScope",
            "subqueryInTransactionsParameters",
            "subqueryInTransactionsBatchParameters",
            "subqueryInTransactionsErrorParameters",
            "subqueryInTransactionsReportParameters",
            "patternList",
            "insertPatternList",
            "pattern",
            "insertPattern",
            "quantifier",
            "anonymousPattern",
            "shortestPathPattern",
            "patternElement",
            "selector",
            "groupToken",
            "pathToken",
            "pathPatternNonEmpty",
            "nodePattern",
            "insertNodePattern",
            "parenthesizedPath",
            "nodeLabels",
            "nodeLabelsIs",
            "dynamicExpression",
            "dynamicLabelType",
            "labelType",
            "relType",
            "labelOrRelType",
            "properties",
            "relationshipPattern",
            "insertRelationshipPattern",
            "leftArrow",
            "arrowLine",
            "rightArrow",
            "pathLength",
            "labelExpression",
            "labelExpression4",
            "labelExpression4Is",
            "labelExpression3",
            "labelExpression3Is",
            "labelExpression2",
            "labelExpression2Is",
            "labelExpression1",
            "labelExpression1Is",
            "insertNodeLabelExpression",
            "insertRelationshipLabelExpression",
            "expression",
            "expression11",
            "expression10",
            "expression9",
            "expression8",
            "expression7",
            "comparisonExpression6",
            "normalForm",
            "expression6",
            "expression5",
            "expression4",
            "expression3",
            "expression2",
            "postFix",
            "property",
            "dynamicProperty",
            "propertyExpression",
            "dynamicPropertyExpression",
            "expression1",
            "literal",
            "caseExpression",
            "caseAlternative",
            "extendedCaseExpression",
            "extendedCaseAlternative",
            "extendedWhen",
            "listComprehension",
            "patternComprehension",
            "reduceExpression",
            "listItemsPredicate",
            "normalizeFunction",
            "trimFunction",
            "patternExpression",
            "shortestPathExpression",
            "parenthesizedExpression",
            "mapProjection",
            "mapProjectionElement",
            "countStar",
            "existsExpression",
            "countExpression",
            "collectExpression",
            "numberLiteral",
            "signedIntegerLiteral",
            "listLiteral",
            "propertyKeyName",
            "parameter",
            "parameterName",
            "functionInvocation",
            "functionArgument",
            "functionName",
            "namespace",
            "variable",
            "nonEmptyNameList",
            "type",
            "typePart",
            "typeName",
            "typeNullability",
            "typeListSuffix",
            "command",
            "createCommand",
            "dropCommand",
            "showCommand",
            "showCommandYield",
            "yieldItem",
            "yieldSkip",
            "yieldLimit",
            "yieldClause",
            "commandOptions",
            "terminateCommand",
            "composableCommandClauses",
            "composableShowCommandClauses",
            "showIndexCommand",
            "showIndexType",
            "showIndexesEnd",
            "showConstraintCommand",
            "showConstraintEntity",
            "constraintExistType",
            "showConstraintsEnd",
            "showProcedures",
            "showFunctions",
            "functionToken",
            "executableBy",
            "showFunctionsType",
            "showTransactions",
            "terminateTransactions",
            "showSettings",
            "settingToken",
            "namesAndClauses",
            "stringsOrExpression",
            "commandNodePattern",
            "commandRelPattern",
            "createConstraint",
            "constraintType",
            "dropConstraint",
            "createIndex",
            "createIndex_",
            "createFulltextIndex",
            "fulltextNodePattern",
            "fulltextRelPattern",
            "createLookupIndex",
            "lookupIndexNodePattern",
            "lookupIndexRelPattern",
            "dropIndex",
            "propertyList",
            "enclosedPropertyList",
            "alterCommand",
            "renameCommand",
            "grantCommand",
            "denyCommand",
            "revokeCommand",
            "userNames",
            "roleNames",
            "roleToken",
            "enableServerCommand",
            "alterServer",
            "renameServer",
            "dropServer",
            "showServers",
            "allocationCommand",
            "deallocateDatabaseFromServers",
            "reallocateDatabases",
            "createRole",
            "dropRole",
            "renameRole",
            "showRoles",
            "grantRole",
            "revokeRole",
            "createUser",
            "dropUser",
            "renameUser",
            "alterCurrentUser",
            "alterUser",
            "removeNamedProvider",
            "password",
            "passwordOnly",
            "passwordExpression",
            "passwordChangeRequired",
            "userStatus",
            "homeDatabase",
            "setAuthClause",
            "userAuthAttribute",
            "showUsers",
            "showCurrentUser",
            "showSupportedPrivileges",
            "showPrivileges",
            "showRolePrivileges",
            "showUserPrivileges",
            "privilegeAsCommand",
            "privilegeToken",
            "privilege",
            "allPrivilege",
            "allPrivilegeType",
            "allPrivilegeTarget",
            "createPrivilege",
            "createPrivilegeForDatabase",
            "createNodePrivilegeToken",
            "createRelPrivilegeToken",
            "createPropertyPrivilegeToken",
            "actionForDBMS",
            "dropPrivilege",
            "loadPrivilege",
            "showPrivilege",
            "setPrivilege",
            "passwordToken",
            "removePrivilege",
            "writePrivilege",
            "databasePrivilege",
            "dbmsPrivilege",
            "dbmsPrivilegeExecute",
            "adminToken",
            "procedureToken",
            "indexToken",
            "constraintToken",
            "transactionToken",
            "userQualifier",
            "executeFunctionQualifier",
            "executeProcedureQualifier",
            "settingQualifier",
            "globs",
            "glob",
            "globRecursive",
            "globPart",
            "qualifiedGraphPrivilegesWithProperty",
            "qualifiedGraphPrivileges",
            "labelsResource",
            "propertiesResource",
            "nonEmptyStringList",
            "graphQualifier",
            "graphQualifierToken",
            "relToken",
            "elementToken",
            "nodeToken",
            "databaseScope",
            "graphScope",
            "createCompositeDatabase",
            "createDatabase",
            "primaryTopology",
            "primaryToken",
            "secondaryTopology",
            "secondaryToken",
            "dropDatabase",
            "alterDatabase",
            "alterDatabaseAccess",
            "alterDatabaseTopology",
            "alterDatabaseOption",
            "startDatabase",
            "stopDatabase",
            "waitClause",
            "secondsToken",
            "showDatabase",
            "createAlias",
            "dropAlias",
            "alterAlias",
            "alterAliasTarget",
            "alterAliasUser",
            "alterAliasPassword",
            "alterAliasDriver",
            "alterAliasProperties",
            "showAliases",
            "symbolicNameOrStringParameter",
            "commandNameExpression",
            "symbolicNameOrStringParameterList",
            "symbolicAliasNameList",
            "symbolicAliasNameOrParameter",
            "symbolicAliasName",
            "stringListLiteral",
            "stringList",
            "stringLiteral",
            "stringOrParameterExpression",
            "stringOrParameter",
            "mapOrParameter",
            "map",
            "symbolicNameString",
            "escapedSymbolicNameString",
            "unescapedSymbolicNameString",
            "symbolicLabelNameString",
            "unescapedLabelSymbolicNameString",
            "endOfFile"
        };
    }

    public static final String[] ruleNames = makeRuleNames();

    private static String[] makeLiteralNames() {
        return new String[] {
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, null, null, null, "'|'", null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, "':'", "'::'", "','", null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, "'$'", null, "'/'", "'.'", "'..'", "'||'", null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, "'='", null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, "'>='", null, null, null, null, null, "'>'", null, null,
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'&'",
            "'!'", "'['", "'{'", "'<='", null, null, null, null, null, null, "'('", "'<'", null, null, null, null,
            "'-'", "'%'", "'!='", "'<>'", null, null, null, null, null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
            "'+'", "'+='", null, null, "'^'", null, null, null, null, null, null, null, null, null, null, "'?'", null,
            "']'", "'}'", null, null, null, null, "'=~'", null, null, null, null, null, null, null, null, null, null,
            null, null, null, null, null, "')'", null, null, null, null, null, null, null, "';'", null, null, null,
            null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
            null, null, "'*'"
        };
    }

    private static final String[] _LITERAL_NAMES = makeLiteralNames();

    private static String[] makeSymbolicNames() {
        return new String[] {
            null,
            "SPACE",
            "SINGLE_LINE_COMMENT",
            "MULTI_LINE_COMMENT",
            "DECIMAL_DOUBLE",
            "UNSIGNED_DECIMAL_INTEGER",
            "UNSIGNED_HEX_INTEGER",
            "UNSIGNED_OCTAL_INTEGER",
            "STRING_LITERAL1",
            "STRING_LITERAL2",
            "ESCAPED_SYMBOLIC_NAME",
            "ACCESS",
            "ACTIVE",
            "ADMIN",
            "ADMINISTRATOR",
            "ALIAS",
            "ALIASES",
            "ALL_SHORTEST_PATHS",
            "ALL",
            "ALTER",
            "AND",
            "ANY",
            "ARRAY",
            "AS",
            "ASC",
            "ASCENDING",
            "ASSIGN",
            "AT",
            "AUTH",
            "BAR",
            "BINDINGS",
            "BOOL",
            "BOOLEAN",
            "BOOSTED",
            "BOTH",
            "BREAK",
            "BTREE",
            "BUILT",
            "BY",
            "CALL",
            "CASE",
            "CHANGE",
            "CIDR",
            "COLLECT",
            "COLON",
            "COLONCOLON",
            "COMMA",
            "COMMAND",
            "COMMANDS",
            "COMPOSITE",
            "CONCURRENT",
            "CONSTRAINT",
            "CONSTRAINTS",
            "CONTAINS",
            "COPY",
            "CONTINUE",
            "COUNT",
            "CREATE",
            "CSV",
            "CURRENT",
            "DATA",
            "DATABASE",
            "DATABASES",
            "DATE",
            "DATETIME",
            "DBMS",
            "DEALLOCATE",
            "DEFAULT",
            "DEFINED",
            "DELETE",
            "DENY",
            "DESC",
            "DESCENDING",
            "DESTROY",
            "DETACH",
            "DIFFERENT",
            "DOLLAR",
            "DISTINCT",
            "DIVIDE",
            "DOT",
            "DOTDOT",
            "DOUBLEBAR",
            "DRIVER",
            "DROP",
            "DRYRUN",
            "DUMP",
            "DURATION",
            "EACH",
            "EDGE",
            "ENABLE",
            "ELEMENT",
            "ELEMENTS",
            "ELSE",
            "ENCRYPTED",
            "END",
            "ENDS",
            "EQ",
            "EXECUTABLE",
            "EXECUTE",
            "EXIST",
            "EXISTENCE",
            "EXISTS",
            "ERROR",
            "FAIL",
            "FALSE",
            "FIELDTERMINATOR",
            "FINISH",
            "FLOAT",
            "FOR",
            "FOREACH",
            "FROM",
            "FULLTEXT",
            "FUNCTION",
            "FUNCTIONS",
            "GE",
            "GRANT",
            "GRAPH",
            "GRAPHS",
            "GROUP",
            "GROUPS",
            "GT",
            "HEADERS",
            "HOME",
            "ID",
            "IF",
            "IMPERSONATE",
            "IMMUTABLE",
            "IN",
            "INDEX",
            "INDEXES",
            "INF",
            "INFINITY",
            "INSERT",
            "INT",
            "INTEGER",
            "IS",
            "JOIN",
            "KEY",
            "LABEL",
            "LABELS",
            "AMPERSAND",
            "EXCLAMATION_MARK",
            "LBRACKET",
            "LCURLY",
            "LE",
            "LEADING",
            "LIMITROWS",
            "LIST",
            "LOAD",
            "LOCAL",
            "LOOKUP",
            "LPAREN",
            "LT",
            "MANAGEMENT",
            "MAP",
            "MATCH",
            "MERGE",
            "MINUS",
            "PERCENT",
            "INVALID_NEQ",
            "NEQ",
            "NAME",
            "NAMES",
            "NAN",
            "NFC",
            "NFD",
            "NFKC",
            "NFKD",
            "NEW",
            "NODE",
            "NODETACH",
            "NODES",
            "NONE",
            "NORMALIZE",
            "NORMALIZED",
            "NOT",
            "NOTHING",
            "NOWAIT",
            "NULL",
            "OF",
            "ON",
            "ONLY",
            "OPTIONAL",
            "OPTIONS",
            "OPTION",
            "OR",
            "ORDER",
            "PASSWORD",
            "PASSWORDS",
            "PATH",
            "PATHS",
            "PLAINTEXT",
            "PLUS",
            "PLUSEQUAL",
            "POINT",
            "POPULATED",
            "POW",
            "PRIMARY",
            "PRIMARIES",
            "PRIVILEGE",
            "PRIVILEGES",
            "PROCEDURE",
            "PROCEDURES",
            "PROPERTIES",
            "PROPERTY",
            "PROVIDER",
            "PROVIDERS",
            "QUESTION",
            "RANGE",
            "RBRACKET",
            "RCURLY",
            "READ",
            "REALLOCATE",
            "REDUCE",
            "RENAME",
            "REGEQ",
            "REL",
            "RELATIONSHIP",
            "RELATIONSHIPS",
            "REMOVE",
            "REPEATABLE",
            "REPLACE",
            "REPORT",
            "REQUIRE",
            "REQUIRED",
            "RETURN",
            "REVOKE",
            "ROLE",
            "ROLES",
            "ROW",
            "ROWS",
            "RPAREN",
            "SCAN",
            "SEC",
            "SECOND",
            "SECONDARY",
            "SECONDARIES",
            "SECONDS",
            "SEEK",
            "SEMICOLON",
            "SERVER",
            "SERVERS",
            "SET",
            "SETTING",
            "SETTINGS",
            "SHORTEST_PATH",
            "SHORTEST",
            "SHOW",
            "SIGNED",
            "SINGLE",
            "SKIPROWS",
            "START",
            "STARTS",
            "STATUS",
            "STOP",
            "STRING",
            "SUPPORTED",
            "SUSPENDED",
            "TARGET",
            "TERMINATE",
            "TEXT",
            "THEN",
            "TIME",
            "TIMES",
            "TIMESTAMP",
            "TIMEZONE",
            "TO",
            "TOPOLOGY",
            "TRAILING",
            "TRANSACTION",
            "TRANSACTIONS",
            "TRAVERSE",
            "TRIM",
            "TRUE",
            "TYPE",
            "TYPED",
            "TYPES",
            "UNION",
            "UNIQUE",
            "UNIQUENESS",
            "UNWIND",
            "URL",
            "USE",
            "USER",
            "USERS",
            "USING",
            "VALUE",
            "VARCHAR",
            "VECTOR",
            "VERTEX",
            "WAIT",
            "WHEN",
            "WHERE",
            "WITH",
            "WITHOUT",
            "WRITE",
            "XOR",
            "YIELD",
            "ZONE",
            "ZONED",
            "IDENTIFIER",
            "ARROW_LINE",
            "ARROW_LEFT_HEAD",
            "ARROW_RIGHT_HEAD",
            "ErrorChar"
        };
    }

    private static final String[] _SYMBOLIC_NAMES = makeSymbolicNames();
    public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

    /**
     * @deprecated Use {@link #VOCABULARY} instead.
     */
    @Deprecated
    public static final String[] tokenNames;

    static {
        tokenNames = new String[_SYMBOLIC_NAMES.length];
        for (int i = 0; i < tokenNames.length; i++) {
            tokenNames[i] = VOCABULARY.getLiteralName(i);
            if (tokenNames[i] == null) {
                tokenNames[i] = VOCABULARY.getSymbolicName(i);
            }

            if (tokenNames[i] == null) {
                tokenNames[i] = "<INVALID>";
            }
        }
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return tokenNames;
    }

    @Override
    public Vocabulary getVocabulary() {
        return VOCABULARY;
    }

    @Override
    public String getGrammarFileName() {
        return "Cypher6Parser.g4";
    }

    @Override
    public String[] getRuleNames() {
        return ruleNames;
    }

    @Override
    public String getSerializedATN() {
        return _serializedATN;
    }

    @Override
    public ATN getATN() {
        return _ATN;
    }

    public Cypher6Parser(TokenStream input) {
        super(input);
        _interp = new ParserATNSimulator(this, _ATN, _decisionToDFA, _sharedContextCache);
    }

    @SuppressWarnings("CheckReturnValue")
    public static class StatementsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<StatementContext> statement() {
            return getRuleContexts(StatementContext.class);
        }

        public StatementContext statement(int i) {
            return getRuleContext(StatementContext.class, i);
        }

        public TerminalNode EOF() {
            return getToken(Cypher6Parser.EOF, 0);
        }

        public List<TerminalNode> SEMICOLON() {
            return getTokens(Cypher6Parser.SEMICOLON);
        }

        public TerminalNode SEMICOLON(int i) {
            return getToken(Cypher6Parser.SEMICOLON, i);
        }

        public StatementsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_statements;
        }
    }

    public final StatementsContext statements() throws RecognitionException {
        StatementsContext _localctx = new StatementsContext(_ctx, getState());
        enterRule(_localctx, 0, RULE_statements);
        int _la;
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(644);
                statement();
                setState(649);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 0, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(645);
                                match(SEMICOLON);
                                setState(646);
                                statement();
                            }
                        }
                    }
                    setState(651);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 0, _ctx);
                }
                setState(653);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SEMICOLON) {
                    {
                        setState(652);
                        match(SEMICOLON);
                    }
                }

                setState(655);
                match(EOF);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class StatementContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public CommandContext command() {
            return getRuleContext(CommandContext.class, 0);
        }

        public RegularQueryContext regularQuery() {
            return getRuleContext(RegularQueryContext.class, 0);
        }

        public StatementContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_statement;
        }
    }

    public final StatementContext statement() throws RecognitionException {
        StatementContext _localctx = new StatementContext(_ctx, getState());
        enterRule(_localctx, 2, RULE_statement);
        try {
            setState(659);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 2, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(657);
                        command();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(658);
                        regularQuery();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RegularQueryContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<SingleQueryContext> singleQuery() {
            return getRuleContexts(SingleQueryContext.class);
        }

        public SingleQueryContext singleQuery(int i) {
            return getRuleContext(SingleQueryContext.class, i);
        }

        public List<TerminalNode> UNION() {
            return getTokens(Cypher6Parser.UNION);
        }

        public TerminalNode UNION(int i) {
            return getToken(Cypher6Parser.UNION, i);
        }

        public List<TerminalNode> ALL() {
            return getTokens(Cypher6Parser.ALL);
        }

        public TerminalNode ALL(int i) {
            return getToken(Cypher6Parser.ALL, i);
        }

        public List<TerminalNode> DISTINCT() {
            return getTokens(Cypher6Parser.DISTINCT);
        }

        public TerminalNode DISTINCT(int i) {
            return getToken(Cypher6Parser.DISTINCT, i);
        }

        public RegularQueryContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_regularQuery;
        }
    }

    public final RegularQueryContext regularQuery() throws RecognitionException {
        RegularQueryContext _localctx = new RegularQueryContext(_ctx, getState());
        enterRule(_localctx, 4, RULE_regularQuery);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(661);
                singleQuery();
                setState(669);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == UNION) {
                    {
                        {
                            setState(662);
                            match(UNION);
                            setState(664);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == ALL || _la == DISTINCT) {
                                {
                                    setState(663);
                                    _la = _input.LA(1);
                                    if (!(_la == ALL || _la == DISTINCT)) {
                                        _errHandler.recoverInline(this);
                                    } else {
                                        if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                        _errHandler.reportMatch(this);
                                        consume();
                                    }
                                }
                            }

                            setState(666);
                            singleQuery();
                        }
                    }
                    setState(671);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SingleQueryContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<ClauseContext> clause() {
            return getRuleContexts(ClauseContext.class);
        }

        public ClauseContext clause(int i) {
            return getRuleContext(ClauseContext.class, i);
        }

        public SingleQueryContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_singleQuery;
        }
    }

    public final SingleQueryContext singleQuery() throws RecognitionException {
        SingleQueryContext _localctx = new SingleQueryContext(_ctx, getState());
        enterRule(_localctx, 6, RULE_singleQuery);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(673);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(672);
                            clause();
                        }
                    }
                    setState(675);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (((((_la - 39)) & ~0x3f) == 0 && ((1L << (_la - 39)) & 35433742337L) != 0)
                        || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & 1693247973883913L) != 0)
                        || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 36591746972389377L) != 0)
                        || ((((_la - 242)) & ~0x3f) == 0 && ((1L << (_la - 242)) & 2253174203219969L) != 0));
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public UseClauseContext useClause() {
            return getRuleContext(UseClauseContext.class, 0);
        }

        public FinishClauseContext finishClause() {
            return getRuleContext(FinishClauseContext.class, 0);
        }

        public ReturnClauseContext returnClause() {
            return getRuleContext(ReturnClauseContext.class, 0);
        }

        public CreateClauseContext createClause() {
            return getRuleContext(CreateClauseContext.class, 0);
        }

        public InsertClauseContext insertClause() {
            return getRuleContext(InsertClauseContext.class, 0);
        }

        public DeleteClauseContext deleteClause() {
            return getRuleContext(DeleteClauseContext.class, 0);
        }

        public SetClauseContext setClause() {
            return getRuleContext(SetClauseContext.class, 0);
        }

        public RemoveClauseContext removeClause() {
            return getRuleContext(RemoveClauseContext.class, 0);
        }

        public MatchClauseContext matchClause() {
            return getRuleContext(MatchClauseContext.class, 0);
        }

        public MergeClauseContext mergeClause() {
            return getRuleContext(MergeClauseContext.class, 0);
        }

        public WithClauseContext withClause() {
            return getRuleContext(WithClauseContext.class, 0);
        }

        public UnwindClauseContext unwindClause() {
            return getRuleContext(UnwindClauseContext.class, 0);
        }

        public CallClauseContext callClause() {
            return getRuleContext(CallClauseContext.class, 0);
        }

        public SubqueryClauseContext subqueryClause() {
            return getRuleContext(SubqueryClauseContext.class, 0);
        }

        public LoadCSVClauseContext loadCSVClause() {
            return getRuleContext(LoadCSVClauseContext.class, 0);
        }

        public ForeachClauseContext foreachClause() {
            return getRuleContext(ForeachClauseContext.class, 0);
        }

        public ClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_clause;
        }
    }

    public final ClauseContext clause() throws RecognitionException {
        ClauseContext _localctx = new ClauseContext(_ctx, getState());
        enterRule(_localctx, 8, RULE_clause);
        try {
            setState(693);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 6, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(677);
                        useClause();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(678);
                        finishClause();
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(679);
                        returnClause();
                    }
                    break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(680);
                        createClause();
                    }
                    break;
                case 5:
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(681);
                        insertClause();
                    }
                    break;
                case 6:
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(682);
                        deleteClause();
                    }
                    break;
                case 7:
                    enterOuterAlt(_localctx, 7);
                    {
                        setState(683);
                        setClause();
                    }
                    break;
                case 8:
                    enterOuterAlt(_localctx, 8);
                    {
                        setState(684);
                        removeClause();
                    }
                    break;
                case 9:
                    enterOuterAlt(_localctx, 9);
                    {
                        setState(685);
                        matchClause();
                    }
                    break;
                case 10:
                    enterOuterAlt(_localctx, 10);
                    {
                        setState(686);
                        mergeClause();
                    }
                    break;
                case 11:
                    enterOuterAlt(_localctx, 11);
                    {
                        setState(687);
                        withClause();
                    }
                    break;
                case 12:
                    enterOuterAlt(_localctx, 12);
                    {
                        setState(688);
                        unwindClause();
                    }
                    break;
                case 13:
                    enterOuterAlt(_localctx, 13);
                    {
                        setState(689);
                        callClause();
                    }
                    break;
                case 14:
                    enterOuterAlt(_localctx, 14);
                    {
                        setState(690);
                        subqueryClause();
                    }
                    break;
                case 15:
                    enterOuterAlt(_localctx, 15);
                    {
                        setState(691);
                        loadCSVClause();
                    }
                    break;
                case 16:
                    enterOuterAlt(_localctx, 16);
                    {
                        setState(692);
                        foreachClause();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class UseClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USE() {
            return getToken(Cypher6Parser.USE, 0);
        }

        public GraphReferenceContext graphReference() {
            return getRuleContext(GraphReferenceContext.class, 0);
        }

        public TerminalNode GRAPH() {
            return getToken(Cypher6Parser.GRAPH, 0);
        }

        public UseClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_useClause;
        }
    }

    public final UseClauseContext useClause() throws RecognitionException {
        UseClauseContext _localctx = new UseClauseContext(_ctx, getState());
        enterRule(_localctx, 10, RULE_useClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(695);
                match(USE);
                setState(697);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 7, _ctx)) {
                    case 1:
                        {
                            setState(696);
                            match(GRAPH);
                        }
                        break;
                }
                setState(699);
                graphReference();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GraphReferenceContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public GraphReferenceContext graphReference() {
            return getRuleContext(GraphReferenceContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public FunctionInvocationContext functionInvocation() {
            return getRuleContext(FunctionInvocationContext.class, 0);
        }

        public SymbolicAliasNameContext symbolicAliasName() {
            return getRuleContext(SymbolicAliasNameContext.class, 0);
        }

        public GraphReferenceContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_graphReference;
        }
    }

    public final GraphReferenceContext graphReference() throws RecognitionException {
        GraphReferenceContext _localctx = new GraphReferenceContext(_ctx, getState());
        enterRule(_localctx, 12, RULE_graphReference);
        try {
            setState(707);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 8, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(701);
                        match(LPAREN);
                        setState(702);
                        graphReference();
                        setState(703);
                        match(RPAREN);
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(705);
                        functionInvocation();
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(706);
                        symbolicAliasName();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FinishClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode FINISH() {
            return getToken(Cypher6Parser.FINISH, 0);
        }

        public FinishClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_finishClause;
        }
    }

    public final FinishClauseContext finishClause() throws RecognitionException {
        FinishClauseContext _localctx = new FinishClauseContext(_ctx, getState());
        enterRule(_localctx, 14, RULE_finishClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(709);
                match(FINISH);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ReturnClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode RETURN() {
            return getToken(Cypher6Parser.RETURN, 0);
        }

        public ReturnBodyContext returnBody() {
            return getRuleContext(ReturnBodyContext.class, 0);
        }

        public ReturnClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_returnClause;
        }
    }

    public final ReturnClauseContext returnClause() throws RecognitionException {
        ReturnClauseContext _localctx = new ReturnClauseContext(_ctx, getState());
        enterRule(_localctx, 16, RULE_returnClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(711);
                match(RETURN);
                setState(712);
                returnBody();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ReturnBodyContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ReturnItemsContext returnItems() {
            return getRuleContext(ReturnItemsContext.class, 0);
        }

        public TerminalNode DISTINCT() {
            return getToken(Cypher6Parser.DISTINCT, 0);
        }

        public OrderByContext orderBy() {
            return getRuleContext(OrderByContext.class, 0);
        }

        public SkipContext skip() {
            return getRuleContext(SkipContext.class, 0);
        }

        public LimitContext limit() {
            return getRuleContext(LimitContext.class, 0);
        }

        public ReturnBodyContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_returnBody;
        }
    }

    public final ReturnBodyContext returnBody() throws RecognitionException {
        ReturnBodyContext _localctx = new ReturnBodyContext(_ctx, getState());
        enterRule(_localctx, 18, RULE_returnBody);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(715);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 9, _ctx)) {
                    case 1:
                        {
                            setState(714);
                            match(DISTINCT);
                        }
                        break;
                }
                setState(717);
                returnItems();
                setState(719);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ORDER) {
                    {
                        setState(718);
                        orderBy();
                    }
                }

                setState(722);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SKIPROWS) {
                    {
                        setState(721);
                        skip();
                    }
                }

                setState(725);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LIMITROWS) {
                    {
                        setState(724);
                        limit();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ReturnItemContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public ReturnItemContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_returnItem;
        }
    }

    public final ReturnItemContext returnItem() throws RecognitionException {
        ReturnItemContext _localctx = new ReturnItemContext(_ctx, getState());
        enterRule(_localctx, 20, RULE_returnItem);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(727);
                expression();
                setState(730);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(728);
                        match(AS);
                        setState(729);
                        variable();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ReturnItemsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public List<ReturnItemContext> returnItem() {
            return getRuleContexts(ReturnItemContext.class);
        }

        public ReturnItemContext returnItem(int i) {
            return getRuleContext(ReturnItemContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public ReturnItemsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_returnItems;
        }
    }

    public final ReturnItemsContext returnItems() throws RecognitionException {
        ReturnItemsContext _localctx = new ReturnItemsContext(_ctx, getState());
        enterRule(_localctx, 22, RULE_returnItems);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(734);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case TIMES:
                        {
                            setState(732);
                            match(TIMES);
                        }
                        break;
                    case DECIMAL_DOUBLE:
                    case UNSIGNED_DECIMAL_INTEGER:
                    case UNSIGNED_HEX_INTEGER:
                    case UNSIGNED_OCTAL_INTEGER:
                    case STRING_LITERAL1:
                    case STRING_LITERAL2:
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DOLLAR:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LBRACKET:
                    case LCURLY:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case LPAREN:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case MINUS:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case PLUS:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(733);
                            returnItem();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(740);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(736);
                            match(COMMA);
                            setState(737);
                            returnItem();
                        }
                    }
                    setState(742);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class OrderItemContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public AscTokenContext ascToken() {
            return getRuleContext(AscTokenContext.class, 0);
        }

        public DescTokenContext descToken() {
            return getRuleContext(DescTokenContext.class, 0);
        }

        public OrderItemContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_orderItem;
        }
    }

    public final OrderItemContext orderItem() throws RecognitionException {
        OrderItemContext _localctx = new OrderItemContext(_ctx, getState());
        enterRule(_localctx, 24, RULE_orderItem);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(743);
                expression();
                setState(746);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ASC:
                    case ASCENDING:
                        {
                            setState(744);
                            ascToken();
                        }
                        break;
                    case DESC:
                    case DESCENDING:
                        {
                            setState(745);
                            descToken();
                        }
                        break;
                    case EOF:
                    case CALL:
                    case COMMA:
                    case CREATE:
                    case DELETE:
                    case DETACH:
                    case FINISH:
                    case FOREACH:
                    case INSERT:
                    case LIMITROWS:
                    case LOAD:
                    case MATCH:
                    case MERGE:
                    case NODETACH:
                    case OPTIONAL:
                    case RCURLY:
                    case REMOVE:
                    case RETURN:
                    case RPAREN:
                    case SEMICOLON:
                    case SET:
                    case SHOW:
                    case SKIPROWS:
                    case TERMINATE:
                    case UNION:
                    case UNWIND:
                    case USE:
                    case WHERE:
                    case WITH:
                        break;
                    default:
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AscTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ASC() {
            return getToken(Cypher6Parser.ASC, 0);
        }

        public TerminalNode ASCENDING() {
            return getToken(Cypher6Parser.ASCENDING, 0);
        }

        public AscTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_ascToken;
        }
    }

    public final AscTokenContext ascToken() throws RecognitionException {
        AscTokenContext _localctx = new AscTokenContext(_ctx, getState());
        enterRule(_localctx, 26, RULE_ascToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(748);
                _la = _input.LA(1);
                if (!(_la == ASC || _la == ASCENDING)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DescTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DESC() {
            return getToken(Cypher6Parser.DESC, 0);
        }

        public TerminalNode DESCENDING() {
            return getToken(Cypher6Parser.DESCENDING, 0);
        }

        public DescTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_descToken;
        }
    }

    public final DescTokenContext descToken() throws RecognitionException {
        DescTokenContext _localctx = new DescTokenContext(_ctx, getState());
        enterRule(_localctx, 28, RULE_descToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(750);
                _la = _input.LA(1);
                if (!(_la == DESC || _la == DESCENDING)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class OrderByContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ORDER() {
            return getToken(Cypher6Parser.ORDER, 0);
        }

        public TerminalNode BY() {
            return getToken(Cypher6Parser.BY, 0);
        }

        public List<OrderItemContext> orderItem() {
            return getRuleContexts(OrderItemContext.class);
        }

        public OrderItemContext orderItem(int i) {
            return getRuleContext(OrderItemContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public OrderByContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_orderBy;
        }
    }

    public final OrderByContext orderBy() throws RecognitionException {
        OrderByContext _localctx = new OrderByContext(_ctx, getState());
        enterRule(_localctx, 30, RULE_orderBy);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(752);
                match(ORDER);
                setState(753);
                match(BY);
                setState(754);
                orderItem();
                setState(759);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(755);
                            match(COMMA);
                            setState(756);
                            orderItem();
                        }
                    }
                    setState(761);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SkipContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SKIPROWS() {
            return getToken(Cypher6Parser.SKIPROWS, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public SkipContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_skip;
        }
    }

    public final SkipContext skip() throws RecognitionException {
        SkipContext _localctx = new SkipContext(_ctx, getState());
        enterRule(_localctx, 32, RULE_skip);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(762);
                match(SKIPROWS);
                setState(763);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LimitContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LIMITROWS() {
            return getToken(Cypher6Parser.LIMITROWS, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public LimitContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_limit;
        }
    }

    public final LimitContext limit() throws RecognitionException {
        LimitContext _localctx = new LimitContext(_ctx, getState());
        enterRule(_localctx, 34, RULE_limit);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(765);
                match(LIMITROWS);
                setState(766);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhereClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public WhereClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_whereClause;
        }
    }

    public final WhereClauseContext whereClause() throws RecognitionException {
        WhereClauseContext _localctx = new WhereClauseContext(_ctx, getState());
        enterRule(_localctx, 36, RULE_whereClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(768);
                match(WHERE);
                setState(769);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WithClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public ReturnBodyContext returnBody() {
            return getRuleContext(ReturnBodyContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public WithClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_withClause;
        }
    }

    public final WithClauseContext withClause() throws RecognitionException {
        WithClauseContext _localctx = new WithClauseContext(_ctx, getState());
        enterRule(_localctx, 38, RULE_withClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(771);
                match(WITH);
                setState(772);
                returnBody();
                setState(774);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(773);
                        whereClause();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CREATE() {
            return getToken(Cypher6Parser.CREATE, 0);
        }

        public PatternListContext patternList() {
            return getRuleContext(PatternListContext.class, 0);
        }

        public CreateClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createClause;
        }
    }

    public final CreateClauseContext createClause() throws RecognitionException {
        CreateClauseContext _localctx = new CreateClauseContext(_ctx, getState());
        enterRule(_localctx, 40, RULE_createClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(776);
                match(CREATE);
                setState(777);
                patternList();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode INSERT() {
            return getToken(Cypher6Parser.INSERT, 0);
        }

        public InsertPatternListContext insertPatternList() {
            return getRuleContext(InsertPatternListContext.class, 0);
        }

        public InsertClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertClause;
        }
    }

    public final InsertClauseContext insertClause() throws RecognitionException {
        InsertClauseContext _localctx = new InsertClauseContext(_ctx, getState());
        enterRule(_localctx, 42, RULE_insertClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(779);
                match(INSERT);
                setState(780);
                insertPatternList();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SET() {
            return getToken(Cypher6Parser.SET, 0);
        }

        public List<SetItemContext> setItem() {
            return getRuleContexts(SetItemContext.class);
        }

        public SetItemContext setItem(int i) {
            return getRuleContext(SetItemContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public SetClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_setClause;
        }
    }

    public final SetClauseContext setClause() throws RecognitionException {
        SetClauseContext _localctx = new SetClauseContext(_ctx, getState());
        enterRule(_localctx, 44, RULE_setClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(782);
                match(SET);
                setState(783);
                setItem();
                setState(788);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(784);
                            match(COMMA);
                            setState(785);
                            setItem();
                        }
                    }
                    setState(790);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetItemContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SetItemContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_setItem;
        }

        public SetItemContext() {}

        public void copyFrom(SetItemContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetPropContext extends SetItemContext {
        public PropertyExpressionContext propertyExpression() {
            return getRuleContext(PropertyExpressionContext.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public SetPropContext(SetItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AddPropContext extends SetItemContext {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode PLUSEQUAL() {
            return getToken(Cypher6Parser.PLUSEQUAL, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public AddPropContext(SetItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetDynamicPropContext extends SetItemContext {
        public DynamicPropertyExpressionContext dynamicPropertyExpression() {
            return getRuleContext(DynamicPropertyExpressionContext.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public SetDynamicPropContext(SetItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetPropsContext extends SetItemContext {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public SetPropsContext(SetItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetLabelsContext extends SetItemContext {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public NodeLabelsContext nodeLabels() {
            return getRuleContext(NodeLabelsContext.class, 0);
        }

        public SetLabelsContext(SetItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetLabelsIsContext extends SetItemContext {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public NodeLabelsIsContext nodeLabelsIs() {
            return getRuleContext(NodeLabelsIsContext.class, 0);
        }

        public SetLabelsIsContext(SetItemContext ctx) {
            copyFrom(ctx);
        }
    }

    public final SetItemContext setItem() throws RecognitionException {
        SetItemContext _localctx = new SetItemContext(_ctx, getState());
        enterRule(_localctx, 46, RULE_setItem);
        try {
            setState(813);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 20, _ctx)) {
                case 1:
                    _localctx = new SetPropContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(791);
                        propertyExpression();
                        setState(792);
                        match(EQ);
                        setState(793);
                        expression();
                    }
                    break;
                case 2:
                    _localctx = new SetDynamicPropContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(795);
                        dynamicPropertyExpression();
                        setState(796);
                        match(EQ);
                        setState(797);
                        expression();
                    }
                    break;
                case 3:
                    _localctx = new SetPropsContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(799);
                        variable();
                        setState(800);
                        match(EQ);
                        setState(801);
                        expression();
                    }
                    break;
                case 4:
                    _localctx = new AddPropContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(803);
                        variable();
                        setState(804);
                        match(PLUSEQUAL);
                        setState(805);
                        expression();
                    }
                    break;
                case 5:
                    _localctx = new SetLabelsContext(_localctx);
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(807);
                        variable();
                        setState(808);
                        nodeLabels();
                    }
                    break;
                case 6:
                    _localctx = new SetLabelsIsContext(_localctx);
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(810);
                        variable();
                        setState(811);
                        nodeLabelsIs();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemoveClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REMOVE() {
            return getToken(Cypher6Parser.REMOVE, 0);
        }

        public List<RemoveItemContext> removeItem() {
            return getRuleContexts(RemoveItemContext.class);
        }

        public RemoveItemContext removeItem(int i) {
            return getRuleContext(RemoveItemContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public RemoveClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_removeClause;
        }
    }

    public final RemoveClauseContext removeClause() throws RecognitionException {
        RemoveClauseContext _localctx = new RemoveClauseContext(_ctx, getState());
        enterRule(_localctx, 48, RULE_removeClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(815);
                match(REMOVE);
                setState(816);
                removeItem();
                setState(821);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(817);
                            match(COMMA);
                            setState(818);
                            removeItem();
                        }
                    }
                    setState(823);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemoveItemContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public RemoveItemContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_removeItem;
        }

        public RemoveItemContext() {}

        public void copyFrom(RemoveItemContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemoveLabelsIsContext extends RemoveItemContext {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public NodeLabelsIsContext nodeLabelsIs() {
            return getRuleContext(NodeLabelsIsContext.class, 0);
        }

        public RemoveLabelsIsContext(RemoveItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemoveDynamicPropContext extends RemoveItemContext {
        public DynamicPropertyExpressionContext dynamicPropertyExpression() {
            return getRuleContext(DynamicPropertyExpressionContext.class, 0);
        }

        public RemoveDynamicPropContext(RemoveItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemoveLabelsContext extends RemoveItemContext {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public NodeLabelsContext nodeLabels() {
            return getRuleContext(NodeLabelsContext.class, 0);
        }

        public RemoveLabelsContext(RemoveItemContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemovePropContext extends RemoveItemContext {
        public PropertyExpressionContext propertyExpression() {
            return getRuleContext(PropertyExpressionContext.class, 0);
        }

        public RemovePropContext(RemoveItemContext ctx) {
            copyFrom(ctx);
        }
    }

    public final RemoveItemContext removeItem() throws RecognitionException {
        RemoveItemContext _localctx = new RemoveItemContext(_ctx, getState());
        enterRule(_localctx, 50, RULE_removeItem);
        try {
            setState(832);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 22, _ctx)) {
                case 1:
                    _localctx = new RemovePropContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(824);
                        propertyExpression();
                    }
                    break;
                case 2:
                    _localctx = new RemoveDynamicPropContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(825);
                        dynamicPropertyExpression();
                    }
                    break;
                case 3:
                    _localctx = new RemoveLabelsContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(826);
                        variable();
                        setState(827);
                        nodeLabels();
                    }
                    break;
                case 4:
                    _localctx = new RemoveLabelsIsContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(829);
                        variable();
                        setState(830);
                        nodeLabelsIs();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DeleteClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DELETE() {
            return getToken(Cypher6Parser.DELETE, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public TerminalNode DETACH() {
            return getToken(Cypher6Parser.DETACH, 0);
        }

        public TerminalNode NODETACH() {
            return getToken(Cypher6Parser.NODETACH, 0);
        }

        public DeleteClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_deleteClause;
        }
    }

    public final DeleteClauseContext deleteClause() throws RecognitionException {
        DeleteClauseContext _localctx = new DeleteClauseContext(_ctx, getState());
        enterRule(_localctx, 52, RULE_deleteClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(835);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == DETACH || _la == NODETACH) {
                    {
                        setState(834);
                        _la = _input.LA(1);
                        if (!(_la == DETACH || _la == NODETACH)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(837);
                match(DELETE);
                setState(838);
                expression();
                setState(843);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(839);
                            match(COMMA);
                            setState(840);
                            expression();
                        }
                    }
                    setState(845);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class MatchClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode MATCH() {
            return getToken(Cypher6Parser.MATCH, 0);
        }

        public PatternListContext patternList() {
            return getRuleContext(PatternListContext.class, 0);
        }

        public TerminalNode OPTIONAL() {
            return getToken(Cypher6Parser.OPTIONAL, 0);
        }

        public MatchModeContext matchMode() {
            return getRuleContext(MatchModeContext.class, 0);
        }

        public List<HintContext> hint() {
            return getRuleContexts(HintContext.class);
        }

        public HintContext hint(int i) {
            return getRuleContext(HintContext.class, i);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public MatchClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_matchClause;
        }
    }

    public final MatchClauseContext matchClause() throws RecognitionException {
        MatchClauseContext _localctx = new MatchClauseContext(_ctx, getState());
        enterRule(_localctx, 54, RULE_matchClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(847);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OPTIONAL) {
                    {
                        setState(846);
                        match(OPTIONAL);
                    }
                }

                setState(849);
                match(MATCH);
                setState(851);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 26, _ctx)) {
                    case 1:
                        {
                            setState(850);
                            matchMode();
                        }
                        break;
                }
                setState(853);
                patternList();
                setState(857);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == USING) {
                    {
                        {
                            setState(854);
                            hint();
                        }
                    }
                    setState(859);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(861);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(860);
                        whereClause();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class MatchModeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REPEATABLE() {
            return getToken(Cypher6Parser.REPEATABLE, 0);
        }

        public TerminalNode ELEMENT() {
            return getToken(Cypher6Parser.ELEMENT, 0);
        }

        public TerminalNode ELEMENTS() {
            return getToken(Cypher6Parser.ELEMENTS, 0);
        }

        public TerminalNode BINDINGS() {
            return getToken(Cypher6Parser.BINDINGS, 0);
        }

        public TerminalNode DIFFERENT() {
            return getToken(Cypher6Parser.DIFFERENT, 0);
        }

        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public TerminalNode RELATIONSHIPS() {
            return getToken(Cypher6Parser.RELATIONSHIPS, 0);
        }

        public MatchModeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_matchMode;
        }
    }

    public final MatchModeContext matchMode() throws RecognitionException {
        MatchModeContext _localctx = new MatchModeContext(_ctx, getState());
        enterRule(_localctx, 56, RULE_matchMode);
        try {
            setState(879);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case REPEATABLE:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(863);
                        match(REPEATABLE);
                        setState(869);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case ELEMENT:
                                {
                                    setState(864);
                                    match(ELEMENT);
                                    setState(866);
                                    _errHandler.sync(this);
                                    switch (getInterpreter().adaptivePredict(_input, 29, _ctx)) {
                                        case 1:
                                            {
                                                setState(865);
                                                match(BINDINGS);
                                            }
                                            break;
                                    }
                                }
                                break;
                            case ELEMENTS:
                                {
                                    setState(868);
                                    match(ELEMENTS);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    break;
                case DIFFERENT:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(871);
                        match(DIFFERENT);
                        setState(877);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case RELATIONSHIP:
                                {
                                    setState(872);
                                    match(RELATIONSHIP);
                                    setState(874);
                                    _errHandler.sync(this);
                                    switch (getInterpreter().adaptivePredict(_input, 31, _ctx)) {
                                        case 1:
                                            {
                                                setState(873);
                                                match(BINDINGS);
                                            }
                                            break;
                                    }
                                }
                                break;
                            case RELATIONSHIPS:
                                {
                                    setState(876);
                                    match(RELATIONSHIPS);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class HintContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USING() {
            return getToken(Cypher6Parser.USING, 0);
        }

        public TerminalNode JOIN() {
            return getToken(Cypher6Parser.JOIN, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public NonEmptyNameListContext nonEmptyNameList() {
            return getRuleContext(NonEmptyNameListContext.class, 0);
        }

        public TerminalNode SCAN() {
            return getToken(Cypher6Parser.SCAN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public LabelOrRelTypeContext labelOrRelType() {
            return getRuleContext(LabelOrRelTypeContext.class, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode INDEX() {
            return getToken(Cypher6Parser.INDEX, 0);
        }

        public TerminalNode BTREE() {
            return getToken(Cypher6Parser.BTREE, 0);
        }

        public TerminalNode TEXT() {
            return getToken(Cypher6Parser.TEXT, 0);
        }

        public TerminalNode RANGE() {
            return getToken(Cypher6Parser.RANGE, 0);
        }

        public TerminalNode POINT() {
            return getToken(Cypher6Parser.POINT, 0);
        }

        public TerminalNode SEEK() {
            return getToken(Cypher6Parser.SEEK, 0);
        }

        public HintContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_hint;
        }
    }

    public final HintContext hint() throws RecognitionException {
        HintContext _localctx = new HintContext(_ctx, getState());
        enterRule(_localctx, 58, RULE_hint);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(881);
                match(USING);
                setState(909);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case BTREE:
                    case INDEX:
                    case POINT:
                    case RANGE:
                    case TEXT:
                        {
                            {
                                setState(891);
                                _errHandler.sync(this);
                                switch (_input.LA(1)) {
                                    case INDEX:
                                        {
                                            setState(882);
                                            match(INDEX);
                                        }
                                        break;
                                    case BTREE:
                                        {
                                            setState(883);
                                            match(BTREE);
                                            setState(884);
                                            match(INDEX);
                                        }
                                        break;
                                    case TEXT:
                                        {
                                            setState(885);
                                            match(TEXT);
                                            setState(886);
                                            match(INDEX);
                                        }
                                        break;
                                    case RANGE:
                                        {
                                            setState(887);
                                            match(RANGE);
                                            setState(888);
                                            match(INDEX);
                                        }
                                        break;
                                    case POINT:
                                        {
                                            setState(889);
                                            match(POINT);
                                            setState(890);
                                            match(INDEX);
                                        }
                                        break;
                                    default:
                                        throw new NoViableAltException(this);
                                }
                                setState(894);
                                _errHandler.sync(this);
                                switch (getInterpreter().adaptivePredict(_input, 35, _ctx)) {
                                    case 1:
                                        {
                                            setState(893);
                                            match(SEEK);
                                        }
                                        break;
                                }
                                setState(896);
                                variable();
                                setState(897);
                                labelOrRelType();
                                setState(898);
                                match(LPAREN);
                                setState(899);
                                nonEmptyNameList();
                                setState(900);
                                match(RPAREN);
                            }
                        }
                        break;
                    case JOIN:
                        {
                            setState(902);
                            match(JOIN);
                            setState(903);
                            match(ON);
                            setState(904);
                            nonEmptyNameList();
                        }
                        break;
                    case SCAN:
                        {
                            setState(905);
                            match(SCAN);
                            setState(906);
                            variable();
                            setState(907);
                            labelOrRelType();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class MergeClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode MERGE() {
            return getToken(Cypher6Parser.MERGE, 0);
        }

        public PatternContext pattern() {
            return getRuleContext(PatternContext.class, 0);
        }

        public List<MergeActionContext> mergeAction() {
            return getRuleContexts(MergeActionContext.class);
        }

        public MergeActionContext mergeAction(int i) {
            return getRuleContext(MergeActionContext.class, i);
        }

        public MergeClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_mergeClause;
        }
    }

    public final MergeClauseContext mergeClause() throws RecognitionException {
        MergeClauseContext _localctx = new MergeClauseContext(_ctx, getState());
        enterRule(_localctx, 60, RULE_mergeClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(911);
                match(MERGE);
                setState(912);
                pattern();
                setState(916);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == ON) {
                    {
                        {
                            setState(913);
                            mergeAction();
                        }
                    }
                    setState(918);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class MergeActionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public SetClauseContext setClause() {
            return getRuleContext(SetClauseContext.class, 0);
        }

        public TerminalNode MATCH() {
            return getToken(Cypher6Parser.MATCH, 0);
        }

        public TerminalNode CREATE() {
            return getToken(Cypher6Parser.CREATE, 0);
        }

        public MergeActionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_mergeAction;
        }
    }

    public final MergeActionContext mergeAction() throws RecognitionException {
        MergeActionContext _localctx = new MergeActionContext(_ctx, getState());
        enterRule(_localctx, 62, RULE_mergeAction);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(919);
                match(ON);
                setState(920);
                _la = _input.LA(1);
                if (!(_la == CREATE || _la == MATCH)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(921);
                setClause();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class UnwindClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode UNWIND() {
            return getToken(Cypher6Parser.UNWIND, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public UnwindClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_unwindClause;
        }
    }

    public final UnwindClauseContext unwindClause() throws RecognitionException {
        UnwindClauseContext _localctx = new UnwindClauseContext(_ctx, getState());
        enterRule(_localctx, 64, RULE_unwindClause);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(923);
                match(UNWIND);
                setState(924);
                expression();
                setState(925);
                match(AS);
                setState(926);
                variable();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CallClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CALL() {
            return getToken(Cypher6Parser.CALL, 0);
        }

        public ProcedureNameContext procedureName() {
            return getRuleContext(ProcedureNameContext.class, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode YIELD() {
            return getToken(Cypher6Parser.YIELD, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public List<ProcedureResultItemContext> procedureResultItem() {
            return getRuleContexts(ProcedureResultItemContext.class);
        }

        public ProcedureResultItemContext procedureResultItem(int i) {
            return getRuleContext(ProcedureResultItemContext.class, i);
        }

        public List<ProcedureArgumentContext> procedureArgument() {
            return getRuleContexts(ProcedureArgumentContext.class);
        }

        public ProcedureArgumentContext procedureArgument(int i) {
            return getRuleContext(ProcedureArgumentContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public CallClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_callClause;
        }
    }

    public final CallClauseContext callClause() throws RecognitionException {
        CallClauseContext _localctx = new CallClauseContext(_ctx, getState());
        enterRule(_localctx, 66, RULE_callClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(928);
                match(CALL);
                setState(929);
                procedureName();
                setState(942);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LPAREN) {
                    {
                        setState(930);
                        match(LPAREN);
                        setState(939);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839181840L) != 0)
                                || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239983617L) != 0)
                                || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -7533047809L) != 0)
                                || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & -141287252983827L) != 0)
                                || ((((_la - 256)) & ~0x3f) == 0 && ((1L << (_la - 256)) & 35184372088703L) != 0)) {
                            {
                                setState(931);
                                procedureArgument();
                                setState(936);
                                _errHandler.sync(this);
                                _la = _input.LA(1);
                                while (_la == COMMA) {
                                    {
                                        {
                                            setState(932);
                                            match(COMMA);
                                            setState(933);
                                            procedureArgument();
                                        }
                                    }
                                    setState(938);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                }
                            }
                        }

                        setState(941);
                        match(RPAREN);
                    }
                }

                setState(959);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == YIELD) {
                    {
                        setState(944);
                        match(YIELD);
                        setState(957);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case TIMES:
                                {
                                    setState(945);
                                    match(TIMES);
                                }
                                break;
                            case ESCAPED_SYMBOLIC_NAME:
                            case ACCESS:
                            case ACTIVE:
                            case ADMIN:
                            case ADMINISTRATOR:
                            case ALIAS:
                            case ALIASES:
                            case ALL_SHORTEST_PATHS:
                            case ALL:
                            case ALTER:
                            case AND:
                            case ANY:
                            case ARRAY:
                            case AS:
                            case ASC:
                            case ASCENDING:
                            case ASSIGN:
                            case AT:
                            case AUTH:
                            case BINDINGS:
                            case BOOL:
                            case BOOLEAN:
                            case BOOSTED:
                            case BOTH:
                            case BREAK:
                            case BTREE:
                            case BUILT:
                            case BY:
                            case CALL:
                            case CASE:
                            case CHANGE:
                            case CIDR:
                            case COLLECT:
                            case COMMAND:
                            case COMMANDS:
                            case COMPOSITE:
                            case CONCURRENT:
                            case CONSTRAINT:
                            case CONSTRAINTS:
                            case CONTAINS:
                            case COPY:
                            case CONTINUE:
                            case COUNT:
                            case CREATE:
                            case CSV:
                            case CURRENT:
                            case DATA:
                            case DATABASE:
                            case DATABASES:
                            case DATE:
                            case DATETIME:
                            case DBMS:
                            case DEALLOCATE:
                            case DEFAULT:
                            case DEFINED:
                            case DELETE:
                            case DENY:
                            case DESC:
                            case DESCENDING:
                            case DESTROY:
                            case DETACH:
                            case DIFFERENT:
                            case DISTINCT:
                            case DRIVER:
                            case DROP:
                            case DRYRUN:
                            case DUMP:
                            case DURATION:
                            case EACH:
                            case EDGE:
                            case ENABLE:
                            case ELEMENT:
                            case ELEMENTS:
                            case ELSE:
                            case ENCRYPTED:
                            case END:
                            case ENDS:
                            case EXECUTABLE:
                            case EXECUTE:
                            case EXIST:
                            case EXISTENCE:
                            case EXISTS:
                            case ERROR:
                            case FAIL:
                            case FALSE:
                            case FIELDTERMINATOR:
                            case FINISH:
                            case FLOAT:
                            case FOR:
                            case FOREACH:
                            case FROM:
                            case FULLTEXT:
                            case FUNCTION:
                            case FUNCTIONS:
                            case GRANT:
                            case GRAPH:
                            case GRAPHS:
                            case GROUP:
                            case GROUPS:
                            case HEADERS:
                            case HOME:
                            case ID:
                            case IF:
                            case IMPERSONATE:
                            case IMMUTABLE:
                            case IN:
                            case INDEX:
                            case INDEXES:
                            case INF:
                            case INFINITY:
                            case INSERT:
                            case INT:
                            case INTEGER:
                            case IS:
                            case JOIN:
                            case KEY:
                            case LABEL:
                            case LABELS:
                            case LEADING:
                            case LIMITROWS:
                            case LIST:
                            case LOAD:
                            case LOCAL:
                            case LOOKUP:
                            case MANAGEMENT:
                            case MAP:
                            case MATCH:
                            case MERGE:
                            case NAME:
                            case NAMES:
                            case NAN:
                            case NFC:
                            case NFD:
                            case NFKC:
                            case NFKD:
                            case NEW:
                            case NODE:
                            case NODETACH:
                            case NODES:
                            case NONE:
                            case NORMALIZE:
                            case NORMALIZED:
                            case NOT:
                            case NOTHING:
                            case NOWAIT:
                            case NULL:
                            case OF:
                            case ON:
                            case ONLY:
                            case OPTIONAL:
                            case OPTIONS:
                            case OPTION:
                            case OR:
                            case ORDER:
                            case PASSWORD:
                            case PASSWORDS:
                            case PATH:
                            case PATHS:
                            case PLAINTEXT:
                            case POINT:
                            case POPULATED:
                            case PRIMARY:
                            case PRIMARIES:
                            case PRIVILEGE:
                            case PRIVILEGES:
                            case PROCEDURE:
                            case PROCEDURES:
                            case PROPERTIES:
                            case PROPERTY:
                            case PROVIDER:
                            case PROVIDERS:
                            case RANGE:
                            case READ:
                            case REALLOCATE:
                            case REDUCE:
                            case RENAME:
                            case REL:
                            case RELATIONSHIP:
                            case RELATIONSHIPS:
                            case REMOVE:
                            case REPEATABLE:
                            case REPLACE:
                            case REPORT:
                            case REQUIRE:
                            case REQUIRED:
                            case RETURN:
                            case REVOKE:
                            case ROLE:
                            case ROLES:
                            case ROW:
                            case ROWS:
                            case SCAN:
                            case SEC:
                            case SECOND:
                            case SECONDARY:
                            case SECONDARIES:
                            case SECONDS:
                            case SEEK:
                            case SERVER:
                            case SERVERS:
                            case SET:
                            case SETTING:
                            case SETTINGS:
                            case SHORTEST_PATH:
                            case SHORTEST:
                            case SHOW:
                            case SIGNED:
                            case SINGLE:
                            case SKIPROWS:
                            case START:
                            case STARTS:
                            case STATUS:
                            case STOP:
                            case STRING:
                            case SUPPORTED:
                            case SUSPENDED:
                            case TARGET:
                            case TERMINATE:
                            case TEXT:
                            case THEN:
                            case TIME:
                            case TIMESTAMP:
                            case TIMEZONE:
                            case TO:
                            case TOPOLOGY:
                            case TRAILING:
                            case TRANSACTION:
                            case TRANSACTIONS:
                            case TRAVERSE:
                            case TRIM:
                            case TRUE:
                            case TYPE:
                            case TYPED:
                            case TYPES:
                            case UNION:
                            case UNIQUE:
                            case UNIQUENESS:
                            case UNWIND:
                            case URL:
                            case USE:
                            case USER:
                            case USERS:
                            case USING:
                            case VALUE:
                            case VARCHAR:
                            case VECTOR:
                            case VERTEX:
                            case WAIT:
                            case WHEN:
                            case WHERE:
                            case WITH:
                            case WITHOUT:
                            case WRITE:
                            case XOR:
                            case YIELD:
                            case ZONE:
                            case ZONED:
                            case IDENTIFIER:
                                {
                                    setState(946);
                                    procedureResultItem();
                                    setState(951);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    while (_la == COMMA) {
                                        {
                                            {
                                                setState(947);
                                                match(COMMA);
                                                setState(948);
                                                procedureResultItem();
                                            }
                                        }
                                        setState(953);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                    }
                                    setState(955);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    if (_la == WHERE) {
                                        {
                                            setState(954);
                                            whereClause();
                                        }
                                    }
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ProcedureNameContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public NamespaceContext namespace() {
            return getRuleContext(NamespaceContext.class, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public ProcedureNameContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_procedureName;
        }
    }

    public final ProcedureNameContext procedureName() throws RecognitionException {
        ProcedureNameContext _localctx = new ProcedureNameContext(_ctx, getState());
        enterRule(_localctx, 68, RULE_procedureName);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(961);
                namespace();
                setState(962);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ProcedureArgumentContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public ProcedureArgumentContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_procedureArgument;
        }
    }

    public final ProcedureArgumentContext procedureArgument() throws RecognitionException {
        ProcedureArgumentContext _localctx = new ProcedureArgumentContext(_ctx, getState());
        enterRule(_localctx, 70, RULE_procedureArgument);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(964);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ProcedureResultItemContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public ProcedureResultItemContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_procedureResultItem;
        }
    }

    public final ProcedureResultItemContext procedureResultItem() throws RecognitionException {
        ProcedureResultItemContext _localctx = new ProcedureResultItemContext(_ctx, getState());
        enterRule(_localctx, 72, RULE_procedureResultItem);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(966);
                symbolicNameString();
                setState(969);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(967);
                        match(AS);
                        setState(968);
                        variable();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LoadCSVClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LOAD() {
            return getToken(Cypher6Parser.LOAD, 0);
        }

        public TerminalNode CSV() {
            return getToken(Cypher6Parser.CSV, 0);
        }

        public TerminalNode FROM() {
            return getToken(Cypher6Parser.FROM, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public TerminalNode HEADERS() {
            return getToken(Cypher6Parser.HEADERS, 0);
        }

        public TerminalNode FIELDTERMINATOR() {
            return getToken(Cypher6Parser.FIELDTERMINATOR, 0);
        }

        public StringLiteralContext stringLiteral() {
            return getRuleContext(StringLiteralContext.class, 0);
        }

        public LoadCSVClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_loadCSVClause;
        }
    }

    public final LoadCSVClauseContext loadCSVClause() throws RecognitionException {
        LoadCSVClauseContext _localctx = new LoadCSVClauseContext(_ctx, getState());
        enterRule(_localctx, 74, RULE_loadCSVClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(971);
                match(LOAD);
                setState(972);
                match(CSV);
                setState(975);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WITH) {
                    {
                        setState(973);
                        match(WITH);
                        setState(974);
                        match(HEADERS);
                    }
                }

                setState(977);
                match(FROM);
                setState(978);
                expression();
                setState(979);
                match(AS);
                setState(980);
                variable();
                setState(983);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == FIELDTERMINATOR) {
                    {
                        setState(981);
                        match(FIELDTERMINATOR);
                        setState(982);
                        stringLiteral();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ForeachClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode FOREACH() {
            return getToken(Cypher6Parser.FOREACH, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode BAR() {
            return getToken(Cypher6Parser.BAR, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public List<ClauseContext> clause() {
            return getRuleContexts(ClauseContext.class);
        }

        public ClauseContext clause(int i) {
            return getRuleContext(ClauseContext.class, i);
        }

        public ForeachClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_foreachClause;
        }
    }

    public final ForeachClauseContext foreachClause() throws RecognitionException {
        ForeachClauseContext _localctx = new ForeachClauseContext(_ctx, getState());
        enterRule(_localctx, 76, RULE_foreachClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(985);
                match(FOREACH);
                setState(986);
                match(LPAREN);
                setState(987);
                variable();
                setState(988);
                match(IN);
                setState(989);
                expression();
                setState(990);
                match(BAR);
                setState(992);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(991);
                            clause();
                        }
                    }
                    setState(994);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (((((_la - 39)) & ~0x3f) == 0 && ((1L << (_la - 39)) & 35433742337L) != 0)
                        || ((((_la - 106)) & ~0x3f) == 0 && ((1L << (_la - 106)) & 1693247973883913L) != 0)
                        || ((((_la - 170)) & ~0x3f) == 0 && ((1L << (_la - 170)) & 36591746972389377L) != 0)
                        || ((((_la - 242)) & ~0x3f) == 0 && ((1L << (_la - 242)) & 2253174203219969L) != 0));
                setState(996);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SubqueryClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CALL() {
            return getToken(Cypher6Parser.CALL, 0);
        }

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public RegularQueryContext regularQuery() {
            return getRuleContext(RegularQueryContext.class, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public SubqueryScopeContext subqueryScope() {
            return getRuleContext(SubqueryScopeContext.class, 0);
        }

        public SubqueryInTransactionsParametersContext subqueryInTransactionsParameters() {
            return getRuleContext(SubqueryInTransactionsParametersContext.class, 0);
        }

        public SubqueryClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_subqueryClause;
        }
    }

    public final SubqueryClauseContext subqueryClause() throws RecognitionException {
        SubqueryClauseContext _localctx = new SubqueryClauseContext(_ctx, getState());
        enterRule(_localctx, 78, RULE_subqueryClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(998);
                match(CALL);
                setState(1000);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LPAREN) {
                    {
                        setState(999);
                        subqueryScope();
                    }
                }

                setState(1002);
                match(LCURLY);
                setState(1003);
                regularQuery();
                setState(1004);
                match(RCURLY);
                setState(1006);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IN) {
                    {
                        setState(1005);
                        subqueryInTransactionsParameters();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SubqueryScopeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public List<VariableContext> variable() {
            return getRuleContexts(VariableContext.class);
        }

        public VariableContext variable(int i) {
            return getRuleContext(VariableContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public SubqueryScopeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_subqueryScope;
        }
    }

    public final SubqueryScopeContext subqueryScope() throws RecognitionException {
        SubqueryScopeContext _localctx = new SubqueryScopeContext(_ctx, getState());
        enterRule(_localctx, 80, RULE_subqueryScope);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1008);
                match(LPAREN);
                setState(1018);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case TIMES:
                        {
                            setState(1009);
                            match(TIMES);
                        }
                        break;
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(1010);
                            variable();
                            setState(1015);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            while (_la == COMMA) {
                                {
                                    {
                                        setState(1011);
                                        match(COMMA);
                                        setState(1012);
                                        variable();
                                    }
                                }
                                setState(1017);
                                _errHandler.sync(this);
                                _la = _input.LA(1);
                            }
                        }
                        break;
                    case RPAREN:
                        break;
                    default:
                        break;
                }
                setState(1020);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SubqueryInTransactionsParametersContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public TerminalNode TRANSACTIONS() {
            return getToken(Cypher6Parser.TRANSACTIONS, 0);
        }

        public TerminalNode CONCURRENT() {
            return getToken(Cypher6Parser.CONCURRENT, 0);
        }

        public List<SubqueryInTransactionsBatchParametersContext> subqueryInTransactionsBatchParameters() {
            return getRuleContexts(SubqueryInTransactionsBatchParametersContext.class);
        }

        public SubqueryInTransactionsBatchParametersContext subqueryInTransactionsBatchParameters(int i) {
            return getRuleContext(SubqueryInTransactionsBatchParametersContext.class, i);
        }

        public List<SubqueryInTransactionsErrorParametersContext> subqueryInTransactionsErrorParameters() {
            return getRuleContexts(SubqueryInTransactionsErrorParametersContext.class);
        }

        public SubqueryInTransactionsErrorParametersContext subqueryInTransactionsErrorParameters(int i) {
            return getRuleContext(SubqueryInTransactionsErrorParametersContext.class, i);
        }

        public List<SubqueryInTransactionsReportParametersContext> subqueryInTransactionsReportParameters() {
            return getRuleContexts(SubqueryInTransactionsReportParametersContext.class);
        }

        public SubqueryInTransactionsReportParametersContext subqueryInTransactionsReportParameters(int i) {
            return getRuleContext(SubqueryInTransactionsReportParametersContext.class, i);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public SubqueryInTransactionsParametersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_subqueryInTransactionsParameters;
        }
    }

    public final SubqueryInTransactionsParametersContext subqueryInTransactionsParameters()
            throws RecognitionException {
        SubqueryInTransactionsParametersContext _localctx =
                new SubqueryInTransactionsParametersContext(_ctx, getState());
        enterRule(_localctx, 82, RULE_subqueryInTransactionsParameters);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1022);
                match(IN);
                setState(1027);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 54, _ctx)) {
                    case 1:
                        {
                            setState(1024);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 53, _ctx)) {
                                case 1:
                                    {
                                        setState(1023);
                                        expression();
                                    }
                                    break;
                            }
                            setState(1026);
                            match(CONCURRENT);
                        }
                        break;
                }
                setState(1029);
                match(TRANSACTIONS);
                setState(1035);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (((((_la - 179)) & ~0x3f) == 0 && ((1L << (_la - 179)) & 8796093022211L) != 0)) {
                    {
                        setState(1033);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case OF:
                                {
                                    setState(1030);
                                    subqueryInTransactionsBatchParameters();
                                }
                                break;
                            case ON:
                                {
                                    setState(1031);
                                    subqueryInTransactionsErrorParameters();
                                }
                                break;
                            case REPORT:
                                {
                                    setState(1032);
                                    subqueryInTransactionsReportParameters();
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    setState(1037);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SubqueryInTransactionsBatchParametersContext
            extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode OF() {
            return getToken(Cypher6Parser.OF, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode ROW() {
            return getToken(Cypher6Parser.ROW, 0);
        }

        public TerminalNode ROWS() {
            return getToken(Cypher6Parser.ROWS, 0);
        }

        public SubqueryInTransactionsBatchParametersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_subqueryInTransactionsBatchParameters;
        }
    }

    public final SubqueryInTransactionsBatchParametersContext subqueryInTransactionsBatchParameters()
            throws RecognitionException {
        SubqueryInTransactionsBatchParametersContext _localctx =
                new SubqueryInTransactionsBatchParametersContext(_ctx, getState());
        enterRule(_localctx, 84, RULE_subqueryInTransactionsBatchParameters);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1038);
                match(OF);
                setState(1039);
                expression();
                setState(1040);
                _la = _input.LA(1);
                if (!(_la == ROW || _la == ROWS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SubqueryInTransactionsErrorParametersContext
            extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public TerminalNode ERROR() {
            return getToken(Cypher6Parser.ERROR, 0);
        }

        public TerminalNode CONTINUE() {
            return getToken(Cypher6Parser.CONTINUE, 0);
        }

        public TerminalNode BREAK() {
            return getToken(Cypher6Parser.BREAK, 0);
        }

        public TerminalNode FAIL() {
            return getToken(Cypher6Parser.FAIL, 0);
        }

        public SubqueryInTransactionsErrorParametersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_subqueryInTransactionsErrorParameters;
        }
    }

    public final SubqueryInTransactionsErrorParametersContext subqueryInTransactionsErrorParameters()
            throws RecognitionException {
        SubqueryInTransactionsErrorParametersContext _localctx =
                new SubqueryInTransactionsErrorParametersContext(_ctx, getState());
        enterRule(_localctx, 86, RULE_subqueryInTransactionsErrorParameters);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1042);
                match(ON);
                setState(1043);
                match(ERROR);
                setState(1044);
                _la = _input.LA(1);
                if (!(_la == BREAK || _la == CONTINUE || _la == FAIL)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SubqueryInTransactionsReportParametersContext
            extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REPORT() {
            return getToken(Cypher6Parser.REPORT, 0);
        }

        public TerminalNode STATUS() {
            return getToken(Cypher6Parser.STATUS, 0);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public SubqueryInTransactionsReportParametersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_subqueryInTransactionsReportParameters;
        }
    }

    public final SubqueryInTransactionsReportParametersContext subqueryInTransactionsReportParameters()
            throws RecognitionException {
        SubqueryInTransactionsReportParametersContext _localctx =
                new SubqueryInTransactionsReportParametersContext(_ctx, getState());
        enterRule(_localctx, 88, RULE_subqueryInTransactionsReportParameters);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1046);
                match(REPORT);
                setState(1047);
                match(STATUS);
                setState(1048);
                match(AS);
                setState(1049);
                variable();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PatternListContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<PatternContext> pattern() {
            return getRuleContexts(PatternContext.class);
        }

        public PatternContext pattern(int i) {
            return getRuleContext(PatternContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public PatternListContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_patternList;
        }
    }

    public final PatternListContext patternList() throws RecognitionException {
        PatternListContext _localctx = new PatternListContext(_ctx, getState());
        enterRule(_localctx, 90, RULE_patternList);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1051);
                pattern();
                setState(1056);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(1052);
                            match(COMMA);
                            setState(1053);
                            pattern();
                        }
                    }
                    setState(1058);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertPatternListContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<InsertPatternContext> insertPattern() {
            return getRuleContexts(InsertPatternContext.class);
        }

        public InsertPatternContext insertPattern(int i) {
            return getRuleContext(InsertPatternContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public InsertPatternListContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertPatternList;
        }
    }

    public final InsertPatternListContext insertPatternList() throws RecognitionException {
        InsertPatternListContext _localctx = new InsertPatternListContext(_ctx, getState());
        enterRule(_localctx, 92, RULE_insertPatternList);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1059);
                insertPattern();
                setState(1064);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(1060);
                            match(COMMA);
                            setState(1061);
                            insertPattern();
                        }
                    }
                    setState(1066);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public AnonymousPatternContext anonymousPattern() {
            return getRuleContext(AnonymousPatternContext.class, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public SelectorContext selector() {
            return getRuleContext(SelectorContext.class, 0);
        }

        public PatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_pattern;
        }
    }

    public final PatternContext pattern() throws RecognitionException {
        PatternContext _localctx = new PatternContext(_ctx, getState());
        enterRule(_localctx, 94, RULE_pattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1070);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 59, _ctx)) {
                    case 1:
                        {
                            setState(1067);
                            variable();
                            setState(1068);
                            match(EQ);
                        }
                        break;
                }
                setState(1073);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ALL || _la == ANY || _la == SHORTEST) {
                    {
                        setState(1072);
                        selector();
                    }
                }

                setState(1075);
                anonymousPattern();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<InsertNodePatternContext> insertNodePattern() {
            return getRuleContexts(InsertNodePatternContext.class);
        }

        public InsertNodePatternContext insertNodePattern(int i) {
            return getRuleContext(InsertNodePatternContext.class, i);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public List<InsertRelationshipPatternContext> insertRelationshipPattern() {
            return getRuleContexts(InsertRelationshipPatternContext.class);
        }

        public InsertRelationshipPatternContext insertRelationshipPattern(int i) {
            return getRuleContext(InsertRelationshipPatternContext.class, i);
        }

        public InsertPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertPattern;
        }
    }

    public final InsertPatternContext insertPattern() throws RecognitionException {
        InsertPatternContext _localctx = new InsertPatternContext(_ctx, getState());
        enterRule(_localctx, 96, RULE_insertPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1080);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839182848L) != 0)
                        || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239987713L) != 0)
                        || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -8078356481L) != 0)
                        || ((((_la - 194)) & ~0x3f) == 0 && ((1L << (_la - 194)) & -35321813245957L) != 0)
                        || ((((_la - 258)) & ~0x3f) == 0 && ((1L << (_la - 258)) & 8796093022175L) != 0)) {
                    {
                        setState(1077);
                        symbolicNameString();
                        setState(1078);
                        match(EQ);
                    }
                }

                setState(1082);
                insertNodePattern();
                setState(1088);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == LT || _la == MINUS || _la == ARROW_LINE || _la == ARROW_LEFT_HEAD) {
                    {
                        {
                            setState(1083);
                            insertRelationshipPattern();
                            setState(1084);
                            insertNodePattern();
                        }
                    }
                    setState(1090);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class QuantifierContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Token from;
        public Token to;

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public List<TerminalNode> UNSIGNED_DECIMAL_INTEGER() {
            return getTokens(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER(int i) {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, i);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public TerminalNode COMMA() {
            return getToken(Cypher6Parser.COMMA, 0);
        }

        public TerminalNode PLUS() {
            return getToken(Cypher6Parser.PLUS, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public QuantifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_quantifier;
        }
    }

    public final QuantifierContext quantifier() throws RecognitionException {
        QuantifierContext _localctx = new QuantifierContext(_ctx, getState());
        enterRule(_localctx, 98, RULE_quantifier);
        int _la;
        try {
            setState(1105);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 65, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1091);
                        match(LCURLY);
                        setState(1092);
                        match(UNSIGNED_DECIMAL_INTEGER);
                        setState(1093);
                        match(RCURLY);
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1094);
                        match(LCURLY);
                        setState(1096);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == UNSIGNED_DECIMAL_INTEGER) {
                            {
                                setState(1095);
                                ((QuantifierContext) _localctx).from = match(UNSIGNED_DECIMAL_INTEGER);
                            }
                        }

                        setState(1098);
                        match(COMMA);
                        setState(1100);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == UNSIGNED_DECIMAL_INTEGER) {
                            {
                                setState(1099);
                                ((QuantifierContext) _localctx).to = match(UNSIGNED_DECIMAL_INTEGER);
                            }
                        }

                        setState(1102);
                        match(RCURLY);
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1103);
                        match(PLUS);
                    }
                    break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1104);
                        match(TIMES);
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AnonymousPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ShortestPathPatternContext shortestPathPattern() {
            return getRuleContext(ShortestPathPatternContext.class, 0);
        }

        public PatternElementContext patternElement() {
            return getRuleContext(PatternElementContext.class, 0);
        }

        public AnonymousPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_anonymousPattern;
        }
    }

    public final AnonymousPatternContext anonymousPattern() throws RecognitionException {
        AnonymousPatternContext _localctx = new AnonymousPatternContext(_ctx, getState());
        enterRule(_localctx, 100, RULE_anonymousPattern);
        try {
            setState(1109);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case ALL_SHORTEST_PATHS:
                case SHORTEST_PATH:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1107);
                        shortestPathPattern();
                    }
                    break;
                case LPAREN:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1108);
                        patternElement();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShortestPathPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public PatternElementContext patternElement() {
            return getRuleContext(PatternElementContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode SHORTEST_PATH() {
            return getToken(Cypher6Parser.SHORTEST_PATH, 0);
        }

        public TerminalNode ALL_SHORTEST_PATHS() {
            return getToken(Cypher6Parser.ALL_SHORTEST_PATHS, 0);
        }

        public ShortestPathPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_shortestPathPattern;
        }
    }

    public final ShortestPathPatternContext shortestPathPattern() throws RecognitionException {
        ShortestPathPatternContext _localctx = new ShortestPathPatternContext(_ctx, getState());
        enterRule(_localctx, 102, RULE_shortestPathPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1111);
                _la = _input.LA(1);
                if (!(_la == ALL_SHORTEST_PATHS || _la == SHORTEST_PATH)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(1112);
                match(LPAREN);
                setState(1113);
                patternElement();
                setState(1114);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PatternElementContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<NodePatternContext> nodePattern() {
            return getRuleContexts(NodePatternContext.class);
        }

        public NodePatternContext nodePattern(int i) {
            return getRuleContext(NodePatternContext.class, i);
        }

        public List<ParenthesizedPathContext> parenthesizedPath() {
            return getRuleContexts(ParenthesizedPathContext.class);
        }

        public ParenthesizedPathContext parenthesizedPath(int i) {
            return getRuleContext(ParenthesizedPathContext.class, i);
        }

        public List<RelationshipPatternContext> relationshipPattern() {
            return getRuleContexts(RelationshipPatternContext.class);
        }

        public RelationshipPatternContext relationshipPattern(int i) {
            return getRuleContext(RelationshipPatternContext.class, i);
        }

        public List<QuantifierContext> quantifier() {
            return getRuleContexts(QuantifierContext.class);
        }

        public QuantifierContext quantifier(int i) {
            return getRuleContext(QuantifierContext.class, i);
        }

        public PatternElementContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_patternElement;
        }
    }

    public final PatternElementContext patternElement() throws RecognitionException {
        PatternElementContext _localctx = new PatternElementContext(_ctx, getState());
        enterRule(_localctx, 104, RULE_patternElement);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1129);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        setState(1129);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 69, _ctx)) {
                            case 1:
                                {
                                    setState(1116);
                                    nodePattern();
                                    setState(1125);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    while (_la == LT || _la == MINUS || _la == ARROW_LINE || _la == ARROW_LEFT_HEAD) {
                                        {
                                            {
                                                setState(1117);
                                                relationshipPattern();
                                                setState(1119);
                                                _errHandler.sync(this);
                                                _la = _input.LA(1);
                                                if (_la == LCURLY || _la == PLUS || _la == TIMES) {
                                                    {
                                                        setState(1118);
                                                        quantifier();
                                                    }
                                                }

                                                setState(1121);
                                                nodePattern();
                                            }
                                        }
                                        setState(1127);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                    }
                                }
                                break;
                            case 2:
                                {
                                    setState(1128);
                                    parenthesizedPath();
                                }
                                break;
                        }
                    }
                    setState(1131);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == LPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SelectorContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SelectorContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_selector;
        }

        public SelectorContext() {}

        public void copyFrom(SelectorContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AllShortestPathContext extends SelectorContext {
        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode SHORTEST() {
            return getToken(Cypher6Parser.SHORTEST, 0);
        }

        public PathTokenContext pathToken() {
            return getRuleContext(PathTokenContext.class, 0);
        }

        public AllShortestPathContext(SelectorContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AnyPathContext extends SelectorContext {
        public TerminalNode ANY() {
            return getToken(Cypher6Parser.ANY, 0);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, 0);
        }

        public PathTokenContext pathToken() {
            return getRuleContext(PathTokenContext.class, 0);
        }

        public AnyPathContext(SelectorContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShortestGroupContext extends SelectorContext {
        public TerminalNode SHORTEST() {
            return getToken(Cypher6Parser.SHORTEST, 0);
        }

        public GroupTokenContext groupToken() {
            return getRuleContext(GroupTokenContext.class, 0);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, 0);
        }

        public PathTokenContext pathToken() {
            return getRuleContext(PathTokenContext.class, 0);
        }

        public ShortestGroupContext(SelectorContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AnyShortestPathContext extends SelectorContext {
        public TerminalNode ANY() {
            return getToken(Cypher6Parser.ANY, 0);
        }

        public TerminalNode SHORTEST() {
            return getToken(Cypher6Parser.SHORTEST, 0);
        }

        public PathTokenContext pathToken() {
            return getRuleContext(PathTokenContext.class, 0);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, 0);
        }

        public AnyShortestPathContext(SelectorContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AllPathContext extends SelectorContext {
        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public PathTokenContext pathToken() {
            return getRuleContext(PathTokenContext.class, 0);
        }

        public AllPathContext(SelectorContext ctx) {
            copyFrom(ctx);
        }
    }

    public final SelectorContext selector() throws RecognitionException {
        SelectorContext _localctx = new SelectorContext(_ctx, getState());
        enterRule(_localctx, 106, RULE_selector);
        int _la;
        try {
            setState(1167);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 79, _ctx)) {
                case 1:
                    _localctx = new AnyShortestPathContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1133);
                        match(ANY);
                        setState(1134);
                        match(SHORTEST);
                        setState(1136);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == PATH || _la == PATHS) {
                            {
                                setState(1135);
                                pathToken();
                            }
                        }
                    }
                    break;
                case 2:
                    _localctx = new AllShortestPathContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1138);
                        match(ALL);
                        setState(1139);
                        match(SHORTEST);
                        setState(1141);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == PATH || _la == PATHS) {
                            {
                                setState(1140);
                                pathToken();
                            }
                        }
                    }
                    break;
                case 3:
                    _localctx = new AnyPathContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1143);
                        match(ANY);
                        setState(1145);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == UNSIGNED_DECIMAL_INTEGER) {
                            {
                                setState(1144);
                                match(UNSIGNED_DECIMAL_INTEGER);
                            }
                        }

                        setState(1148);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == PATH || _la == PATHS) {
                            {
                                setState(1147);
                                pathToken();
                            }
                        }
                    }
                    break;
                case 4:
                    _localctx = new AllPathContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1150);
                        match(ALL);
                        setState(1152);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == PATH || _la == PATHS) {
                            {
                                setState(1151);
                                pathToken();
                            }
                        }
                    }
                    break;
                case 5:
                    _localctx = new ShortestGroupContext(_localctx);
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(1154);
                        match(SHORTEST);
                        setState(1156);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == UNSIGNED_DECIMAL_INTEGER) {
                            {
                                setState(1155);
                                match(UNSIGNED_DECIMAL_INTEGER);
                            }
                        }

                        setState(1159);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == PATH || _la == PATHS) {
                            {
                                setState(1158);
                                pathToken();
                            }
                        }

                        setState(1161);
                        groupToken();
                    }
                    break;
                case 6:
                    _localctx = new AnyShortestPathContext(_localctx);
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(1162);
                        match(SHORTEST);
                        setState(1163);
                        match(UNSIGNED_DECIMAL_INTEGER);
                        setState(1165);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == PATH || _la == PATHS) {
                            {
                                setState(1164);
                                pathToken();
                            }
                        }
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GroupTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode GROUP() {
            return getToken(Cypher6Parser.GROUP, 0);
        }

        public TerminalNode GROUPS() {
            return getToken(Cypher6Parser.GROUPS, 0);
        }

        public GroupTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_groupToken;
        }
    }

    public final GroupTokenContext groupToken() throws RecognitionException {
        GroupTokenContext _localctx = new GroupTokenContext(_ctx, getState());
        enterRule(_localctx, 108, RULE_groupToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1169);
                _la = _input.LA(1);
                if (!(_la == GROUP || _la == GROUPS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PathTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PATH() {
            return getToken(Cypher6Parser.PATH, 0);
        }

        public TerminalNode PATHS() {
            return getToken(Cypher6Parser.PATHS, 0);
        }

        public PathTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_pathToken;
        }
    }

    public final PathTokenContext pathToken() throws RecognitionException {
        PathTokenContext _localctx = new PathTokenContext(_ctx, getState());
        enterRule(_localctx, 110, RULE_pathToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1171);
                _la = _input.LA(1);
                if (!(_la == PATH || _la == PATHS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PathPatternNonEmptyContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<NodePatternContext> nodePattern() {
            return getRuleContexts(NodePatternContext.class);
        }

        public NodePatternContext nodePattern(int i) {
            return getRuleContext(NodePatternContext.class, i);
        }

        public List<RelationshipPatternContext> relationshipPattern() {
            return getRuleContexts(RelationshipPatternContext.class);
        }

        public RelationshipPatternContext relationshipPattern(int i) {
            return getRuleContext(RelationshipPatternContext.class, i);
        }

        public PathPatternNonEmptyContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_pathPatternNonEmpty;
        }
    }

    public final PathPatternNonEmptyContext pathPatternNonEmpty() throws RecognitionException {
        PathPatternNonEmptyContext _localctx = new PathPatternNonEmptyContext(_ctx, getState());
        enterRule(_localctx, 112, RULE_pathPatternNonEmpty);
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1173);
                nodePattern();
                setState(1177);
                _errHandler.sync(this);
                _alt = 1;
                do {
                    switch (_alt) {
                        case 1:
                            {
                                {
                                    setState(1174);
                                    relationshipPattern();
                                    setState(1175);
                                    nodePattern();
                                }
                            }
                            break;
                        default:
                            throw new NoViableAltException(this);
                    }
                    setState(1179);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 80, _ctx);
                } while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NodePatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public LabelExpressionContext labelExpression() {
            return getRuleContext(LabelExpressionContext.class, 0);
        }

        public PropertiesContext properties() {
            return getRuleContext(PropertiesContext.class, 0);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public NodePatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_nodePattern;
        }
    }

    public final NodePatternContext nodePattern() throws RecognitionException {
        NodePatternContext _localctx = new NodePatternContext(_ctx, getState());
        enterRule(_localctx, 114, RULE_nodePattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1181);
                match(LPAREN);
                setState(1183);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 81, _ctx)) {
                    case 1:
                        {
                            setState(1182);
                            variable();
                        }
                        break;
                }
                setState(1186);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == COLON || _la == IS) {
                    {
                        setState(1185);
                        labelExpression();
                    }
                }

                setState(1189);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == DOLLAR || _la == LCURLY) {
                    {
                        setState(1188);
                        properties();
                    }
                }

                setState(1193);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(1191);
                        match(WHERE);
                        setState(1192);
                        expression();
                    }
                }

                setState(1195);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertNodePatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public InsertNodeLabelExpressionContext insertNodeLabelExpression() {
            return getRuleContext(InsertNodeLabelExpressionContext.class, 0);
        }

        public MapContext map() {
            return getRuleContext(MapContext.class, 0);
        }

        public InsertNodePatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertNodePattern;
        }
    }

    public final InsertNodePatternContext insertNodePattern() throws RecognitionException {
        InsertNodePatternContext _localctx = new InsertNodePatternContext(_ctx, getState());
        enterRule(_localctx, 116, RULE_insertNodePattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1197);
                match(LPAREN);
                setState(1199);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 85, _ctx)) {
                    case 1:
                        {
                            setState(1198);
                            variable();
                        }
                        break;
                }
                setState(1202);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == COLON || _la == IS) {
                    {
                        setState(1201);
                        insertNodeLabelExpression();
                    }
                }

                setState(1205);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LCURLY) {
                    {
                        setState(1204);
                        map();
                    }
                }

                setState(1207);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ParenthesizedPathContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public PatternContext pattern() {
            return getRuleContext(PatternContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public QuantifierContext quantifier() {
            return getRuleContext(QuantifierContext.class, 0);
        }

        public ParenthesizedPathContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_parenthesizedPath;
        }
    }

    public final ParenthesizedPathContext parenthesizedPath() throws RecognitionException {
        ParenthesizedPathContext _localctx = new ParenthesizedPathContext(_ctx, getState());
        enterRule(_localctx, 118, RULE_parenthesizedPath);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1209);
                match(LPAREN);
                setState(1210);
                pattern();
                setState(1213);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(1211);
                        match(WHERE);
                        setState(1212);
                        expression();
                    }
                }

                setState(1215);
                match(RPAREN);
                setState(1217);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LCURLY || _la == PLUS || _la == TIMES) {
                    {
                        setState(1216);
                        quantifier();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NodeLabelsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<LabelTypeContext> labelType() {
            return getRuleContexts(LabelTypeContext.class);
        }

        public LabelTypeContext labelType(int i) {
            return getRuleContext(LabelTypeContext.class, i);
        }

        public List<DynamicLabelTypeContext> dynamicLabelType() {
            return getRuleContexts(DynamicLabelTypeContext.class);
        }

        public DynamicLabelTypeContext dynamicLabelType(int i) {
            return getRuleContext(DynamicLabelTypeContext.class, i);
        }

        public NodeLabelsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_nodeLabels;
        }
    }

    public final NodeLabelsContext nodeLabels() throws RecognitionException {
        NodeLabelsContext _localctx = new NodeLabelsContext(_ctx, getState());
        enterRule(_localctx, 120, RULE_nodeLabels);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1221);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        setState(1221);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 90, _ctx)) {
                            case 1:
                                {
                                    setState(1219);
                                    labelType();
                                }
                                break;
                            case 2:
                                {
                                    setState(1220);
                                    dynamicLabelType();
                                }
                                break;
                        }
                    }
                    setState(1223);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == COLON);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NodeLabelsIsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public DynamicExpressionContext dynamicExpression() {
            return getRuleContext(DynamicExpressionContext.class, 0);
        }

        public List<LabelTypeContext> labelType() {
            return getRuleContexts(LabelTypeContext.class);
        }

        public LabelTypeContext labelType(int i) {
            return getRuleContext(LabelTypeContext.class, i);
        }

        public List<DynamicLabelTypeContext> dynamicLabelType() {
            return getRuleContexts(DynamicLabelTypeContext.class);
        }

        public DynamicLabelTypeContext dynamicLabelType(int i) {
            return getRuleContext(DynamicLabelTypeContext.class, i);
        }

        public NodeLabelsIsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_nodeLabelsIs;
        }
    }

    public final NodeLabelsIsContext nodeLabelsIs() throws RecognitionException {
        NodeLabelsIsContext _localctx = new NodeLabelsIsContext(_ctx, getState());
        enterRule(_localctx, 122, RULE_nodeLabelsIs);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1225);
                match(IS);
                setState(1228);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(1226);
                            symbolicNameString();
                        }
                        break;
                    case DOLLAR:
                        {
                            setState(1227);
                            dynamicExpression();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(1234);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COLON) {
                    {
                        setState(1232);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 93, _ctx)) {
                            case 1:
                                {
                                    setState(1230);
                                    labelType();
                                }
                                break;
                            case 2:
                                {
                                    setState(1231);
                                    dynamicLabelType();
                                }
                                break;
                        }
                    }
                    setState(1236);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DynamicExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DOLLAR() {
            return getToken(Cypher6Parser.DOLLAR, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public DynamicExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dynamicExpression;
        }
    }

    public final DynamicExpressionContext dynamicExpression() throws RecognitionException {
        DynamicExpressionContext _localctx = new DynamicExpressionContext(_ctx, getState());
        enterRule(_localctx, 124, RULE_dynamicExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1237);
                match(DOLLAR);
                setState(1238);
                match(LPAREN);
                setState(1239);
                expression();
                setState(1240);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DynamicLabelTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public DynamicExpressionContext dynamicExpression() {
            return getRuleContext(DynamicExpressionContext.class, 0);
        }

        public DynamicLabelTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dynamicLabelType;
        }
    }

    public final DynamicLabelTypeContext dynamicLabelType() throws RecognitionException {
        DynamicLabelTypeContext _localctx = new DynamicLabelTypeContext(_ctx, getState());
        enterRule(_localctx, 126, RULE_dynamicLabelType);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1242);
                match(COLON);
                setState(1243);
                dynamicExpression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public LabelTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelType;
        }
    }

    public final LabelTypeContext labelType() throws RecognitionException {
        LabelTypeContext _localctx = new LabelTypeContext(_ctx, getState());
        enterRule(_localctx, 128, RULE_labelType);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1245);
                match(COLON);
                setState(1246);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RelTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public RelTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_relType;
        }
    }

    public final RelTypeContext relType() throws RecognitionException {
        RelTypeContext _localctx = new RelTypeContext(_ctx, getState());
        enterRule(_localctx, 130, RULE_relType);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1248);
                match(COLON);
                setState(1249);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelOrRelTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public LabelOrRelTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelOrRelType;
        }
    }

    public final LabelOrRelTypeContext labelOrRelType() throws RecognitionException {
        LabelOrRelTypeContext _localctx = new LabelOrRelTypeContext(_ctx, getState());
        enterRule(_localctx, 132, RULE_labelOrRelType);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1251);
                match(COLON);
                setState(1252);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertiesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public MapContext map() {
            return getRuleContext(MapContext.class, 0);
        }

        public ParameterContext parameter() {
            return getRuleContext(ParameterContext.class, 0);
        }

        public PropertiesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_properties;
        }
    }

    public final PropertiesContext properties() throws RecognitionException {
        PropertiesContext _localctx = new PropertiesContext(_ctx, getState());
        enterRule(_localctx, 134, RULE_properties);
        try {
            setState(1256);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case LCURLY:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1254);
                        map();
                    }
                    break;
                case DOLLAR:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1255);
                        parameter("ANY");
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RelationshipPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<ArrowLineContext> arrowLine() {
            return getRuleContexts(ArrowLineContext.class);
        }

        public ArrowLineContext arrowLine(int i) {
            return getRuleContext(ArrowLineContext.class, i);
        }

        public LeftArrowContext leftArrow() {
            return getRuleContext(LeftArrowContext.class, 0);
        }

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public RightArrowContext rightArrow() {
            return getRuleContext(RightArrowContext.class, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public LabelExpressionContext labelExpression() {
            return getRuleContext(LabelExpressionContext.class, 0);
        }

        public PathLengthContext pathLength() {
            return getRuleContext(PathLengthContext.class, 0);
        }

        public PropertiesContext properties() {
            return getRuleContext(PropertiesContext.class, 0);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public RelationshipPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_relationshipPattern;
        }
    }

    public final RelationshipPatternContext relationshipPattern() throws RecognitionException {
        RelationshipPatternContext _localctx = new RelationshipPatternContext(_ctx, getState());
        enterRule(_localctx, 136, RULE_relationshipPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1259);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LT || _la == ARROW_LEFT_HEAD) {
                    {
                        setState(1258);
                        leftArrow();
                    }
                }

                setState(1261);
                arrowLine();
                setState(1280);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LBRACKET) {
                    {
                        setState(1262);
                        match(LBRACKET);
                        setState(1264);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 97, _ctx)) {
                            case 1:
                                {
                                    setState(1263);
                                    variable();
                                }
                                break;
                        }
                        setState(1267);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == COLON || _la == IS) {
                            {
                                setState(1266);
                                labelExpression();
                            }
                        }

                        setState(1270);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == TIMES) {
                            {
                                setState(1269);
                                pathLength();
                            }
                        }

                        setState(1273);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == DOLLAR || _la == LCURLY) {
                            {
                                setState(1272);
                                properties();
                            }
                        }

                        setState(1277);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == WHERE) {
                            {
                                setState(1275);
                                match(WHERE);
                                setState(1276);
                                expression();
                            }
                        }

                        setState(1279);
                        match(RBRACKET);
                    }
                }

                setState(1282);
                arrowLine();
                setState(1284);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == GT || _la == ARROW_RIGHT_HEAD) {
                    {
                        setState(1283);
                        rightArrow();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertRelationshipPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<ArrowLineContext> arrowLine() {
            return getRuleContexts(ArrowLineContext.class);
        }

        public ArrowLineContext arrowLine(int i) {
            return getRuleContext(ArrowLineContext.class, i);
        }

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public InsertRelationshipLabelExpressionContext insertRelationshipLabelExpression() {
            return getRuleContext(InsertRelationshipLabelExpressionContext.class, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public LeftArrowContext leftArrow() {
            return getRuleContext(LeftArrowContext.class, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public MapContext map() {
            return getRuleContext(MapContext.class, 0);
        }

        public RightArrowContext rightArrow() {
            return getRuleContext(RightArrowContext.class, 0);
        }

        public InsertRelationshipPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertRelationshipPattern;
        }
    }

    public final InsertRelationshipPatternContext insertRelationshipPattern() throws RecognitionException {
        InsertRelationshipPatternContext _localctx = new InsertRelationshipPatternContext(_ctx, getState());
        enterRule(_localctx, 138, RULE_insertRelationshipPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1287);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LT || _la == ARROW_LEFT_HEAD) {
                    {
                        setState(1286);
                        leftArrow();
                    }
                }

                setState(1289);
                arrowLine();
                setState(1290);
                match(LBRACKET);
                setState(1292);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 105, _ctx)) {
                    case 1:
                        {
                            setState(1291);
                            variable();
                        }
                        break;
                }
                setState(1294);
                insertRelationshipLabelExpression();
                setState(1296);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LCURLY) {
                    {
                        setState(1295);
                        map();
                    }
                }

                setState(1298);
                match(RBRACKET);
                setState(1299);
                arrowLine();
                setState(1301);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == GT || _la == ARROW_RIGHT_HEAD) {
                    {
                        setState(1300);
                        rightArrow();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LeftArrowContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LT() {
            return getToken(Cypher6Parser.LT, 0);
        }

        public TerminalNode ARROW_LEFT_HEAD() {
            return getToken(Cypher6Parser.ARROW_LEFT_HEAD, 0);
        }

        public LeftArrowContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_leftArrow;
        }
    }

    public final LeftArrowContext leftArrow() throws RecognitionException {
        LeftArrowContext _localctx = new LeftArrowContext(_ctx, getState());
        enterRule(_localctx, 140, RULE_leftArrow);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1303);
                _la = _input.LA(1);
                if (!(_la == LT || _la == ARROW_LEFT_HEAD)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ArrowLineContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ARROW_LINE() {
            return getToken(Cypher6Parser.ARROW_LINE, 0);
        }

        public TerminalNode MINUS() {
            return getToken(Cypher6Parser.MINUS, 0);
        }

        public ArrowLineContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_arrowLine;
        }
    }

    public final ArrowLineContext arrowLine() throws RecognitionException {
        ArrowLineContext _localctx = new ArrowLineContext(_ctx, getState());
        enterRule(_localctx, 142, RULE_arrowLine);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1305);
                _la = _input.LA(1);
                if (!(_la == MINUS || _la == ARROW_LINE)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RightArrowContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode GT() {
            return getToken(Cypher6Parser.GT, 0);
        }

        public TerminalNode ARROW_RIGHT_HEAD() {
            return getToken(Cypher6Parser.ARROW_RIGHT_HEAD, 0);
        }

        public RightArrowContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_rightArrow;
        }
    }

    public final RightArrowContext rightArrow() throws RecognitionException {
        RightArrowContext _localctx = new RightArrowContext(_ctx, getState());
        enterRule(_localctx, 144, RULE_rightArrow);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1307);
                _la = _input.LA(1);
                if (!(_la == GT || _la == ARROW_RIGHT_HEAD)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PathLengthContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Token from;
        public Token to;
        public Token single;

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public TerminalNode DOTDOT() {
            return getToken(Cypher6Parser.DOTDOT, 0);
        }

        public List<TerminalNode> UNSIGNED_DECIMAL_INTEGER() {
            return getTokens(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER(int i) {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, i);
        }

        public PathLengthContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_pathLength;
        }
    }

    public final PathLengthContext pathLength() throws RecognitionException {
        PathLengthContext _localctx = new PathLengthContext(_ctx, getState());
        enterRule(_localctx, 146, RULE_pathLength);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1309);
                match(TIMES);
                setState(1318);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 110, _ctx)) {
                    case 1:
                        {
                            setState(1311);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == UNSIGNED_DECIMAL_INTEGER) {
                                {
                                    setState(1310);
                                    ((PathLengthContext) _localctx).from = match(UNSIGNED_DECIMAL_INTEGER);
                                }
                            }

                            setState(1313);
                            match(DOTDOT);
                            setState(1315);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == UNSIGNED_DECIMAL_INTEGER) {
                                {
                                    setState(1314);
                                    ((PathLengthContext) _localctx).to = match(UNSIGNED_DECIMAL_INTEGER);
                                }
                            }
                        }
                        break;
                    case 2:
                        {
                            setState(1317);
                            ((PathLengthContext) _localctx).single = match(UNSIGNED_DECIMAL_INTEGER);
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public LabelExpression4Context labelExpression4() {
            return getRuleContext(LabelExpression4Context.class, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public LabelExpression4IsContext labelExpression4Is() {
            return getRuleContext(LabelExpression4IsContext.class, 0);
        }

        public LabelExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression;
        }
    }

    public final LabelExpressionContext labelExpression() throws RecognitionException {
        LabelExpressionContext _localctx = new LabelExpressionContext(_ctx, getState());
        enterRule(_localctx, 148, RULE_labelExpression);
        try {
            setState(1324);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case COLON:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1320);
                        match(COLON);
                        setState(1321);
                        labelExpression4();
                    }
                    break;
                case IS:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1322);
                        match(IS);
                        setState(1323);
                        labelExpression4Is();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression4Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<LabelExpression3Context> labelExpression3() {
            return getRuleContexts(LabelExpression3Context.class);
        }

        public LabelExpression3Context labelExpression3(int i) {
            return getRuleContext(LabelExpression3Context.class, i);
        }

        public List<TerminalNode> BAR() {
            return getTokens(Cypher6Parser.BAR);
        }

        public TerminalNode BAR(int i) {
            return getToken(Cypher6Parser.BAR, i);
        }

        public List<TerminalNode> COLON() {
            return getTokens(Cypher6Parser.COLON);
        }

        public TerminalNode COLON(int i) {
            return getToken(Cypher6Parser.COLON, i);
        }

        public LabelExpression4Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression4;
        }
    }

    public final LabelExpression4Context labelExpression4() throws RecognitionException {
        LabelExpression4Context _localctx = new LabelExpression4Context(_ctx, getState());
        enterRule(_localctx, 150, RULE_labelExpression4);
        int _la;
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1326);
                labelExpression3();
                setState(1334);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 113, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1327);
                                match(BAR);
                                setState(1329);
                                _errHandler.sync(this);
                                _la = _input.LA(1);
                                if (_la == COLON) {
                                    {
                                        setState(1328);
                                        match(COLON);
                                    }
                                }

                                setState(1331);
                                labelExpression3();
                            }
                        }
                    }
                    setState(1336);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 113, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression4IsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<LabelExpression3IsContext> labelExpression3Is() {
            return getRuleContexts(LabelExpression3IsContext.class);
        }

        public LabelExpression3IsContext labelExpression3Is(int i) {
            return getRuleContext(LabelExpression3IsContext.class, i);
        }

        public List<TerminalNode> BAR() {
            return getTokens(Cypher6Parser.BAR);
        }

        public TerminalNode BAR(int i) {
            return getToken(Cypher6Parser.BAR, i);
        }

        public List<TerminalNode> COLON() {
            return getTokens(Cypher6Parser.COLON);
        }

        public TerminalNode COLON(int i) {
            return getToken(Cypher6Parser.COLON, i);
        }

        public LabelExpression4IsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression4Is;
        }
    }

    public final LabelExpression4IsContext labelExpression4Is() throws RecognitionException {
        LabelExpression4IsContext _localctx = new LabelExpression4IsContext(_ctx, getState());
        enterRule(_localctx, 152, RULE_labelExpression4Is);
        int _la;
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1337);
                labelExpression3Is();
                setState(1345);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 115, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1338);
                                match(BAR);
                                setState(1340);
                                _errHandler.sync(this);
                                _la = _input.LA(1);
                                if (_la == COLON) {
                                    {
                                        setState(1339);
                                        match(COLON);
                                    }
                                }

                                setState(1342);
                                labelExpression3Is();
                            }
                        }
                    }
                    setState(1347);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 115, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression3Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<LabelExpression2Context> labelExpression2() {
            return getRuleContexts(LabelExpression2Context.class);
        }

        public LabelExpression2Context labelExpression2(int i) {
            return getRuleContext(LabelExpression2Context.class, i);
        }

        public List<TerminalNode> AMPERSAND() {
            return getTokens(Cypher6Parser.AMPERSAND);
        }

        public TerminalNode AMPERSAND(int i) {
            return getToken(Cypher6Parser.AMPERSAND, i);
        }

        public List<TerminalNode> COLON() {
            return getTokens(Cypher6Parser.COLON);
        }

        public TerminalNode COLON(int i) {
            return getToken(Cypher6Parser.COLON, i);
        }

        public LabelExpression3Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression3;
        }
    }

    public final LabelExpression3Context labelExpression3() throws RecognitionException {
        LabelExpression3Context _localctx = new LabelExpression3Context(_ctx, getState());
        enterRule(_localctx, 154, RULE_labelExpression3);
        int _la;
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1348);
                labelExpression2();
                setState(1353);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 116, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1349);
                                _la = _input.LA(1);
                                if (!(_la == COLON || _la == AMPERSAND)) {
                                    _errHandler.recoverInline(this);
                                } else {
                                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                    _errHandler.reportMatch(this);
                                    consume();
                                }
                                setState(1350);
                                labelExpression2();
                            }
                        }
                    }
                    setState(1355);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 116, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression3IsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<LabelExpression2IsContext> labelExpression2Is() {
            return getRuleContexts(LabelExpression2IsContext.class);
        }

        public LabelExpression2IsContext labelExpression2Is(int i) {
            return getRuleContext(LabelExpression2IsContext.class, i);
        }

        public List<TerminalNode> AMPERSAND() {
            return getTokens(Cypher6Parser.AMPERSAND);
        }

        public TerminalNode AMPERSAND(int i) {
            return getToken(Cypher6Parser.AMPERSAND, i);
        }

        public List<TerminalNode> COLON() {
            return getTokens(Cypher6Parser.COLON);
        }

        public TerminalNode COLON(int i) {
            return getToken(Cypher6Parser.COLON, i);
        }

        public LabelExpression3IsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression3Is;
        }
    }

    public final LabelExpression3IsContext labelExpression3Is() throws RecognitionException {
        LabelExpression3IsContext _localctx = new LabelExpression3IsContext(_ctx, getState());
        enterRule(_localctx, 156, RULE_labelExpression3Is);
        int _la;
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1356);
                labelExpression2Is();
                setState(1361);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 117, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1357);
                                _la = _input.LA(1);
                                if (!(_la == COLON || _la == AMPERSAND)) {
                                    _errHandler.recoverInline(this);
                                } else {
                                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                    _errHandler.reportMatch(this);
                                    consume();
                                }
                                setState(1358);
                                labelExpression2Is();
                            }
                        }
                    }
                    setState(1363);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 117, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression2Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public LabelExpression1Context labelExpression1() {
            return getRuleContext(LabelExpression1Context.class, 0);
        }

        public List<TerminalNode> EXCLAMATION_MARK() {
            return getTokens(Cypher6Parser.EXCLAMATION_MARK);
        }

        public TerminalNode EXCLAMATION_MARK(int i) {
            return getToken(Cypher6Parser.EXCLAMATION_MARK, i);
        }

        public LabelExpression2Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression2;
        }
    }

    public final LabelExpression2Context labelExpression2() throws RecognitionException {
        LabelExpression2Context _localctx = new LabelExpression2Context(_ctx, getState());
        enterRule(_localctx, 158, RULE_labelExpression2);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1367);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == EXCLAMATION_MARK) {
                    {
                        {
                            setState(1364);
                            match(EXCLAMATION_MARK);
                        }
                    }
                    setState(1369);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(1370);
                labelExpression1();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression2IsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public LabelExpression1IsContext labelExpression1Is() {
            return getRuleContext(LabelExpression1IsContext.class, 0);
        }

        public List<TerminalNode> EXCLAMATION_MARK() {
            return getTokens(Cypher6Parser.EXCLAMATION_MARK);
        }

        public TerminalNode EXCLAMATION_MARK(int i) {
            return getToken(Cypher6Parser.EXCLAMATION_MARK, i);
        }

        public LabelExpression2IsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression2Is;
        }
    }

    public final LabelExpression2IsContext labelExpression2Is() throws RecognitionException {
        LabelExpression2IsContext _localctx = new LabelExpression2IsContext(_ctx, getState());
        enterRule(_localctx, 160, RULE_labelExpression2Is);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1375);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == EXCLAMATION_MARK) {
                    {
                        {
                            setState(1372);
                            match(EXCLAMATION_MARK);
                        }
                    }
                    setState(1377);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(1378);
                labelExpression1Is();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression1Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public LabelExpression1Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression1;
        }

        public LabelExpression1Context() {}

        public void copyFrom(LabelExpression1Context ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AnyLabelContext extends LabelExpression1Context {
        public TerminalNode PERCENT() {
            return getToken(Cypher6Parser.PERCENT, 0);
        }

        public AnyLabelContext(LabelExpression1Context ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelNameContext extends LabelExpression1Context {
        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public LabelNameContext(LabelExpression1Context ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ParenthesizedLabelExpressionContext extends LabelExpression1Context {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public LabelExpression4Context labelExpression4() {
            return getRuleContext(LabelExpression4Context.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public ParenthesizedLabelExpressionContext(LabelExpression1Context ctx) {
            copyFrom(ctx);
        }
    }

    public final LabelExpression1Context labelExpression1() throws RecognitionException {
        LabelExpression1Context _localctx = new LabelExpression1Context(_ctx, getState());
        enterRule(_localctx, 162, RULE_labelExpression1);
        try {
            setState(1386);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case LPAREN:
                    _localctx = new ParenthesizedLabelExpressionContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1380);
                        match(LPAREN);
                        setState(1381);
                        labelExpression4();
                        setState(1382);
                        match(RPAREN);
                    }
                    break;
                case PERCENT:
                    _localctx = new AnyLabelContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1384);
                        match(PERCENT);
                    }
                    break;
                case ESCAPED_SYMBOLIC_NAME:
                case ACCESS:
                case ACTIVE:
                case ADMIN:
                case ADMINISTRATOR:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATHS:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case ARRAY:
                case AS:
                case ASC:
                case ASCENDING:
                case ASSIGN:
                case AT:
                case AUTH:
                case BINDINGS:
                case BOOL:
                case BOOLEAN:
                case BOOSTED:
                case BOTH:
                case BREAK:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CHANGE:
                case CIDR:
                case COLLECT:
                case COMMAND:
                case COMMANDS:
                case COMPOSITE:
                case CONCURRENT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case CONTINUE:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DATE:
                case DATETIME:
                case DBMS:
                case DEALLOCATE:
                case DEFAULT:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESCENDING:
                case DESTROY:
                case DETACH:
                case DIFFERENT:
                case DISTINCT:
                case DRIVER:
                case DROP:
                case DRYRUN:
                case DUMP:
                case DURATION:
                case EACH:
                case EDGE:
                case ENABLE:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXECUTE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case ERROR:
                case FAIL:
                case FALSE:
                case FIELDTERMINATOR:
                case FINISH:
                case FLOAT:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case GROUP:
                case GROUPS:
                case HEADERS:
                case HOME:
                case ID:
                case IF:
                case IMPERSONATE:
                case IMMUTABLE:
                case IN:
                case INDEX:
                case INDEXES:
                case INF:
                case INFINITY:
                case INSERT:
                case INT:
                case INTEGER:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LEADING:
                case LIMITROWS:
                case LIST:
                case LOAD:
                case LOCAL:
                case LOOKUP:
                case MANAGEMENT:
                case MAP:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NAN:
                case NFC:
                case NFD:
                case NFKC:
                case NFKD:
                case NEW:
                case NODE:
                case NODETACH:
                case NODES:
                case NONE:
                case NORMALIZE:
                case NORMALIZED:
                case NOT:
                case NOTHING:
                case NOWAIT:
                case NULL:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OPTION:
                case OR:
                case ORDER:
                case PASSWORD:
                case PASSWORDS:
                case PATH:
                case PATHS:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIMARY:
                case PRIMARIES:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTIES:
                case PROPERTY:
                case PROVIDER:
                case PROVIDERS:
                case RANGE:
                case READ:
                case REALLOCATE:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPEATABLE:
                case REPLACE:
                case REPORT:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDARY:
                case SECONDARIES:
                case SECONDS:
                case SEEK:
                case SERVER:
                case SERVERS:
                case SET:
                case SETTING:
                case SETTINGS:
                case SHORTEST_PATH:
                case SHORTEST:
                case SHOW:
                case SIGNED:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case STRING:
                case SUPPORTED:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TIME:
                case TIMESTAMP:
                case TIMEZONE:
                case TO:
                case TOPOLOGY:
                case TRAILING:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRIM:
                case TRUE:
                case TYPE:
                case TYPED:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNIQUENESS:
                case UNWIND:
                case URL:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VALUE:
                case VARCHAR:
                case VECTOR:
                case VERTEX:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WITHOUT:
                case WRITE:
                case XOR:
                case YIELD:
                case ZONE:
                case ZONED:
                case IDENTIFIER:
                    _localctx = new LabelNameContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1385);
                        symbolicNameString();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelExpression1IsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public LabelExpression1IsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelExpression1Is;
        }

        public LabelExpression1IsContext() {}

        public void copyFrom(LabelExpression1IsContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ParenthesizedLabelExpressionIsContext extends LabelExpression1IsContext {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public LabelExpression4IsContext labelExpression4Is() {
            return getRuleContext(LabelExpression4IsContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public ParenthesizedLabelExpressionIsContext(LabelExpression1IsContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AnyLabelIsContext extends LabelExpression1IsContext {
        public TerminalNode PERCENT() {
            return getToken(Cypher6Parser.PERCENT, 0);
        }

        public AnyLabelIsContext(LabelExpression1IsContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelNameIsContext extends LabelExpression1IsContext {
        public SymbolicLabelNameStringContext symbolicLabelNameString() {
            return getRuleContext(SymbolicLabelNameStringContext.class, 0);
        }

        public LabelNameIsContext(LabelExpression1IsContext ctx) {
            copyFrom(ctx);
        }
    }

    public final LabelExpression1IsContext labelExpression1Is() throws RecognitionException {
        LabelExpression1IsContext _localctx = new LabelExpression1IsContext(_ctx, getState());
        enterRule(_localctx, 164, RULE_labelExpression1Is);
        try {
            setState(1394);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case LPAREN:
                    _localctx = new ParenthesizedLabelExpressionIsContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1388);
                        match(LPAREN);
                        setState(1389);
                        labelExpression4Is();
                        setState(1390);
                        match(RPAREN);
                    }
                    break;
                case PERCENT:
                    _localctx = new AnyLabelIsContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1392);
                        match(PERCENT);
                    }
                    break;
                case ESCAPED_SYMBOLIC_NAME:
                case ACCESS:
                case ACTIVE:
                case ADMIN:
                case ADMINISTRATOR:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATHS:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case ARRAY:
                case AS:
                case ASC:
                case ASCENDING:
                case ASSIGN:
                case AT:
                case AUTH:
                case BINDINGS:
                case BOOL:
                case BOOLEAN:
                case BOOSTED:
                case BOTH:
                case BREAK:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CHANGE:
                case CIDR:
                case COLLECT:
                case COMMAND:
                case COMMANDS:
                case COMPOSITE:
                case CONCURRENT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case CONTINUE:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DATE:
                case DATETIME:
                case DBMS:
                case DEALLOCATE:
                case DEFAULT:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESCENDING:
                case DESTROY:
                case DETACH:
                case DIFFERENT:
                case DISTINCT:
                case DRIVER:
                case DROP:
                case DRYRUN:
                case DUMP:
                case DURATION:
                case EACH:
                case EDGE:
                case ENABLE:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXECUTE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case ERROR:
                case FAIL:
                case FALSE:
                case FIELDTERMINATOR:
                case FINISH:
                case FLOAT:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case GROUP:
                case GROUPS:
                case HEADERS:
                case HOME:
                case ID:
                case IF:
                case IMPERSONATE:
                case IMMUTABLE:
                case IN:
                case INDEX:
                case INDEXES:
                case INF:
                case INFINITY:
                case INSERT:
                case INT:
                case INTEGER:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LEADING:
                case LIMITROWS:
                case LIST:
                case LOAD:
                case LOCAL:
                case LOOKUP:
                case MANAGEMENT:
                case MAP:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NAN:
                case NEW:
                case NODE:
                case NODETACH:
                case NODES:
                case NONE:
                case NORMALIZE:
                case NOTHING:
                case NOWAIT:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OPTION:
                case OR:
                case ORDER:
                case PASSWORD:
                case PASSWORDS:
                case PATH:
                case PATHS:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIMARY:
                case PRIMARIES:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTIES:
                case PROPERTY:
                case PROVIDER:
                case PROVIDERS:
                case RANGE:
                case READ:
                case REALLOCATE:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPEATABLE:
                case REPLACE:
                case REPORT:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDARY:
                case SECONDARIES:
                case SECONDS:
                case SEEK:
                case SERVER:
                case SERVERS:
                case SET:
                case SETTING:
                case SETTINGS:
                case SHORTEST_PATH:
                case SHORTEST:
                case SHOW:
                case SIGNED:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case STRING:
                case SUPPORTED:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TIME:
                case TIMESTAMP:
                case TIMEZONE:
                case TO:
                case TOPOLOGY:
                case TRAILING:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRIM:
                case TRUE:
                case TYPE:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNIQUENESS:
                case UNWIND:
                case URL:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VALUE:
                case VARCHAR:
                case VECTOR:
                case VERTEX:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WITHOUT:
                case WRITE:
                case XOR:
                case YIELD:
                case ZONE:
                case ZONED:
                case IDENTIFIER:
                    _localctx = new LabelNameIsContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1393);
                        symbolicLabelNameString();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertNodeLabelExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public List<TerminalNode> COLON() {
            return getTokens(Cypher6Parser.COLON);
        }

        public TerminalNode COLON(int i) {
            return getToken(Cypher6Parser.COLON, i);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public List<TerminalNode> AMPERSAND() {
            return getTokens(Cypher6Parser.AMPERSAND);
        }

        public TerminalNode AMPERSAND(int i) {
            return getToken(Cypher6Parser.AMPERSAND, i);
        }

        public InsertNodeLabelExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertNodeLabelExpression;
        }
    }

    public final InsertNodeLabelExpressionContext insertNodeLabelExpression() throws RecognitionException {
        InsertNodeLabelExpressionContext _localctx = new InsertNodeLabelExpressionContext(_ctx, getState());
        enterRule(_localctx, 166, RULE_insertNodeLabelExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1396);
                _la = _input.LA(1);
                if (!(_la == COLON || _la == IS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(1397);
                symbolicNameString();
                setState(1402);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COLON || _la == AMPERSAND) {
                    {
                        {
                            setState(1398);
                            _la = _input.LA(1);
                            if (!(_la == COLON || _la == AMPERSAND)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(1399);
                            symbolicNameString();
                        }
                    }
                    setState(1404);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class InsertRelationshipLabelExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public InsertRelationshipLabelExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_insertRelationshipLabelExpression;
        }
    }

    public final InsertRelationshipLabelExpressionContext insertRelationshipLabelExpression()
            throws RecognitionException {
        InsertRelationshipLabelExpressionContext _localctx =
                new InsertRelationshipLabelExpressionContext(_ctx, getState());
        enterRule(_localctx, 168, RULE_insertRelationshipLabelExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1405);
                _la = _input.LA(1);
                if (!(_la == COLON || _la == IS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(1406);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression11Context> expression11() {
            return getRuleContexts(Expression11Context.class);
        }

        public Expression11Context expression11(int i) {
            return getRuleContext(Expression11Context.class, i);
        }

        public List<TerminalNode> OR() {
            return getTokens(Cypher6Parser.OR);
        }

        public TerminalNode OR(int i) {
            return getToken(Cypher6Parser.OR, i);
        }

        public ExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression;
        }
    }

    public final ExpressionContext expression() throws RecognitionException {
        ExpressionContext _localctx = new ExpressionContext(_ctx, getState());
        enterRule(_localctx, 170, RULE_expression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1408);
                expression11();
                setState(1413);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == OR) {
                    {
                        {
                            setState(1409);
                            match(OR);
                            setState(1410);
                            expression11();
                        }
                    }
                    setState(1415);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression11Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression10Context> expression10() {
            return getRuleContexts(Expression10Context.class);
        }

        public Expression10Context expression10(int i) {
            return getRuleContext(Expression10Context.class, i);
        }

        public List<TerminalNode> XOR() {
            return getTokens(Cypher6Parser.XOR);
        }

        public TerminalNode XOR(int i) {
            return getToken(Cypher6Parser.XOR, i);
        }

        public Expression11Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression11;
        }
    }

    public final Expression11Context expression11() throws RecognitionException {
        Expression11Context _localctx = new Expression11Context(_ctx, getState());
        enterRule(_localctx, 172, RULE_expression11);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1416);
                expression10();
                setState(1421);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == XOR) {
                    {
                        {
                            setState(1417);
                            match(XOR);
                            setState(1418);
                            expression10();
                        }
                    }
                    setState(1423);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression10Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression9Context> expression9() {
            return getRuleContexts(Expression9Context.class);
        }

        public Expression9Context expression9(int i) {
            return getRuleContext(Expression9Context.class, i);
        }

        public List<TerminalNode> AND() {
            return getTokens(Cypher6Parser.AND);
        }

        public TerminalNode AND(int i) {
            return getToken(Cypher6Parser.AND, i);
        }

        public Expression10Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression10;
        }
    }

    public final Expression10Context expression10() throws RecognitionException {
        Expression10Context _localctx = new Expression10Context(_ctx, getState());
        enterRule(_localctx, 174, RULE_expression10);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1424);
                expression9();
                setState(1429);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == AND) {
                    {
                        {
                            setState(1425);
                            match(AND);
                            setState(1426);
                            expression9();
                        }
                    }
                    setState(1431);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression9Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Expression8Context expression8() {
            return getRuleContext(Expression8Context.class, 0);
        }

        public List<TerminalNode> NOT() {
            return getTokens(Cypher6Parser.NOT);
        }

        public TerminalNode NOT(int i) {
            return getToken(Cypher6Parser.NOT, i);
        }

        public Expression9Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression9;
        }
    }

    public final Expression9Context expression9() throws RecognitionException {
        Expression9Context _localctx = new Expression9Context(_ctx, getState());
        enterRule(_localctx, 176, RULE_expression9);
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1435);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 126, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1432);
                                match(NOT);
                            }
                        }
                    }
                    setState(1437);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 126, _ctx);
                }
                setState(1438);
                expression8();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression8Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression7Context> expression7() {
            return getRuleContexts(Expression7Context.class);
        }

        public Expression7Context expression7(int i) {
            return getRuleContext(Expression7Context.class, i);
        }

        public List<TerminalNode> EQ() {
            return getTokens(Cypher6Parser.EQ);
        }

        public TerminalNode EQ(int i) {
            return getToken(Cypher6Parser.EQ, i);
        }

        public List<TerminalNode> INVALID_NEQ() {
            return getTokens(Cypher6Parser.INVALID_NEQ);
        }

        public TerminalNode INVALID_NEQ(int i) {
            return getToken(Cypher6Parser.INVALID_NEQ, i);
        }

        public List<TerminalNode> NEQ() {
            return getTokens(Cypher6Parser.NEQ);
        }

        public TerminalNode NEQ(int i) {
            return getToken(Cypher6Parser.NEQ, i);
        }

        public List<TerminalNode> LE() {
            return getTokens(Cypher6Parser.LE);
        }

        public TerminalNode LE(int i) {
            return getToken(Cypher6Parser.LE, i);
        }

        public List<TerminalNode> GE() {
            return getTokens(Cypher6Parser.GE);
        }

        public TerminalNode GE(int i) {
            return getToken(Cypher6Parser.GE, i);
        }

        public List<TerminalNode> LT() {
            return getTokens(Cypher6Parser.LT);
        }

        public TerminalNode LT(int i) {
            return getToken(Cypher6Parser.LT, i);
        }

        public List<TerminalNode> GT() {
            return getTokens(Cypher6Parser.GT);
        }

        public TerminalNode GT(int i) {
            return getToken(Cypher6Parser.GT, i);
        }

        public Expression8Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression8;
        }
    }

    public final Expression8Context expression8() throws RecognitionException {
        Expression8Context _localctx = new Expression8Context(_ctx, getState());
        enterRule(_localctx, 178, RULE_expression8);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1440);
                expression7();
                setState(1445);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (((((_la - 96)) & ~0x3f) == 0 && ((1L << (_la - 96)) & -9151032967823097855L) != 0)
                        || _la == NEQ) {
                    {
                        {
                            setState(1441);
                            _la = _input.LA(1);
                            if (!(((((_la - 96)) & ~0x3f) == 0 && ((1L << (_la - 96)) & -9151032967823097855L) != 0)
                                    || _la == NEQ)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(1442);
                            expression7();
                        }
                    }
                    setState(1447);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression7Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Expression6Context expression6() {
            return getRuleContext(Expression6Context.class, 0);
        }

        public ComparisonExpression6Context comparisonExpression6() {
            return getRuleContext(ComparisonExpression6Context.class, 0);
        }

        public Expression7Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression7;
        }
    }

    public final Expression7Context expression7() throws RecognitionException {
        Expression7Context _localctx = new Expression7Context(_ctx, getState());
        enterRule(_localctx, 180, RULE_expression7);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1448);
                expression6();
                setState(1450);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == COLONCOLON
                        || _la == CONTAINS
                        || ((((_la - 95)) & ~0x3f) == 0 && ((1L << (_la - 95)) & 1103806595073L) != 0)
                        || _la == REGEQ
                        || _la == STARTS) {
                    {
                        setState(1449);
                        comparisonExpression6();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ComparisonExpression6Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ComparisonExpression6Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_comparisonExpression6;
        }

        public ComparisonExpression6Context() {}

        public void copyFrom(ComparisonExpression6Context ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TypeComparisonContext extends ComparisonExpression6Context {
        public TypeContext type() {
            return getRuleContext(TypeContext.class, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode COLONCOLON() {
            return getToken(Cypher6Parser.COLONCOLON, 0);
        }

        public TerminalNode TYPED() {
            return getToken(Cypher6Parser.TYPED, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TypeComparisonContext(ComparisonExpression6Context ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class StringAndListComparisonContext extends ComparisonExpression6Context {
        public Expression6Context expression6() {
            return getRuleContext(Expression6Context.class, 0);
        }

        public TerminalNode REGEQ() {
            return getToken(Cypher6Parser.REGEQ, 0);
        }

        public TerminalNode STARTS() {
            return getToken(Cypher6Parser.STARTS, 0);
        }

        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public TerminalNode ENDS() {
            return getToken(Cypher6Parser.ENDS, 0);
        }

        public TerminalNode CONTAINS() {
            return getToken(Cypher6Parser.CONTAINS, 0);
        }

        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public StringAndListComparisonContext(ComparisonExpression6Context ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NormalFormComparisonContext extends ComparisonExpression6Context {
        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode NORMALIZED() {
            return getToken(Cypher6Parser.NORMALIZED, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public NormalFormContext normalForm() {
            return getRuleContext(NormalFormContext.class, 0);
        }

        public NormalFormComparisonContext(ComparisonExpression6Context ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NullComparisonContext extends ComparisonExpression6Context {
        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode NULL() {
            return getToken(Cypher6Parser.NULL, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public NullComparisonContext(ComparisonExpression6Context ctx) {
            copyFrom(ctx);
        }
    }

    public final ComparisonExpression6Context comparisonExpression6() throws RecognitionException {
        ComparisonExpression6Context _localctx = new ComparisonExpression6Context(_ctx, getState());
        enterRule(_localctx, 182, RULE_comparisonExpression6);
        int _la;
        try {
            setState(1484);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 135, _ctx)) {
                case 1:
                    _localctx = new StringAndListComparisonContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1459);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case REGEQ:
                                {
                                    setState(1452);
                                    match(REGEQ);
                                }
                                break;
                            case STARTS:
                                {
                                    setState(1453);
                                    match(STARTS);
                                    setState(1454);
                                    match(WITH);
                                }
                                break;
                            case ENDS:
                                {
                                    setState(1455);
                                    match(ENDS);
                                    setState(1456);
                                    match(WITH);
                                }
                                break;
                            case CONTAINS:
                                {
                                    setState(1457);
                                    match(CONTAINS);
                                }
                                break;
                            case IN:
                                {
                                    setState(1458);
                                    match(IN);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                        setState(1461);
                        expression6();
                    }
                    break;
                case 2:
                    _localctx = new NullComparisonContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1462);
                        match(IS);
                        setState(1464);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == NOT) {
                            {
                                setState(1463);
                                match(NOT);
                            }
                        }

                        setState(1466);
                        match(NULL);
                    }
                    break;
                case 3:
                    _localctx = new TypeComparisonContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1473);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case IS:
                                {
                                    setState(1467);
                                    match(IS);
                                    setState(1469);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    if (_la == NOT) {
                                        {
                                            setState(1468);
                                            match(NOT);
                                        }
                                    }

                                    setState(1471);
                                    _la = _input.LA(1);
                                    if (!(_la == COLONCOLON || _la == TYPED)) {
                                        _errHandler.recoverInline(this);
                                    } else {
                                        if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                        _errHandler.reportMatch(this);
                                        consume();
                                    }
                                }
                                break;
                            case COLONCOLON:
                                {
                                    setState(1472);
                                    match(COLONCOLON);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                        setState(1475);
                        type();
                    }
                    break;
                case 4:
                    _localctx = new NormalFormComparisonContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1476);
                        match(IS);
                        setState(1478);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == NOT) {
                            {
                                setState(1477);
                                match(NOT);
                            }
                        }

                        setState(1481);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 164)) & ~0x3f) == 0 && ((1L << (_la - 164)) & 15L) != 0)) {
                            {
                                setState(1480);
                                normalForm();
                            }
                        }

                        setState(1483);
                        match(NORMALIZED);
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NormalFormContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NFC() {
            return getToken(Cypher6Parser.NFC, 0);
        }

        public TerminalNode NFD() {
            return getToken(Cypher6Parser.NFD, 0);
        }

        public TerminalNode NFKC() {
            return getToken(Cypher6Parser.NFKC, 0);
        }

        public TerminalNode NFKD() {
            return getToken(Cypher6Parser.NFKD, 0);
        }

        public NormalFormContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_normalForm;
        }
    }

    public final NormalFormContext normalForm() throws RecognitionException {
        NormalFormContext _localctx = new NormalFormContext(_ctx, getState());
        enterRule(_localctx, 184, RULE_normalForm);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1486);
                _la = _input.LA(1);
                if (!(((((_la - 164)) & ~0x3f) == 0 && ((1L << (_la - 164)) & 15L) != 0))) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression6Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression5Context> expression5() {
            return getRuleContexts(Expression5Context.class);
        }

        public Expression5Context expression5(int i) {
            return getRuleContext(Expression5Context.class, i);
        }

        public List<TerminalNode> PLUS() {
            return getTokens(Cypher6Parser.PLUS);
        }

        public TerminalNode PLUS(int i) {
            return getToken(Cypher6Parser.PLUS, i);
        }

        public List<TerminalNode> MINUS() {
            return getTokens(Cypher6Parser.MINUS);
        }

        public TerminalNode MINUS(int i) {
            return getToken(Cypher6Parser.MINUS, i);
        }

        public List<TerminalNode> DOUBLEBAR() {
            return getTokens(Cypher6Parser.DOUBLEBAR);
        }

        public TerminalNode DOUBLEBAR(int i) {
            return getToken(Cypher6Parser.DOUBLEBAR, i);
        }

        public Expression6Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression6;
        }
    }

    public final Expression6Context expression6() throws RecognitionException {
        Expression6Context _localctx = new Expression6Context(_ctx, getState());
        enterRule(_localctx, 186, RULE_expression6);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1488);
                expression5();
                setState(1493);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == DOUBLEBAR || _la == MINUS || _la == PLUS) {
                    {
                        {
                            setState(1489);
                            _la = _input.LA(1);
                            if (!(_la == DOUBLEBAR || _la == MINUS || _la == PLUS)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(1490);
                            expression5();
                        }
                    }
                    setState(1495);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression5Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression4Context> expression4() {
            return getRuleContexts(Expression4Context.class);
        }

        public Expression4Context expression4(int i) {
            return getRuleContext(Expression4Context.class, i);
        }

        public List<TerminalNode> TIMES() {
            return getTokens(Cypher6Parser.TIMES);
        }

        public TerminalNode TIMES(int i) {
            return getToken(Cypher6Parser.TIMES, i);
        }

        public List<TerminalNode> DIVIDE() {
            return getTokens(Cypher6Parser.DIVIDE);
        }

        public TerminalNode DIVIDE(int i) {
            return getToken(Cypher6Parser.DIVIDE, i);
        }

        public List<TerminalNode> PERCENT() {
            return getTokens(Cypher6Parser.PERCENT);
        }

        public TerminalNode PERCENT(int i) {
            return getToken(Cypher6Parser.PERCENT, i);
        }

        public Expression5Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression5;
        }
    }

    public final Expression5Context expression5() throws RecognitionException {
        Expression5Context _localctx = new Expression5Context(_ctx, getState());
        enterRule(_localctx, 188, RULE_expression5);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1496);
                expression4();
                setState(1501);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == DIVIDE || _la == PERCENT || _la == TIMES) {
                    {
                        {
                            setState(1497);
                            _la = _input.LA(1);
                            if (!(_la == DIVIDE || _la == PERCENT || _la == TIMES)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(1498);
                            expression4();
                        }
                    }
                    setState(1503);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression4Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<Expression3Context> expression3() {
            return getRuleContexts(Expression3Context.class);
        }

        public Expression3Context expression3(int i) {
            return getRuleContext(Expression3Context.class, i);
        }

        public List<TerminalNode> POW() {
            return getTokens(Cypher6Parser.POW);
        }

        public TerminalNode POW(int i) {
            return getToken(Cypher6Parser.POW, i);
        }

        public Expression4Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression4;
        }
    }

    public final Expression4Context expression4() throws RecognitionException {
        Expression4Context _localctx = new Expression4Context(_ctx, getState());
        enterRule(_localctx, 190, RULE_expression4);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1504);
                expression3();
                setState(1509);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == POW) {
                    {
                        {
                            setState(1505);
                            match(POW);
                            setState(1506);
                            expression3();
                        }
                    }
                    setState(1511);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression3Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Expression2Context expression2() {
            return getRuleContext(Expression2Context.class, 0);
        }

        public TerminalNode PLUS() {
            return getToken(Cypher6Parser.PLUS, 0);
        }

        public TerminalNode MINUS() {
            return getToken(Cypher6Parser.MINUS, 0);
        }

        public Expression3Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression3;
        }
    }

    public final Expression3Context expression3() throws RecognitionException {
        Expression3Context _localctx = new Expression3Context(_ctx, getState());
        enterRule(_localctx, 192, RULE_expression3);
        int _la;
        try {
            setState(1515);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 139, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1512);
                        expression2();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1513);
                        _la = _input.LA(1);
                        if (!(_la == MINUS || _la == PLUS)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(1514);
                        expression2();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression2Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Expression1Context expression1() {
            return getRuleContext(Expression1Context.class, 0);
        }

        public List<PostFixContext> postFix() {
            return getRuleContexts(PostFixContext.class);
        }

        public PostFixContext postFix(int i) {
            return getRuleContext(PostFixContext.class, i);
        }

        public Expression2Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression2;
        }
    }

    public final Expression2Context expression2() throws RecognitionException {
        Expression2Context _localctx = new Expression2Context(_ctx, getState());
        enterRule(_localctx, 194, RULE_expression2);
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1517);
                expression1();
                setState(1521);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 140, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1518);
                                postFix();
                            }
                        }
                    }
                    setState(1523);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 140, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PostFixContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public PostFixContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_postFix;
        }

        public PostFixContext() {}

        public void copyFrom(PostFixContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class IndexPostfixContext extends PostFixContext {
        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public IndexPostfixContext(PostFixContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertyPostfixContext extends PostFixContext {
        public PropertyContext property() {
            return getRuleContext(PropertyContext.class, 0);
        }

        public PropertyPostfixContext(PostFixContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelPostfixContext extends PostFixContext {
        public LabelExpressionContext labelExpression() {
            return getRuleContext(LabelExpressionContext.class, 0);
        }

        public LabelPostfixContext(PostFixContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RangePostfixContext extends PostFixContext {
        public ExpressionContext fromExp;
        public ExpressionContext toExp;

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public TerminalNode DOTDOT() {
            return getToken(Cypher6Parser.DOTDOT, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public RangePostfixContext(PostFixContext ctx) {
            copyFrom(ctx);
        }
    }

    public final PostFixContext postFix() throws RecognitionException {
        PostFixContext _localctx = new PostFixContext(_ctx, getState());
        enterRule(_localctx, 196, RULE_postFix);
        int _la;
        try {
            setState(1539);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 143, _ctx)) {
                case 1:
                    _localctx = new PropertyPostfixContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1524);
                        property();
                    }
                    break;
                case 2:
                    _localctx = new LabelPostfixContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1525);
                        labelExpression();
                    }
                    break;
                case 3:
                    _localctx = new IndexPostfixContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1526);
                        match(LBRACKET);
                        setState(1527);
                        expression();
                        setState(1528);
                        match(RBRACKET);
                    }
                    break;
                case 4:
                    _localctx = new RangePostfixContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1530);
                        match(LBRACKET);
                        setState(1532);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839181840L) != 0)
                                || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239983617L) != 0)
                                || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -7533047809L) != 0)
                                || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & -141287252983827L) != 0)
                                || ((((_la - 256)) & ~0x3f) == 0 && ((1L << (_la - 256)) & 35184372088703L) != 0)) {
                            {
                                setState(1531);
                                ((RangePostfixContext) _localctx).fromExp = expression();
                            }
                        }

                        setState(1534);
                        match(DOTDOT);
                        setState(1536);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839181840L) != 0)
                                || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239983617L) != 0)
                                || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -7533047809L) != 0)
                                || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & -141287252983827L) != 0)
                                || ((((_la - 256)) & ~0x3f) == 0 && ((1L << (_la - 256)) & 35184372088703L) != 0)) {
                            {
                                setState(1535);
                                ((RangePostfixContext) _localctx).toExp = expression();
                            }
                        }

                        setState(1538);
                        match(RBRACKET);
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertyContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DOT() {
            return getToken(Cypher6Parser.DOT, 0);
        }

        public PropertyKeyNameContext propertyKeyName() {
            return getRuleContext(PropertyKeyNameContext.class, 0);
        }

        public PropertyContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_property;
        }
    }

    public final PropertyContext property() throws RecognitionException {
        PropertyContext _localctx = new PropertyContext(_ctx, getState());
        enterRule(_localctx, 198, RULE_property);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1541);
                match(DOT);
                setState(1542);
                propertyKeyName();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DynamicPropertyContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public DynamicPropertyContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dynamicProperty;
        }
    }

    public final DynamicPropertyContext dynamicProperty() throws RecognitionException {
        DynamicPropertyContext _localctx = new DynamicPropertyContext(_ctx, getState());
        enterRule(_localctx, 200, RULE_dynamicProperty);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1544);
                match(LBRACKET);
                setState(1545);
                expression();
                setState(1546);
                match(RBRACKET);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertyExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Expression1Context expression1() {
            return getRuleContext(Expression1Context.class, 0);
        }

        public List<PropertyContext> property() {
            return getRuleContexts(PropertyContext.class);
        }

        public PropertyContext property(int i) {
            return getRuleContext(PropertyContext.class, i);
        }

        public PropertyExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_propertyExpression;
        }
    }

    public final PropertyExpressionContext propertyExpression() throws RecognitionException {
        PropertyExpressionContext _localctx = new PropertyExpressionContext(_ctx, getState());
        enterRule(_localctx, 202, RULE_propertyExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1548);
                expression1();
                setState(1550);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(1549);
                            property();
                        }
                    }
                    setState(1552);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == DOT);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DynamicPropertyExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public Expression1Context expression1() {
            return getRuleContext(Expression1Context.class, 0);
        }

        public DynamicPropertyContext dynamicProperty() {
            return getRuleContext(DynamicPropertyContext.class, 0);
        }

        public DynamicPropertyExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dynamicPropertyExpression;
        }
    }

    public final DynamicPropertyExpressionContext dynamicPropertyExpression() throws RecognitionException {
        DynamicPropertyExpressionContext _localctx = new DynamicPropertyExpressionContext(_ctx, getState());
        enterRule(_localctx, 204, RULE_dynamicPropertyExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1554);
                expression1();
                setState(1555);
                dynamicProperty();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class Expression1Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public LiteralContext literal() {
            return getRuleContext(LiteralContext.class, 0);
        }

        public ParameterContext parameter() {
            return getRuleContext(ParameterContext.class, 0);
        }

        public CaseExpressionContext caseExpression() {
            return getRuleContext(CaseExpressionContext.class, 0);
        }

        public ExtendedCaseExpressionContext extendedCaseExpression() {
            return getRuleContext(ExtendedCaseExpressionContext.class, 0);
        }

        public CountStarContext countStar() {
            return getRuleContext(CountStarContext.class, 0);
        }

        public ExistsExpressionContext existsExpression() {
            return getRuleContext(ExistsExpressionContext.class, 0);
        }

        public CountExpressionContext countExpression() {
            return getRuleContext(CountExpressionContext.class, 0);
        }

        public CollectExpressionContext collectExpression() {
            return getRuleContext(CollectExpressionContext.class, 0);
        }

        public MapProjectionContext mapProjection() {
            return getRuleContext(MapProjectionContext.class, 0);
        }

        public ListComprehensionContext listComprehension() {
            return getRuleContext(ListComprehensionContext.class, 0);
        }

        public ListLiteralContext listLiteral() {
            return getRuleContext(ListLiteralContext.class, 0);
        }

        public PatternComprehensionContext patternComprehension() {
            return getRuleContext(PatternComprehensionContext.class, 0);
        }

        public ReduceExpressionContext reduceExpression() {
            return getRuleContext(ReduceExpressionContext.class, 0);
        }

        public ListItemsPredicateContext listItemsPredicate() {
            return getRuleContext(ListItemsPredicateContext.class, 0);
        }

        public NormalizeFunctionContext normalizeFunction() {
            return getRuleContext(NormalizeFunctionContext.class, 0);
        }

        public TrimFunctionContext trimFunction() {
            return getRuleContext(TrimFunctionContext.class, 0);
        }

        public PatternExpressionContext patternExpression() {
            return getRuleContext(PatternExpressionContext.class, 0);
        }

        public ShortestPathExpressionContext shortestPathExpression() {
            return getRuleContext(ShortestPathExpressionContext.class, 0);
        }

        public ParenthesizedExpressionContext parenthesizedExpression() {
            return getRuleContext(ParenthesizedExpressionContext.class, 0);
        }

        public FunctionInvocationContext functionInvocation() {
            return getRuleContext(FunctionInvocationContext.class, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public Expression1Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_expression1;
        }
    }

    public final Expression1Context expression1() throws RecognitionException {
        Expression1Context _localctx = new Expression1Context(_ctx, getState());
        enterRule(_localctx, 206, RULE_expression1);
        try {
            setState(1578);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 145, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1557);
                        literal();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1558);
                        parameter("ANY");
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1559);
                        caseExpression();
                    }
                    break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1560);
                        extendedCaseExpression();
                    }
                    break;
                case 5:
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(1561);
                        countStar();
                    }
                    break;
                case 6:
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(1562);
                        existsExpression();
                    }
                    break;
                case 7:
                    enterOuterAlt(_localctx, 7);
                    {
                        setState(1563);
                        countExpression();
                    }
                    break;
                case 8:
                    enterOuterAlt(_localctx, 8);
                    {
                        setState(1564);
                        collectExpression();
                    }
                    break;
                case 9:
                    enterOuterAlt(_localctx, 9);
                    {
                        setState(1565);
                        mapProjection();
                    }
                    break;
                case 10:
                    enterOuterAlt(_localctx, 10);
                    {
                        setState(1566);
                        listComprehension();
                    }
                    break;
                case 11:
                    enterOuterAlt(_localctx, 11);
                    {
                        setState(1567);
                        listLiteral();
                    }
                    break;
                case 12:
                    enterOuterAlt(_localctx, 12);
                    {
                        setState(1568);
                        patternComprehension();
                    }
                    break;
                case 13:
                    enterOuterAlt(_localctx, 13);
                    {
                        setState(1569);
                        reduceExpression();
                    }
                    break;
                case 14:
                    enterOuterAlt(_localctx, 14);
                    {
                        setState(1570);
                        listItemsPredicate();
                    }
                    break;
                case 15:
                    enterOuterAlt(_localctx, 15);
                    {
                        setState(1571);
                        normalizeFunction();
                    }
                    break;
                case 16:
                    enterOuterAlt(_localctx, 16);
                    {
                        setState(1572);
                        trimFunction();
                    }
                    break;
                case 17:
                    enterOuterAlt(_localctx, 17);
                    {
                        setState(1573);
                        patternExpression();
                    }
                    break;
                case 18:
                    enterOuterAlt(_localctx, 18);
                    {
                        setState(1574);
                        shortestPathExpression();
                    }
                    break;
                case 19:
                    enterOuterAlt(_localctx, 19);
                    {
                        setState(1575);
                        parenthesizedExpression();
                    }
                    break;
                case 20:
                    enterOuterAlt(_localctx, 20);
                    {
                        setState(1576);
                        functionInvocation();
                    }
                    break;
                case 21:
                    enterOuterAlt(_localctx, 21);
                    {
                        setState(1577);
                        variable();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LiteralContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public LiteralContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_literal;
        }

        public LiteralContext() {}

        public void copyFrom(LiteralContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NummericLiteralContext extends LiteralContext {
        public NumberLiteralContext numberLiteral() {
            return getRuleContext(NumberLiteralContext.class, 0);
        }

        public NummericLiteralContext(LiteralContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class BooleanLiteralContext extends LiteralContext {
        public TerminalNode TRUE() {
            return getToken(Cypher6Parser.TRUE, 0);
        }

        public TerminalNode FALSE() {
            return getToken(Cypher6Parser.FALSE, 0);
        }

        public BooleanLiteralContext(LiteralContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class KeywordLiteralContext extends LiteralContext {
        public TerminalNode INF() {
            return getToken(Cypher6Parser.INF, 0);
        }

        public TerminalNode INFINITY() {
            return getToken(Cypher6Parser.INFINITY, 0);
        }

        public TerminalNode NAN() {
            return getToken(Cypher6Parser.NAN, 0);
        }

        public TerminalNode NULL() {
            return getToken(Cypher6Parser.NULL, 0);
        }

        public KeywordLiteralContext(LiteralContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class OtherLiteralContext extends LiteralContext {
        public MapContext map() {
            return getRuleContext(MapContext.class, 0);
        }

        public OtherLiteralContext(LiteralContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class StringsLiteralContext extends LiteralContext {
        public StringLiteralContext stringLiteral() {
            return getRuleContext(StringLiteralContext.class, 0);
        }

        public StringsLiteralContext(LiteralContext ctx) {
            copyFrom(ctx);
        }
    }

    public final LiteralContext literal() throws RecognitionException {
        LiteralContext _localctx = new LiteralContext(_ctx, getState());
        enterRule(_localctx, 208, RULE_literal);
        try {
            setState(1589);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case DECIMAL_DOUBLE:
                case UNSIGNED_DECIMAL_INTEGER:
                case UNSIGNED_HEX_INTEGER:
                case UNSIGNED_OCTAL_INTEGER:
                case MINUS:
                    _localctx = new NummericLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1580);
                        numberLiteral();
                    }
                    break;
                case STRING_LITERAL1:
                case STRING_LITERAL2:
                    _localctx = new StringsLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1581);
                        stringLiteral();
                    }
                    break;
                case LCURLY:
                    _localctx = new OtherLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1582);
                        map();
                    }
                    break;
                case TRUE:
                    _localctx = new BooleanLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1583);
                        match(TRUE);
                    }
                    break;
                case FALSE:
                    _localctx = new BooleanLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(1584);
                        match(FALSE);
                    }
                    break;
                case INF:
                    _localctx = new KeywordLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(1585);
                        match(INF);
                    }
                    break;
                case INFINITY:
                    _localctx = new KeywordLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 7);
                    {
                        setState(1586);
                        match(INFINITY);
                    }
                    break;
                case NAN:
                    _localctx = new KeywordLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 8);
                    {
                        setState(1587);
                        match(NAN);
                    }
                    break;
                case NULL:
                    _localctx = new KeywordLiteralContext(_localctx);
                    enterOuterAlt(_localctx, 9);
                    {
                        setState(1588);
                        match(NULL);
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CaseExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CASE() {
            return getToken(Cypher6Parser.CASE, 0);
        }

        public TerminalNode END() {
            return getToken(Cypher6Parser.END, 0);
        }

        public List<CaseAlternativeContext> caseAlternative() {
            return getRuleContexts(CaseAlternativeContext.class);
        }

        public CaseAlternativeContext caseAlternative(int i) {
            return getRuleContext(CaseAlternativeContext.class, i);
        }

        public TerminalNode ELSE() {
            return getToken(Cypher6Parser.ELSE, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public CaseExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_caseExpression;
        }
    }

    public final CaseExpressionContext caseExpression() throws RecognitionException {
        CaseExpressionContext _localctx = new CaseExpressionContext(_ctx, getState());
        enterRule(_localctx, 210, RULE_caseExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1591);
                match(CASE);
                setState(1593);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(1592);
                            caseAlternative();
                        }
                    }
                    setState(1595);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == WHEN);
                setState(1599);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ELSE) {
                    {
                        setState(1597);
                        match(ELSE);
                        setState(1598);
                        expression();
                    }
                }

                setState(1601);
                match(END);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CaseAlternativeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode WHEN() {
            return getToken(Cypher6Parser.WHEN, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public TerminalNode THEN() {
            return getToken(Cypher6Parser.THEN, 0);
        }

        public CaseAlternativeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_caseAlternative;
        }
    }

    public final CaseAlternativeContext caseAlternative() throws RecognitionException {
        CaseAlternativeContext _localctx = new CaseAlternativeContext(_ctx, getState());
        enterRule(_localctx, 212, RULE_caseAlternative);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1603);
                match(WHEN);
                setState(1604);
                expression();
                setState(1605);
                match(THEN);
                setState(1606);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExtendedCaseExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext elseExp;

        public TerminalNode CASE() {
            return getToken(Cypher6Parser.CASE, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public TerminalNode END() {
            return getToken(Cypher6Parser.END, 0);
        }

        public List<ExtendedCaseAlternativeContext> extendedCaseAlternative() {
            return getRuleContexts(ExtendedCaseAlternativeContext.class);
        }

        public ExtendedCaseAlternativeContext extendedCaseAlternative(int i) {
            return getRuleContext(ExtendedCaseAlternativeContext.class, i);
        }

        public TerminalNode ELSE() {
            return getToken(Cypher6Parser.ELSE, 0);
        }

        public ExtendedCaseExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_extendedCaseExpression;
        }
    }

    public final ExtendedCaseExpressionContext extendedCaseExpression() throws RecognitionException {
        ExtendedCaseExpressionContext _localctx = new ExtendedCaseExpressionContext(_ctx, getState());
        enterRule(_localctx, 214, RULE_extendedCaseExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1608);
                match(CASE);
                setState(1609);
                expression();
                setState(1611);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(1610);
                            extendedCaseAlternative();
                        }
                    }
                    setState(1613);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == WHEN);
                setState(1617);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ELSE) {
                    {
                        setState(1615);
                        match(ELSE);
                        setState(1616);
                        ((ExtendedCaseExpressionContext) _localctx).elseExp = expression();
                    }
                }

                setState(1619);
                match(END);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExtendedCaseAlternativeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode WHEN() {
            return getToken(Cypher6Parser.WHEN, 0);
        }

        public List<ExtendedWhenContext> extendedWhen() {
            return getRuleContexts(ExtendedWhenContext.class);
        }

        public ExtendedWhenContext extendedWhen(int i) {
            return getRuleContext(ExtendedWhenContext.class, i);
        }

        public TerminalNode THEN() {
            return getToken(Cypher6Parser.THEN, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public ExtendedCaseAlternativeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_extendedCaseAlternative;
        }
    }

    public final ExtendedCaseAlternativeContext extendedCaseAlternative() throws RecognitionException {
        ExtendedCaseAlternativeContext _localctx = new ExtendedCaseAlternativeContext(_ctx, getState());
        enterRule(_localctx, 216, RULE_extendedCaseAlternative);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1621);
                match(WHEN);
                setState(1622);
                extendedWhen();
                setState(1627);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(1623);
                            match(COMMA);
                            setState(1624);
                            extendedWhen();
                        }
                    }
                    setState(1629);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(1630);
                match(THEN);
                setState(1631);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExtendedWhenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExtendedWhenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_extendedWhen;
        }

        public ExtendedWhenContext() {}

        public void copyFrom(ExtendedWhenContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhenStringOrListContext extends ExtendedWhenContext {
        public Expression6Context expression6() {
            return getRuleContext(Expression6Context.class, 0);
        }

        public TerminalNode REGEQ() {
            return getToken(Cypher6Parser.REGEQ, 0);
        }

        public TerminalNode STARTS() {
            return getToken(Cypher6Parser.STARTS, 0);
        }

        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public TerminalNode ENDS() {
            return getToken(Cypher6Parser.ENDS, 0);
        }

        public WhenStringOrListContext(ExtendedWhenContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhenTypeContext extends ExtendedWhenContext {
        public TypeContext type() {
            return getRuleContext(TypeContext.class, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode TYPED() {
            return getToken(Cypher6Parser.TYPED, 0);
        }

        public TerminalNode COLONCOLON() {
            return getToken(Cypher6Parser.COLONCOLON, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public WhenTypeContext(ExtendedWhenContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhenFormContext extends ExtendedWhenContext {
        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode NORMALIZED() {
            return getToken(Cypher6Parser.NORMALIZED, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public NormalFormContext normalForm() {
            return getRuleContext(NormalFormContext.class, 0);
        }

        public WhenFormContext(ExtendedWhenContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhenNullContext extends ExtendedWhenContext {
        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode NULL() {
            return getToken(Cypher6Parser.NULL, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public WhenNullContext(ExtendedWhenContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhenEqualsContext extends ExtendedWhenContext {
        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public WhenEqualsContext(ExtendedWhenContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WhenComparatorContext extends ExtendedWhenContext {
        public Expression7Context expression7() {
            return getRuleContext(Expression7Context.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public TerminalNode NEQ() {
            return getToken(Cypher6Parser.NEQ, 0);
        }

        public TerminalNode INVALID_NEQ() {
            return getToken(Cypher6Parser.INVALID_NEQ, 0);
        }

        public TerminalNode LE() {
            return getToken(Cypher6Parser.LE, 0);
        }

        public TerminalNode GE() {
            return getToken(Cypher6Parser.GE, 0);
        }

        public TerminalNode LT() {
            return getToken(Cypher6Parser.LT, 0);
        }

        public TerminalNode GT() {
            return getToken(Cypher6Parser.GT, 0);
        }

        public WhenComparatorContext(ExtendedWhenContext ctx) {
            copyFrom(ctx);
        }
    }

    public final ExtendedWhenContext extendedWhen() throws RecognitionException {
        ExtendedWhenContext _localctx = new ExtendedWhenContext(_ctx, getState());
        enterRule(_localctx, 218, RULE_extendedWhen);
        int _la;
        try {
            setState(1666);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 158, _ctx)) {
                case 1:
                    _localctx = new WhenStringOrListContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1638);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case REGEQ:
                                {
                                    setState(1633);
                                    match(REGEQ);
                                }
                                break;
                            case STARTS:
                                {
                                    setState(1634);
                                    match(STARTS);
                                    setState(1635);
                                    match(WITH);
                                }
                                break;
                            case ENDS:
                                {
                                    setState(1636);
                                    match(ENDS);
                                    setState(1637);
                                    match(WITH);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                        setState(1640);
                        expression6();
                    }
                    break;
                case 2:
                    _localctx = new WhenNullContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1641);
                        match(IS);
                        setState(1643);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == NOT) {
                            {
                                setState(1642);
                                match(NOT);
                            }
                        }

                        setState(1645);
                        match(NULL);
                    }
                    break;
                case 3:
                    _localctx = new WhenTypeContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1652);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case IS:
                                {
                                    setState(1646);
                                    match(IS);
                                    setState(1648);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    if (_la == NOT) {
                                        {
                                            setState(1647);
                                            match(NOT);
                                        }
                                    }

                                    setState(1650);
                                    match(TYPED);
                                }
                                break;
                            case COLONCOLON:
                                {
                                    setState(1651);
                                    match(COLONCOLON);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                        setState(1654);
                        type();
                    }
                    break;
                case 4:
                    _localctx = new WhenFormContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1655);
                        match(IS);
                        setState(1657);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == NOT) {
                            {
                                setState(1656);
                                match(NOT);
                            }
                        }

                        setState(1660);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 164)) & ~0x3f) == 0 && ((1L << (_la - 164)) & 15L) != 0)) {
                            {
                                setState(1659);
                                normalForm();
                            }
                        }

                        setState(1662);
                        match(NORMALIZED);
                    }
                    break;
                case 5:
                    _localctx = new WhenComparatorContext(_localctx);
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(1663);
                        _la = _input.LA(1);
                        if (!(((((_la - 96)) & ~0x3f) == 0 && ((1L << (_la - 96)) & -9151032967823097855L) != 0)
                                || _la == NEQ)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(1664);
                        expression7();
                    }
                    break;
                case 6:
                    _localctx = new WhenEqualsContext(_localctx);
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(1665);
                        expression();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ListComprehensionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext whereExp;
        public ExpressionContext barExp;

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public TerminalNode BAR() {
            return getToken(Cypher6Parser.BAR, 0);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ListComprehensionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_listComprehension;
        }
    }

    public final ListComprehensionContext listComprehension() throws RecognitionException {
        ListComprehensionContext _localctx = new ListComprehensionContext(_ctx, getState());
        enterRule(_localctx, 220, RULE_listComprehension);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1668);
                match(LBRACKET);
                setState(1669);
                variable();
                setState(1670);
                match(IN);
                setState(1671);
                expression();
                setState(1682);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 161, _ctx)) {
                    case 1:
                        {
                            setState(1674);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == WHERE) {
                                {
                                    setState(1672);
                                    match(WHERE);
                                    setState(1673);
                                    ((ListComprehensionContext) _localctx).whereExp = expression();
                                }
                            }

                            setState(1676);
                            match(BAR);
                            setState(1677);
                            ((ListComprehensionContext) _localctx).barExp = expression();
                        }
                        break;
                    case 2:
                        {
                            setState(1680);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == WHERE) {
                                {
                                    setState(1678);
                                    match(WHERE);
                                    setState(1679);
                                    ((ListComprehensionContext) _localctx).whereExp = expression();
                                }
                            }
                        }
                        break;
                }
                setState(1684);
                match(RBRACKET);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PatternComprehensionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext whereExp;
        public ExpressionContext barExp;

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public PathPatternNonEmptyContext pathPatternNonEmpty() {
            return getRuleContext(PathPatternNonEmptyContext.class, 0);
        }

        public TerminalNode BAR() {
            return getToken(Cypher6Parser.BAR, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public PatternComprehensionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_patternComprehension;
        }
    }

    public final PatternComprehensionContext patternComprehension() throws RecognitionException {
        PatternComprehensionContext _localctx = new PatternComprehensionContext(_ctx, getState());
        enterRule(_localctx, 222, RULE_patternComprehension);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1686);
                match(LBRACKET);
                setState(1690);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839182848L) != 0)
                        || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239987713L) != 0)
                        || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -8078356481L) != 0)
                        || ((((_la - 194)) & ~0x3f) == 0 && ((1L << (_la - 194)) & -35321813245957L) != 0)
                        || ((((_la - 258)) & ~0x3f) == 0 && ((1L << (_la - 258)) & 8796093022175L) != 0)) {
                    {
                        setState(1687);
                        variable();
                        setState(1688);
                        match(EQ);
                    }
                }

                setState(1692);
                pathPatternNonEmpty();
                setState(1695);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(1693);
                        match(WHERE);
                        setState(1694);
                        ((PatternComprehensionContext) _localctx).whereExp = expression();
                    }
                }

                setState(1697);
                match(BAR);
                setState(1698);
                ((PatternComprehensionContext) _localctx).barExp = expression();
                setState(1699);
                match(RBRACKET);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ReduceExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REDUCE() {
            return getToken(Cypher6Parser.REDUCE, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public List<VariableContext> variable() {
            return getRuleContexts(VariableContext.class);
        }

        public VariableContext variable(int i) {
            return getRuleContext(VariableContext.class, i);
        }

        public TerminalNode EQ() {
            return getToken(Cypher6Parser.EQ, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public TerminalNode COMMA() {
            return getToken(Cypher6Parser.COMMA, 0);
        }

        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public TerminalNode BAR() {
            return getToken(Cypher6Parser.BAR, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public ReduceExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_reduceExpression;
        }
    }

    public final ReduceExpressionContext reduceExpression() throws RecognitionException {
        ReduceExpressionContext _localctx = new ReduceExpressionContext(_ctx, getState());
        enterRule(_localctx, 224, RULE_reduceExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1701);
                match(REDUCE);
                setState(1702);
                match(LPAREN);
                setState(1703);
                variable();
                setState(1704);
                match(EQ);
                setState(1705);
                expression();
                setState(1706);
                match(COMMA);
                setState(1707);
                variable();
                setState(1708);
                match(IN);
                setState(1709);
                expression();
                setState(1710);
                match(BAR);
                setState(1711);
                expression();
                setState(1712);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ListItemsPredicateContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext inExp;
        public ExpressionContext whereExp;

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode ANY() {
            return getToken(Cypher6Parser.ANY, 0);
        }

        public TerminalNode NONE() {
            return getToken(Cypher6Parser.NONE, 0);
        }

        public TerminalNode SINGLE() {
            return getToken(Cypher6Parser.SINGLE, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ListItemsPredicateContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_listItemsPredicate;
        }
    }

    public final ListItemsPredicateContext listItemsPredicate() throws RecognitionException {
        ListItemsPredicateContext _localctx = new ListItemsPredicateContext(_ctx, getState());
        enterRule(_localctx, 226, RULE_listItemsPredicate);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1714);
                _la = _input.LA(1);
                if (!(_la == ALL || _la == ANY || _la == NONE || _la == SINGLE)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(1715);
                match(LPAREN);
                setState(1716);
                variable();
                setState(1717);
                match(IN);
                setState(1718);
                ((ListItemsPredicateContext) _localctx).inExp = expression();
                setState(1721);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(1719);
                        match(WHERE);
                        setState(1720);
                        ((ListItemsPredicateContext) _localctx).whereExp = expression();
                    }
                }

                setState(1723);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NormalizeFunctionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NORMALIZE() {
            return getToken(Cypher6Parser.NORMALIZE, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode COMMA() {
            return getToken(Cypher6Parser.COMMA, 0);
        }

        public NormalFormContext normalForm() {
            return getRuleContext(NormalFormContext.class, 0);
        }

        public NormalizeFunctionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_normalizeFunction;
        }
    }

    public final NormalizeFunctionContext normalizeFunction() throws RecognitionException {
        NormalizeFunctionContext _localctx = new NormalizeFunctionContext(_ctx, getState());
        enterRule(_localctx, 228, RULE_normalizeFunction);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1725);
                match(NORMALIZE);
                setState(1726);
                match(LPAREN);
                setState(1727);
                expression();
                setState(1730);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == COMMA) {
                    {
                        setState(1728);
                        match(COMMA);
                        setState(1729);
                        normalForm();
                    }
                }

                setState(1732);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TrimFunctionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext trimCharacterString;
        public ExpressionContext trimSource;

        public TerminalNode TRIM() {
            return getToken(Cypher6Parser.TRIM, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public TerminalNode FROM() {
            return getToken(Cypher6Parser.FROM, 0);
        }

        public TerminalNode BOTH() {
            return getToken(Cypher6Parser.BOTH, 0);
        }

        public TerminalNode LEADING() {
            return getToken(Cypher6Parser.LEADING, 0);
        }

        public TerminalNode TRAILING() {
            return getToken(Cypher6Parser.TRAILING, 0);
        }

        public TrimFunctionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_trimFunction;
        }
    }

    public final TrimFunctionContext trimFunction() throws RecognitionException {
        TrimFunctionContext _localctx = new TrimFunctionContext(_ctx, getState());
        enterRule(_localctx, 230, RULE_trimFunction);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1734);
                match(TRIM);
                setState(1735);
                match(LPAREN);
                setState(1743);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 168, _ctx)) {
                    case 1:
                        {
                            setState(1737);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 166, _ctx)) {
                                case 1:
                                    {
                                        setState(1736);
                                        _la = _input.LA(1);
                                        if (!(_la == BOTH || _la == LEADING || _la == TRAILING)) {
                                            _errHandler.recoverInline(this);
                                        } else {
                                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                            _errHandler.reportMatch(this);
                                            consume();
                                        }
                                    }
                                    break;
                            }
                            setState(1740);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 167, _ctx)) {
                                case 1:
                                    {
                                        setState(1739);
                                        ((TrimFunctionContext) _localctx).trimCharacterString = expression();
                                    }
                                    break;
                            }
                            setState(1742);
                            match(FROM);
                        }
                        break;
                }
                setState(1745);
                ((TrimFunctionContext) _localctx).trimSource = expression();
                setState(1746);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PatternExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public PathPatternNonEmptyContext pathPatternNonEmpty() {
            return getRuleContext(PathPatternNonEmptyContext.class, 0);
        }

        public PatternExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_patternExpression;
        }
    }

    public final PatternExpressionContext patternExpression() throws RecognitionException {
        PatternExpressionContext _localctx = new PatternExpressionContext(_ctx, getState());
        enterRule(_localctx, 232, RULE_patternExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1748);
                pathPatternNonEmpty();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShortestPathExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ShortestPathPatternContext shortestPathPattern() {
            return getRuleContext(ShortestPathPatternContext.class, 0);
        }

        public ShortestPathExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_shortestPathExpression;
        }
    }

    public final ShortestPathExpressionContext shortestPathExpression() throws RecognitionException {
        ShortestPathExpressionContext _localctx = new ShortestPathExpressionContext(_ctx, getState());
        enterRule(_localctx, 234, RULE_shortestPathExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1750);
                shortestPathPattern();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ParenthesizedExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public ParenthesizedExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_parenthesizedExpression;
        }
    }

    public final ParenthesizedExpressionContext parenthesizedExpression() throws RecognitionException {
        ParenthesizedExpressionContext _localctx = new ParenthesizedExpressionContext(_ctx, getState());
        enterRule(_localctx, 236, RULE_parenthesizedExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1752);
                match(LPAREN);
                setState(1753);
                expression();
                setState(1754);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class MapProjectionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public List<MapProjectionElementContext> mapProjectionElement() {
            return getRuleContexts(MapProjectionElementContext.class);
        }

        public MapProjectionElementContext mapProjectionElement(int i) {
            return getRuleContext(MapProjectionElementContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public MapProjectionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_mapProjection;
        }
    }

    public final MapProjectionContext mapProjection() throws RecognitionException {
        MapProjectionContext _localctx = new MapProjectionContext(_ctx, getState());
        enterRule(_localctx, 238, RULE_mapProjection);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1756);
                variable();
                setState(1757);
                match(LCURLY);
                setState(1766);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839182848L) != 0)
                        || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239954945L) != 0)
                        || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -8078356481L) != 0)
                        || ((((_la - 194)) & ~0x3f) == 0 && ((1L << (_la - 194)) & -35321813245957L) != 0)
                        || ((((_la - 258)) & ~0x3f) == 0 && ((1L << (_la - 258)) & 8796093022175L) != 0)) {
                    {
                        setState(1758);
                        mapProjectionElement();
                        setState(1763);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        while (_la == COMMA) {
                            {
                                {
                                    setState(1759);
                                    match(COMMA);
                                    setState(1760);
                                    mapProjectionElement();
                                }
                            }
                            setState(1765);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                        }
                    }
                }

                setState(1768);
                match(RCURLY);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class MapProjectionElementContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public PropertyKeyNameContext propertyKeyName() {
            return getRuleContext(PropertyKeyNameContext.class, 0);
        }

        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public PropertyContext property() {
            return getRuleContext(PropertyContext.class, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode DOT() {
            return getToken(Cypher6Parser.DOT, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public MapProjectionElementContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_mapProjectionElement;
        }
    }

    public final MapProjectionElementContext mapProjectionElement() throws RecognitionException {
        MapProjectionElementContext _localctx = new MapProjectionElementContext(_ctx, getState());
        enterRule(_localctx, 240, RULE_mapProjectionElement);
        try {
            setState(1778);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 171, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1770);
                        propertyKeyName();
                        setState(1771);
                        match(COLON);
                        setState(1772);
                        expression();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1774);
                        property();
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1775);
                        variable();
                    }
                    break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1776);
                        match(DOT);
                        setState(1777);
                        match(TIMES);
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CountStarContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COUNT() {
            return getToken(Cypher6Parser.COUNT, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public CountStarContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_countStar;
        }
    }

    public final CountStarContext countStar() throws RecognitionException {
        CountStarContext _localctx = new CountStarContext(_ctx, getState());
        enterRule(_localctx, 242, RULE_countStar);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1780);
                match(COUNT);
                setState(1781);
                match(LPAREN);
                setState(1782);
                match(TIMES);
                setState(1783);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExistsExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public RegularQueryContext regularQuery() {
            return getRuleContext(RegularQueryContext.class, 0);
        }

        public PatternListContext patternList() {
            return getRuleContext(PatternListContext.class, 0);
        }

        public MatchModeContext matchMode() {
            return getRuleContext(MatchModeContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public ExistsExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_existsExpression;
        }
    }

    public final ExistsExpressionContext existsExpression() throws RecognitionException {
        ExistsExpressionContext _localctx = new ExistsExpressionContext(_ctx, getState());
        enterRule(_localctx, 244, RULE_existsExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1785);
                match(EXISTS);
                setState(1786);
                match(LCURLY);
                setState(1795);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 174, _ctx)) {
                    case 1:
                        {
                            setState(1787);
                            regularQuery();
                        }
                        break;
                    case 2:
                        {
                            setState(1789);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 172, _ctx)) {
                                case 1:
                                    {
                                        setState(1788);
                                        matchMode();
                                    }
                                    break;
                            }
                            setState(1791);
                            patternList();
                            setState(1793);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == WHERE) {
                                {
                                    setState(1792);
                                    whereClause();
                                }
                            }
                        }
                        break;
                }
                setState(1797);
                match(RCURLY);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CountExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COUNT() {
            return getToken(Cypher6Parser.COUNT, 0);
        }

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public RegularQueryContext regularQuery() {
            return getRuleContext(RegularQueryContext.class, 0);
        }

        public PatternListContext patternList() {
            return getRuleContext(PatternListContext.class, 0);
        }

        public MatchModeContext matchMode() {
            return getRuleContext(MatchModeContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public CountExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_countExpression;
        }
    }

    public final CountExpressionContext countExpression() throws RecognitionException {
        CountExpressionContext _localctx = new CountExpressionContext(_ctx, getState());
        enterRule(_localctx, 246, RULE_countExpression);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1799);
                match(COUNT);
                setState(1800);
                match(LCURLY);
                setState(1809);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 177, _ctx)) {
                    case 1:
                        {
                            setState(1801);
                            regularQuery();
                        }
                        break;
                    case 2:
                        {
                            setState(1803);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 175, _ctx)) {
                                case 1:
                                    {
                                        setState(1802);
                                        matchMode();
                                    }
                                    break;
                            }
                            setState(1805);
                            patternList();
                            setState(1807);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == WHERE) {
                                {
                                    setState(1806);
                                    whereClause();
                                }
                            }
                        }
                        break;
                }
                setState(1811);
                match(RCURLY);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CollectExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode COLLECT() {
            return getToken(Cypher6Parser.COLLECT, 0);
        }

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public RegularQueryContext regularQuery() {
            return getRuleContext(RegularQueryContext.class, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public CollectExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_collectExpression;
        }
    }

    public final CollectExpressionContext collectExpression() throws RecognitionException {
        CollectExpressionContext _localctx = new CollectExpressionContext(_ctx, getState());
        enterRule(_localctx, 248, RULE_collectExpression);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1813);
                match(COLLECT);
                setState(1814);
                match(LCURLY);
                setState(1815);
                regularQuery();
                setState(1816);
                match(RCURLY);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NumberLiteralContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DECIMAL_DOUBLE() {
            return getToken(Cypher6Parser.DECIMAL_DOUBLE, 0);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, 0);
        }

        public TerminalNode UNSIGNED_HEX_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_HEX_INTEGER, 0);
        }

        public TerminalNode UNSIGNED_OCTAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_OCTAL_INTEGER, 0);
        }

        public TerminalNode MINUS() {
            return getToken(Cypher6Parser.MINUS, 0);
        }

        public NumberLiteralContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_numberLiteral;
        }
    }

    public final NumberLiteralContext numberLiteral() throws RecognitionException {
        NumberLiteralContext _localctx = new NumberLiteralContext(_ctx, getState());
        enterRule(_localctx, 250, RULE_numberLiteral);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1819);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == MINUS) {
                    {
                        setState(1818);
                        match(MINUS);
                    }
                }

                setState(1821);
                _la = _input.LA(1);
                if (!((((_la) & ~0x3f) == 0 && ((1L << _la) & 240L) != 0))) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SignedIntegerLiteralContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode UNSIGNED_DECIMAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, 0);
        }

        public TerminalNode MINUS() {
            return getToken(Cypher6Parser.MINUS, 0);
        }

        public SignedIntegerLiteralContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_signedIntegerLiteral;
        }
    }

    public final SignedIntegerLiteralContext signedIntegerLiteral() throws RecognitionException {
        SignedIntegerLiteralContext _localctx = new SignedIntegerLiteralContext(_ctx, getState());
        enterRule(_localctx, 252, RULE_signedIntegerLiteral);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1824);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == MINUS) {
                    {
                        setState(1823);
                        match(MINUS);
                    }
                }

                setState(1826);
                match(UNSIGNED_DECIMAL_INTEGER);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ListLiteralContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public List<ExpressionContext> expression() {
            return getRuleContexts(ExpressionContext.class);
        }

        public ExpressionContext expression(int i) {
            return getRuleContext(ExpressionContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public ListLiteralContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_listLiteral;
        }
    }

    public final ListLiteralContext listLiteral() throws RecognitionException {
        ListLiteralContext _localctx = new ListLiteralContext(_ctx, getState());
        enterRule(_localctx, 254, RULE_listLiteral);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1828);
                match(LBRACKET);
                setState(1837);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839181840L) != 0)
                        || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239983617L) != 0)
                        || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -7533047809L) != 0)
                        || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & -141287252983827L) != 0)
                        || ((((_la - 256)) & ~0x3f) == 0 && ((1L << (_la - 256)) & 35184372088703L) != 0)) {
                    {
                        setState(1829);
                        expression();
                        setState(1834);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        while (_la == COMMA) {
                            {
                                {
                                    setState(1830);
                                    match(COMMA);
                                    setState(1831);
                                    expression();
                                }
                            }
                            setState(1836);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                        }
                    }
                }

                setState(1839);
                match(RBRACKET);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertyKeyNameContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public PropertyKeyNameContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_propertyKeyName;
        }
    }

    public final PropertyKeyNameContext propertyKeyName() throws RecognitionException {
        PropertyKeyNameContext _localctx = new PropertyKeyNameContext(_ctx, getState());
        enterRule(_localctx, 256, RULE_propertyKeyName);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1841);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ParameterContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public String paramType;

        public TerminalNode DOLLAR() {
            return getToken(Cypher6Parser.DOLLAR, 0);
        }

        public ParameterNameContext parameterName() {
            return getRuleContext(ParameterNameContext.class, 0);
        }

        public ParameterContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ParameterContext(ParserRuleContext parent, int invokingState, String paramType) {
            super(parent, invokingState);
            this.paramType = paramType;
        }

        @Override
        public int getRuleIndex() {
            return RULE_parameter;
        }
    }

    public final ParameterContext parameter(String paramType) throws RecognitionException {
        ParameterContext _localctx = new ParameterContext(_ctx, getState(), paramType);
        enterRule(_localctx, 258, RULE_parameter);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1843);
                match(DOLLAR);
                setState(1844);
                parameterName(paramType);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ParameterNameContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public String paramType;

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public TerminalNode UNSIGNED_DECIMAL_INTEGER() {
            return getToken(Cypher6Parser.UNSIGNED_DECIMAL_INTEGER, 0);
        }

        public ParameterNameContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        public ParameterNameContext(ParserRuleContext parent, int invokingState, String paramType) {
            super(parent, invokingState);
            this.paramType = paramType;
        }

        @Override
        public int getRuleIndex() {
            return RULE_parameterName;
        }
    }

    public final ParameterNameContext parameterName(String paramType) throws RecognitionException {
        ParameterNameContext _localctx = new ParameterNameContext(_ctx, getState(), paramType);
        enterRule(_localctx, 260, RULE_parameterName);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1848);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(1846);
                            symbolicNameString();
                        }
                        break;
                    case UNSIGNED_DECIMAL_INTEGER:
                        {
                            setState(1847);
                            match(UNSIGNED_DECIMAL_INTEGER);
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FunctionInvocationContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public FunctionNameContext functionName() {
            return getRuleContext(FunctionNameContext.class, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public List<FunctionArgumentContext> functionArgument() {
            return getRuleContexts(FunctionArgumentContext.class);
        }

        public FunctionArgumentContext functionArgument(int i) {
            return getRuleContext(FunctionArgumentContext.class, i);
        }

        public TerminalNode DISTINCT() {
            return getToken(Cypher6Parser.DISTINCT, 0);
        }

        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public FunctionInvocationContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_functionInvocation;
        }
    }

    public final FunctionInvocationContext functionInvocation() throws RecognitionException {
        FunctionInvocationContext _localctx = new FunctionInvocationContext(_ctx, getState());
        enterRule(_localctx, 262, RULE_functionInvocation);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1850);
                functionName();
                setState(1851);
                match(LPAREN);
                setState(1853);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 183, _ctx)) {
                    case 1:
                        {
                            setState(1852);
                            _la = _input.LA(1);
                            if (!(_la == ALL || _la == DISTINCT)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                        }
                        break;
                }
                setState(1863);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if ((((_la) & ~0x3f) == 0 && ((1L << _la) & -123145839181840L) != 0)
                        || ((((_la - 64)) & ~0x3f) == 0 && ((1L << (_la - 64)) & -73183498239983617L) != 0)
                        || ((((_la - 128)) & ~0x3f) == 0 && ((1L << (_la - 128)) & -7533047809L) != 0)
                        || ((((_la - 192)) & ~0x3f) == 0 && ((1L << (_la - 192)) & -141287252983827L) != 0)
                        || ((((_la - 256)) & ~0x3f) == 0 && ((1L << (_la - 256)) & 35184372088703L) != 0)) {
                    {
                        setState(1855);
                        functionArgument();
                        setState(1860);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        while (_la == COMMA) {
                            {
                                {
                                    setState(1856);
                                    match(COMMA);
                                    setState(1857);
                                    functionArgument();
                                }
                            }
                            setState(1862);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                        }
                    }
                }

                setState(1865);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FunctionArgumentContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public FunctionArgumentContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_functionArgument;
        }
    }

    public final FunctionArgumentContext functionArgument() throws RecognitionException {
        FunctionArgumentContext _localctx = new FunctionArgumentContext(_ctx, getState());
        enterRule(_localctx, 264, RULE_functionArgument);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1867);
                expression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FunctionNameContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public NamespaceContext namespace() {
            return getRuleContext(NamespaceContext.class, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public FunctionNameContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_functionName;
        }
    }

    public final FunctionNameContext functionName() throws RecognitionException {
        FunctionNameContext _localctx = new FunctionNameContext(_ctx, getState());
        enterRule(_localctx, 266, RULE_functionName);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1869);
                namespace();
                setState(1870);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NamespaceContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public List<TerminalNode> DOT() {
            return getTokens(Cypher6Parser.DOT);
        }

        public TerminalNode DOT(int i) {
            return getToken(Cypher6Parser.DOT, i);
        }

        public NamespaceContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_namespace;
        }
    }

    public final NamespaceContext namespace() throws RecognitionException {
        NamespaceContext _localctx = new NamespaceContext(_ctx, getState());
        enterRule(_localctx, 268, RULE_namespace);
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1877);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 186, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1872);
                                symbolicNameString();
                                setState(1873);
                                match(DOT);
                            }
                        }
                    }
                    setState(1879);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 186, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class VariableContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public VariableContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_variable;
        }
    }

    public final VariableContext variable() throws RecognitionException {
        VariableContext _localctx = new VariableContext(_ctx, getState());
        enterRule(_localctx, 270, RULE_variable);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1880);
                symbolicNameString();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NonEmptyNameListContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public NonEmptyNameListContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_nonEmptyNameList;
        }
    }

    public final NonEmptyNameListContext nonEmptyNameList() throws RecognitionException {
        NonEmptyNameListContext _localctx = new NonEmptyNameListContext(_ctx, getState());
        enterRule(_localctx, 272, RULE_nonEmptyNameList);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1882);
                symbolicNameString();
                setState(1887);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(1883);
                            match(COMMA);
                            setState(1884);
                            symbolicNameString();
                        }
                    }
                    setState(1889);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<TypePartContext> typePart() {
            return getRuleContexts(TypePartContext.class);
        }

        public TypePartContext typePart(int i) {
            return getRuleContext(TypePartContext.class, i);
        }

        public List<TerminalNode> BAR() {
            return getTokens(Cypher6Parser.BAR);
        }

        public TerminalNode BAR(int i) {
            return getToken(Cypher6Parser.BAR, i);
        }

        public TypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_type;
        }
    }

    public final TypeContext type() throws RecognitionException {
        TypeContext _localctx = new TypeContext(_ctx, getState());
        enterRule(_localctx, 274, RULE_type);
        try {
            int _alt;
            enterOuterAlt(_localctx, 1);
            {
                setState(1890);
                typePart();
                setState(1895);
                _errHandler.sync(this);
                _alt = getInterpreter().adaptivePredict(_input, 188, _ctx);
                while (_alt != 2 && _alt != org.antlr.v4.runtime.atn.ATN.INVALID_ALT_NUMBER) {
                    if (_alt == 1) {
                        {
                            {
                                setState(1891);
                                match(BAR);
                                setState(1892);
                                typePart();
                            }
                        }
                    }
                    setState(1897);
                    _errHandler.sync(this);
                    _alt = getInterpreter().adaptivePredict(_input, 188, _ctx);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TypePartContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TypeNameContext typeName() {
            return getRuleContext(TypeNameContext.class, 0);
        }

        public TypeNullabilityContext typeNullability() {
            return getRuleContext(TypeNullabilityContext.class, 0);
        }

        public List<TypeListSuffixContext> typeListSuffix() {
            return getRuleContexts(TypeListSuffixContext.class);
        }

        public TypeListSuffixContext typeListSuffix(int i) {
            return getRuleContext(TypeListSuffixContext.class, i);
        }

        public TypePartContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_typePart;
        }
    }

    public final TypePartContext typePart() throws RecognitionException {
        TypePartContext _localctx = new TypePartContext(_ctx, getState());
        enterRule(_localctx, 276, RULE_typePart);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1898);
                typeName();
                setState(1900);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == EXCLAMATION_MARK || _la == NOT) {
                    {
                        setState(1899);
                        typeNullability();
                    }
                }

                setState(1905);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == ARRAY || _la == LIST) {
                    {
                        {
                            setState(1902);
                            typeListSuffix();
                        }
                    }
                    setState(1907);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TypeNameContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NOTHING() {
            return getToken(Cypher6Parser.NOTHING, 0);
        }

        public TerminalNode NULL() {
            return getToken(Cypher6Parser.NULL, 0);
        }

        public TerminalNode BOOL() {
            return getToken(Cypher6Parser.BOOL, 0);
        }

        public TerminalNode BOOLEAN() {
            return getToken(Cypher6Parser.BOOLEAN, 0);
        }

        public TerminalNode VARCHAR() {
            return getToken(Cypher6Parser.VARCHAR, 0);
        }

        public TerminalNode STRING() {
            return getToken(Cypher6Parser.STRING, 0);
        }

        public TerminalNode INT() {
            return getToken(Cypher6Parser.INT, 0);
        }

        public TerminalNode INTEGER() {
            return getToken(Cypher6Parser.INTEGER, 0);
        }

        public TerminalNode SIGNED() {
            return getToken(Cypher6Parser.SIGNED, 0);
        }

        public TerminalNode FLOAT() {
            return getToken(Cypher6Parser.FLOAT, 0);
        }

        public TerminalNode DATE() {
            return getToken(Cypher6Parser.DATE, 0);
        }

        public TerminalNode LOCAL() {
            return getToken(Cypher6Parser.LOCAL, 0);
        }

        public List<TerminalNode> TIME() {
            return getTokens(Cypher6Parser.TIME);
        }

        public TerminalNode TIME(int i) {
            return getToken(Cypher6Parser.TIME, i);
        }

        public TerminalNode DATETIME() {
            return getToken(Cypher6Parser.DATETIME, 0);
        }

        public TerminalNode ZONED() {
            return getToken(Cypher6Parser.ZONED, 0);
        }

        public TerminalNode WITHOUT() {
            return getToken(Cypher6Parser.WITHOUT, 0);
        }

        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public TerminalNode TIMEZONE() {
            return getToken(Cypher6Parser.TIMEZONE, 0);
        }

        public TerminalNode ZONE() {
            return getToken(Cypher6Parser.ZONE, 0);
        }

        public TerminalNode TIMESTAMP() {
            return getToken(Cypher6Parser.TIMESTAMP, 0);
        }

        public TerminalNode DURATION() {
            return getToken(Cypher6Parser.DURATION, 0);
        }

        public TerminalNode POINT() {
            return getToken(Cypher6Parser.POINT, 0);
        }

        public TerminalNode NODE() {
            return getToken(Cypher6Parser.NODE, 0);
        }

        public TerminalNode VERTEX() {
            return getToken(Cypher6Parser.VERTEX, 0);
        }

        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public TerminalNode EDGE() {
            return getToken(Cypher6Parser.EDGE, 0);
        }

        public TerminalNode MAP() {
            return getToken(Cypher6Parser.MAP, 0);
        }

        public TerminalNode LT() {
            return getToken(Cypher6Parser.LT, 0);
        }

        public TypeContext type() {
            return getRuleContext(TypeContext.class, 0);
        }

        public TerminalNode GT() {
            return getToken(Cypher6Parser.GT, 0);
        }

        public TerminalNode LIST() {
            return getToken(Cypher6Parser.LIST, 0);
        }

        public TerminalNode ARRAY() {
            return getToken(Cypher6Parser.ARRAY, 0);
        }

        public TerminalNode PATH() {
            return getToken(Cypher6Parser.PATH, 0);
        }

        public TerminalNode PATHS() {
            return getToken(Cypher6Parser.PATHS, 0);
        }

        public TerminalNode PROPERTY() {
            return getToken(Cypher6Parser.PROPERTY, 0);
        }

        public TerminalNode VALUE() {
            return getToken(Cypher6Parser.VALUE, 0);
        }

        public TerminalNode ANY() {
            return getToken(Cypher6Parser.ANY, 0);
        }

        public TypeNameContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_typeName;
        }
    }

    public final TypeNameContext typeName() throws RecognitionException {
        TypeNameContext _localctx = new TypeNameContext(_ctx, getState());
        enterRule(_localctx, 278, RULE_typeName);
        int _la;
        try {
            setState(1973);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case NOTHING:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1908);
                        match(NOTHING);
                    }
                    break;
                case NULL:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1909);
                        match(NULL);
                    }
                    break;
                case BOOL:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(1910);
                        match(BOOL);
                    }
                    break;
                case BOOLEAN:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(1911);
                        match(BOOLEAN);
                    }
                    break;
                case VARCHAR:
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(1912);
                        match(VARCHAR);
                    }
                    break;
                case STRING:
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(1913);
                        match(STRING);
                    }
                    break;
                case INT:
                    enterOuterAlt(_localctx, 7);
                    {
                        setState(1914);
                        match(INT);
                    }
                    break;
                case INTEGER:
                case SIGNED:
                    enterOuterAlt(_localctx, 8);
                    {
                        setState(1916);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == SIGNED) {
                            {
                                setState(1915);
                                match(SIGNED);
                            }
                        }

                        setState(1918);
                        match(INTEGER);
                    }
                    break;
                case FLOAT:
                    enterOuterAlt(_localctx, 9);
                    {
                        setState(1919);
                        match(FLOAT);
                    }
                    break;
                case DATE:
                    enterOuterAlt(_localctx, 10);
                    {
                        setState(1920);
                        match(DATE);
                    }
                    break;
                case LOCAL:
                    enterOuterAlt(_localctx, 11);
                    {
                        setState(1921);
                        match(LOCAL);
                        setState(1922);
                        _la = _input.LA(1);
                        if (!(_la == DATETIME || _la == TIME)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                    break;
                case ZONED:
                    enterOuterAlt(_localctx, 12);
                    {
                        setState(1923);
                        match(ZONED);
                        setState(1924);
                        _la = _input.LA(1);
                        if (!(_la == DATETIME || _la == TIME)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                    break;
                case TIME:
                    enterOuterAlt(_localctx, 13);
                    {
                        setState(1925);
                        match(TIME);
                        setState(1926);
                        _la = _input.LA(1);
                        if (!(_la == WITH || _la == WITHOUT)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(1930);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case TIMEZONE:
                                {
                                    setState(1927);
                                    match(TIMEZONE);
                                }
                                break;
                            case TIME:
                                {
                                    setState(1928);
                                    match(TIME);
                                    setState(1929);
                                    match(ZONE);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    break;
                case TIMESTAMP:
                    enterOuterAlt(_localctx, 14);
                    {
                        setState(1932);
                        match(TIMESTAMP);
                        setState(1933);
                        _la = _input.LA(1);
                        if (!(_la == WITH || _la == WITHOUT)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(1937);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case TIMEZONE:
                                {
                                    setState(1934);
                                    match(TIMEZONE);
                                }
                                break;
                            case TIME:
                                {
                                    setState(1935);
                                    match(TIME);
                                    setState(1936);
                                    match(ZONE);
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    break;
                case DURATION:
                    enterOuterAlt(_localctx, 15);
                    {
                        setState(1939);
                        match(DURATION);
                    }
                    break;
                case POINT:
                    enterOuterAlt(_localctx, 16);
                    {
                        setState(1940);
                        match(POINT);
                    }
                    break;
                case NODE:
                    enterOuterAlt(_localctx, 17);
                    {
                        setState(1941);
                        match(NODE);
                    }
                    break;
                case VERTEX:
                    enterOuterAlt(_localctx, 18);
                    {
                        setState(1942);
                        match(VERTEX);
                    }
                    break;
                case RELATIONSHIP:
                    enterOuterAlt(_localctx, 19);
                    {
                        setState(1943);
                        match(RELATIONSHIP);
                    }
                    break;
                case EDGE:
                    enterOuterAlt(_localctx, 20);
                    {
                        setState(1944);
                        match(EDGE);
                    }
                    break;
                case MAP:
                    enterOuterAlt(_localctx, 21);
                    {
                        setState(1945);
                        match(MAP);
                    }
                    break;
                case ARRAY:
                case LIST:
                    enterOuterAlt(_localctx, 22);
                    {
                        setState(1946);
                        _la = _input.LA(1);
                        if (!(_la == ARRAY || _la == LIST)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(1947);
                        match(LT);
                        setState(1948);
                        type();
                        setState(1949);
                        match(GT);
                    }
                    break;
                case PATH:
                    enterOuterAlt(_localctx, 23);
                    {
                        setState(1951);
                        match(PATH);
                    }
                    break;
                case PATHS:
                    enterOuterAlt(_localctx, 24);
                    {
                        setState(1952);
                        match(PATHS);
                    }
                    break;
                case PROPERTY:
                    enterOuterAlt(_localctx, 25);
                    {
                        setState(1953);
                        match(PROPERTY);
                        setState(1954);
                        match(VALUE);
                    }
                    break;
                case ANY:
                    enterOuterAlt(_localctx, 26);
                    {
                        setState(1955);
                        match(ANY);
                        setState(1971);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 195, _ctx)) {
                            case 1:
                                {
                                    setState(1956);
                                    match(NODE);
                                }
                                break;
                            case 2:
                                {
                                    setState(1957);
                                    match(VERTEX);
                                }
                                break;
                            case 3:
                                {
                                    setState(1958);
                                    match(RELATIONSHIP);
                                }
                                break;
                            case 4:
                                {
                                    setState(1959);
                                    match(EDGE);
                                }
                                break;
                            case 5:
                                {
                                    setState(1960);
                                    match(MAP);
                                }
                                break;
                            case 6:
                                {
                                    setState(1961);
                                    match(PROPERTY);
                                    setState(1962);
                                    match(VALUE);
                                }
                                break;
                            case 7:
                                {
                                    setState(1964);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    if (_la == VALUE) {
                                        {
                                            setState(1963);
                                            match(VALUE);
                                        }
                                    }

                                    setState(1966);
                                    match(LT);
                                    setState(1967);
                                    type();
                                    setState(1968);
                                    match(GT);
                                }
                                break;
                            case 8:
                                {
                                    setState(1970);
                                    match(VALUE);
                                }
                                break;
                        }
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TypeNullabilityContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode NULL() {
            return getToken(Cypher6Parser.NULL, 0);
        }

        public TerminalNode EXCLAMATION_MARK() {
            return getToken(Cypher6Parser.EXCLAMATION_MARK, 0);
        }

        public TypeNullabilityContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_typeNullability;
        }
    }

    public final TypeNullabilityContext typeNullability() throws RecognitionException {
        TypeNullabilityContext _localctx = new TypeNullabilityContext(_ctx, getState());
        enterRule(_localctx, 280, RULE_typeNullability);
        try {
            setState(1978);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case NOT:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(1975);
                        match(NOT);
                        setState(1976);
                        match(NULL);
                    }
                    break;
                case EXCLAMATION_MARK:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(1977);
                        match(EXCLAMATION_MARK);
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TypeListSuffixContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LIST() {
            return getToken(Cypher6Parser.LIST, 0);
        }

        public TerminalNode ARRAY() {
            return getToken(Cypher6Parser.ARRAY, 0);
        }

        public TypeNullabilityContext typeNullability() {
            return getRuleContext(TypeNullabilityContext.class, 0);
        }

        public TypeListSuffixContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_typeListSuffix;
        }
    }

    public final TypeListSuffixContext typeListSuffix() throws RecognitionException {
        TypeListSuffixContext _localctx = new TypeListSuffixContext(_ctx, getState());
        enterRule(_localctx, 282, RULE_typeListSuffix);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1980);
                _la = _input.LA(1);
                if (!(_la == ARRAY || _la == LIST)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(1982);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == EXCLAMATION_MARK || _la == NOT) {
                    {
                        setState(1981);
                        typeNullability();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public CreateCommandContext createCommand() {
            return getRuleContext(CreateCommandContext.class, 0);
        }

        public DropCommandContext dropCommand() {
            return getRuleContext(DropCommandContext.class, 0);
        }

        public AlterCommandContext alterCommand() {
            return getRuleContext(AlterCommandContext.class, 0);
        }

        public RenameCommandContext renameCommand() {
            return getRuleContext(RenameCommandContext.class, 0);
        }

        public DenyCommandContext denyCommand() {
            return getRuleContext(DenyCommandContext.class, 0);
        }

        public RevokeCommandContext revokeCommand() {
            return getRuleContext(RevokeCommandContext.class, 0);
        }

        public GrantCommandContext grantCommand() {
            return getRuleContext(GrantCommandContext.class, 0);
        }

        public StartDatabaseContext startDatabase() {
            return getRuleContext(StartDatabaseContext.class, 0);
        }

        public StopDatabaseContext stopDatabase() {
            return getRuleContext(StopDatabaseContext.class, 0);
        }

        public EnableServerCommandContext enableServerCommand() {
            return getRuleContext(EnableServerCommandContext.class, 0);
        }

        public AllocationCommandContext allocationCommand() {
            return getRuleContext(AllocationCommandContext.class, 0);
        }

        public ShowCommandContext showCommand() {
            return getRuleContext(ShowCommandContext.class, 0);
        }

        public TerminateCommandContext terminateCommand() {
            return getRuleContext(TerminateCommandContext.class, 0);
        }

        public UseClauseContext useClause() {
            return getRuleContext(UseClauseContext.class, 0);
        }

        public CommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_command;
        }
    }

    public final CommandContext command() throws RecognitionException {
        CommandContext _localctx = new CommandContext(_ctx, getState());
        enterRule(_localctx, 284, RULE_command);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(1985);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == USE) {
                    {
                        setState(1984);
                        useClause();
                    }
                }

                setState(2000);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case CREATE:
                        {
                            setState(1987);
                            createCommand();
                        }
                        break;
                    case DROP:
                        {
                            setState(1988);
                            dropCommand();
                        }
                        break;
                    case ALTER:
                        {
                            setState(1989);
                            alterCommand();
                        }
                        break;
                    case RENAME:
                        {
                            setState(1990);
                            renameCommand();
                        }
                        break;
                    case DENY:
                        {
                            setState(1991);
                            denyCommand();
                        }
                        break;
                    case REVOKE:
                        {
                            setState(1992);
                            revokeCommand();
                        }
                        break;
                    case GRANT:
                        {
                            setState(1993);
                            grantCommand();
                        }
                        break;
                    case START:
                        {
                            setState(1994);
                            startDatabase();
                        }
                        break;
                    case STOP:
                        {
                            setState(1995);
                            stopDatabase();
                        }
                        break;
                    case ENABLE:
                        {
                            setState(1996);
                            enableServerCommand();
                        }
                        break;
                    case DEALLOCATE:
                    case DRYRUN:
                    case REALLOCATE:
                        {
                            setState(1997);
                            allocationCommand();
                        }
                        break;
                    case SHOW:
                        {
                            setState(1998);
                            showCommand();
                        }
                        break;
                    case TERMINATE:
                        {
                            setState(1999);
                            terminateCommand();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CREATE() {
            return getToken(Cypher6Parser.CREATE, 0);
        }

        public CreateAliasContext createAlias() {
            return getRuleContext(CreateAliasContext.class, 0);
        }

        public CreateCompositeDatabaseContext createCompositeDatabase() {
            return getRuleContext(CreateCompositeDatabaseContext.class, 0);
        }

        public CreateConstraintContext createConstraint() {
            return getRuleContext(CreateConstraintContext.class, 0);
        }

        public CreateDatabaseContext createDatabase() {
            return getRuleContext(CreateDatabaseContext.class, 0);
        }

        public CreateIndexContext createIndex() {
            return getRuleContext(CreateIndexContext.class, 0);
        }

        public CreateRoleContext createRole() {
            return getRuleContext(CreateRoleContext.class, 0);
        }

        public CreateUserContext createUser() {
            return getRuleContext(CreateUserContext.class, 0);
        }

        public TerminalNode OR() {
            return getToken(Cypher6Parser.OR, 0);
        }

        public TerminalNode REPLACE() {
            return getToken(Cypher6Parser.REPLACE, 0);
        }

        public CreateCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createCommand;
        }
    }

    public final CreateCommandContext createCommand() throws RecognitionException {
        CreateCommandContext _localctx = new CreateCommandContext(_ctx, getState());
        enterRule(_localctx, 286, RULE_createCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2002);
                match(CREATE);
                setState(2005);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OR) {
                    {
                        setState(2003);
                        match(OR);
                        setState(2004);
                        match(REPLACE);
                    }
                }

                setState(2014);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ALIAS:
                        {
                            setState(2007);
                            createAlias();
                        }
                        break;
                    case COMPOSITE:
                        {
                            setState(2008);
                            createCompositeDatabase();
                        }
                        break;
                    case CONSTRAINT:
                        {
                            setState(2009);
                            createConstraint();
                        }
                        break;
                    case DATABASE:
                        {
                            setState(2010);
                            createDatabase();
                        }
                        break;
                    case BTREE:
                    case FULLTEXT:
                    case INDEX:
                    case LOOKUP:
                    case POINT:
                    case RANGE:
                    case TEXT:
                    case VECTOR:
                        {
                            setState(2011);
                            createIndex();
                        }
                        break;
                    case ROLE:
                        {
                            setState(2012);
                            createRole();
                        }
                        break;
                    case USER:
                        {
                            setState(2013);
                            createUser();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DROP() {
            return getToken(Cypher6Parser.DROP, 0);
        }

        public DropAliasContext dropAlias() {
            return getRuleContext(DropAliasContext.class, 0);
        }

        public DropConstraintContext dropConstraint() {
            return getRuleContext(DropConstraintContext.class, 0);
        }

        public DropDatabaseContext dropDatabase() {
            return getRuleContext(DropDatabaseContext.class, 0);
        }

        public DropIndexContext dropIndex() {
            return getRuleContext(DropIndexContext.class, 0);
        }

        public DropRoleContext dropRole() {
            return getRuleContext(DropRoleContext.class, 0);
        }

        public DropServerContext dropServer() {
            return getRuleContext(DropServerContext.class, 0);
        }

        public DropUserContext dropUser() {
            return getRuleContext(DropUserContext.class, 0);
        }

        public DropCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropCommand;
        }
    }

    public final DropCommandContext dropCommand() throws RecognitionException {
        DropCommandContext _localctx = new DropCommandContext(_ctx, getState());
        enterRule(_localctx, 288, RULE_dropCommand);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2016);
                match(DROP);
                setState(2024);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ALIAS:
                        {
                            setState(2017);
                            dropAlias();
                        }
                        break;
                    case CONSTRAINT:
                        {
                            setState(2018);
                            dropConstraint();
                        }
                        break;
                    case COMPOSITE:
                    case DATABASE:
                        {
                            setState(2019);
                            dropDatabase();
                        }
                        break;
                    case INDEX:
                        {
                            setState(2020);
                            dropIndex();
                        }
                        break;
                    case ROLE:
                        {
                            setState(2021);
                            dropRole();
                        }
                        break;
                    case SERVER:
                        {
                            setState(2022);
                            dropServer();
                        }
                        break;
                    case USER:
                        {
                            setState(2023);
                            dropUser();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SHOW() {
            return getToken(Cypher6Parser.SHOW, 0);
        }

        public ShowAliasesContext showAliases() {
            return getRuleContext(ShowAliasesContext.class, 0);
        }

        public ShowConstraintCommandContext showConstraintCommand() {
            return getRuleContext(ShowConstraintCommandContext.class, 0);
        }

        public ShowCurrentUserContext showCurrentUser() {
            return getRuleContext(ShowCurrentUserContext.class, 0);
        }

        public ShowDatabaseContext showDatabase() {
            return getRuleContext(ShowDatabaseContext.class, 0);
        }

        public ShowFunctionsContext showFunctions() {
            return getRuleContext(ShowFunctionsContext.class, 0);
        }

        public ShowIndexCommandContext showIndexCommand() {
            return getRuleContext(ShowIndexCommandContext.class, 0);
        }

        public ShowPrivilegesContext showPrivileges() {
            return getRuleContext(ShowPrivilegesContext.class, 0);
        }

        public ShowProceduresContext showProcedures() {
            return getRuleContext(ShowProceduresContext.class, 0);
        }

        public ShowRolePrivilegesContext showRolePrivileges() {
            return getRuleContext(ShowRolePrivilegesContext.class, 0);
        }

        public ShowRolesContext showRoles() {
            return getRuleContext(ShowRolesContext.class, 0);
        }

        public ShowServersContext showServers() {
            return getRuleContext(ShowServersContext.class, 0);
        }

        public ShowSettingsContext showSettings() {
            return getRuleContext(ShowSettingsContext.class, 0);
        }

        public ShowSupportedPrivilegesContext showSupportedPrivileges() {
            return getRuleContext(ShowSupportedPrivilegesContext.class, 0);
        }

        public ShowTransactionsContext showTransactions() {
            return getRuleContext(ShowTransactionsContext.class, 0);
        }

        public ShowUserPrivilegesContext showUserPrivileges() {
            return getRuleContext(ShowUserPrivilegesContext.class, 0);
        }

        public ShowUsersContext showUsers() {
            return getRuleContext(ShowUsersContext.class, 0);
        }

        public ShowCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showCommand;
        }
    }

    public final ShowCommandContext showCommand() throws RecognitionException {
        ShowCommandContext _localctx = new ShowCommandContext(_ctx, getState());
        enterRule(_localctx, 290, RULE_showCommand);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2026);
                match(SHOW);
                setState(2043);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 204, _ctx)) {
                    case 1:
                        {
                            setState(2027);
                            showAliases();
                        }
                        break;
                    case 2:
                        {
                            setState(2028);
                            showConstraintCommand();
                        }
                        break;
                    case 3:
                        {
                            setState(2029);
                            showCurrentUser();
                        }
                        break;
                    case 4:
                        {
                            setState(2030);
                            showDatabase();
                        }
                        break;
                    case 5:
                        {
                            setState(2031);
                            showFunctions();
                        }
                        break;
                    case 6:
                        {
                            setState(2032);
                            showIndexCommand();
                        }
                        break;
                    case 7:
                        {
                            setState(2033);
                            showPrivileges();
                        }
                        break;
                    case 8:
                        {
                            setState(2034);
                            showProcedures();
                        }
                        break;
                    case 9:
                        {
                            setState(2035);
                            showRolePrivileges();
                        }
                        break;
                    case 10:
                        {
                            setState(2036);
                            showRoles();
                        }
                        break;
                    case 11:
                        {
                            setState(2037);
                            showServers();
                        }
                        break;
                    case 12:
                        {
                            setState(2038);
                            showSettings();
                        }
                        break;
                    case 13:
                        {
                            setState(2039);
                            showSupportedPrivileges();
                        }
                        break;
                    case 14:
                        {
                            setState(2040);
                            showTransactions();
                        }
                        break;
                    case 15:
                        {
                            setState(2041);
                            showUserPrivileges();
                        }
                        break;
                    case 16:
                        {
                            setState(2042);
                            showUsers();
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowCommandYieldContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public YieldClauseContext yieldClause() {
            return getRuleContext(YieldClauseContext.class, 0);
        }

        public ReturnClauseContext returnClause() {
            return getRuleContext(ReturnClauseContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public ShowCommandYieldContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showCommandYield;
        }
    }

    public final ShowCommandYieldContext showCommandYield() throws RecognitionException {
        ShowCommandYieldContext _localctx = new ShowCommandYieldContext(_ctx, getState());
        enterRule(_localctx, 292, RULE_showCommandYield);
        int _la;
        try {
            setState(2050);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case YIELD:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2045);
                        yieldClause();
                        setState(2047);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == RETURN) {
                            {
                                setState(2046);
                                returnClause();
                            }
                        }
                    }
                    break;
                case WHERE:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2049);
                        whereClause();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class YieldItemContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<VariableContext> variable() {
            return getRuleContexts(VariableContext.class);
        }

        public VariableContext variable(int i) {
            return getRuleContext(VariableContext.class, i);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public YieldItemContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_yieldItem;
        }
    }

    public final YieldItemContext yieldItem() throws RecognitionException {
        YieldItemContext _localctx = new YieldItemContext(_ctx, getState());
        enterRule(_localctx, 294, RULE_yieldItem);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2052);
                variable();
                setState(2055);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(2053);
                        match(AS);
                        setState(2054);
                        variable();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class YieldSkipContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SKIPROWS() {
            return getToken(Cypher6Parser.SKIPROWS, 0);
        }

        public SignedIntegerLiteralContext signedIntegerLiteral() {
            return getRuleContext(SignedIntegerLiteralContext.class, 0);
        }

        public YieldSkipContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_yieldSkip;
        }
    }

    public final YieldSkipContext yieldSkip() throws RecognitionException {
        YieldSkipContext _localctx = new YieldSkipContext(_ctx, getState());
        enterRule(_localctx, 296, RULE_yieldSkip);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2057);
                match(SKIPROWS);
                setState(2058);
                signedIntegerLiteral();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class YieldLimitContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LIMITROWS() {
            return getToken(Cypher6Parser.LIMITROWS, 0);
        }

        public SignedIntegerLiteralContext signedIntegerLiteral() {
            return getRuleContext(SignedIntegerLiteralContext.class, 0);
        }

        public YieldLimitContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_yieldLimit;
        }
    }

    public final YieldLimitContext yieldLimit() throws RecognitionException {
        YieldLimitContext _localctx = new YieldLimitContext(_ctx, getState());
        enterRule(_localctx, 298, RULE_yieldLimit);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2060);
                match(LIMITROWS);
                setState(2061);
                signedIntegerLiteral();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class YieldClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode YIELD() {
            return getToken(Cypher6Parser.YIELD, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public List<YieldItemContext> yieldItem() {
            return getRuleContexts(YieldItemContext.class);
        }

        public YieldItemContext yieldItem(int i) {
            return getRuleContext(YieldItemContext.class, i);
        }

        public OrderByContext orderBy() {
            return getRuleContext(OrderByContext.class, 0);
        }

        public YieldSkipContext yieldSkip() {
            return getRuleContext(YieldSkipContext.class, 0);
        }

        public YieldLimitContext yieldLimit() {
            return getRuleContext(YieldLimitContext.class, 0);
        }

        public WhereClauseContext whereClause() {
            return getRuleContext(WhereClauseContext.class, 0);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public YieldClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_yieldClause;
        }
    }

    public final YieldClauseContext yieldClause() throws RecognitionException {
        YieldClauseContext _localctx = new YieldClauseContext(_ctx, getState());
        enterRule(_localctx, 300, RULE_yieldClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2063);
                match(YIELD);
                setState(2073);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case TIMES:
                        {
                            setState(2064);
                            match(TIMES);
                        }
                        break;
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(2065);
                            yieldItem();
                            setState(2070);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            while (_la == COMMA) {
                                {
                                    {
                                        setState(2066);
                                        match(COMMA);
                                        setState(2067);
                                        yieldItem();
                                    }
                                }
                                setState(2072);
                                _errHandler.sync(this);
                                _la = _input.LA(1);
                            }
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(2076);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ORDER) {
                    {
                        setState(2075);
                        orderBy();
                    }
                }

                setState(2079);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SKIPROWS) {
                    {
                        setState(2078);
                        yieldSkip();
                    }
                }

                setState(2082);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LIMITROWS) {
                    {
                        setState(2081);
                        yieldLimit();
                    }
                }

                setState(2085);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE) {
                    {
                        setState(2084);
                        whereClause();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CommandOptionsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode OPTIONS() {
            return getToken(Cypher6Parser.OPTIONS, 0);
        }

        public MapOrParameterContext mapOrParameter() {
            return getRuleContext(MapOrParameterContext.class, 0);
        }

        public CommandOptionsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_commandOptions;
        }
    }

    public final CommandOptionsContext commandOptions() throws RecognitionException {
        CommandOptionsContext _localctx = new CommandOptionsContext(_ctx, getState());
        enterRule(_localctx, 302, RULE_commandOptions);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2087);
                match(OPTIONS);
                setState(2088);
                mapOrParameter();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TerminateCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode TERMINATE() {
            return getToken(Cypher6Parser.TERMINATE, 0);
        }

        public TerminateTransactionsContext terminateTransactions() {
            return getRuleContext(TerminateTransactionsContext.class, 0);
        }

        public TerminateCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_terminateCommand;
        }
    }

    public final TerminateCommandContext terminateCommand() throws RecognitionException {
        TerminateCommandContext _localctx = new TerminateCommandContext(_ctx, getState());
        enterRule(_localctx, 304, RULE_terminateCommand);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2090);
                match(TERMINATE);
                setState(2091);
                terminateTransactions();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ComposableCommandClausesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminateCommandContext terminateCommand() {
            return getRuleContext(TerminateCommandContext.class, 0);
        }

        public ComposableShowCommandClausesContext composableShowCommandClauses() {
            return getRuleContext(ComposableShowCommandClausesContext.class, 0);
        }

        public ComposableCommandClausesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_composableCommandClauses;
        }
    }

    public final ComposableCommandClausesContext composableCommandClauses() throws RecognitionException {
        ComposableCommandClausesContext _localctx = new ComposableCommandClausesContext(_ctx, getState());
        enterRule(_localctx, 306, RULE_composableCommandClauses);
        try {
            setState(2095);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case TERMINATE:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2093);
                        terminateCommand();
                    }
                    break;
                case SHOW:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2094);
                        composableShowCommandClauses();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ComposableShowCommandClausesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SHOW() {
            return getToken(Cypher6Parser.SHOW, 0);
        }

        public ShowIndexCommandContext showIndexCommand() {
            return getRuleContext(ShowIndexCommandContext.class, 0);
        }

        public ShowConstraintCommandContext showConstraintCommand() {
            return getRuleContext(ShowConstraintCommandContext.class, 0);
        }

        public ShowFunctionsContext showFunctions() {
            return getRuleContext(ShowFunctionsContext.class, 0);
        }

        public ShowProceduresContext showProcedures() {
            return getRuleContext(ShowProceduresContext.class, 0);
        }

        public ShowSettingsContext showSettings() {
            return getRuleContext(ShowSettingsContext.class, 0);
        }

        public ShowTransactionsContext showTransactions() {
            return getRuleContext(ShowTransactionsContext.class, 0);
        }

        public ComposableShowCommandClausesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_composableShowCommandClauses;
        }
    }

    public final ComposableShowCommandClausesContext composableShowCommandClauses() throws RecognitionException {
        ComposableShowCommandClausesContext _localctx = new ComposableShowCommandClausesContext(_ctx, getState());
        enterRule(_localctx, 308, RULE_composableShowCommandClauses);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2097);
                match(SHOW);
                setState(2104);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 215, _ctx)) {
                    case 1:
                        {
                            setState(2098);
                            showIndexCommand();
                        }
                        break;
                    case 2:
                        {
                            setState(2099);
                            showConstraintCommand();
                        }
                        break;
                    case 3:
                        {
                            setState(2100);
                            showFunctions();
                        }
                        break;
                    case 4:
                        {
                            setState(2101);
                            showProcedures();
                        }
                        break;
                    case 5:
                        {
                            setState(2102);
                            showSettings();
                        }
                        break;
                    case 6:
                        {
                            setState(2103);
                            showTransactions();
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowIndexCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ShowIndexesEndContext showIndexesEnd() {
            return getRuleContext(ShowIndexesEndContext.class, 0);
        }

        public ShowIndexTypeContext showIndexType() {
            return getRuleContext(ShowIndexTypeContext.class, 0);
        }

        public ShowIndexCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showIndexCommand;
        }
    }

    public final ShowIndexCommandContext showIndexCommand() throws RecognitionException {
        ShowIndexCommandContext _localctx = new ShowIndexCommandContext(_ctx, getState());
        enterRule(_localctx, 310, RULE_showIndexCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2107);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ALL
                        || _la == BTREE
                        || _la == FULLTEXT
                        || _la == LOOKUP
                        || _la == POINT
                        || _la == RANGE
                        || _la == TEXT
                        || _la == VECTOR) {
                    {
                        setState(2106);
                        showIndexType();
                    }
                }

                setState(2109);
                showIndexesEnd();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowIndexTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode BTREE() {
            return getToken(Cypher6Parser.BTREE, 0);
        }

        public TerminalNode FULLTEXT() {
            return getToken(Cypher6Parser.FULLTEXT, 0);
        }

        public TerminalNode LOOKUP() {
            return getToken(Cypher6Parser.LOOKUP, 0);
        }

        public TerminalNode POINT() {
            return getToken(Cypher6Parser.POINT, 0);
        }

        public TerminalNode RANGE() {
            return getToken(Cypher6Parser.RANGE, 0);
        }

        public TerminalNode TEXT() {
            return getToken(Cypher6Parser.TEXT, 0);
        }

        public TerminalNode VECTOR() {
            return getToken(Cypher6Parser.VECTOR, 0);
        }

        public ShowIndexTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showIndexType;
        }
    }

    public final ShowIndexTypeContext showIndexType() throws RecognitionException {
        ShowIndexTypeContext _localctx = new ShowIndexTypeContext(_ctx, getState());
        enterRule(_localctx, 312, RULE_showIndexType);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2111);
                _la = _input.LA(1);
                if (!(_la == ALL
                        || _la == BTREE
                        || _la == FULLTEXT
                        || _la == LOOKUP
                        || _la == POINT
                        || _la == RANGE
                        || _la == TEXT
                        || _la == VECTOR)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowIndexesEndContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public IndexTokenContext indexToken() {
            return getRuleContext(IndexTokenContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ComposableCommandClausesContext composableCommandClauses() {
            return getRuleContext(ComposableCommandClausesContext.class, 0);
        }

        public ShowIndexesEndContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showIndexesEnd;
        }
    }

    public final ShowIndexesEndContext showIndexesEnd() throws RecognitionException {
        ShowIndexesEndContext _localctx = new ShowIndexesEndContext(_ctx, getState());
        enterRule(_localctx, 314, RULE_showIndexesEnd);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2113);
                indexToken();
                setState(2115);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2114);
                        showCommandYield();
                    }
                }

                setState(2118);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SHOW || _la == TERMINATE) {
                    {
                        setState(2117);
                        composableCommandClauses();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ShowConstraintCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showConstraintCommand;
        }

        public ShowConstraintCommandContext() {}

        public void copyFrom(ShowConstraintCommandContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintUniqueContext extends ShowConstraintCommandContext {
        public ShowConstraintsEndContext showConstraintsEnd() {
            return getRuleContext(ShowConstraintsEndContext.class, 0);
        }

        public TerminalNode UNIQUE() {
            return getToken(Cypher6Parser.UNIQUE, 0);
        }

        public TerminalNode UNIQUENESS() {
            return getToken(Cypher6Parser.UNIQUENESS, 0);
        }

        public ShowConstraintEntityContext showConstraintEntity() {
            return getRuleContext(ShowConstraintEntityContext.class, 0);
        }

        public ShowConstraintUniqueContext(ShowConstraintCommandContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintExistContext extends ShowConstraintCommandContext {
        public ConstraintExistTypeContext constraintExistType() {
            return getRuleContext(ConstraintExistTypeContext.class, 0);
        }

        public ShowConstraintsEndContext showConstraintsEnd() {
            return getRuleContext(ShowConstraintsEndContext.class, 0);
        }

        public ShowConstraintEntityContext showConstraintEntity() {
            return getRuleContext(ShowConstraintEntityContext.class, 0);
        }

        public ShowConstraintExistContext(ShowConstraintCommandContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintAllContext extends ShowConstraintCommandContext {
        public ShowConstraintsEndContext showConstraintsEnd() {
            return getRuleContext(ShowConstraintsEndContext.class, 0);
        }

        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public ShowConstraintAllContext(ShowConstraintCommandContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintKeyContext extends ShowConstraintCommandContext {
        public TerminalNode KEY() {
            return getToken(Cypher6Parser.KEY, 0);
        }

        public ShowConstraintsEndContext showConstraintsEnd() {
            return getRuleContext(ShowConstraintsEndContext.class, 0);
        }

        public ShowConstraintEntityContext showConstraintEntity() {
            return getRuleContext(ShowConstraintEntityContext.class, 0);
        }

        public ShowConstraintKeyContext(ShowConstraintCommandContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintPropTypeContext extends ShowConstraintCommandContext {
        public TerminalNode PROPERTY() {
            return getToken(Cypher6Parser.PROPERTY, 0);
        }

        public TerminalNode TYPE() {
            return getToken(Cypher6Parser.TYPE, 0);
        }

        public ShowConstraintsEndContext showConstraintsEnd() {
            return getRuleContext(ShowConstraintsEndContext.class, 0);
        }

        public ShowConstraintEntityContext showConstraintEntity() {
            return getRuleContext(ShowConstraintEntityContext.class, 0);
        }

        public ShowConstraintPropTypeContext(ShowConstraintCommandContext ctx) {
            copyFrom(ctx);
        }
    }

    public final ShowConstraintCommandContext showConstraintCommand() throws RecognitionException {
        ShowConstraintCommandContext _localctx = new ShowConstraintCommandContext(_ctx, getState());
        enterRule(_localctx, 316, RULE_showConstraintCommand);
        int _la;
        try {
            setState(2146);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 224, _ctx)) {
                case 1:
                    _localctx = new ShowConstraintAllContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2121);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == ALL) {
                            {
                                setState(2120);
                                match(ALL);
                            }
                        }

                        setState(2123);
                        showConstraintsEnd();
                    }
                    break;
                case 2:
                    _localctx = new ShowConstraintExistContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2125);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & 422212465065985L) != 0)) {
                            {
                                setState(2124);
                                showConstraintEntity();
                            }
                        }

                        setState(2127);
                        constraintExistType();
                        setState(2128);
                        showConstraintsEnd();
                    }
                    break;
                case 3:
                    _localctx = new ShowConstraintKeyContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2131);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & 422212465065985L) != 0)) {
                            {
                                setState(2130);
                                showConstraintEntity();
                            }
                        }

                        setState(2133);
                        match(KEY);
                        setState(2134);
                        showConstraintsEnd();
                    }
                    break;
                case 4:
                    _localctx = new ShowConstraintPropTypeContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2136);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & 422212465065985L) != 0)) {
                            {
                                setState(2135);
                                showConstraintEntity();
                            }
                        }

                        setState(2138);
                        match(PROPERTY);
                        setState(2139);
                        match(TYPE);
                        setState(2140);
                        showConstraintsEnd();
                    }
                    break;
                case 5:
                    _localctx = new ShowConstraintUniqueContext(_localctx);
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(2142);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & 422212465065985L) != 0)) {
                            {
                                setState(2141);
                                showConstraintEntity();
                            }
                        }

                        setState(2144);
                        _la = _input.LA(1);
                        if (!(_la == UNIQUE || _la == UNIQUENESS)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(2145);
                        showConstraintsEnd();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintEntityContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ShowConstraintEntityContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showConstraintEntity;
        }

        public ShowConstraintEntityContext() {}

        public void copyFrom(ShowConstraintEntityContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NodeEntityContext extends ShowConstraintEntityContext {
        public TerminalNode NODE() {
            return getToken(Cypher6Parser.NODE, 0);
        }

        public NodeEntityContext(ShowConstraintEntityContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RelEntityContext extends ShowConstraintEntityContext {
        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public TerminalNode REL() {
            return getToken(Cypher6Parser.REL, 0);
        }

        public RelEntityContext(ShowConstraintEntityContext ctx) {
            copyFrom(ctx);
        }
    }

    public final ShowConstraintEntityContext showConstraintEntity() throws RecognitionException {
        ShowConstraintEntityContext _localctx = new ShowConstraintEntityContext(_ctx, getState());
        enterRule(_localctx, 318, RULE_showConstraintEntity);
        int _la;
        try {
            setState(2150);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case NODE:
                    _localctx = new NodeEntityContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2148);
                        match(NODE);
                    }
                    break;
                case REL:
                case RELATIONSHIP:
                    _localctx = new RelEntityContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2149);
                        _la = _input.LA(1);
                        if (!(_la == REL || _la == RELATIONSHIP)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintExistTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode EXISTENCE() {
            return getToken(Cypher6Parser.EXISTENCE, 0);
        }

        public TerminalNode EXIST() {
            return getToken(Cypher6Parser.EXIST, 0);
        }

        public TerminalNode PROPERTY() {
            return getToken(Cypher6Parser.PROPERTY, 0);
        }

        public ConstraintExistTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_constraintExistType;
        }
    }

    public final ConstraintExistTypeContext constraintExistType() throws RecognitionException {
        ConstraintExistTypeContext _localctx = new ConstraintExistTypeContext(_ctx, getState());
        enterRule(_localctx, 320, RULE_constraintExistType);
        try {
            setState(2158);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 226, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2152);
                        match(EXISTENCE);
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2153);
                        match(EXIST);
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2154);
                        match(PROPERTY);
                        setState(2155);
                        match(EXISTENCE);
                    }
                    break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2156);
                        match(PROPERTY);
                        setState(2157);
                        match(EXIST);
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowConstraintsEndContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ConstraintTokenContext constraintToken() {
            return getRuleContext(ConstraintTokenContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ComposableCommandClausesContext composableCommandClauses() {
            return getRuleContext(ComposableCommandClausesContext.class, 0);
        }

        public ShowConstraintsEndContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showConstraintsEnd;
        }
    }

    public final ShowConstraintsEndContext showConstraintsEnd() throws RecognitionException {
        ShowConstraintsEndContext _localctx = new ShowConstraintsEndContext(_ctx, getState());
        enterRule(_localctx, 322, RULE_showConstraintsEnd);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2160);
                constraintToken();
                setState(2162);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2161);
                        showCommandYield();
                    }
                }

                setState(2165);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SHOW || _la == TERMINATE) {
                    {
                        setState(2164);
                        composableCommandClauses();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowProceduresContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PROCEDURE() {
            return getToken(Cypher6Parser.PROCEDURE, 0);
        }

        public TerminalNode PROCEDURES() {
            return getToken(Cypher6Parser.PROCEDURES, 0);
        }

        public ExecutableByContext executableBy() {
            return getRuleContext(ExecutableByContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ComposableCommandClausesContext composableCommandClauses() {
            return getRuleContext(ComposableCommandClausesContext.class, 0);
        }

        public ShowProceduresContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showProcedures;
        }
    }

    public final ShowProceduresContext showProcedures() throws RecognitionException {
        ShowProceduresContext _localctx = new ShowProceduresContext(_ctx, getState());
        enterRule(_localctx, 324, RULE_showProcedures);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2167);
                _la = _input.LA(1);
                if (!(_la == PROCEDURE || _la == PROCEDURES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2169);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == EXECUTABLE) {
                    {
                        setState(2168);
                        executableBy();
                    }
                }

                setState(2172);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2171);
                        showCommandYield();
                    }
                }

                setState(2175);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SHOW || _la == TERMINATE) {
                    {
                        setState(2174);
                        composableCommandClauses();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowFunctionsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public FunctionTokenContext functionToken() {
            return getRuleContext(FunctionTokenContext.class, 0);
        }

        public ShowFunctionsTypeContext showFunctionsType() {
            return getRuleContext(ShowFunctionsTypeContext.class, 0);
        }

        public ExecutableByContext executableBy() {
            return getRuleContext(ExecutableByContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ComposableCommandClausesContext composableCommandClauses() {
            return getRuleContext(ComposableCommandClausesContext.class, 0);
        }

        public ShowFunctionsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showFunctions;
        }
    }

    public final ShowFunctionsContext showFunctions() throws RecognitionException {
        ShowFunctionsContext _localctx = new ShowFunctionsContext(_ctx, getState());
        enterRule(_localctx, 326, RULE_showFunctions);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2178);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ALL || _la == BUILT || _la == USER) {
                    {
                        setState(2177);
                        showFunctionsType();
                    }
                }

                setState(2180);
                functionToken();
                setState(2182);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == EXECUTABLE) {
                    {
                        setState(2181);
                        executableBy();
                    }
                }

                setState(2185);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2184);
                        showCommandYield();
                    }
                }

                setState(2188);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SHOW || _la == TERMINATE) {
                    {
                        setState(2187);
                        composableCommandClauses();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FunctionTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode FUNCTION() {
            return getToken(Cypher6Parser.FUNCTION, 0);
        }

        public TerminalNode FUNCTIONS() {
            return getToken(Cypher6Parser.FUNCTIONS, 0);
        }

        public FunctionTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_functionToken;
        }
    }

    public final FunctionTokenContext functionToken() throws RecognitionException {
        FunctionTokenContext _localctx = new FunctionTokenContext(_ctx, getState());
        enterRule(_localctx, 328, RULE_functionToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2190);
                _la = _input.LA(1);
                if (!(_la == FUNCTION || _la == FUNCTIONS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExecutableByContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode EXECUTABLE() {
            return getToken(Cypher6Parser.EXECUTABLE, 0);
        }

        public TerminalNode BY() {
            return getToken(Cypher6Parser.BY, 0);
        }

        public TerminalNode CURRENT() {
            return getToken(Cypher6Parser.CURRENT, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public ExecutableByContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_executableBy;
        }
    }

    public final ExecutableByContext executableBy() throws RecognitionException {
        ExecutableByContext _localctx = new ExecutableByContext(_ctx, getState());
        enterRule(_localctx, 330, RULE_executableBy);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2192);
                match(EXECUTABLE);
                setState(2199);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == BY) {
                    {
                        setState(2193);
                        match(BY);
                        setState(2197);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 236, _ctx)) {
                            case 1:
                                {
                                    setState(2194);
                                    match(CURRENT);
                                    setState(2195);
                                    match(USER);
                                }
                                break;
                            case 2:
                                {
                                    setState(2196);
                                    symbolicNameString();
                                }
                                break;
                        }
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowFunctionsTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode BUILT() {
            return getToken(Cypher6Parser.BUILT, 0);
        }

        public TerminalNode IN() {
            return getToken(Cypher6Parser.IN, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode DEFINED() {
            return getToken(Cypher6Parser.DEFINED, 0);
        }

        public ShowFunctionsTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showFunctionsType;
        }
    }

    public final ShowFunctionsTypeContext showFunctionsType() throws RecognitionException {
        ShowFunctionsTypeContext _localctx = new ShowFunctionsTypeContext(_ctx, getState());
        enterRule(_localctx, 332, RULE_showFunctionsType);
        try {
            setState(2206);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case ALL:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2201);
                        match(ALL);
                    }
                    break;
                case BUILT:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2202);
                        match(BUILT);
                        setState(2203);
                        match(IN);
                    }
                    break;
                case USER:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2204);
                        match(USER);
                        setState(2205);
                        match(DEFINED);
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowTransactionsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TransactionTokenContext transactionToken() {
            return getRuleContext(TransactionTokenContext.class, 0);
        }

        public NamesAndClausesContext namesAndClauses() {
            return getRuleContext(NamesAndClausesContext.class, 0);
        }

        public ShowTransactionsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showTransactions;
        }
    }

    public final ShowTransactionsContext showTransactions() throws RecognitionException {
        ShowTransactionsContext _localctx = new ShowTransactionsContext(_ctx, getState());
        enterRule(_localctx, 334, RULE_showTransactions);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2208);
                transactionToken();
                setState(2209);
                namesAndClauses();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TerminateTransactionsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TransactionTokenContext transactionToken() {
            return getRuleContext(TransactionTokenContext.class, 0);
        }

        public NamesAndClausesContext namesAndClauses() {
            return getRuleContext(NamesAndClausesContext.class, 0);
        }

        public TerminateTransactionsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_terminateTransactions;
        }
    }

    public final TerminateTransactionsContext terminateTransactions() throws RecognitionException {
        TerminateTransactionsContext _localctx = new TerminateTransactionsContext(_ctx, getState());
        enterRule(_localctx, 336, RULE_terminateTransactions);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2211);
                transactionToken();
                setState(2212);
                namesAndClauses();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowSettingsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SettingTokenContext settingToken() {
            return getRuleContext(SettingTokenContext.class, 0);
        }

        public NamesAndClausesContext namesAndClauses() {
            return getRuleContext(NamesAndClausesContext.class, 0);
        }

        public ShowSettingsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showSettings;
        }
    }

    public final ShowSettingsContext showSettings() throws RecognitionException {
        ShowSettingsContext _localctx = new ShowSettingsContext(_ctx, getState());
        enterRule(_localctx, 338, RULE_showSettings);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2214);
                settingToken();
                setState(2215);
                namesAndClauses();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SettingTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SETTING() {
            return getToken(Cypher6Parser.SETTING, 0);
        }

        public TerminalNode SETTINGS() {
            return getToken(Cypher6Parser.SETTINGS, 0);
        }

        public SettingTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_settingToken;
        }
    }

    public final SettingTokenContext settingToken() throws RecognitionException {
        SettingTokenContext _localctx = new SettingTokenContext(_ctx, getState());
        enterRule(_localctx, 340, RULE_settingToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2217);
                _la = _input.LA(1);
                if (!(_la == SETTING || _la == SETTINGS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NamesAndClausesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public StringsOrExpressionContext stringsOrExpression() {
            return getRuleContext(StringsOrExpressionContext.class, 0);
        }

        public ComposableCommandClausesContext composableCommandClauses() {
            return getRuleContext(ComposableCommandClausesContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public NamesAndClausesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_namesAndClauses;
        }
    }

    public final NamesAndClausesContext namesAndClauses() throws RecognitionException {
        NamesAndClausesContext _localctx = new NamesAndClausesContext(_ctx, getState());
        enterRule(_localctx, 342, RULE_namesAndClauses);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2226);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 241, _ctx)) {
                    case 1:
                        {
                            setState(2220);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == WHERE || _la == YIELD) {
                                {
                                    setState(2219);
                                    showCommandYield();
                                }
                            }
                        }
                        break;
                    case 2:
                        {
                            setState(2222);
                            stringsOrExpression();
                            setState(2224);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == WHERE || _la == YIELD) {
                                {
                                    setState(2223);
                                    showCommandYield();
                                }
                            }
                        }
                        break;
                }
                setState(2229);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == SHOW || _la == TERMINATE) {
                    {
                        setState(2228);
                        composableCommandClauses();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class StringsOrExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public StringListContext stringList() {
            return getRuleContext(StringListContext.class, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public StringsOrExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_stringsOrExpression;
        }
    }

    public final StringsOrExpressionContext stringsOrExpression() throws RecognitionException {
        StringsOrExpressionContext _localctx = new StringsOrExpressionContext(_ctx, getState());
        enterRule(_localctx, 344, RULE_stringsOrExpression);
        try {
            setState(2233);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 243, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2231);
                        stringList();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2232);
                        expression();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CommandNodePatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public LabelTypeContext labelType() {
            return getRuleContext(LabelTypeContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public CommandNodePatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_commandNodePattern;
        }
    }

    public final CommandNodePatternContext commandNodePattern() throws RecognitionException {
        CommandNodePatternContext _localctx = new CommandNodePatternContext(_ctx, getState());
        enterRule(_localctx, 346, RULE_commandNodePattern);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2235);
                match(LPAREN);
                setState(2236);
                variable();
                setState(2237);
                labelType();
                setState(2238);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CommandRelPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<TerminalNode> LPAREN() {
            return getTokens(Cypher6Parser.LPAREN);
        }

        public TerminalNode LPAREN(int i) {
            return getToken(Cypher6Parser.LPAREN, i);
        }

        public List<TerminalNode> RPAREN() {
            return getTokens(Cypher6Parser.RPAREN);
        }

        public TerminalNode RPAREN(int i) {
            return getToken(Cypher6Parser.RPAREN, i);
        }

        public List<ArrowLineContext> arrowLine() {
            return getRuleContexts(ArrowLineContext.class);
        }

        public ArrowLineContext arrowLine(int i) {
            return getRuleContext(ArrowLineContext.class, i);
        }

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public RelTypeContext relType() {
            return getRuleContext(RelTypeContext.class, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public LeftArrowContext leftArrow() {
            return getRuleContext(LeftArrowContext.class, 0);
        }

        public RightArrowContext rightArrow() {
            return getRuleContext(RightArrowContext.class, 0);
        }

        public CommandRelPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_commandRelPattern;
        }
    }

    public final CommandRelPatternContext commandRelPattern() throws RecognitionException {
        CommandRelPatternContext _localctx = new CommandRelPatternContext(_ctx, getState());
        enterRule(_localctx, 348, RULE_commandRelPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2240);
                match(LPAREN);
                setState(2241);
                match(RPAREN);
                setState(2243);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LT || _la == ARROW_LEFT_HEAD) {
                    {
                        setState(2242);
                        leftArrow();
                    }
                }

                setState(2245);
                arrowLine();
                setState(2246);
                match(LBRACKET);
                setState(2247);
                variable();
                setState(2248);
                relType();
                setState(2249);
                match(RBRACKET);
                setState(2250);
                arrowLine();
                setState(2252);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == GT || _la == ARROW_RIGHT_HEAD) {
                    {
                        setState(2251);
                        rightArrow();
                    }
                }

                setState(2254);
                match(LPAREN);
                setState(2255);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateConstraintContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CONSTRAINT() {
            return getToken(Cypher6Parser.CONSTRAINT, 0);
        }

        public TerminalNode FOR() {
            return getToken(Cypher6Parser.FOR, 0);
        }

        public ConstraintTypeContext constraintType() {
            return getRuleContext(ConstraintTypeContext.class, 0);
        }

        public CommandNodePatternContext commandNodePattern() {
            return getRuleContext(CommandNodePatternContext.class, 0);
        }

        public CommandRelPatternContext commandRelPattern() {
            return getRuleContext(CommandRelPatternContext.class, 0);
        }

        public SymbolicNameOrStringParameterContext symbolicNameOrStringParameter() {
            return getRuleContext(SymbolicNameOrStringParameterContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public CommandOptionsContext commandOptions() {
            return getRuleContext(CommandOptionsContext.class, 0);
        }

        public CreateConstraintContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createConstraint;
        }
    }

    public final CreateConstraintContext createConstraint() throws RecognitionException {
        CreateConstraintContext _localctx = new CreateConstraintContext(_ctx, getState());
        enterRule(_localctx, 350, RULE_createConstraint);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2257);
                match(CONSTRAINT);
                setState(2259);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 246, _ctx)) {
                    case 1:
                        {
                            setState(2258);
                            symbolicNameOrStringParameter();
                        }
                        break;
                }
                setState(2264);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2261);
                        match(IF);
                        setState(2262);
                        match(NOT);
                        setState(2263);
                        match(EXISTS);
                    }
                }

                setState(2266);
                match(FOR);
                setState(2269);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 248, _ctx)) {
                    case 1:
                        {
                            setState(2267);
                            commandNodePattern();
                        }
                        break;
                    case 2:
                        {
                            setState(2268);
                            commandRelPattern();
                        }
                        break;
                }
                setState(2271);
                constraintType();
                setState(2273);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OPTIONS) {
                    {
                        setState(2272);
                        commandOptions();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public ConstraintTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_constraintType;
        }

        public ConstraintTypeContext() {}

        public void copyFrom(ConstraintTypeContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintTypedContext extends ConstraintTypeContext {
        public TerminalNode REQUIRE() {
            return getToken(Cypher6Parser.REQUIRE, 0);
        }

        public PropertyListContext propertyList() {
            return getRuleContext(PropertyListContext.class, 0);
        }

        public TypeContext type() {
            return getRuleContext(TypeContext.class, 0);
        }

        public TerminalNode COLONCOLON() {
            return getToken(Cypher6Parser.COLONCOLON, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode TYPED() {
            return getToken(Cypher6Parser.TYPED, 0);
        }

        public ConstraintTypedContext(ConstraintTypeContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintKeyContext extends ConstraintTypeContext {
        public TerminalNode REQUIRE() {
            return getToken(Cypher6Parser.REQUIRE, 0);
        }

        public PropertyListContext propertyList() {
            return getRuleContext(PropertyListContext.class, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode KEY() {
            return getToken(Cypher6Parser.KEY, 0);
        }

        public TerminalNode NODE() {
            return getToken(Cypher6Parser.NODE, 0);
        }

        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public TerminalNode REL() {
            return getToken(Cypher6Parser.REL, 0);
        }

        public ConstraintKeyContext(ConstraintTypeContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintIsNotNullContext extends ConstraintTypeContext {
        public TerminalNode REQUIRE() {
            return getToken(Cypher6Parser.REQUIRE, 0);
        }

        public PropertyListContext propertyList() {
            return getRuleContext(PropertyListContext.class, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode NULL() {
            return getToken(Cypher6Parser.NULL, 0);
        }

        public ConstraintIsNotNullContext(ConstraintTypeContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintIsUniqueContext extends ConstraintTypeContext {
        public TerminalNode REQUIRE() {
            return getToken(Cypher6Parser.REQUIRE, 0);
        }

        public PropertyListContext propertyList() {
            return getRuleContext(PropertyListContext.class, 0);
        }

        public TerminalNode IS() {
            return getToken(Cypher6Parser.IS, 0);
        }

        public TerminalNode UNIQUE() {
            return getToken(Cypher6Parser.UNIQUE, 0);
        }

        public TerminalNode NODE() {
            return getToken(Cypher6Parser.NODE, 0);
        }

        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public TerminalNode REL() {
            return getToken(Cypher6Parser.REL, 0);
        }

        public ConstraintIsUniqueContext(ConstraintTypeContext ctx) {
            copyFrom(ctx);
        }
    }

    public final ConstraintTypeContext constraintType() throws RecognitionException {
        ConstraintTypeContext _localctx = new ConstraintTypeContext(_ctx, getState());
        enterRule(_localctx, 352, RULE_constraintType);
        int _la;
        try {
            setState(2306);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 253, _ctx)) {
                case 1:
                    _localctx = new ConstraintTypedContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2275);
                        match(REQUIRE);
                        setState(2276);
                        propertyList();
                        setState(2280);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case COLONCOLON:
                                {
                                    setState(2277);
                                    match(COLONCOLON);
                                }
                                break;
                            case IS:
                                {
                                    setState(2278);
                                    match(IS);
                                    setState(2279);
                                    _la = _input.LA(1);
                                    if (!(_la == COLONCOLON || _la == TYPED)) {
                                        _errHandler.recoverInline(this);
                                    } else {
                                        if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                        _errHandler.reportMatch(this);
                                        consume();
                                    }
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                        setState(2282);
                        type();
                    }
                    break;
                case 2:
                    _localctx = new ConstraintIsUniqueContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2284);
                        match(REQUIRE);
                        setState(2285);
                        propertyList();
                        setState(2286);
                        match(IS);
                        setState(2288);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & 422212465065985L) != 0)) {
                            {
                                setState(2287);
                                _la = _input.LA(1);
                                if (!(((((_la - 169)) & ~0x3f) == 0
                                        && ((1L << (_la - 169)) & 422212465065985L) != 0))) {
                                    _errHandler.recoverInline(this);
                                } else {
                                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                    _errHandler.reportMatch(this);
                                    consume();
                                }
                            }
                        }

                        setState(2290);
                        match(UNIQUE);
                    }
                    break;
                case 3:
                    _localctx = new ConstraintKeyContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2292);
                        match(REQUIRE);
                        setState(2293);
                        propertyList();
                        setState(2294);
                        match(IS);
                        setState(2296);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (((((_la - 169)) & ~0x3f) == 0 && ((1L << (_la - 169)) & 422212465065985L) != 0)) {
                            {
                                setState(2295);
                                _la = _input.LA(1);
                                if (!(((((_la - 169)) & ~0x3f) == 0
                                        && ((1L << (_la - 169)) & 422212465065985L) != 0))) {
                                    _errHandler.recoverInline(this);
                                } else {
                                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                    _errHandler.reportMatch(this);
                                    consume();
                                }
                            }
                        }

                        setState(2298);
                        match(KEY);
                    }
                    break;
                case 4:
                    _localctx = new ConstraintIsNotNullContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2300);
                        match(REQUIRE);
                        setState(2301);
                        propertyList();
                        setState(2302);
                        match(IS);
                        setState(2303);
                        match(NOT);
                        setState(2304);
                        match(NULL);
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropConstraintContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CONSTRAINT() {
            return getToken(Cypher6Parser.CONSTRAINT, 0);
        }

        public SymbolicNameOrStringParameterContext symbolicNameOrStringParameter() {
            return getRuleContext(SymbolicNameOrStringParameterContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public DropConstraintContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropConstraint;
        }
    }

    public final DropConstraintContext dropConstraint() throws RecognitionException {
        DropConstraintContext _localctx = new DropConstraintContext(_ctx, getState());
        enterRule(_localctx, 354, RULE_dropConstraint);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2308);
                match(CONSTRAINT);
                setState(2309);
                symbolicNameOrStringParameter();
                setState(2312);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2310);
                        match(IF);
                        setState(2311);
                        match(EXISTS);
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateIndexContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode BTREE() {
            return getToken(Cypher6Parser.BTREE, 0);
        }

        public TerminalNode INDEX() {
            return getToken(Cypher6Parser.INDEX, 0);
        }

        public CreateIndex_Context createIndex_() {
            return getRuleContext(CreateIndex_Context.class, 0);
        }

        public TerminalNode RANGE() {
            return getToken(Cypher6Parser.RANGE, 0);
        }

        public TerminalNode TEXT() {
            return getToken(Cypher6Parser.TEXT, 0);
        }

        public TerminalNode POINT() {
            return getToken(Cypher6Parser.POINT, 0);
        }

        public TerminalNode VECTOR() {
            return getToken(Cypher6Parser.VECTOR, 0);
        }

        public TerminalNode LOOKUP() {
            return getToken(Cypher6Parser.LOOKUP, 0);
        }

        public CreateLookupIndexContext createLookupIndex() {
            return getRuleContext(CreateLookupIndexContext.class, 0);
        }

        public TerminalNode FULLTEXT() {
            return getToken(Cypher6Parser.FULLTEXT, 0);
        }

        public CreateFulltextIndexContext createFulltextIndex() {
            return getRuleContext(CreateFulltextIndexContext.class, 0);
        }

        public CreateIndexContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createIndex;
        }
    }

    public final CreateIndexContext createIndex() throws RecognitionException {
        CreateIndexContext _localctx = new CreateIndexContext(_ctx, getState());
        enterRule(_localctx, 356, RULE_createIndex);
        try {
            setState(2337);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case BTREE:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2314);
                        match(BTREE);
                        setState(2315);
                        match(INDEX);
                        setState(2316);
                        createIndex_();
                    }
                    break;
                case RANGE:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2317);
                        match(RANGE);
                        setState(2318);
                        match(INDEX);
                        setState(2319);
                        createIndex_();
                    }
                    break;
                case TEXT:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2320);
                        match(TEXT);
                        setState(2321);
                        match(INDEX);
                        setState(2322);
                        createIndex_();
                    }
                    break;
                case POINT:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2323);
                        match(POINT);
                        setState(2324);
                        match(INDEX);
                        setState(2325);
                        createIndex_();
                    }
                    break;
                case VECTOR:
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(2326);
                        match(VECTOR);
                        setState(2327);
                        match(INDEX);
                        setState(2328);
                        createIndex_();
                    }
                    break;
                case LOOKUP:
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(2329);
                        match(LOOKUP);
                        setState(2330);
                        match(INDEX);
                        setState(2331);
                        createLookupIndex();
                    }
                    break;
                case FULLTEXT:
                    enterOuterAlt(_localctx, 7);
                    {
                        setState(2332);
                        match(FULLTEXT);
                        setState(2333);
                        match(INDEX);
                        setState(2334);
                        createFulltextIndex();
                    }
                    break;
                case INDEX:
                    enterOuterAlt(_localctx, 8);
                    {
                        setState(2335);
                        match(INDEX);
                        setState(2336);
                        createIndex_();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateIndex_Context extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode FOR() {
            return getToken(Cypher6Parser.FOR, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public PropertyListContext propertyList() {
            return getRuleContext(PropertyListContext.class, 0);
        }

        public CommandNodePatternContext commandNodePattern() {
            return getRuleContext(CommandNodePatternContext.class, 0);
        }

        public CommandRelPatternContext commandRelPattern() {
            return getRuleContext(CommandRelPatternContext.class, 0);
        }

        public SymbolicNameOrStringParameterContext symbolicNameOrStringParameter() {
            return getRuleContext(SymbolicNameOrStringParameterContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public CommandOptionsContext commandOptions() {
            return getRuleContext(CommandOptionsContext.class, 0);
        }

        public CreateIndex_Context(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createIndex_;
        }
    }

    public final CreateIndex_Context createIndex_() throws RecognitionException {
        CreateIndex_Context _localctx = new CreateIndex_Context(_ctx, getState());
        enterRule(_localctx, 358, RULE_createIndex_);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2340);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 256, _ctx)) {
                    case 1:
                        {
                            setState(2339);
                            symbolicNameOrStringParameter();
                        }
                        break;
                }
                setState(2345);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2342);
                        match(IF);
                        setState(2343);
                        match(NOT);
                        setState(2344);
                        match(EXISTS);
                    }
                }

                setState(2347);
                match(FOR);
                setState(2350);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 258, _ctx)) {
                    case 1:
                        {
                            setState(2348);
                            commandNodePattern();
                        }
                        break;
                    case 2:
                        {
                            setState(2349);
                            commandRelPattern();
                        }
                        break;
                }
                setState(2352);
                match(ON);
                setState(2353);
                propertyList();
                setState(2355);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OPTIONS) {
                    {
                        setState(2354);
                        commandOptions();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateFulltextIndexContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode FOR() {
            return getToken(Cypher6Parser.FOR, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public TerminalNode EACH() {
            return getToken(Cypher6Parser.EACH, 0);
        }

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public EnclosedPropertyListContext enclosedPropertyList() {
            return getRuleContext(EnclosedPropertyListContext.class, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public FulltextNodePatternContext fulltextNodePattern() {
            return getRuleContext(FulltextNodePatternContext.class, 0);
        }

        public FulltextRelPatternContext fulltextRelPattern() {
            return getRuleContext(FulltextRelPatternContext.class, 0);
        }

        public SymbolicNameOrStringParameterContext symbolicNameOrStringParameter() {
            return getRuleContext(SymbolicNameOrStringParameterContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public CommandOptionsContext commandOptions() {
            return getRuleContext(CommandOptionsContext.class, 0);
        }

        public CreateFulltextIndexContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createFulltextIndex;
        }
    }

    public final CreateFulltextIndexContext createFulltextIndex() throws RecognitionException {
        CreateFulltextIndexContext _localctx = new CreateFulltextIndexContext(_ctx, getState());
        enterRule(_localctx, 360, RULE_createFulltextIndex);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2358);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 260, _ctx)) {
                    case 1:
                        {
                            setState(2357);
                            symbolicNameOrStringParameter();
                        }
                        break;
                }
                setState(2363);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2360);
                        match(IF);
                        setState(2361);
                        match(NOT);
                        setState(2362);
                        match(EXISTS);
                    }
                }

                setState(2365);
                match(FOR);
                setState(2368);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 262, _ctx)) {
                    case 1:
                        {
                            setState(2366);
                            fulltextNodePattern();
                        }
                        break;
                    case 2:
                        {
                            setState(2367);
                            fulltextRelPattern();
                        }
                        break;
                }
                setState(2370);
                match(ON);
                setState(2371);
                match(EACH);
                setState(2372);
                match(LBRACKET);
                setState(2373);
                enclosedPropertyList();
                setState(2374);
                match(RBRACKET);
                setState(2376);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OPTIONS) {
                    {
                        setState(2375);
                        commandOptions();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FulltextNodePatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public List<TerminalNode> BAR() {
            return getTokens(Cypher6Parser.BAR);
        }

        public TerminalNode BAR(int i) {
            return getToken(Cypher6Parser.BAR, i);
        }

        public FulltextNodePatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_fulltextNodePattern;
        }
    }

    public final FulltextNodePatternContext fulltextNodePattern() throws RecognitionException {
        FulltextNodePatternContext _localctx = new FulltextNodePatternContext(_ctx, getState());
        enterRule(_localctx, 362, RULE_fulltextNodePattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2378);
                match(LPAREN);
                setState(2379);
                variable();
                setState(2380);
                match(COLON);
                setState(2381);
                symbolicNameString();
                setState(2386);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == BAR) {
                    {
                        {
                            setState(2382);
                            match(BAR);
                            setState(2383);
                            symbolicNameString();
                        }
                    }
                    setState(2388);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(2389);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class FulltextRelPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<TerminalNode> LPAREN() {
            return getTokens(Cypher6Parser.LPAREN);
        }

        public TerminalNode LPAREN(int i) {
            return getToken(Cypher6Parser.LPAREN, i);
        }

        public List<TerminalNode> RPAREN() {
            return getTokens(Cypher6Parser.RPAREN);
        }

        public TerminalNode RPAREN(int i) {
            return getToken(Cypher6Parser.RPAREN, i);
        }

        public List<ArrowLineContext> arrowLine() {
            return getRuleContexts(ArrowLineContext.class);
        }

        public ArrowLineContext arrowLine(int i) {
            return getRuleContext(ArrowLineContext.class, i);
        }

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public LeftArrowContext leftArrow() {
            return getRuleContext(LeftArrowContext.class, 0);
        }

        public List<TerminalNode> BAR() {
            return getTokens(Cypher6Parser.BAR);
        }

        public TerminalNode BAR(int i) {
            return getToken(Cypher6Parser.BAR, i);
        }

        public RightArrowContext rightArrow() {
            return getRuleContext(RightArrowContext.class, 0);
        }

        public FulltextRelPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_fulltextRelPattern;
        }
    }

    public final FulltextRelPatternContext fulltextRelPattern() throws RecognitionException {
        FulltextRelPatternContext _localctx = new FulltextRelPatternContext(_ctx, getState());
        enterRule(_localctx, 364, RULE_fulltextRelPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2391);
                match(LPAREN);
                setState(2392);
                match(RPAREN);
                setState(2394);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LT || _la == ARROW_LEFT_HEAD) {
                    {
                        setState(2393);
                        leftArrow();
                    }
                }

                setState(2396);
                arrowLine();
                setState(2397);
                match(LBRACKET);
                setState(2398);
                variable();
                setState(2399);
                match(COLON);
                setState(2400);
                symbolicNameString();
                setState(2405);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == BAR) {
                    {
                        {
                            setState(2401);
                            match(BAR);
                            setState(2402);
                            symbolicNameString();
                        }
                    }
                    setState(2407);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(2408);
                match(RBRACKET);
                setState(2409);
                arrowLine();
                setState(2411);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == GT || _la == ARROW_RIGHT_HEAD) {
                    {
                        setState(2410);
                        rightArrow();
                    }
                }

                setState(2413);
                match(LPAREN);
                setState(2414);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateLookupIndexContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode FOR() {
            return getToken(Cypher6Parser.FOR, 0);
        }

        public SymbolicNameStringContext symbolicNameString() {
            return getRuleContext(SymbolicNameStringContext.class, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public LookupIndexNodePatternContext lookupIndexNodePattern() {
            return getRuleContext(LookupIndexNodePatternContext.class, 0);
        }

        public LookupIndexRelPatternContext lookupIndexRelPattern() {
            return getRuleContext(LookupIndexRelPatternContext.class, 0);
        }

        public SymbolicNameOrStringParameterContext symbolicNameOrStringParameter() {
            return getRuleContext(SymbolicNameOrStringParameterContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public CommandOptionsContext commandOptions() {
            return getRuleContext(CommandOptionsContext.class, 0);
        }

        public CreateLookupIndexContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createLookupIndex;
        }
    }

    public final CreateLookupIndexContext createLookupIndex() throws RecognitionException {
        CreateLookupIndexContext _localctx = new CreateLookupIndexContext(_ctx, getState());
        enterRule(_localctx, 366, RULE_createLookupIndex);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2417);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 268, _ctx)) {
                    case 1:
                        {
                            setState(2416);
                            symbolicNameOrStringParameter();
                        }
                        break;
                }
                setState(2422);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2419);
                        match(IF);
                        setState(2420);
                        match(NOT);
                        setState(2421);
                        match(EXISTS);
                    }
                }

                setState(2424);
                match(FOR);
                setState(2427);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 270, _ctx)) {
                    case 1:
                        {
                            setState(2425);
                            lookupIndexNodePattern();
                        }
                        break;
                    case 2:
                        {
                            setState(2426);
                            lookupIndexRelPattern();
                        }
                        break;
                }
                setState(2429);
                symbolicNameString();
                setState(2430);
                match(LPAREN);
                setState(2431);
                variable();
                setState(2432);
                match(RPAREN);
                setState(2434);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OPTIONS) {
                    {
                        setState(2433);
                        commandOptions();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LookupIndexNodePatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public TerminalNode EACH() {
            return getToken(Cypher6Parser.EACH, 0);
        }

        public LookupIndexNodePatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_lookupIndexNodePattern;
        }
    }

    public final LookupIndexNodePatternContext lookupIndexNodePattern() throws RecognitionException {
        LookupIndexNodePatternContext _localctx = new LookupIndexNodePatternContext(_ctx, getState());
        enterRule(_localctx, 368, RULE_lookupIndexNodePattern);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2436);
                match(LPAREN);
                setState(2437);
                variable();
                setState(2438);
                match(RPAREN);
                setState(2439);
                match(ON);
                setState(2440);
                match(EACH);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LookupIndexRelPatternContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<TerminalNode> LPAREN() {
            return getTokens(Cypher6Parser.LPAREN);
        }

        public TerminalNode LPAREN(int i) {
            return getToken(Cypher6Parser.LPAREN, i);
        }

        public List<TerminalNode> RPAREN() {
            return getTokens(Cypher6Parser.RPAREN);
        }

        public TerminalNode RPAREN(int i) {
            return getToken(Cypher6Parser.RPAREN, i);
        }

        public List<ArrowLineContext> arrowLine() {
            return getRuleContexts(ArrowLineContext.class);
        }

        public ArrowLineContext arrowLine(int i) {
            return getRuleContext(ArrowLineContext.class, i);
        }

        public TerminalNode LBRACKET() {
            return getToken(Cypher6Parser.LBRACKET, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode RBRACKET() {
            return getToken(Cypher6Parser.RBRACKET, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public LeftArrowContext leftArrow() {
            return getRuleContext(LeftArrowContext.class, 0);
        }

        public RightArrowContext rightArrow() {
            return getRuleContext(RightArrowContext.class, 0);
        }

        public TerminalNode EACH() {
            return getToken(Cypher6Parser.EACH, 0);
        }

        public LookupIndexRelPatternContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_lookupIndexRelPattern;
        }
    }

    public final LookupIndexRelPatternContext lookupIndexRelPattern() throws RecognitionException {
        LookupIndexRelPatternContext _localctx = new LookupIndexRelPatternContext(_ctx, getState());
        enterRule(_localctx, 370, RULE_lookupIndexRelPattern);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2442);
                match(LPAREN);
                setState(2443);
                match(RPAREN);
                setState(2445);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LT || _la == ARROW_LEFT_HEAD) {
                    {
                        setState(2444);
                        leftArrow();
                    }
                }

                setState(2447);
                arrowLine();
                setState(2448);
                match(LBRACKET);
                setState(2449);
                variable();
                setState(2450);
                match(RBRACKET);
                setState(2451);
                arrowLine();
                setState(2453);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == GT || _la == ARROW_RIGHT_HEAD) {
                    {
                        setState(2452);
                        rightArrow();
                    }
                }

                setState(2455);
                match(LPAREN);
                setState(2456);
                match(RPAREN);
                setState(2457);
                match(ON);
                setState(2459);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 274, _ctx)) {
                    case 1:
                        {
                            setState(2458);
                            match(EACH);
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropIndexContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode INDEX() {
            return getToken(Cypher6Parser.INDEX, 0);
        }

        public SymbolicNameOrStringParameterContext symbolicNameOrStringParameter() {
            return getRuleContext(SymbolicNameOrStringParameterContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public DropIndexContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropIndex;
        }
    }

    public final DropIndexContext dropIndex() throws RecognitionException {
        DropIndexContext _localctx = new DropIndexContext(_ctx, getState());
        enterRule(_localctx, 372, RULE_dropIndex);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2461);
                match(INDEX);
                setState(2462);
                symbolicNameOrStringParameter();
                setState(2465);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2463);
                        match(IF);
                        setState(2464);
                        match(EXISTS);
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertyListContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public PropertyContext property() {
            return getRuleContext(PropertyContext.class, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public EnclosedPropertyListContext enclosedPropertyList() {
            return getRuleContext(EnclosedPropertyListContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public PropertyListContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_propertyList;
        }
    }

    public final PropertyListContext propertyList() throws RecognitionException {
        PropertyListContext _localctx = new PropertyListContext(_ctx, getState());
        enterRule(_localctx, 374, RULE_propertyList);
        try {
            setState(2474);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case ESCAPED_SYMBOLIC_NAME:
                case ACCESS:
                case ACTIVE:
                case ADMIN:
                case ADMINISTRATOR:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATHS:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case ARRAY:
                case AS:
                case ASC:
                case ASCENDING:
                case ASSIGN:
                case AT:
                case AUTH:
                case BINDINGS:
                case BOOL:
                case BOOLEAN:
                case BOOSTED:
                case BOTH:
                case BREAK:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CHANGE:
                case CIDR:
                case COLLECT:
                case COMMAND:
                case COMMANDS:
                case COMPOSITE:
                case CONCURRENT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case CONTINUE:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DATE:
                case DATETIME:
                case DBMS:
                case DEALLOCATE:
                case DEFAULT:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESCENDING:
                case DESTROY:
                case DETACH:
                case DIFFERENT:
                case DISTINCT:
                case DRIVER:
                case DROP:
                case DRYRUN:
                case DUMP:
                case DURATION:
                case EACH:
                case EDGE:
                case ENABLE:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXECUTE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case ERROR:
                case FAIL:
                case FALSE:
                case FIELDTERMINATOR:
                case FINISH:
                case FLOAT:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case GROUP:
                case GROUPS:
                case HEADERS:
                case HOME:
                case ID:
                case IF:
                case IMPERSONATE:
                case IMMUTABLE:
                case IN:
                case INDEX:
                case INDEXES:
                case INF:
                case INFINITY:
                case INSERT:
                case INT:
                case INTEGER:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LEADING:
                case LIMITROWS:
                case LIST:
                case LOAD:
                case LOCAL:
                case LOOKUP:
                case MANAGEMENT:
                case MAP:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NAN:
                case NFC:
                case NFD:
                case NFKC:
                case NFKD:
                case NEW:
                case NODE:
                case NODETACH:
                case NODES:
                case NONE:
                case NORMALIZE:
                case NORMALIZED:
                case NOT:
                case NOTHING:
                case NOWAIT:
                case NULL:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OPTION:
                case OR:
                case ORDER:
                case PASSWORD:
                case PASSWORDS:
                case PATH:
                case PATHS:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIMARY:
                case PRIMARIES:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTIES:
                case PROPERTY:
                case PROVIDER:
                case PROVIDERS:
                case RANGE:
                case READ:
                case REALLOCATE:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPEATABLE:
                case REPLACE:
                case REPORT:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDARY:
                case SECONDARIES:
                case SECONDS:
                case SEEK:
                case SERVER:
                case SERVERS:
                case SET:
                case SETTING:
                case SETTINGS:
                case SHORTEST_PATH:
                case SHORTEST:
                case SHOW:
                case SIGNED:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case STRING:
                case SUPPORTED:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TIME:
                case TIMESTAMP:
                case TIMEZONE:
                case TO:
                case TOPOLOGY:
                case TRAILING:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRIM:
                case TRUE:
                case TYPE:
                case TYPED:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNIQUENESS:
                case UNWIND:
                case URL:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VALUE:
                case VARCHAR:
                case VECTOR:
                case VERTEX:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WITHOUT:
                case WRITE:
                case XOR:
                case YIELD:
                case ZONE:
                case ZONED:
                case IDENTIFIER:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2467);
                        variable();
                        setState(2468);
                        property();
                    }
                    break;
                case LPAREN:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2470);
                        match(LPAREN);
                        setState(2471);
                        enclosedPropertyList();
                        setState(2472);
                        match(RPAREN);
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class EnclosedPropertyListContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<VariableContext> variable() {
            return getRuleContexts(VariableContext.class);
        }

        public VariableContext variable(int i) {
            return getRuleContext(VariableContext.class, i);
        }

        public List<PropertyContext> property() {
            return getRuleContexts(PropertyContext.class);
        }

        public PropertyContext property(int i) {
            return getRuleContext(PropertyContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public EnclosedPropertyListContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_enclosedPropertyList;
        }
    }

    public final EnclosedPropertyListContext enclosedPropertyList() throws RecognitionException {
        EnclosedPropertyListContext _localctx = new EnclosedPropertyListContext(_ctx, getState());
        enterRule(_localctx, 376, RULE_enclosedPropertyList);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2476);
                variable();
                setState(2477);
                property();
                setState(2484);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(2478);
                            match(COMMA);
                            setState(2479);
                            variable();
                            setState(2480);
                            property();
                        }
                    }
                    setState(2486);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AlterCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ALTER() {
            return getToken(Cypher6Parser.ALTER, 0);
        }

        public AlterAliasContext alterAlias() {
            return getRuleContext(AlterAliasContext.class, 0);
        }

        public AlterCurrentUserContext alterCurrentUser() {
            return getRuleContext(AlterCurrentUserContext.class, 0);
        }

        public AlterDatabaseContext alterDatabase() {
            return getRuleContext(AlterDatabaseContext.class, 0);
        }

        public AlterUserContext alterUser() {
            return getRuleContext(AlterUserContext.class, 0);
        }

        public AlterServerContext alterServer() {
            return getRuleContext(AlterServerContext.class, 0);
        }

        public AlterCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_alterCommand;
        }
    }

    public final AlterCommandContext alterCommand() throws RecognitionException {
        AlterCommandContext _localctx = new AlterCommandContext(_ctx, getState());
        enterRule(_localctx, 378, RULE_alterCommand);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2487);
                match(ALTER);
                setState(2493);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ALIAS:
                        {
                            setState(2488);
                            alterAlias();
                        }
                        break;
                    case CURRENT:
                        {
                            setState(2489);
                            alterCurrentUser();
                        }
                        break;
                    case DATABASE:
                        {
                            setState(2490);
                            alterDatabase();
                        }
                        break;
                    case USER:
                        {
                            setState(2491);
                            alterUser();
                        }
                        break;
                    case SERVER:
                        {
                            setState(2492);
                            alterServer();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RenameCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode RENAME() {
            return getToken(Cypher6Parser.RENAME, 0);
        }

        public RenameRoleContext renameRole() {
            return getRuleContext(RenameRoleContext.class, 0);
        }

        public RenameServerContext renameServer() {
            return getRuleContext(RenameServerContext.class, 0);
        }

        public RenameUserContext renameUser() {
            return getRuleContext(RenameUserContext.class, 0);
        }

        public RenameCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_renameCommand;
        }
    }

    public final RenameCommandContext renameCommand() throws RecognitionException {
        RenameCommandContext _localctx = new RenameCommandContext(_ctx, getState());
        enterRule(_localctx, 380, RULE_renameCommand);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2495);
                match(RENAME);
                setState(2499);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ROLE:
                        {
                            setState(2496);
                            renameRole();
                        }
                        break;
                    case SERVER:
                        {
                            setState(2497);
                            renameServer();
                        }
                        break;
                    case USER:
                        {
                            setState(2498);
                            renameUser();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GrantCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode GRANT() {
            return getToken(Cypher6Parser.GRANT, 0);
        }

        public PrivilegeContext privilege() {
            return getRuleContext(PrivilegeContext.class, 0);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public RoleNamesContext roleNames() {
            return getRuleContext(RoleNamesContext.class, 0);
        }

        public RoleTokenContext roleToken() {
            return getRuleContext(RoleTokenContext.class, 0);
        }

        public GrantRoleContext grantRole() {
            return getRuleContext(GrantRoleContext.class, 0);
        }

        public TerminalNode IMMUTABLE() {
            return getToken(Cypher6Parser.IMMUTABLE, 0);
        }

        public GrantCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_grantCommand;
        }
    }

    public final GrantCommandContext grantCommand() throws RecognitionException {
        GrantCommandContext _localctx = new GrantCommandContext(_ctx, getState());
        enterRule(_localctx, 382, RULE_grantCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2501);
                match(GRANT);
                setState(2512);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 281, _ctx)) {
                    case 1:
                        {
                            setState(2503);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == IMMUTABLE) {
                                {
                                    setState(2502);
                                    match(IMMUTABLE);
                                }
                            }

                            setState(2505);
                            privilege();
                            setState(2506);
                            match(TO);
                            setState(2507);
                            roleNames();
                        }
                        break;
                    case 2:
                        {
                            setState(2509);
                            roleToken();
                            setState(2510);
                            grantRole();
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DenyCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DENY() {
            return getToken(Cypher6Parser.DENY, 0);
        }

        public PrivilegeContext privilege() {
            return getRuleContext(PrivilegeContext.class, 0);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public RoleNamesContext roleNames() {
            return getRuleContext(RoleNamesContext.class, 0);
        }

        public TerminalNode IMMUTABLE() {
            return getToken(Cypher6Parser.IMMUTABLE, 0);
        }

        public DenyCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_denyCommand;
        }
    }

    public final DenyCommandContext denyCommand() throws RecognitionException {
        DenyCommandContext _localctx = new DenyCommandContext(_ctx, getState());
        enterRule(_localctx, 384, RULE_denyCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2514);
                match(DENY);
                setState(2516);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IMMUTABLE) {
                    {
                        setState(2515);
                        match(IMMUTABLE);
                    }
                }

                setState(2518);
                privilege();
                setState(2519);
                match(TO);
                setState(2520);
                roleNames();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RevokeCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REVOKE() {
            return getToken(Cypher6Parser.REVOKE, 0);
        }

        public PrivilegeContext privilege() {
            return getRuleContext(PrivilegeContext.class, 0);
        }

        public TerminalNode FROM() {
            return getToken(Cypher6Parser.FROM, 0);
        }

        public RoleNamesContext roleNames() {
            return getRuleContext(RoleNamesContext.class, 0);
        }

        public RoleTokenContext roleToken() {
            return getRuleContext(RoleTokenContext.class, 0);
        }

        public RevokeRoleContext revokeRole() {
            return getRuleContext(RevokeRoleContext.class, 0);
        }

        public TerminalNode IMMUTABLE() {
            return getToken(Cypher6Parser.IMMUTABLE, 0);
        }

        public TerminalNode DENY() {
            return getToken(Cypher6Parser.DENY, 0);
        }

        public TerminalNode GRANT() {
            return getToken(Cypher6Parser.GRANT, 0);
        }

        public RevokeCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_revokeCommand;
        }
    }

    public final RevokeCommandContext revokeCommand() throws RecognitionException {
        RevokeCommandContext _localctx = new RevokeCommandContext(_ctx, getState());
        enterRule(_localctx, 386, RULE_revokeCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2522);
                match(REVOKE);
                setState(2536);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 285, _ctx)) {
                    case 1:
                        {
                            setState(2524);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == DENY || _la == GRANT) {
                                {
                                    setState(2523);
                                    _la = _input.LA(1);
                                    if (!(_la == DENY || _la == GRANT)) {
                                        _errHandler.recoverInline(this);
                                    } else {
                                        if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                        _errHandler.reportMatch(this);
                                        consume();
                                    }
                                }
                            }

                            setState(2527);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == IMMUTABLE) {
                                {
                                    setState(2526);
                                    match(IMMUTABLE);
                                }
                            }

                            setState(2529);
                            privilege();
                            setState(2530);
                            match(FROM);
                            setState(2531);
                            roleNames();
                        }
                        break;
                    case 2:
                        {
                            setState(2533);
                            roleToken();
                            setState(2534);
                            revokeRole();
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class UserNamesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SymbolicNameOrStringParameterListContext symbolicNameOrStringParameterList() {
            return getRuleContext(SymbolicNameOrStringParameterListContext.class, 0);
        }

        public UserNamesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_userNames;
        }
    }

    public final UserNamesContext userNames() throws RecognitionException {
        UserNamesContext _localctx = new UserNamesContext(_ctx, getState());
        enterRule(_localctx, 388, RULE_userNames);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2538);
                symbolicNameOrStringParameterList();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RoleNamesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public SymbolicNameOrStringParameterListContext symbolicNameOrStringParameterList() {
            return getRuleContext(SymbolicNameOrStringParameterListContext.class, 0);
        }

        public RoleNamesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_roleNames;
        }
    }

    public final RoleNamesContext roleNames() throws RecognitionException {
        RoleNamesContext _localctx = new RoleNamesContext(_ctx, getState());
        enterRule(_localctx, 390, RULE_roleNames);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2540);
                symbolicNameOrStringParameterList();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RoleTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ROLES() {
            return getToken(Cypher6Parser.ROLES, 0);
        }

        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public RoleTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_roleToken;
        }
    }

    public final RoleTokenContext roleToken() throws RecognitionException {
        RoleTokenContext _localctx = new RoleTokenContext(_ctx, getState());
        enterRule(_localctx, 392, RULE_roleToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2542);
                _la = _input.LA(1);
                if (!(_la == ROLE || _la == ROLES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class EnableServerCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ENABLE() {
            return getToken(Cypher6Parser.ENABLE, 0);
        }

        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public StringOrParameterContext stringOrParameter() {
            return getRuleContext(StringOrParameterContext.class, 0);
        }

        public CommandOptionsContext commandOptions() {
            return getRuleContext(CommandOptionsContext.class, 0);
        }

        public EnableServerCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_enableServerCommand;
        }
    }

    public final EnableServerCommandContext enableServerCommand() throws RecognitionException {
        EnableServerCommandContext _localctx = new EnableServerCommandContext(_ctx, getState());
        enterRule(_localctx, 394, RULE_enableServerCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2544);
                match(ENABLE);
                setState(2545);
                match(SERVER);
                setState(2546);
                stringOrParameter();
                setState(2548);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == OPTIONS) {
                    {
                        setState(2547);
                        commandOptions();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AlterServerContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public StringOrParameterContext stringOrParameter() {
            return getRuleContext(StringOrParameterContext.class, 0);
        }

        public TerminalNode SET() {
            return getToken(Cypher6Parser.SET, 0);
        }

        public CommandOptionsContext commandOptions() {
            return getRuleContext(CommandOptionsContext.class, 0);
        }

        public AlterServerContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_alterServer;
        }
    }

    public final AlterServerContext alterServer() throws RecognitionException {
        AlterServerContext _localctx = new AlterServerContext(_ctx, getState());
        enterRule(_localctx, 396, RULE_alterServer);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2550);
                match(SERVER);
                setState(2551);
                stringOrParameter();
                setState(2552);
                match(SET);
                setState(2553);
                commandOptions();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RenameServerContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public List<StringOrParameterContext> stringOrParameter() {
            return getRuleContexts(StringOrParameterContext.class);
        }

        public StringOrParameterContext stringOrParameter(int i) {
            return getRuleContext(StringOrParameterContext.class, i);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public RenameServerContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_renameServer;
        }
    }

    public final RenameServerContext renameServer() throws RecognitionException {
        RenameServerContext _localctx = new RenameServerContext(_ctx, getState());
        enterRule(_localctx, 398, RULE_renameServer);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2555);
                match(SERVER);
                setState(2556);
                stringOrParameter();
                setState(2557);
                match(TO);
                setState(2558);
                stringOrParameter();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropServerContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public StringOrParameterContext stringOrParameter() {
            return getRuleContext(StringOrParameterContext.class, 0);
        }

        public DropServerContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropServer;
        }
    }

    public final DropServerContext dropServer() throws RecognitionException {
        DropServerContext _localctx = new DropServerContext(_ctx, getState());
        enterRule(_localctx, 400, RULE_dropServer);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2560);
                match(SERVER);
                setState(2561);
                stringOrParameter();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowServersContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public TerminalNode SERVERS() {
            return getToken(Cypher6Parser.SERVERS, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowServersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showServers;
        }
    }

    public final ShowServersContext showServers() throws RecognitionException {
        ShowServersContext _localctx = new ShowServersContext(_ctx, getState());
        enterRule(_localctx, 402, RULE_showServers);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2563);
                _la = _input.LA(1);
                if (!(_la == SERVER || _la == SERVERS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2565);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2564);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AllocationCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public DeallocateDatabaseFromServersContext deallocateDatabaseFromServers() {
            return getRuleContext(DeallocateDatabaseFromServersContext.class, 0);
        }

        public ReallocateDatabasesContext reallocateDatabases() {
            return getRuleContext(ReallocateDatabasesContext.class, 0);
        }

        public TerminalNode DRYRUN() {
            return getToken(Cypher6Parser.DRYRUN, 0);
        }

        public AllocationCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_allocationCommand;
        }
    }

    public final AllocationCommandContext allocationCommand() throws RecognitionException {
        AllocationCommandContext _localctx = new AllocationCommandContext(_ctx, getState());
        enterRule(_localctx, 404, RULE_allocationCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2568);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == DRYRUN) {
                    {
                        setState(2567);
                        match(DRYRUN);
                    }
                }

                setState(2572);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case DEALLOCATE:
                        {
                            setState(2570);
                            deallocateDatabaseFromServers();
                        }
                        break;
                    case REALLOCATE:
                        {
                            setState(2571);
                            reallocateDatabases();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DeallocateDatabaseFromServersContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DEALLOCATE() {
            return getToken(Cypher6Parser.DEALLOCATE, 0);
        }

        public TerminalNode FROM() {
            return getToken(Cypher6Parser.FROM, 0);
        }

        public List<StringOrParameterContext> stringOrParameter() {
            return getRuleContexts(StringOrParameterContext.class);
        }

        public StringOrParameterContext stringOrParameter(int i) {
            return getRuleContext(StringOrParameterContext.class, i);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode DATABASES() {
            return getToken(Cypher6Parser.DATABASES, 0);
        }

        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public TerminalNode SERVERS() {
            return getToken(Cypher6Parser.SERVERS, 0);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public DeallocateDatabaseFromServersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_deallocateDatabaseFromServers;
        }
    }

    public final DeallocateDatabaseFromServersContext deallocateDatabaseFromServers() throws RecognitionException {
        DeallocateDatabaseFromServersContext _localctx = new DeallocateDatabaseFromServersContext(_ctx, getState());
        enterRule(_localctx, 406, RULE_deallocateDatabaseFromServers);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2574);
                match(DEALLOCATE);
                setState(2575);
                _la = _input.LA(1);
                if (!(_la == DATABASE || _la == DATABASES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2576);
                match(FROM);
                setState(2577);
                _la = _input.LA(1);
                if (!(_la == SERVER || _la == SERVERS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2578);
                stringOrParameter();
                setState(2583);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(2579);
                            match(COMMA);
                            setState(2580);
                            stringOrParameter();
                        }
                    }
                    setState(2585);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ReallocateDatabasesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REALLOCATE() {
            return getToken(Cypher6Parser.REALLOCATE, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode DATABASES() {
            return getToken(Cypher6Parser.DATABASES, 0);
        }

        public ReallocateDatabasesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_reallocateDatabases;
        }
    }

    public final ReallocateDatabasesContext reallocateDatabases() throws RecognitionException {
        ReallocateDatabasesContext _localctx = new ReallocateDatabasesContext(_ctx, getState());
        enterRule(_localctx, 408, RULE_reallocateDatabases);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2586);
                match(REALLOCATE);
                setState(2587);
                _la = _input.LA(1);
                if (!(_la == DATABASE || _la == DATABASES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateRoleContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public List<CommandNameExpressionContext> commandNameExpression() {
            return getRuleContexts(CommandNameExpressionContext.class);
        }

        public CommandNameExpressionContext commandNameExpression(int i) {
            return getRuleContext(CommandNameExpressionContext.class, i);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public TerminalNode COPY() {
            return getToken(Cypher6Parser.COPY, 0);
        }

        public TerminalNode OF() {
            return getToken(Cypher6Parser.OF, 0);
        }

        public CreateRoleContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createRole;
        }
    }

    public final CreateRoleContext createRole() throws RecognitionException {
        CreateRoleContext _localctx = new CreateRoleContext(_ctx, getState());
        enterRule(_localctx, 410, RULE_createRole);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2589);
                match(ROLE);
                setState(2590);
                commandNameExpression();
                setState(2594);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2591);
                        match(IF);
                        setState(2592);
                        match(NOT);
                        setState(2593);
                        match(EXISTS);
                    }
                }

                setState(2600);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(2596);
                        match(AS);
                        setState(2597);
                        match(COPY);
                        setState(2598);
                        match(OF);
                        setState(2599);
                        commandNameExpression();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropRoleContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public CommandNameExpressionContext commandNameExpression() {
            return getRuleContext(CommandNameExpressionContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public DropRoleContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropRole;
        }
    }

    public final DropRoleContext dropRole() throws RecognitionException {
        DropRoleContext _localctx = new DropRoleContext(_ctx, getState());
        enterRule(_localctx, 412, RULE_dropRole);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2602);
                match(ROLE);
                setState(2603);
                commandNameExpression();
                setState(2606);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2604);
                        match(IF);
                        setState(2605);
                        match(EXISTS);
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RenameRoleContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public List<CommandNameExpressionContext> commandNameExpression() {
            return getRuleContexts(CommandNameExpressionContext.class);
        }

        public CommandNameExpressionContext commandNameExpression(int i) {
            return getRuleContext(CommandNameExpressionContext.class, i);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public RenameRoleContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_renameRole;
        }
    }

    public final RenameRoleContext renameRole() throws RecognitionException {
        RenameRoleContext _localctx = new RenameRoleContext(_ctx, getState());
        enterRule(_localctx, 414, RULE_renameRole);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2608);
                match(ROLE);
                setState(2609);
                commandNameExpression();
                setState(2612);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2610);
                        match(IF);
                        setState(2611);
                        match(EXISTS);
                    }
                }

                setState(2614);
                match(TO);
                setState(2615);
                commandNameExpression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowRolesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public RoleTokenContext roleToken() {
            return getRuleContext(RoleTokenContext.class, 0);
        }

        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode POPULATED() {
            return getToken(Cypher6Parser.POPULATED, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode USERS() {
            return getToken(Cypher6Parser.USERS, 0);
        }

        public ShowRolesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showRoles;
        }
    }

    public final ShowRolesContext showRoles() throws RecognitionException {
        ShowRolesContext _localctx = new ShowRolesContext(_ctx, getState());
        enterRule(_localctx, 416, RULE_showRoles);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2618);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ALL || _la == POPULATED) {
                    {
                        setState(2617);
                        _la = _input.LA(1);
                        if (!(_la == ALL || _la == POPULATED)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(2620);
                roleToken();
                setState(2623);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WITH) {
                    {
                        setState(2621);
                        match(WITH);
                        setState(2622);
                        _la = _input.LA(1);
                        if (!(_la == USER || _la == USERS)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(2626);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2625);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GrantRoleContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public RoleNamesContext roleNames() {
            return getRuleContext(RoleNamesContext.class, 0);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public UserNamesContext userNames() {
            return getRuleContext(UserNamesContext.class, 0);
        }

        public GrantRoleContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_grantRole;
        }
    }

    public final GrantRoleContext grantRole() throws RecognitionException {
        GrantRoleContext _localctx = new GrantRoleContext(_ctx, getState());
        enterRule(_localctx, 418, RULE_grantRole);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2628);
                roleNames();
                setState(2629);
                match(TO);
                setState(2630);
                userNames();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RevokeRoleContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public RoleNamesContext roleNames() {
            return getRuleContext(RoleNamesContext.class, 0);
        }

        public TerminalNode FROM() {
            return getToken(Cypher6Parser.FROM, 0);
        }

        public UserNamesContext userNames() {
            return getRuleContext(UserNamesContext.class, 0);
        }

        public RevokeRoleContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_revokeRole;
        }
    }

    public final RevokeRoleContext revokeRole() throws RecognitionException {
        RevokeRoleContext _localctx = new RevokeRoleContext(_ctx, getState());
        enterRule(_localctx, 420, RULE_revokeRole);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2632);
                roleNames();
                setState(2633);
                match(FROM);
                setState(2634);
                userNames();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateUserContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public CommandNameExpressionContext commandNameExpression() {
            return getRuleContext(CommandNameExpressionContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public List<TerminalNode> SET() {
            return getTokens(Cypher6Parser.SET);
        }

        public TerminalNode SET(int i) {
            return getToken(Cypher6Parser.SET, i);
        }

        public List<PasswordContext> password() {
            return getRuleContexts(PasswordContext.class);
        }

        public PasswordContext password(int i) {
            return getRuleContext(PasswordContext.class, i);
        }

        public List<TerminalNode> PASSWORD() {
            return getTokens(Cypher6Parser.PASSWORD);
        }

        public TerminalNode PASSWORD(int i) {
            return getToken(Cypher6Parser.PASSWORD, i);
        }

        public List<PasswordChangeRequiredContext> passwordChangeRequired() {
            return getRuleContexts(PasswordChangeRequiredContext.class);
        }

        public PasswordChangeRequiredContext passwordChangeRequired(int i) {
            return getRuleContext(PasswordChangeRequiredContext.class, i);
        }

        public List<UserStatusContext> userStatus() {
            return getRuleContexts(UserStatusContext.class);
        }

        public UserStatusContext userStatus(int i) {
            return getRuleContext(UserStatusContext.class, i);
        }

        public List<HomeDatabaseContext> homeDatabase() {
            return getRuleContexts(HomeDatabaseContext.class);
        }

        public HomeDatabaseContext homeDatabase(int i) {
            return getRuleContext(HomeDatabaseContext.class, i);
        }

        public List<SetAuthClauseContext> setAuthClause() {
            return getRuleContexts(SetAuthClauseContext.class);
        }

        public SetAuthClauseContext setAuthClause(int i) {
            return getRuleContext(SetAuthClauseContext.class, i);
        }

        public CreateUserContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createUser;
        }
    }

    public final CreateUserContext createUser() throws RecognitionException {
        CreateUserContext _localctx = new CreateUserContext(_ctx, getState());
        enterRule(_localctx, 422, RULE_createUser);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2636);
                match(USER);
                setState(2637);
                commandNameExpression();
                setState(2641);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2638);
                        match(IF);
                        setState(2639);
                        match(NOT);
                        setState(2640);
                        match(EXISTS);
                    }
                }

                setState(2652);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(2643);
                            match(SET);
                            setState(2650);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 299, _ctx)) {
                                case 1:
                                    {
                                        setState(2644);
                                        password();
                                    }
                                    break;
                                case 2:
                                    {
                                        setState(2645);
                                        match(PASSWORD);
                                        setState(2646);
                                        passwordChangeRequired();
                                    }
                                    break;
                                case 3:
                                    {
                                        setState(2647);
                                        userStatus();
                                    }
                                    break;
                                case 4:
                                    {
                                        setState(2648);
                                        homeDatabase();
                                    }
                                    break;
                                case 5:
                                    {
                                        setState(2649);
                                        setAuthClause();
                                    }
                                    break;
                            }
                        }
                    }
                    setState(2654);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == SET);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropUserContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public CommandNameExpressionContext commandNameExpression() {
            return getRuleContext(CommandNameExpressionContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public DropUserContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropUser;
        }
    }

    public final DropUserContext dropUser() throws RecognitionException {
        DropUserContext _localctx = new DropUserContext(_ctx, getState());
        enterRule(_localctx, 424, RULE_dropUser);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2656);
                match(USER);
                setState(2657);
                commandNameExpression();
                setState(2660);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2658);
                        match(IF);
                        setState(2659);
                        match(EXISTS);
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RenameUserContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public List<CommandNameExpressionContext> commandNameExpression() {
            return getRuleContexts(CommandNameExpressionContext.class);
        }

        public CommandNameExpressionContext commandNameExpression(int i) {
            return getRuleContext(CommandNameExpressionContext.class, i);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public RenameUserContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_renameUser;
        }
    }

    public final RenameUserContext renameUser() throws RecognitionException {
        RenameUserContext _localctx = new RenameUserContext(_ctx, getState());
        enterRule(_localctx, 426, RULE_renameUser);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2662);
                match(USER);
                setState(2663);
                commandNameExpression();
                setState(2666);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2664);
                        match(IF);
                        setState(2665);
                        match(EXISTS);
                    }
                }

                setState(2668);
                match(TO);
                setState(2669);
                commandNameExpression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AlterCurrentUserContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CURRENT() {
            return getToken(Cypher6Parser.CURRENT, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode SET() {
            return getToken(Cypher6Parser.SET, 0);
        }

        public TerminalNode PASSWORD() {
            return getToken(Cypher6Parser.PASSWORD, 0);
        }

        public TerminalNode FROM() {
            return getToken(Cypher6Parser.FROM, 0);
        }

        public List<PasswordExpressionContext> passwordExpression() {
            return getRuleContexts(PasswordExpressionContext.class);
        }

        public PasswordExpressionContext passwordExpression(int i) {
            return getRuleContext(PasswordExpressionContext.class, i);
        }

        public TerminalNode TO() {
            return getToken(Cypher6Parser.TO, 0);
        }

        public AlterCurrentUserContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_alterCurrentUser;
        }
    }

    public final AlterCurrentUserContext alterCurrentUser() throws RecognitionException {
        AlterCurrentUserContext _localctx = new AlterCurrentUserContext(_ctx, getState());
        enterRule(_localctx, 428, RULE_alterCurrentUser);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2671);
                match(CURRENT);
                setState(2672);
                match(USER);
                setState(2673);
                match(SET);
                setState(2674);
                match(PASSWORD);
                setState(2675);
                match(FROM);
                setState(2676);
                passwordExpression();
                setState(2677);
                match(TO);
                setState(2678);
                passwordExpression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AlterUserContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public CommandNameExpressionContext commandNameExpression() {
            return getRuleContext(CommandNameExpressionContext.class, 0);
        }

        public TerminalNode IF() {
            return getToken(Cypher6Parser.IF, 0);
        }

        public TerminalNode EXISTS() {
            return getToken(Cypher6Parser.EXISTS, 0);
        }

        public List<TerminalNode> REMOVE() {
            return getTokens(Cypher6Parser.REMOVE);
        }

        public TerminalNode REMOVE(int i) {
            return getToken(Cypher6Parser.REMOVE, i);
        }

        public List<TerminalNode> SET() {
            return getTokens(Cypher6Parser.SET);
        }

        public TerminalNode SET(int i) {
            return getToken(Cypher6Parser.SET, i);
        }

        public List<TerminalNode> HOME() {
            return getTokens(Cypher6Parser.HOME);
        }

        public TerminalNode HOME(int i) {
            return getToken(Cypher6Parser.HOME, i);
        }

        public List<TerminalNode> DATABASE() {
            return getTokens(Cypher6Parser.DATABASE);
        }

        public TerminalNode DATABASE(int i) {
            return getToken(Cypher6Parser.DATABASE, i);
        }

        public List<TerminalNode> ALL() {
            return getTokens(Cypher6Parser.ALL);
        }

        public TerminalNode ALL(int i) {
            return getToken(Cypher6Parser.ALL, i);
        }

        public List<TerminalNode> AUTH() {
            return getTokens(Cypher6Parser.AUTH);
        }

        public TerminalNode AUTH(int i) {
            return getToken(Cypher6Parser.AUTH, i);
        }

        public List<RemoveNamedProviderContext> removeNamedProvider() {
            return getRuleContexts(RemoveNamedProviderContext.class);
        }

        public RemoveNamedProviderContext removeNamedProvider(int i) {
            return getRuleContext(RemoveNamedProviderContext.class, i);
        }

        public List<PasswordContext> password() {
            return getRuleContexts(PasswordContext.class);
        }

        public PasswordContext password(int i) {
            return getRuleContext(PasswordContext.class, i);
        }

        public List<TerminalNode> PASSWORD() {
            return getTokens(Cypher6Parser.PASSWORD);
        }

        public TerminalNode PASSWORD(int i) {
            return getToken(Cypher6Parser.PASSWORD, i);
        }

        public List<PasswordChangeRequiredContext> passwordChangeRequired() {
            return getRuleContexts(PasswordChangeRequiredContext.class);
        }

        public PasswordChangeRequiredContext passwordChangeRequired(int i) {
            return getRuleContext(PasswordChangeRequiredContext.class, i);
        }

        public List<UserStatusContext> userStatus() {
            return getRuleContexts(UserStatusContext.class);
        }

        public UserStatusContext userStatus(int i) {
            return getRuleContext(UserStatusContext.class, i);
        }

        public List<HomeDatabaseContext> homeDatabase() {
            return getRuleContexts(HomeDatabaseContext.class);
        }

        public HomeDatabaseContext homeDatabase(int i) {
            return getRuleContext(HomeDatabaseContext.class, i);
        }

        public List<SetAuthClauseContext> setAuthClause() {
            return getRuleContexts(SetAuthClauseContext.class);
        }

        public SetAuthClauseContext setAuthClause(int i) {
            return getRuleContext(SetAuthClauseContext.class, i);
        }

        public List<TerminalNode> PROVIDER() {
            return getTokens(Cypher6Parser.PROVIDER);
        }

        public TerminalNode PROVIDER(int i) {
            return getToken(Cypher6Parser.PROVIDER, i);
        }

        public List<TerminalNode> PROVIDERS() {
            return getTokens(Cypher6Parser.PROVIDERS);
        }

        public TerminalNode PROVIDERS(int i) {
            return getToken(Cypher6Parser.PROVIDERS, i);
        }

        public AlterUserContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_alterUser;
        }
    }

    public final AlterUserContext alterUser() throws RecognitionException {
        AlterUserContext _localctx = new AlterUserContext(_ctx, getState());
        enterRule(_localctx, 430, RULE_alterUser);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2680);
                match(USER);
                setState(2681);
                commandNameExpression();
                setState(2684);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == IF) {
                    {
                        setState(2682);
                        match(IF);
                        setState(2683);
                        match(EXISTS);
                    }
                }

                setState(2699);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == REMOVE) {
                    {
                        {
                            setState(2686);
                            match(REMOVE);
                            setState(2695);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case HOME:
                                    {
                                        setState(2687);
                                        match(HOME);
                                        setState(2688);
                                        match(DATABASE);
                                    }
                                    break;
                                case ALL:
                                    {
                                        setState(2689);
                                        match(ALL);
                                        setState(2690);
                                        match(AUTH);
                                        setState(2692);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                        if (_la == PROVIDER || _la == PROVIDERS) {
                                            {
                                                setState(2691);
                                                _la = _input.LA(1);
                                                if (!(_la == PROVIDER || _la == PROVIDERS)) {
                                                    _errHandler.recoverInline(this);
                                                } else {
                                                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                                    _errHandler.reportMatch(this);
                                                    consume();
                                                }
                                            }
                                        }
                                    }
                                    break;
                                case AUTH:
                                    {
                                        setState(2694);
                                        removeNamedProvider();
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                        }
                    }
                    setState(2701);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
                setState(2713);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == SET) {
                    {
                        {
                            setState(2702);
                            match(SET);
                            setState(2709);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 307, _ctx)) {
                                case 1:
                                    {
                                        setState(2703);
                                        password();
                                    }
                                    break;
                                case 2:
                                    {
                                        setState(2704);
                                        match(PASSWORD);
                                        setState(2705);
                                        passwordChangeRequired();
                                    }
                                    break;
                                case 3:
                                    {
                                        setState(2706);
                                        userStatus();
                                    }
                                    break;
                                case 4:
                                    {
                                        setState(2707);
                                        homeDatabase();
                                    }
                                    break;
                                case 5:
                                    {
                                        setState(2708);
                                        setAuthClause();
                                    }
                                    break;
                            }
                        }
                    }
                    setState(2715);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemoveNamedProviderContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode AUTH() {
            return getToken(Cypher6Parser.AUTH, 0);
        }

        public StringLiteralContext stringLiteral() {
            return getRuleContext(StringLiteralContext.class, 0);
        }

        public StringListLiteralContext stringListLiteral() {
            return getRuleContext(StringListLiteralContext.class, 0);
        }

        public ParameterContext parameter() {
            return getRuleContext(ParameterContext.class, 0);
        }

        public TerminalNode PROVIDER() {
            return getToken(Cypher6Parser.PROVIDER, 0);
        }

        public TerminalNode PROVIDERS() {
            return getToken(Cypher6Parser.PROVIDERS, 0);
        }

        public RemoveNamedProviderContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_removeNamedProvider;
        }
    }

    public final RemoveNamedProviderContext removeNamedProvider() throws RecognitionException {
        RemoveNamedProviderContext _localctx = new RemoveNamedProviderContext(_ctx, getState());
        enterRule(_localctx, 432, RULE_removeNamedProvider);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2716);
                match(AUTH);
                setState(2718);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == PROVIDER || _la == PROVIDERS) {
                    {
                        setState(2717);
                        _la = _input.LA(1);
                        if (!(_la == PROVIDER || _la == PROVIDERS)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(2723);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case STRING_LITERAL1:
                    case STRING_LITERAL2:
                        {
                            setState(2720);
                            stringLiteral();
                        }
                        break;
                    case LBRACKET:
                        {
                            setState(2721);
                            stringListLiteral();
                        }
                        break;
                    case DOLLAR:
                        {
                            setState(2722);
                            parameter("ANY");
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PasswordContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PASSWORD() {
            return getToken(Cypher6Parser.PASSWORD, 0);
        }

        public PasswordExpressionContext passwordExpression() {
            return getRuleContext(PasswordExpressionContext.class, 0);
        }

        public PasswordChangeRequiredContext passwordChangeRequired() {
            return getRuleContext(PasswordChangeRequiredContext.class, 0);
        }

        public TerminalNode PLAINTEXT() {
            return getToken(Cypher6Parser.PLAINTEXT, 0);
        }

        public TerminalNode ENCRYPTED() {
            return getToken(Cypher6Parser.ENCRYPTED, 0);
        }

        public PasswordContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_password;
        }
    }

    public final PasswordContext password() throws RecognitionException {
        PasswordContext _localctx = new PasswordContext(_ctx, getState());
        enterRule(_localctx, 434, RULE_password);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2726);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ENCRYPTED || _la == PLAINTEXT) {
                    {
                        setState(2725);
                        _la = _input.LA(1);
                        if (!(_la == ENCRYPTED || _la == PLAINTEXT)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(2728);
                match(PASSWORD);
                setState(2729);
                passwordExpression();
                setState(2731);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == CHANGE) {
                    {
                        setState(2730);
                        passwordChangeRequired();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PasswordOnlyContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PASSWORD() {
            return getToken(Cypher6Parser.PASSWORD, 0);
        }

        public PasswordExpressionContext passwordExpression() {
            return getRuleContext(PasswordExpressionContext.class, 0);
        }

        public TerminalNode PLAINTEXT() {
            return getToken(Cypher6Parser.PLAINTEXT, 0);
        }

        public TerminalNode ENCRYPTED() {
            return getToken(Cypher6Parser.ENCRYPTED, 0);
        }

        public PasswordOnlyContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_passwordOnly;
        }
    }

    public final PasswordOnlyContext passwordOnly() throws RecognitionException {
        PasswordOnlyContext _localctx = new PasswordOnlyContext(_ctx, getState());
        enterRule(_localctx, 436, RULE_passwordOnly);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2734);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ENCRYPTED || _la == PLAINTEXT) {
                    {
                        setState(2733);
                        _la = _input.LA(1);
                        if (!(_la == ENCRYPTED || _la == PLAINTEXT)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(2736);
                match(PASSWORD);
                setState(2737);
                passwordExpression();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PasswordExpressionContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public StringLiteralContext stringLiteral() {
            return getRuleContext(StringLiteralContext.class, 0);
        }

        public ParameterContext parameter() {
            return getRuleContext(ParameterContext.class, 0);
        }

        public PasswordExpressionContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_passwordExpression;
        }
    }

    public final PasswordExpressionContext passwordExpression() throws RecognitionException {
        PasswordExpressionContext _localctx = new PasswordExpressionContext(_ctx, getState());
        enterRule(_localctx, 438, RULE_passwordExpression);
        try {
            setState(2741);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case STRING_LITERAL1:
                case STRING_LITERAL2:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2739);
                        stringLiteral();
                    }
                    break;
                case DOLLAR:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2740);
                        parameter("STRING");
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PasswordChangeRequiredContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CHANGE() {
            return getToken(Cypher6Parser.CHANGE, 0);
        }

        public TerminalNode REQUIRED() {
            return getToken(Cypher6Parser.REQUIRED, 0);
        }

        public TerminalNode NOT() {
            return getToken(Cypher6Parser.NOT, 0);
        }

        public PasswordChangeRequiredContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_passwordChangeRequired;
        }
    }

    public final PasswordChangeRequiredContext passwordChangeRequired() throws RecognitionException {
        PasswordChangeRequiredContext _localctx = new PasswordChangeRequiredContext(_ctx, getState());
        enterRule(_localctx, 440, RULE_passwordChangeRequired);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2743);
                match(CHANGE);
                setState(2745);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == NOT) {
                    {
                        setState(2744);
                        match(NOT);
                    }
                }

                setState(2747);
                match(REQUIRED);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class UserStatusContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode STATUS() {
            return getToken(Cypher6Parser.STATUS, 0);
        }

        public TerminalNode SUSPENDED() {
            return getToken(Cypher6Parser.SUSPENDED, 0);
        }

        public TerminalNode ACTIVE() {
            return getToken(Cypher6Parser.ACTIVE, 0);
        }

        public UserStatusContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_userStatus;
        }
    }

    public final UserStatusContext userStatus() throws RecognitionException {
        UserStatusContext _localctx = new UserStatusContext(_ctx, getState());
        enterRule(_localctx, 442, RULE_userStatus);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2749);
                match(STATUS);
                setState(2750);
                _la = _input.LA(1);
                if (!(_la == ACTIVE || _la == SUSPENDED)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class HomeDatabaseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode HOME() {
            return getToken(Cypher6Parser.HOME, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public SymbolicAliasNameOrParameterContext symbolicAliasNameOrParameter() {
            return getRuleContext(SymbolicAliasNameOrParameterContext.class, 0);
        }

        public HomeDatabaseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_homeDatabase;
        }
    }

    public final HomeDatabaseContext homeDatabase() throws RecognitionException {
        HomeDatabaseContext _localctx = new HomeDatabaseContext(_ctx, getState());
        enterRule(_localctx, 444, RULE_homeDatabase);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2752);
                match(HOME);
                setState(2753);
                match(DATABASE);
                setState(2754);
                symbolicAliasNameOrParameter();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetAuthClauseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode AUTH() {
            return getToken(Cypher6Parser.AUTH, 0);
        }

        public StringLiteralContext stringLiteral() {
            return getRuleContext(StringLiteralContext.class, 0);
        }

        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public TerminalNode PROVIDER() {
            return getToken(Cypher6Parser.PROVIDER, 0);
        }

        public List<TerminalNode> SET() {
            return getTokens(Cypher6Parser.SET);
        }

        public TerminalNode SET(int i) {
            return getToken(Cypher6Parser.SET, i);
        }

        public List<UserAuthAttributeContext> userAuthAttribute() {
            return getRuleContexts(UserAuthAttributeContext.class);
        }

        public UserAuthAttributeContext userAuthAttribute(int i) {
            return getRuleContext(UserAuthAttributeContext.class, i);
        }

        public SetAuthClauseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_setAuthClause;
        }
    }

    public final SetAuthClauseContext setAuthClause() throws RecognitionException {
        SetAuthClauseContext _localctx = new SetAuthClauseContext(_ctx, getState());
        enterRule(_localctx, 446, RULE_setAuthClause);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2756);
                match(AUTH);
                setState(2758);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == PROVIDER) {
                    {
                        setState(2757);
                        match(PROVIDER);
                    }
                }

                setState(2760);
                stringLiteral();
                setState(2761);
                match(LCURLY);
                setState(2764);
                _errHandler.sync(this);
                _la = _input.LA(1);
                do {
                    {
                        {
                            setState(2762);
                            match(SET);
                            {
                                setState(2763);
                                userAuthAttribute();
                            }
                        }
                    }
                    setState(2766);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                } while (_la == SET);
                setState(2768);
                match(RCURLY);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class UserAuthAttributeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ID() {
            return getToken(Cypher6Parser.ID, 0);
        }

        public StringOrParameterExpressionContext stringOrParameterExpression() {
            return getRuleContext(StringOrParameterExpressionContext.class, 0);
        }

        public PasswordOnlyContext passwordOnly() {
            return getRuleContext(PasswordOnlyContext.class, 0);
        }

        public TerminalNode PASSWORD() {
            return getToken(Cypher6Parser.PASSWORD, 0);
        }

        public PasswordChangeRequiredContext passwordChangeRequired() {
            return getRuleContext(PasswordChangeRequiredContext.class, 0);
        }

        public UserAuthAttributeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_userAuthAttribute;
        }
    }

    public final UserAuthAttributeContext userAuthAttribute() throws RecognitionException {
        UserAuthAttributeContext _localctx = new UserAuthAttributeContext(_ctx, getState());
        enterRule(_localctx, 448, RULE_userAuthAttribute);
        try {
            setState(2775);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 318, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2770);
                        match(ID);
                        setState(2771);
                        stringOrParameterExpression();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2772);
                        passwordOnly();
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2773);
                        match(PASSWORD);
                        setState(2774);
                        passwordChangeRequired();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowUsersContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode USERS() {
            return getToken(Cypher6Parser.USERS, 0);
        }

        public TerminalNode WITH() {
            return getToken(Cypher6Parser.WITH, 0);
        }

        public TerminalNode AUTH() {
            return getToken(Cypher6Parser.AUTH, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowUsersContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showUsers;
        }
    }

    public final ShowUsersContext showUsers() throws RecognitionException {
        ShowUsersContext _localctx = new ShowUsersContext(_ctx, getState());
        enterRule(_localctx, 450, RULE_showUsers);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2777);
                _la = _input.LA(1);
                if (!(_la == USER || _la == USERS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2780);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WITH) {
                    {
                        setState(2778);
                        match(WITH);
                        setState(2779);
                        match(AUTH);
                    }
                }

                setState(2783);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2782);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowCurrentUserContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CURRENT() {
            return getToken(Cypher6Parser.CURRENT, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowCurrentUserContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showCurrentUser;
        }
    }

    public final ShowCurrentUserContext showCurrentUser() throws RecognitionException {
        ShowCurrentUserContext _localctx = new ShowCurrentUserContext(_ctx, getState());
        enterRule(_localctx, 452, RULE_showCurrentUser);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2785);
                match(CURRENT);
                setState(2786);
                match(USER);
                setState(2788);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2787);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowSupportedPrivilegesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SUPPORTED() {
            return getToken(Cypher6Parser.SUPPORTED, 0);
        }

        public PrivilegeTokenContext privilegeToken() {
            return getRuleContext(PrivilegeTokenContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowSupportedPrivilegesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showSupportedPrivileges;
        }
    }

    public final ShowSupportedPrivilegesContext showSupportedPrivileges() throws RecognitionException {
        ShowSupportedPrivilegesContext _localctx = new ShowSupportedPrivilegesContext(_ctx, getState());
        enterRule(_localctx, 454, RULE_showSupportedPrivileges);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2790);
                match(SUPPORTED);
                setState(2791);
                privilegeToken();
                setState(2793);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2792);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowPrivilegesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public PrivilegeTokenContext privilegeToken() {
            return getRuleContext(PrivilegeTokenContext.class, 0);
        }

        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public PrivilegeAsCommandContext privilegeAsCommand() {
            return getRuleContext(PrivilegeAsCommandContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowPrivilegesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showPrivileges;
        }
    }

    public final ShowPrivilegesContext showPrivileges() throws RecognitionException {
        ShowPrivilegesContext _localctx = new ShowPrivilegesContext(_ctx, getState());
        enterRule(_localctx, 456, RULE_showPrivileges);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2796);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == ALL) {
                    {
                        setState(2795);
                        match(ALL);
                    }
                }

                setState(2798);
                privilegeToken();
                setState(2800);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(2799);
                        privilegeAsCommand();
                    }
                }

                setState(2803);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2802);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowRolePrivilegesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public RoleNamesContext roleNames() {
            return getRuleContext(RoleNamesContext.class, 0);
        }

        public PrivilegeTokenContext privilegeToken() {
            return getRuleContext(PrivilegeTokenContext.class, 0);
        }

        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public TerminalNode ROLES() {
            return getToken(Cypher6Parser.ROLES, 0);
        }

        public PrivilegeAsCommandContext privilegeAsCommand() {
            return getRuleContext(PrivilegeAsCommandContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowRolePrivilegesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showRolePrivileges;
        }
    }

    public final ShowRolePrivilegesContext showRolePrivileges() throws RecognitionException {
        ShowRolePrivilegesContext _localctx = new ShowRolePrivilegesContext(_ctx, getState());
        enterRule(_localctx, 458, RULE_showRolePrivileges);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2805);
                _la = _input.LA(1);
                if (!(_la == ROLE || _la == ROLES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2806);
                roleNames();
                setState(2807);
                privilegeToken();
                setState(2809);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(2808);
                        privilegeAsCommand();
                    }
                }

                setState(2812);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2811);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowUserPrivilegesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public PrivilegeTokenContext privilegeToken() {
            return getRuleContext(PrivilegeTokenContext.class, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode USERS() {
            return getToken(Cypher6Parser.USERS, 0);
        }

        public UserNamesContext userNames() {
            return getRuleContext(UserNamesContext.class, 0);
        }

        public PrivilegeAsCommandContext privilegeAsCommand() {
            return getRuleContext(PrivilegeAsCommandContext.class, 0);
        }

        public ShowCommandYieldContext showCommandYield() {
            return getRuleContext(ShowCommandYieldContext.class, 0);
        }

        public ShowUserPrivilegesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showUserPrivileges;
        }
    }

    public final ShowUserPrivilegesContext showUserPrivileges() throws RecognitionException {
        ShowUserPrivilegesContext _localctx = new ShowUserPrivilegesContext(_ctx, getState());
        enterRule(_localctx, 460, RULE_showUserPrivileges);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2814);
                _la = _input.LA(1);
                if (!(_la == USER || _la == USERS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
                setState(2816);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 328, _ctx)) {
                    case 1:
                        {
                            setState(2815);
                            userNames();
                        }
                        break;
                }
                setState(2818);
                privilegeToken();
                setState(2820);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == AS) {
                    {
                        setState(2819);
                        privilegeAsCommand();
                    }
                }

                setState(2823);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == WHERE || _la == YIELD) {
                    {
                        setState(2822);
                        showCommandYield();
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PrivilegeAsCommandContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode AS() {
            return getToken(Cypher6Parser.AS, 0);
        }

        public TerminalNode COMMAND() {
            return getToken(Cypher6Parser.COMMAND, 0);
        }

        public TerminalNode COMMANDS() {
            return getToken(Cypher6Parser.COMMANDS, 0);
        }

        public TerminalNode REVOKE() {
            return getToken(Cypher6Parser.REVOKE, 0);
        }

        public PrivilegeAsCommandContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_privilegeAsCommand;
        }
    }

    public final PrivilegeAsCommandContext privilegeAsCommand() throws RecognitionException {
        PrivilegeAsCommandContext _localctx = new PrivilegeAsCommandContext(_ctx, getState());
        enterRule(_localctx, 462, RULE_privilegeAsCommand);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2825);
                match(AS);
                setState(2827);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == REVOKE) {
                    {
                        setState(2826);
                        match(REVOKE);
                    }
                }

                setState(2829);
                _la = _input.LA(1);
                if (!(_la == COMMAND || _la == COMMANDS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PrivilegeTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PRIVILEGE() {
            return getToken(Cypher6Parser.PRIVILEGE, 0);
        }

        public TerminalNode PRIVILEGES() {
            return getToken(Cypher6Parser.PRIVILEGES, 0);
        }

        public PrivilegeTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_privilegeToken;
        }
    }

    public final PrivilegeTokenContext privilegeToken() throws RecognitionException {
        PrivilegeTokenContext _localctx = new PrivilegeTokenContext(_ctx, getState());
        enterRule(_localctx, 464, RULE_privilegeToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2831);
                _la = _input.LA(1);
                if (!(_la == PRIVILEGE || _la == PRIVILEGES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public AllPrivilegeContext allPrivilege() {
            return getRuleContext(AllPrivilegeContext.class, 0);
        }

        public CreatePrivilegeContext createPrivilege() {
            return getRuleContext(CreatePrivilegeContext.class, 0);
        }

        public DatabasePrivilegeContext databasePrivilege() {
            return getRuleContext(DatabasePrivilegeContext.class, 0);
        }

        public DbmsPrivilegeContext dbmsPrivilege() {
            return getRuleContext(DbmsPrivilegeContext.class, 0);
        }

        public DropPrivilegeContext dropPrivilege() {
            return getRuleContext(DropPrivilegeContext.class, 0);
        }

        public LoadPrivilegeContext loadPrivilege() {
            return getRuleContext(LoadPrivilegeContext.class, 0);
        }

        public QualifiedGraphPrivilegesContext qualifiedGraphPrivileges() {
            return getRuleContext(QualifiedGraphPrivilegesContext.class, 0);
        }

        public QualifiedGraphPrivilegesWithPropertyContext qualifiedGraphPrivilegesWithProperty() {
            return getRuleContext(QualifiedGraphPrivilegesWithPropertyContext.class, 0);
        }

        public RemovePrivilegeContext removePrivilege() {
            return getRuleContext(RemovePrivilegeContext.class, 0);
        }

        public SetPrivilegeContext setPrivilege() {
            return getRuleContext(SetPrivilegeContext.class, 0);
        }

        public ShowPrivilegeContext showPrivilege() {
            return getRuleContext(ShowPrivilegeContext.class, 0);
        }

        public WritePrivilegeContext writePrivilege() {
            return getRuleContext(WritePrivilegeContext.class, 0);
        }

        public PrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_privilege;
        }
    }

    public final PrivilegeContext privilege() throws RecognitionException {
        PrivilegeContext _localctx = new PrivilegeContext(_ctx, getState());
        enterRule(_localctx, 466, RULE_privilege);
        try {
            setState(2845);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case ALL:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2833);
                        allPrivilege();
                    }
                    break;
                case CREATE:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2834);
                        createPrivilege();
                    }
                    break;
                case ACCESS:
                case CONSTRAINT:
                case CONSTRAINTS:
                case INDEX:
                case INDEXES:
                case NAME:
                case START:
                case STOP:
                case TERMINATE:
                case TRANSACTION:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2835);
                        databasePrivilege();
                    }
                    break;
                case ALIAS:
                case ALTER:
                case ASSIGN:
                case COMPOSITE:
                case DATABASE:
                case EXECUTE:
                case IMPERSONATE:
                case PRIVILEGE:
                case RENAME:
                case ROLE:
                case SERVER:
                case USER:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2836);
                        dbmsPrivilege();
                    }
                    break;
                case DROP:
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(2837);
                        dropPrivilege();
                    }
                    break;
                case LOAD:
                    enterOuterAlt(_localctx, 6);
                    {
                        setState(2838);
                        loadPrivilege();
                    }
                    break;
                case DELETE:
                case MERGE:
                    enterOuterAlt(_localctx, 7);
                    {
                        setState(2839);
                        qualifiedGraphPrivileges();
                    }
                    break;
                case MATCH:
                case READ:
                case TRAVERSE:
                    enterOuterAlt(_localctx, 8);
                    {
                        setState(2840);
                        qualifiedGraphPrivilegesWithProperty();
                    }
                    break;
                case REMOVE:
                    enterOuterAlt(_localctx, 9);
                    {
                        setState(2841);
                        removePrivilege();
                    }
                    break;
                case SET:
                    enterOuterAlt(_localctx, 10);
                    {
                        setState(2842);
                        setPrivilege();
                    }
                    break;
                case SHOW:
                    enterOuterAlt(_localctx, 11);
                    {
                        setState(2843);
                        showPrivilege();
                    }
                    break;
                case WRITE:
                    enterOuterAlt(_localctx, 12);
                    {
                        setState(2844);
                        writePrivilege();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AllPrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public AllPrivilegeTargetContext allPrivilegeTarget() {
            return getRuleContext(AllPrivilegeTargetContext.class, 0);
        }

        public AllPrivilegeTypeContext allPrivilegeType() {
            return getRuleContext(AllPrivilegeTypeContext.class, 0);
        }

        public AllPrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_allPrivilege;
        }
    }

    public final AllPrivilegeContext allPrivilege() throws RecognitionException {
        AllPrivilegeContext _localctx = new AllPrivilegeContext(_ctx, getState());
        enterRule(_localctx, 468, RULE_allPrivilege);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2847);
                match(ALL);
                setState(2849);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (((((_la - 61)) & ~0x3f) == 0 && ((1L << (_la - 61)) & 36028797018963985L) != 0)
                        || _la == PRIVILEGES) {
                    {
                        setState(2848);
                        allPrivilegeType();
                    }
                }

                setState(2851);
                match(ON);
                setState(2852);
                allPrivilegeTarget();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AllPrivilegeTypeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PRIVILEGES() {
            return getToken(Cypher6Parser.PRIVILEGES, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode GRAPH() {
            return getToken(Cypher6Parser.GRAPH, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public AllPrivilegeTypeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_allPrivilegeType;
        }
    }

    public final AllPrivilegeTypeContext allPrivilegeType() throws RecognitionException {
        AllPrivilegeTypeContext _localctx = new AllPrivilegeTypeContext(_ctx, getState());
        enterRule(_localctx, 470, RULE_allPrivilegeType);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2855);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (((((_la - 61)) & ~0x3f) == 0 && ((1L << (_la - 61)) & 36028797018963985L) != 0)) {
                    {
                        setState(2854);
                        _la = _input.LA(1);
                        if (!(((((_la - 61)) & ~0x3f) == 0 && ((1L << (_la - 61)) & 36028797018963985L) != 0))) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                }

                setState(2857);
                match(PRIVILEGES);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AllPrivilegeTargetContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public AllPrivilegeTargetContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_allPrivilegeTarget;
        }

        public AllPrivilegeTargetContext() {}

        public void copyFrom(AllPrivilegeTargetContext ctx) {
            super.copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DefaultTargetContext extends AllPrivilegeTargetContext {
        public TerminalNode DEFAULT() {
            return getToken(Cypher6Parser.DEFAULT, 0);
        }

        public TerminalNode HOME() {
            return getToken(Cypher6Parser.HOME, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode GRAPH() {
            return getToken(Cypher6Parser.GRAPH, 0);
        }

        public DefaultTargetContext(AllPrivilegeTargetContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DatabaseVariableTargetContext extends AllPrivilegeTargetContext {
        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode DATABASES() {
            return getToken(Cypher6Parser.DATABASES, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public SymbolicAliasNameListContext symbolicAliasNameList() {
            return getRuleContext(SymbolicAliasNameListContext.class, 0);
        }

        public DatabaseVariableTargetContext(AllPrivilegeTargetContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GraphVariableTargetContext extends AllPrivilegeTargetContext {
        public TerminalNode GRAPH() {
            return getToken(Cypher6Parser.GRAPH, 0);
        }

        public TerminalNode GRAPHS() {
            return getToken(Cypher6Parser.GRAPHS, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public SymbolicAliasNameListContext symbolicAliasNameList() {
            return getRuleContext(SymbolicAliasNameListContext.class, 0);
        }

        public GraphVariableTargetContext(AllPrivilegeTargetContext ctx) {
            copyFrom(ctx);
        }
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DBMSTargetContext extends AllPrivilegeTargetContext {
        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public DBMSTargetContext(AllPrivilegeTargetContext ctx) {
            copyFrom(ctx);
        }
    }

    public final AllPrivilegeTargetContext allPrivilegeTarget() throws RecognitionException {
        AllPrivilegeTargetContext _localctx = new AllPrivilegeTargetContext(_ctx, getState());
        enterRule(_localctx, 472, RULE_allPrivilegeTarget);
        int _la;
        try {
            setState(2872);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case DEFAULT:
                case HOME:
                    _localctx = new DefaultTargetContext(_localctx);
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2859);
                        _la = _input.LA(1);
                        if (!(_la == DEFAULT || _la == HOME)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(2860);
                        _la = _input.LA(1);
                        if (!(_la == DATABASE || _la == GRAPH)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                    }
                    break;
                case DATABASE:
                case DATABASES:
                    _localctx = new DatabaseVariableTargetContext(_localctx);
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2861);
                        _la = _input.LA(1);
                        if (!(_la == DATABASE || _la == DATABASES)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(2864);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case TIMES:
                                {
                                    setState(2862);
                                    match(TIMES);
                                }
                                break;
                            case ESCAPED_SYMBOLIC_NAME:
                            case ACCESS:
                            case ACTIVE:
                            case ADMIN:
                            case ADMINISTRATOR:
                            case ALIAS:
                            case ALIASES:
                            case ALL_SHORTEST_PATHS:
                            case ALL:
                            case ALTER:
                            case AND:
                            case ANY:
                            case ARRAY:
                            case AS:
                            case ASC:
                            case ASCENDING:
                            case ASSIGN:
                            case AT:
                            case AUTH:
                            case BINDINGS:
                            case BOOL:
                            case BOOLEAN:
                            case BOOSTED:
                            case BOTH:
                            case BREAK:
                            case BTREE:
                            case BUILT:
                            case BY:
                            case CALL:
                            case CASE:
                            case CHANGE:
                            case CIDR:
                            case COLLECT:
                            case COMMAND:
                            case COMMANDS:
                            case COMPOSITE:
                            case CONCURRENT:
                            case CONSTRAINT:
                            case CONSTRAINTS:
                            case CONTAINS:
                            case COPY:
                            case CONTINUE:
                            case COUNT:
                            case CREATE:
                            case CSV:
                            case CURRENT:
                            case DATA:
                            case DATABASE:
                            case DATABASES:
                            case DATE:
                            case DATETIME:
                            case DBMS:
                            case DEALLOCATE:
                            case DEFAULT:
                            case DEFINED:
                            case DELETE:
                            case DENY:
                            case DESC:
                            case DESCENDING:
                            case DESTROY:
                            case DETACH:
                            case DIFFERENT:
                            case DOLLAR:
                            case DISTINCT:
                            case DRIVER:
                            case DROP:
                            case DRYRUN:
                            case DUMP:
                            case DURATION:
                            case EACH:
                            case EDGE:
                            case ENABLE:
                            case ELEMENT:
                            case ELEMENTS:
                            case ELSE:
                            case ENCRYPTED:
                            case END:
                            case ENDS:
                            case EXECUTABLE:
                            case EXECUTE:
                            case EXIST:
                            case EXISTENCE:
                            case EXISTS:
                            case ERROR:
                            case FAIL:
                            case FALSE:
                            case FIELDTERMINATOR:
                            case FINISH:
                            case FLOAT:
                            case FOR:
                            case FOREACH:
                            case FROM:
                            case FULLTEXT:
                            case FUNCTION:
                            case FUNCTIONS:
                            case GRANT:
                            case GRAPH:
                            case GRAPHS:
                            case GROUP:
                            case GROUPS:
                            case HEADERS:
                            case HOME:
                            case ID:
                            case IF:
                            case IMPERSONATE:
                            case IMMUTABLE:
                            case IN:
                            case INDEX:
                            case INDEXES:
                            case INF:
                            case INFINITY:
                            case INSERT:
                            case INT:
                            case INTEGER:
                            case IS:
                            case JOIN:
                            case KEY:
                            case LABEL:
                            case LABELS:
                            case LEADING:
                            case LIMITROWS:
                            case LIST:
                            case LOAD:
                            case LOCAL:
                            case LOOKUP:
                            case MANAGEMENT:
                            case MAP:
                            case MATCH:
                            case MERGE:
                            case NAME:
                            case NAMES:
                            case NAN:
                            case NFC:
                            case NFD:
                            case NFKC:
                            case NFKD:
                            case NEW:
                            case NODE:
                            case NODETACH:
                            case NODES:
                            case NONE:
                            case NORMALIZE:
                            case NORMALIZED:
                            case NOT:
                            case NOTHING:
                            case NOWAIT:
                            case NULL:
                            case OF:
                            case ON:
                            case ONLY:
                            case OPTIONAL:
                            case OPTIONS:
                            case OPTION:
                            case OR:
                            case ORDER:
                            case PASSWORD:
                            case PASSWORDS:
                            case PATH:
                            case PATHS:
                            case PLAINTEXT:
                            case POINT:
                            case POPULATED:
                            case PRIMARY:
                            case PRIMARIES:
                            case PRIVILEGE:
                            case PRIVILEGES:
                            case PROCEDURE:
                            case PROCEDURES:
                            case PROPERTIES:
                            case PROPERTY:
                            case PROVIDER:
                            case PROVIDERS:
                            case RANGE:
                            case READ:
                            case REALLOCATE:
                            case REDUCE:
                            case RENAME:
                            case REL:
                            case RELATIONSHIP:
                            case RELATIONSHIPS:
                            case REMOVE:
                            case REPEATABLE:
                            case REPLACE:
                            case REPORT:
                            case REQUIRE:
                            case REQUIRED:
                            case RETURN:
                            case REVOKE:
                            case ROLE:
                            case ROLES:
                            case ROW:
                            case ROWS:
                            case SCAN:
                            case SEC:
                            case SECOND:
                            case SECONDARY:
                            case SECONDARIES:
                            case SECONDS:
                            case SEEK:
                            case SERVER:
                            case SERVERS:
                            case SET:
                            case SETTING:
                            case SETTINGS:
                            case SHORTEST_PATH:
                            case SHORTEST:
                            case SHOW:
                            case SIGNED:
                            case SINGLE:
                            case SKIPROWS:
                            case START:
                            case STARTS:
                            case STATUS:
                            case STOP:
                            case STRING:
                            case SUPPORTED:
                            case SUSPENDED:
                            case TARGET:
                            case TERMINATE:
                            case TEXT:
                            case THEN:
                            case TIME:
                            case TIMESTAMP:
                            case TIMEZONE:
                            case TO:
                            case TOPOLOGY:
                            case TRAILING:
                            case TRANSACTION:
                            case TRANSACTIONS:
                            case TRAVERSE:
                            case TRIM:
                            case TRUE:
                            case TYPE:
                            case TYPED:
                            case TYPES:
                            case UNION:
                            case UNIQUE:
                            case UNIQUENESS:
                            case UNWIND:
                            case URL:
                            case USE:
                            case USER:
                            case USERS:
                            case USING:
                            case VALUE:
                            case VARCHAR:
                            case VECTOR:
                            case VERTEX:
                            case WAIT:
                            case WHEN:
                            case WHERE:
                            case WITH:
                            case WITHOUT:
                            case WRITE:
                            case XOR:
                            case YIELD:
                            case ZONE:
                            case ZONED:
                            case IDENTIFIER:
                                {
                                    setState(2863);
                                    symbolicAliasNameList();
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    break;
                case GRAPH:
                case GRAPHS:
                    _localctx = new GraphVariableTargetContext(_localctx);
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2866);
                        _la = _input.LA(1);
                        if (!(_la == GRAPH || _la == GRAPHS)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(2869);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case TIMES:
                                {
                                    setState(2867);
                                    match(TIMES);
                                }
                                break;
                            case ESCAPED_SYMBOLIC_NAME:
                            case ACCESS:
                            case ACTIVE:
                            case ADMIN:
                            case ADMINISTRATOR:
                            case ALIAS:
                            case ALIASES:
                            case ALL_SHORTEST_PATHS:
                            case ALL:
                            case ALTER:
                            case AND:
                            case ANY:
                            case ARRAY:
                            case AS:
                            case ASC:
                            case ASCENDING:
                            case ASSIGN:
                            case AT:
                            case AUTH:
                            case BINDINGS:
                            case BOOL:
                            case BOOLEAN:
                            case BOOSTED:
                            case BOTH:
                            case BREAK:
                            case BTREE:
                            case BUILT:
                            case BY:
                            case CALL:
                            case CASE:
                            case CHANGE:
                            case CIDR:
                            case COLLECT:
                            case COMMAND:
                            case COMMANDS:
                            case COMPOSITE:
                            case CONCURRENT:
                            case CONSTRAINT:
                            case CONSTRAINTS:
                            case CONTAINS:
                            case COPY:
                            case CONTINUE:
                            case COUNT:
                            case CREATE:
                            case CSV:
                            case CURRENT:
                            case DATA:
                            case DATABASE:
                            case DATABASES:
                            case DATE:
                            case DATETIME:
                            case DBMS:
                            case DEALLOCATE:
                            case DEFAULT:
                            case DEFINED:
                            case DELETE:
                            case DENY:
                            case DESC:
                            case DESCENDING:
                            case DESTROY:
                            case DETACH:
                            case DIFFERENT:
                            case DOLLAR:
                            case DISTINCT:
                            case DRIVER:
                            case DROP:
                            case DRYRUN:
                            case DUMP:
                            case DURATION:
                            case EACH:
                            case EDGE:
                            case ENABLE:
                            case ELEMENT:
                            case ELEMENTS:
                            case ELSE:
                            case ENCRYPTED:
                            case END:
                            case ENDS:
                            case EXECUTABLE:
                            case EXECUTE:
                            case EXIST:
                            case EXISTENCE:
                            case EXISTS:
                            case ERROR:
                            case FAIL:
                            case FALSE:
                            case FIELDTERMINATOR:
                            case FINISH:
                            case FLOAT:
                            case FOR:
                            case FOREACH:
                            case FROM:
                            case FULLTEXT:
                            case FUNCTION:
                            case FUNCTIONS:
                            case GRANT:
                            case GRAPH:
                            case GRAPHS:
                            case GROUP:
                            case GROUPS:
                            case HEADERS:
                            case HOME:
                            case ID:
                            case IF:
                            case IMPERSONATE:
                            case IMMUTABLE:
                            case IN:
                            case INDEX:
                            case INDEXES:
                            case INF:
                            case INFINITY:
                            case INSERT:
                            case INT:
                            case INTEGER:
                            case IS:
                            case JOIN:
                            case KEY:
                            case LABEL:
                            case LABELS:
                            case LEADING:
                            case LIMITROWS:
                            case LIST:
                            case LOAD:
                            case LOCAL:
                            case LOOKUP:
                            case MANAGEMENT:
                            case MAP:
                            case MATCH:
                            case MERGE:
                            case NAME:
                            case NAMES:
                            case NAN:
                            case NFC:
                            case NFD:
                            case NFKC:
                            case NFKD:
                            case NEW:
                            case NODE:
                            case NODETACH:
                            case NODES:
                            case NONE:
                            case NORMALIZE:
                            case NORMALIZED:
                            case NOT:
                            case NOTHING:
                            case NOWAIT:
                            case NULL:
                            case OF:
                            case ON:
                            case ONLY:
                            case OPTIONAL:
                            case OPTIONS:
                            case OPTION:
                            case OR:
                            case ORDER:
                            case PASSWORD:
                            case PASSWORDS:
                            case PATH:
                            case PATHS:
                            case PLAINTEXT:
                            case POINT:
                            case POPULATED:
                            case PRIMARY:
                            case PRIMARIES:
                            case PRIVILEGE:
                            case PRIVILEGES:
                            case PROCEDURE:
                            case PROCEDURES:
                            case PROPERTIES:
                            case PROPERTY:
                            case PROVIDER:
                            case PROVIDERS:
                            case RANGE:
                            case READ:
                            case REALLOCATE:
                            case REDUCE:
                            case RENAME:
                            case REL:
                            case RELATIONSHIP:
                            case RELATIONSHIPS:
                            case REMOVE:
                            case REPEATABLE:
                            case REPLACE:
                            case REPORT:
                            case REQUIRE:
                            case REQUIRED:
                            case RETURN:
                            case REVOKE:
                            case ROLE:
                            case ROLES:
                            case ROW:
                            case ROWS:
                            case SCAN:
                            case SEC:
                            case SECOND:
                            case SECONDARY:
                            case SECONDARIES:
                            case SECONDS:
                            case SEEK:
                            case SERVER:
                            case SERVERS:
                            case SET:
                            case SETTING:
                            case SETTINGS:
                            case SHORTEST_PATH:
                            case SHORTEST:
                            case SHOW:
                            case SIGNED:
                            case SINGLE:
                            case SKIPROWS:
                            case START:
                            case STARTS:
                            case STATUS:
                            case STOP:
                            case STRING:
                            case SUPPORTED:
                            case SUSPENDED:
                            case TARGET:
                            case TERMINATE:
                            case TEXT:
                            case THEN:
                            case TIME:
                            case TIMESTAMP:
                            case TIMEZONE:
                            case TO:
                            case TOPOLOGY:
                            case TRAILING:
                            case TRANSACTION:
                            case TRANSACTIONS:
                            case TRAVERSE:
                            case TRIM:
                            case TRUE:
                            case TYPE:
                            case TYPED:
                            case TYPES:
                            case UNION:
                            case UNIQUE:
                            case UNIQUENESS:
                            case UNWIND:
                            case URL:
                            case USE:
                            case USER:
                            case USERS:
                            case USING:
                            case VALUE:
                            case VARCHAR:
                            case VECTOR:
                            case VERTEX:
                            case WAIT:
                            case WHEN:
                            case WHERE:
                            case WITH:
                            case WITHOUT:
                            case WRITE:
                            case XOR:
                            case YIELD:
                            case ZONE:
                            case ZONED:
                            case IDENTIFIER:
                                {
                                    setState(2868);
                                    symbolicAliasNameList();
                                }
                                break;
                            default:
                                throw new NoViableAltException(this);
                        }
                    }
                    break;
                case DBMS:
                    _localctx = new DBMSTargetContext(_localctx);
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2871);
                        match(DBMS);
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreatePrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CREATE() {
            return getToken(Cypher6Parser.CREATE, 0);
        }

        public CreatePrivilegeForDatabaseContext createPrivilegeForDatabase() {
            return getRuleContext(CreatePrivilegeForDatabaseContext.class, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public DatabaseScopeContext databaseScope() {
            return getRuleContext(DatabaseScopeContext.class, 0);
        }

        public ActionForDBMSContext actionForDBMS() {
            return getRuleContext(ActionForDBMSContext.class, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public GraphScopeContext graphScope() {
            return getRuleContext(GraphScopeContext.class, 0);
        }

        public GraphQualifierContext graphQualifier() {
            return getRuleContext(GraphQualifierContext.class, 0);
        }

        public CreatePrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createPrivilege;
        }
    }

    public final CreatePrivilegeContext createPrivilege() throws RecognitionException {
        CreatePrivilegeContext _localctx = new CreatePrivilegeContext(_ctx, getState());
        enterRule(_localctx, 474, RULE_createPrivilege);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2874);
                match(CREATE);
                setState(2887);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case INDEX:
                    case INDEXES:
                    case NEW:
                        {
                            setState(2875);
                            createPrivilegeForDatabase();
                            setState(2876);
                            match(ON);
                            setState(2877);
                            databaseScope();
                        }
                        break;
                    case ALIAS:
                    case COMPOSITE:
                    case DATABASE:
                    case ROLE:
                    case USER:
                        {
                            setState(2879);
                            actionForDBMS();
                            setState(2880);
                            match(ON);
                            setState(2881);
                            match(DBMS);
                        }
                        break;
                    case ON:
                        {
                            setState(2883);
                            match(ON);
                            setState(2884);
                            graphScope();
                            setState(2885);
                            graphQualifier();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreatePrivilegeForDatabaseContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public IndexTokenContext indexToken() {
            return getRuleContext(IndexTokenContext.class, 0);
        }

        public ConstraintTokenContext constraintToken() {
            return getRuleContext(ConstraintTokenContext.class, 0);
        }

        public CreateNodePrivilegeTokenContext createNodePrivilegeToken() {
            return getRuleContext(CreateNodePrivilegeTokenContext.class, 0);
        }

        public CreateRelPrivilegeTokenContext createRelPrivilegeToken() {
            return getRuleContext(CreateRelPrivilegeTokenContext.class, 0);
        }

        public CreatePropertyPrivilegeTokenContext createPropertyPrivilegeToken() {
            return getRuleContext(CreatePropertyPrivilegeTokenContext.class, 0);
        }

        public CreatePrivilegeForDatabaseContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createPrivilegeForDatabase;
        }
    }

    public final CreatePrivilegeForDatabaseContext createPrivilegeForDatabase() throws RecognitionException {
        CreatePrivilegeForDatabaseContext _localctx = new CreatePrivilegeForDatabaseContext(_ctx, getState());
        enterRule(_localctx, 476, RULE_createPrivilegeForDatabase);
        try {
            setState(2894);
            _errHandler.sync(this);
            switch (getInterpreter().adaptivePredict(_input, 339, _ctx)) {
                case 1:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2889);
                        indexToken();
                    }
                    break;
                case 2:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2890);
                        constraintToken();
                    }
                    break;
                case 3:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2891);
                        createNodePrivilegeToken();
                    }
                    break;
                case 4:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2892);
                        createRelPrivilegeToken();
                    }
                    break;
                case 5:
                    enterOuterAlt(_localctx, 5);
                    {
                        setState(2893);
                        createPropertyPrivilegeToken();
                    }
                    break;
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateNodePrivilegeTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NEW() {
            return getToken(Cypher6Parser.NEW, 0);
        }

        public TerminalNode LABEL() {
            return getToken(Cypher6Parser.LABEL, 0);
        }

        public TerminalNode LABELS() {
            return getToken(Cypher6Parser.LABELS, 0);
        }

        public TerminalNode NODE() {
            return getToken(Cypher6Parser.NODE, 0);
        }

        public CreateNodePrivilegeTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createNodePrivilegeToken;
        }
    }

    public final CreateNodePrivilegeTokenContext createNodePrivilegeToken() throws RecognitionException {
        CreateNodePrivilegeTokenContext _localctx = new CreateNodePrivilegeTokenContext(_ctx, getState());
        enterRule(_localctx, 478, RULE_createNodePrivilegeToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2896);
                match(NEW);
                setState(2898);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == NODE) {
                    {
                        setState(2897);
                        match(NODE);
                    }
                }

                setState(2900);
                _la = _input.LA(1);
                if (!(_la == LABEL || _la == LABELS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreateRelPrivilegeTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NEW() {
            return getToken(Cypher6Parser.NEW, 0);
        }

        public TerminalNode TYPE() {
            return getToken(Cypher6Parser.TYPE, 0);
        }

        public TerminalNode TYPES() {
            return getToken(Cypher6Parser.TYPES, 0);
        }

        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public CreateRelPrivilegeTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createRelPrivilegeToken;
        }
    }

    public final CreateRelPrivilegeTokenContext createRelPrivilegeToken() throws RecognitionException {
        CreateRelPrivilegeTokenContext _localctx = new CreateRelPrivilegeTokenContext(_ctx, getState());
        enterRule(_localctx, 480, RULE_createRelPrivilegeToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2902);
                match(NEW);
                setState(2904);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == RELATIONSHIP) {
                    {
                        setState(2903);
                        match(RELATIONSHIP);
                    }
                }

                setState(2906);
                _la = _input.LA(1);
                if (!(_la == TYPE || _la == TYPES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class CreatePropertyPrivilegeTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NEW() {
            return getToken(Cypher6Parser.NEW, 0);
        }

        public TerminalNode NAME() {
            return getToken(Cypher6Parser.NAME, 0);
        }

        public TerminalNode NAMES() {
            return getToken(Cypher6Parser.NAMES, 0);
        }

        public TerminalNode PROPERTY() {
            return getToken(Cypher6Parser.PROPERTY, 0);
        }

        public CreatePropertyPrivilegeTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_createPropertyPrivilegeToken;
        }
    }

    public final CreatePropertyPrivilegeTokenContext createPropertyPrivilegeToken() throws RecognitionException {
        CreatePropertyPrivilegeTokenContext _localctx = new CreatePropertyPrivilegeTokenContext(_ctx, getState());
        enterRule(_localctx, 482, RULE_createPropertyPrivilegeToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2908);
                match(NEW);
                setState(2910);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == PROPERTY) {
                    {
                        setState(2909);
                        match(PROPERTY);
                    }
                }

                setState(2912);
                _la = _input.LA(1);
                if (!(_la == NAME || _la == NAMES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ActionForDBMSContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ALIAS() {
            return getToken(Cypher6Parser.ALIAS, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode COMPOSITE() {
            return getToken(Cypher6Parser.COMPOSITE, 0);
        }

        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public ActionForDBMSContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_actionForDBMS;
        }
    }

    public final ActionForDBMSContext actionForDBMS() throws RecognitionException {
        ActionForDBMSContext _localctx = new ActionForDBMSContext(_ctx, getState());
        enterRule(_localctx, 484, RULE_actionForDBMS);
        int _la;
        try {
            setState(2921);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case ALIAS:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(2914);
                        match(ALIAS);
                    }
                    break;
                case COMPOSITE:
                case DATABASE:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(2916);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == COMPOSITE) {
                            {
                                setState(2915);
                                match(COMPOSITE);
                            }
                        }

                        setState(2918);
                        match(DATABASE);
                    }
                    break;
                case ROLE:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(2919);
                        match(ROLE);
                    }
                    break;
                case USER:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(2920);
                        match(USER);
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DropPrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DROP() {
            return getToken(Cypher6Parser.DROP, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public DatabaseScopeContext databaseScope() {
            return getRuleContext(DatabaseScopeContext.class, 0);
        }

        public ActionForDBMSContext actionForDBMS() {
            return getRuleContext(ActionForDBMSContext.class, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public IndexTokenContext indexToken() {
            return getRuleContext(IndexTokenContext.class, 0);
        }

        public ConstraintTokenContext constraintToken() {
            return getRuleContext(ConstraintTokenContext.class, 0);
        }

        public DropPrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dropPrivilege;
        }
    }

    public final DropPrivilegeContext dropPrivilege() throws RecognitionException {
        DropPrivilegeContext _localctx = new DropPrivilegeContext(_ctx, getState());
        enterRule(_localctx, 486, RULE_dropPrivilege);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2923);
                match(DROP);
                setState(2935);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case INDEX:
                    case INDEXES:
                        {
                            setState(2926);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case INDEX:
                                case INDEXES:
                                    {
                                        setState(2924);
                                        indexToken();
                                    }
                                    break;
                                case CONSTRAINT:
                                case CONSTRAINTS:
                                    {
                                        setState(2925);
                                        constraintToken();
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(2928);
                            match(ON);
                            setState(2929);
                            databaseScope();
                        }
                        break;
                    case ALIAS:
                    case COMPOSITE:
                    case DATABASE:
                    case ROLE:
                    case USER:
                        {
                            setState(2931);
                            actionForDBMS();
                            setState(2932);
                            match(ON);
                            setState(2933);
                            match(DBMS);
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LoadPrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LOAD() {
            return getToken(Cypher6Parser.LOAD, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public StringOrParameterContext stringOrParameter() {
            return getRuleContext(StringOrParameterContext.class, 0);
        }

        public TerminalNode ALL() {
            return getToken(Cypher6Parser.ALL, 0);
        }

        public TerminalNode DATA() {
            return getToken(Cypher6Parser.DATA, 0);
        }

        public TerminalNode URL() {
            return getToken(Cypher6Parser.URL, 0);
        }

        public TerminalNode CIDR() {
            return getToken(Cypher6Parser.CIDR, 0);
        }

        public LoadPrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_loadPrivilege;
        }
    }

    public final LoadPrivilegeContext loadPrivilege() throws RecognitionException {
        LoadPrivilegeContext _localctx = new LoadPrivilegeContext(_ctx, getState());
        enterRule(_localctx, 488, RULE_loadPrivilege);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2937);
                match(LOAD);
                setState(2938);
                match(ON);
                setState(2943);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case CIDR:
                    case URL:
                        {
                            setState(2939);
                            _la = _input.LA(1);
                            if (!(_la == CIDR || _la == URL)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(2940);
                            stringOrParameter();
                        }
                        break;
                    case ALL:
                        {
                            setState(2941);
                            match(ALL);
                            setState(2942);
                            match(DATA);
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ShowPrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SHOW() {
            return getToken(Cypher6Parser.SHOW, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public DatabaseScopeContext databaseScope() {
            return getRuleContext(DatabaseScopeContext.class, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public IndexTokenContext indexToken() {
            return getRuleContext(IndexTokenContext.class, 0);
        }

        public ConstraintTokenContext constraintToken() {
            return getRuleContext(ConstraintTokenContext.class, 0);
        }

        public TransactionTokenContext transactionToken() {
            return getRuleContext(TransactionTokenContext.class, 0);
        }

        public TerminalNode ALIAS() {
            return getToken(Cypher6Parser.ALIAS, 0);
        }

        public TerminalNode PRIVILEGE() {
            return getToken(Cypher6Parser.PRIVILEGE, 0);
        }

        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public TerminalNode SERVERS() {
            return getToken(Cypher6Parser.SERVERS, 0);
        }

        public SettingTokenContext settingToken() {
            return getRuleContext(SettingTokenContext.class, 0);
        }

        public SettingQualifierContext settingQualifier() {
            return getRuleContext(SettingQualifierContext.class, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public UserQualifierContext userQualifier() {
            return getRuleContext(UserQualifierContext.class, 0);
        }

        public ShowPrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_showPrivilege;
        }
    }

    public final ShowPrivilegeContext showPrivilege() throws RecognitionException {
        ShowPrivilegeContext _localctx = new ShowPrivilegeContext(_ctx, getState());
        enterRule(_localctx, 490, RULE_showPrivilege);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2945);
                match(SHOW);
                setState(2970);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case INDEX:
                    case INDEXES:
                    case TRANSACTION:
                    case TRANSACTIONS:
                        {
                            setState(2952);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case INDEX:
                                case INDEXES:
                                    {
                                        setState(2946);
                                        indexToken();
                                    }
                                    break;
                                case CONSTRAINT:
                                case CONSTRAINTS:
                                    {
                                        setState(2947);
                                        constraintToken();
                                    }
                                    break;
                                case TRANSACTION:
                                case TRANSACTIONS:
                                    {
                                        setState(2948);
                                        transactionToken();
                                        setState(2950);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                        if (_la == LPAREN) {
                                            {
                                                setState(2949);
                                                userQualifier();
                                            }
                                        }
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(2954);
                            match(ON);
                            setState(2955);
                            databaseScope();
                        }
                        break;
                    case ALIAS:
                    case PRIVILEGE:
                    case ROLE:
                    case SERVER:
                    case SERVERS:
                    case SETTING:
                    case SETTINGS:
                    case USER:
                        {
                            setState(2966);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case ALIAS:
                                    {
                                        setState(2957);
                                        match(ALIAS);
                                    }
                                    break;
                                case PRIVILEGE:
                                    {
                                        setState(2958);
                                        match(PRIVILEGE);
                                    }
                                    break;
                                case ROLE:
                                    {
                                        setState(2959);
                                        match(ROLE);
                                    }
                                    break;
                                case SERVER:
                                    {
                                        setState(2960);
                                        match(SERVER);
                                    }
                                    break;
                                case SERVERS:
                                    {
                                        setState(2961);
                                        match(SERVERS);
                                    }
                                    break;
                                case SETTING:
                                case SETTINGS:
                                    {
                                        setState(2962);
                                        settingToken();
                                        setState(2963);
                                        settingQualifier();
                                    }
                                    break;
                                case USER:
                                    {
                                        setState(2965);
                                        match(USER);
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(2968);
                            match(ON);
                            setState(2969);
                            match(DBMS);
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SetPrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode SET() {
            return getToken(Cypher6Parser.SET, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public TerminalNode LABEL() {
            return getToken(Cypher6Parser.LABEL, 0);
        }

        public LabelsResourceContext labelsResource() {
            return getRuleContext(LabelsResourceContext.class, 0);
        }

        public GraphScopeContext graphScope() {
            return getRuleContext(GraphScopeContext.class, 0);
        }

        public TerminalNode PROPERTY() {
            return getToken(Cypher6Parser.PROPERTY, 0);
        }

        public PropertiesResourceContext propertiesResource() {
            return getRuleContext(PropertiesResourceContext.class, 0);
        }

        public GraphQualifierContext graphQualifier() {
            return getRuleContext(GraphQualifierContext.class, 0);
        }

        public TerminalNode AUTH() {
            return getToken(Cypher6Parser.AUTH, 0);
        }

        public PasswordTokenContext passwordToken() {
            return getRuleContext(PasswordTokenContext.class, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode ACCESS() {
            return getToken(Cypher6Parser.ACCESS, 0);
        }

        public TerminalNode STATUS() {
            return getToken(Cypher6Parser.STATUS, 0);
        }

        public TerminalNode HOME() {
            return getToken(Cypher6Parser.HOME, 0);
        }

        public SetPrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_setPrivilege;
        }
    }

    public final SetPrivilegeContext setPrivilege() throws RecognitionException {
        SetPrivilegeContext _localctx = new SetPrivilegeContext(_ctx, getState());
        enterRule(_localctx, 492, RULE_setPrivilege);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(2972);
                match(SET);
                setState(3000);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case DATABASE:
                    case PASSWORD:
                    case PASSWORDS:
                    case USER:
                        {
                            setState(2982);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case PASSWORD:
                                case PASSWORDS:
                                    {
                                        setState(2973);
                                        passwordToken();
                                    }
                                    break;
                                case USER:
                                    {
                                        setState(2974);
                                        match(USER);
                                        setState(2978);
                                        _errHandler.sync(this);
                                        switch (_input.LA(1)) {
                                            case STATUS:
                                                {
                                                    setState(2975);
                                                    match(STATUS);
                                                }
                                                break;
                                            case HOME:
                                                {
                                                    setState(2976);
                                                    match(HOME);
                                                    setState(2977);
                                                    match(DATABASE);
                                                }
                                                break;
                                            default:
                                                throw new NoViableAltException(this);
                                        }
                                    }
                                    break;
                                case DATABASE:
                                    {
                                        setState(2980);
                                        match(DATABASE);
                                        setState(2981);
                                        match(ACCESS);
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(2984);
                            match(ON);
                            setState(2985);
                            match(DBMS);
                        }
                        break;
                    case LABEL:
                        {
                            setState(2986);
                            match(LABEL);
                            setState(2987);
                            labelsResource();
                            setState(2988);
                            match(ON);
                            setState(2989);
                            graphScope();
                        }
                        break;
                    case PROPERTY:
                        {
                            setState(2991);
                            match(PROPERTY);
                            setState(2992);
                            propertiesResource();
                            setState(2993);
                            match(ON);
                            setState(2994);
                            graphScope();
                            setState(2995);
                            graphQualifier();
                        }
                        break;
                    case AUTH:
                        {
                            setState(2997);
                            match(AUTH);
                            setState(2998);
                            match(ON);
                            setState(2999);
                            match(DBMS);
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PasswordTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PASSWORD() {
            return getToken(Cypher6Parser.PASSWORD, 0);
        }

        public TerminalNode PASSWORDS() {
            return getToken(Cypher6Parser.PASSWORDS, 0);
        }

        public PasswordTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_passwordToken;
        }
    }

    public final PasswordTokenContext passwordToken() throws RecognitionException {
        PasswordTokenContext _localctx = new PasswordTokenContext(_ctx, getState());
        enterRule(_localctx, 494, RULE_passwordToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3002);
                _la = _input.LA(1);
                if (!(_la == PASSWORD || _la == PASSWORDS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RemovePrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode REMOVE() {
            return getToken(Cypher6Parser.REMOVE, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public TerminalNode LABEL() {
            return getToken(Cypher6Parser.LABEL, 0);
        }

        public LabelsResourceContext labelsResource() {
            return getRuleContext(LabelsResourceContext.class, 0);
        }

        public GraphScopeContext graphScope() {
            return getRuleContext(GraphScopeContext.class, 0);
        }

        public TerminalNode PRIVILEGE() {
            return getToken(Cypher6Parser.PRIVILEGE, 0);
        }

        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public RemovePrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_removePrivilege;
        }
    }

    public final RemovePrivilegeContext removePrivilege() throws RecognitionException {
        RemovePrivilegeContext _localctx = new RemovePrivilegeContext(_ctx, getState());
        enterRule(_localctx, 496, RULE_removePrivilege);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3004);
                match(REMOVE);
                setState(3013);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case PRIVILEGE:
                    case ROLE:
                        {
                            setState(3005);
                            _la = _input.LA(1);
                            if (!(_la == PRIVILEGE || _la == ROLE)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(3006);
                            match(ON);
                            setState(3007);
                            match(DBMS);
                        }
                        break;
                    case LABEL:
                        {
                            setState(3008);
                            match(LABEL);
                            setState(3009);
                            labelsResource();
                            setState(3010);
                            match(ON);
                            setState(3011);
                            graphScope();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class WritePrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode WRITE() {
            return getToken(Cypher6Parser.WRITE, 0);
        }

        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public GraphScopeContext graphScope() {
            return getRuleContext(GraphScopeContext.class, 0);
        }

        public WritePrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_writePrivilege;
        }
    }

    public final WritePrivilegeContext writePrivilege() throws RecognitionException {
        WritePrivilegeContext _localctx = new WritePrivilegeContext(_ctx, getState());
        enterRule(_localctx, 498, RULE_writePrivilege);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3015);
                match(WRITE);
                setState(3016);
                match(ON);
                setState(3017);
                graphScope();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DatabasePrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public DatabaseScopeContext databaseScope() {
            return getRuleContext(DatabaseScopeContext.class, 0);
        }

        public TerminalNode ACCESS() {
            return getToken(Cypher6Parser.ACCESS, 0);
        }

        public TerminalNode START() {
            return getToken(Cypher6Parser.START, 0);
        }

        public TerminalNode STOP() {
            return getToken(Cypher6Parser.STOP, 0);
        }

        public IndexTokenContext indexToken() {
            return getRuleContext(IndexTokenContext.class, 0);
        }

        public ConstraintTokenContext constraintToken() {
            return getRuleContext(ConstraintTokenContext.class, 0);
        }

        public TerminalNode NAME() {
            return getToken(Cypher6Parser.NAME, 0);
        }

        public TerminalNode TRANSACTION() {
            return getToken(Cypher6Parser.TRANSACTION, 0);
        }

        public TerminalNode TERMINATE() {
            return getToken(Cypher6Parser.TERMINATE, 0);
        }

        public TransactionTokenContext transactionToken() {
            return getRuleContext(TransactionTokenContext.class, 0);
        }

        public TerminalNode MANAGEMENT() {
            return getToken(Cypher6Parser.MANAGEMENT, 0);
        }

        public UserQualifierContext userQualifier() {
            return getRuleContext(UserQualifierContext.class, 0);
        }

        public DatabasePrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_databasePrivilege;
        }
    }

    public final DatabasePrivilegeContext databasePrivilege() throws RecognitionException {
        DatabasePrivilegeContext _localctx = new DatabasePrivilegeContext(_ctx, getState());
        enterRule(_localctx, 500, RULE_databasePrivilege);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3041);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ACCESS:
                        {
                            setState(3019);
                            match(ACCESS);
                        }
                        break;
                    case START:
                        {
                            setState(3020);
                            match(START);
                        }
                        break;
                    case STOP:
                        {
                            setState(3021);
                            match(STOP);
                        }
                        break;
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case INDEX:
                    case INDEXES:
                    case NAME:
                        {
                            setState(3025);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case INDEX:
                                case INDEXES:
                                    {
                                        setState(3022);
                                        indexToken();
                                    }
                                    break;
                                case CONSTRAINT:
                                case CONSTRAINTS:
                                    {
                                        setState(3023);
                                        constraintToken();
                                    }
                                    break;
                                case NAME:
                                    {
                                        setState(3024);
                                        match(NAME);
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(3028);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == MANAGEMENT) {
                                {
                                    setState(3027);
                                    match(MANAGEMENT);
                                }
                            }
                        }
                        break;
                    case TERMINATE:
                    case TRANSACTION:
                        {
                            setState(3036);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case TRANSACTION:
                                    {
                                        setState(3030);
                                        match(TRANSACTION);
                                        setState(3032);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                        if (_la == MANAGEMENT) {
                                            {
                                                setState(3031);
                                                match(MANAGEMENT);
                                            }
                                        }
                                    }
                                    break;
                                case TERMINATE:
                                    {
                                        setState(3034);
                                        match(TERMINATE);
                                        setState(3035);
                                        transactionToken();
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(3039);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == LPAREN) {
                                {
                                    setState(3038);
                                    userQualifier();
                                }
                            }
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(3043);
                match(ON);
                setState(3044);
                databaseScope();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DbmsPrivilegeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public TerminalNode DBMS() {
            return getToken(Cypher6Parser.DBMS, 0);
        }

        public TerminalNode ALTER() {
            return getToken(Cypher6Parser.ALTER, 0);
        }

        public TerminalNode ASSIGN() {
            return getToken(Cypher6Parser.ASSIGN, 0);
        }

        public TerminalNode MANAGEMENT() {
            return getToken(Cypher6Parser.MANAGEMENT, 0);
        }

        public DbmsPrivilegeExecuteContext dbmsPrivilegeExecute() {
            return getRuleContext(DbmsPrivilegeExecuteContext.class, 0);
        }

        public TerminalNode RENAME() {
            return getToken(Cypher6Parser.RENAME, 0);
        }

        public TerminalNode IMPERSONATE() {
            return getToken(Cypher6Parser.IMPERSONATE, 0);
        }

        public TerminalNode ALIAS() {
            return getToken(Cypher6Parser.ALIAS, 0);
        }

        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode PRIVILEGE() {
            return getToken(Cypher6Parser.PRIVILEGE, 0);
        }

        public TerminalNode ROLE() {
            return getToken(Cypher6Parser.ROLE, 0);
        }

        public TerminalNode SERVER() {
            return getToken(Cypher6Parser.SERVER, 0);
        }

        public UserQualifierContext userQualifier() {
            return getRuleContext(UserQualifierContext.class, 0);
        }

        public TerminalNode COMPOSITE() {
            return getToken(Cypher6Parser.COMPOSITE, 0);
        }

        public DbmsPrivilegeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dbmsPrivilege;
        }
    }

    public final DbmsPrivilegeContext dbmsPrivilege() throws RecognitionException {
        DbmsPrivilegeContext _localctx = new DbmsPrivilegeContext(_ctx, getState());
        enterRule(_localctx, 502, RULE_dbmsPrivilege);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3069);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ALTER:
                        {
                            setState(3046);
                            match(ALTER);
                            setState(3047);
                            _la = _input.LA(1);
                            if (!(_la == ALIAS || _la == DATABASE || _la == USER)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                        }
                        break;
                    case ASSIGN:
                        {
                            setState(3048);
                            match(ASSIGN);
                            setState(3049);
                            _la = _input.LA(1);
                            if (!(_la == PRIVILEGE || _la == ROLE)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                        }
                        break;
                    case ALIAS:
                    case COMPOSITE:
                    case DATABASE:
                    case PRIVILEGE:
                    case ROLE:
                    case SERVER:
                    case USER:
                        {
                            setState(3059);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case ALIAS:
                                    {
                                        setState(3050);
                                        match(ALIAS);
                                    }
                                    break;
                                case COMPOSITE:
                                case DATABASE:
                                    {
                                        setState(3052);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                        if (_la == COMPOSITE) {
                                            {
                                                setState(3051);
                                                match(COMPOSITE);
                                            }
                                        }

                                        setState(3054);
                                        match(DATABASE);
                                    }
                                    break;
                                case PRIVILEGE:
                                    {
                                        setState(3055);
                                        match(PRIVILEGE);
                                    }
                                    break;
                                case ROLE:
                                    {
                                        setState(3056);
                                        match(ROLE);
                                    }
                                    break;
                                case SERVER:
                                    {
                                        setState(3057);
                                        match(SERVER);
                                    }
                                    break;
                                case USER:
                                    {
                                        setState(3058);
                                        match(USER);
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                            setState(3061);
                            match(MANAGEMENT);
                        }
                        break;
                    case EXECUTE:
                        {
                            setState(3062);
                            dbmsPrivilegeExecute();
                        }
                        break;
                    case RENAME:
                        {
                            setState(3063);
                            match(RENAME);
                            setState(3064);
                            _la = _input.LA(1);
                            if (!(_la == ROLE || _la == USER)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                        }
                        break;
                    case IMPERSONATE:
                        {
                            setState(3065);
                            match(IMPERSONATE);
                            setState(3067);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == LPAREN) {
                                {
                                    setState(3066);
                                    userQualifier();
                                }
                            }
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(3071);
                match(ON);
                setState(3072);
                match(DBMS);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DbmsPrivilegeExecuteContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode EXECUTE() {
            return getToken(Cypher6Parser.EXECUTE, 0);
        }

        public AdminTokenContext adminToken() {
            return getRuleContext(AdminTokenContext.class, 0);
        }

        public TerminalNode PROCEDURES() {
            return getToken(Cypher6Parser.PROCEDURES, 0);
        }

        public ProcedureTokenContext procedureToken() {
            return getRuleContext(ProcedureTokenContext.class, 0);
        }

        public ExecuteProcedureQualifierContext executeProcedureQualifier() {
            return getRuleContext(ExecuteProcedureQualifierContext.class, 0);
        }

        public FunctionTokenContext functionToken() {
            return getRuleContext(FunctionTokenContext.class, 0);
        }

        public ExecuteFunctionQualifierContext executeFunctionQualifier() {
            return getRuleContext(ExecuteFunctionQualifierContext.class, 0);
        }

        public TerminalNode BOOSTED() {
            return getToken(Cypher6Parser.BOOSTED, 0);
        }

        public TerminalNode USER() {
            return getToken(Cypher6Parser.USER, 0);
        }

        public TerminalNode DEFINED() {
            return getToken(Cypher6Parser.DEFINED, 0);
        }

        public DbmsPrivilegeExecuteContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_dbmsPrivilegeExecute;
        }
    }

    public final DbmsPrivilegeExecuteContext dbmsPrivilegeExecute() throws RecognitionException {
        DbmsPrivilegeExecuteContext _localctx = new DbmsPrivilegeExecuteContext(_ctx, getState());
        enterRule(_localctx, 504, RULE_dbmsPrivilegeExecute);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3074);
                match(EXECUTE);
                setState(3095);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ADMIN:
                    case ADMINISTRATOR:
                        {
                            setState(3075);
                            adminToken();
                            setState(3076);
                            match(PROCEDURES);
                        }
                        break;
                    case BOOSTED:
                    case FUNCTION:
                    case FUNCTIONS:
                    case PROCEDURE:
                    case PROCEDURES:
                    case USER:
                        {
                            setState(3079);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == BOOSTED) {
                                {
                                    setState(3078);
                                    match(BOOSTED);
                                }
                            }

                            setState(3093);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case PROCEDURE:
                                case PROCEDURES:
                                    {
                                        setState(3081);
                                        procedureToken();
                                        setState(3082);
                                        executeProcedureQualifier();
                                    }
                                    break;
                                case FUNCTION:
                                case FUNCTIONS:
                                case USER:
                                    {
                                        setState(3088);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                        if (_la == USER) {
                                            {
                                                setState(3084);
                                                match(USER);
                                                setState(3086);
                                                _errHandler.sync(this);
                                                _la = _input.LA(1);
                                                if (_la == DEFINED) {
                                                    {
                                                        setState(3085);
                                                        match(DEFINED);
                                                    }
                                                }
                                            }
                                        }

                                        setState(3090);
                                        functionToken();
                                        setState(3091);
                                        executeFunctionQualifier();
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class AdminTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ADMIN() {
            return getToken(Cypher6Parser.ADMIN, 0);
        }

        public TerminalNode ADMINISTRATOR() {
            return getToken(Cypher6Parser.ADMINISTRATOR, 0);
        }

        public AdminTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_adminToken;
        }
    }

    public final AdminTokenContext adminToken() throws RecognitionException {
        AdminTokenContext _localctx = new AdminTokenContext(_ctx, getState());
        enterRule(_localctx, 506, RULE_adminToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3097);
                _la = _input.LA(1);
                if (!(_la == ADMIN || _la == ADMINISTRATOR)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ProcedureTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode PROCEDURE() {
            return getToken(Cypher6Parser.PROCEDURE, 0);
        }

        public TerminalNode PROCEDURES() {
            return getToken(Cypher6Parser.PROCEDURES, 0);
        }

        public ProcedureTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_procedureToken;
        }
    }

    public final ProcedureTokenContext procedureToken() throws RecognitionException {
        ProcedureTokenContext _localctx = new ProcedureTokenContext(_ctx, getState());
        enterRule(_localctx, 508, RULE_procedureToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3099);
                _la = _input.LA(1);
                if (!(_la == PROCEDURE || _la == PROCEDURES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class IndexTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode INDEX() {
            return getToken(Cypher6Parser.INDEX, 0);
        }

        public TerminalNode INDEXES() {
            return getToken(Cypher6Parser.INDEXES, 0);
        }

        public IndexTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_indexToken;
        }
    }

    public final IndexTokenContext indexToken() throws RecognitionException {
        IndexTokenContext _localctx = new IndexTokenContext(_ctx, getState());
        enterRule(_localctx, 510, RULE_indexToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3101);
                _la = _input.LA(1);
                if (!(_la == INDEX || _la == INDEXES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ConstraintTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode CONSTRAINT() {
            return getToken(Cypher6Parser.CONSTRAINT, 0);
        }

        public TerminalNode CONSTRAINTS() {
            return getToken(Cypher6Parser.CONSTRAINTS, 0);
        }

        public ConstraintTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_constraintToken;
        }
    }

    public final ConstraintTokenContext constraintToken() throws RecognitionException {
        ConstraintTokenContext _localctx = new ConstraintTokenContext(_ctx, getState());
        enterRule(_localctx, 512, RULE_constraintToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3103);
                _la = _input.LA(1);
                if (!(_la == CONSTRAINT || _la == CONSTRAINTS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class TransactionTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode TRANSACTION() {
            return getToken(Cypher6Parser.TRANSACTION, 0);
        }

        public TerminalNode TRANSACTIONS() {
            return getToken(Cypher6Parser.TRANSACTIONS, 0);
        }

        public TransactionTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_transactionToken;
        }
    }

    public final TransactionTokenContext transactionToken() throws RecognitionException {
        TransactionTokenContext _localctx = new TransactionTokenContext(_ctx, getState());
        enterRule(_localctx, 514, RULE_transactionToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3105);
                _la = _input.LA(1);
                if (!(_la == TRANSACTION || _la == TRANSACTIONS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class UserQualifierContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public UserNamesContext userNames() {
            return getRuleContext(UserNamesContext.class, 0);
        }

        public UserQualifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_userQualifier;
        }
    }

    public final UserQualifierContext userQualifier() throws RecognitionException {
        UserQualifierContext _localctx = new UserQualifierContext(_ctx, getState());
        enterRule(_localctx, 516, RULE_userQualifier);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3107);
                match(LPAREN);
                setState(3110);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case TIMES:
                        {
                            setState(3108);
                            match(TIMES);
                        }
                        break;
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DOLLAR:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(3109);
                            userNames();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(3112);
                match(RPAREN);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExecuteFunctionQualifierContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public GlobsContext globs() {
            return getRuleContext(GlobsContext.class, 0);
        }

        public ExecuteFunctionQualifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_executeFunctionQualifier;
        }
    }

    public final ExecuteFunctionQualifierContext executeFunctionQualifier() throws RecognitionException {
        ExecuteFunctionQualifierContext _localctx = new ExecuteFunctionQualifierContext(_ctx, getState());
        enterRule(_localctx, 518, RULE_executeFunctionQualifier);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3114);
                globs();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ExecuteProcedureQualifierContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public GlobsContext globs() {
            return getRuleContext(GlobsContext.class, 0);
        }

        public ExecuteProcedureQualifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_executeProcedureQualifier;
        }
    }

    public final ExecuteProcedureQualifierContext executeProcedureQualifier() throws RecognitionException {
        ExecuteProcedureQualifierContext _localctx = new ExecuteProcedureQualifierContext(_ctx, getState());
        enterRule(_localctx, 520, RULE_executeProcedureQualifier);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3116);
                globs();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class SettingQualifierContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public GlobsContext globs() {
            return getRuleContext(GlobsContext.class, 0);
        }

        public SettingQualifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_settingQualifier;
        }
    }

    public final SettingQualifierContext settingQualifier() throws RecognitionException {
        SettingQualifierContext _localctx = new SettingQualifierContext(_ctx, getState());
        enterRule(_localctx, 522, RULE_settingQualifier);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3118);
                globs();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GlobsContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<GlobContext> glob() {
            return getRuleContexts(GlobContext.class);
        }

        public GlobContext glob(int i) {
            return getRuleContext(GlobContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public GlobsContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_globs;
        }
    }

    public final GlobsContext globs() throws RecognitionException {
        GlobsContext _localctx = new GlobsContext(_ctx, getState());
        enterRule(_localctx, 524, RULE_globs);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3120);
                glob();
                setState(3125);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(3121);
                            match(COMMA);
                            setState(3122);
                            glob();
                        }
                    }
                    setState(3127);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GlobContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public EscapedSymbolicNameStringContext escapedSymbolicNameString() {
            return getRuleContext(EscapedSymbolicNameStringContext.class, 0);
        }

        public GlobRecursiveContext globRecursive() {
            return getRuleContext(GlobRecursiveContext.class, 0);
        }

        public GlobContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_glob;
        }
    }

    public final GlobContext glob() throws RecognitionException {
        GlobContext _localctx = new GlobContext(_ctx, getState());
        enterRule(_localctx, 526, RULE_glob);
        try {
            setState(3133);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case ESCAPED_SYMBOLIC_NAME:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(3128);
                        escapedSymbolicNameString();
                        setState(3130);
                        _errHandler.sync(this);
                        switch (getInterpreter().adaptivePredict(_input, 373, _ctx)) {
                            case 1:
                                {
                                    setState(3129);
                                    globRecursive();
                                }
                                break;
                        }
                    }
                    break;
                case ACCESS:
                case ACTIVE:
                case ADMIN:
                case ADMINISTRATOR:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATHS:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case ARRAY:
                case AS:
                case ASC:
                case ASCENDING:
                case ASSIGN:
                case AT:
                case AUTH:
                case BINDINGS:
                case BOOL:
                case BOOLEAN:
                case BOOSTED:
                case BOTH:
                case BREAK:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CHANGE:
                case CIDR:
                case COLLECT:
                case COMMAND:
                case COMMANDS:
                case COMPOSITE:
                case CONCURRENT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case CONTINUE:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DATE:
                case DATETIME:
                case DBMS:
                case DEALLOCATE:
                case DEFAULT:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESCENDING:
                case DESTROY:
                case DETACH:
                case DIFFERENT:
                case DISTINCT:
                case DOT:
                case DRIVER:
                case DROP:
                case DRYRUN:
                case DUMP:
                case DURATION:
                case EACH:
                case EDGE:
                case ENABLE:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXECUTE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case ERROR:
                case FAIL:
                case FALSE:
                case FIELDTERMINATOR:
                case FINISH:
                case FLOAT:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case GROUP:
                case GROUPS:
                case HEADERS:
                case HOME:
                case ID:
                case IF:
                case IMPERSONATE:
                case IMMUTABLE:
                case IN:
                case INDEX:
                case INDEXES:
                case INF:
                case INFINITY:
                case INSERT:
                case INT:
                case INTEGER:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LEADING:
                case LIMITROWS:
                case LIST:
                case LOAD:
                case LOCAL:
                case LOOKUP:
                case MANAGEMENT:
                case MAP:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NAN:
                case NFC:
                case NFD:
                case NFKC:
                case NFKD:
                case NEW:
                case NODE:
                case NODETACH:
                case NODES:
                case NONE:
                case NORMALIZE:
                case NORMALIZED:
                case NOT:
                case NOTHING:
                case NOWAIT:
                case NULL:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OPTION:
                case OR:
                case ORDER:
                case PASSWORD:
                case PASSWORDS:
                case PATH:
                case PATHS:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIMARY:
                case PRIMARIES:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTIES:
                case PROPERTY:
                case PROVIDER:
                case PROVIDERS:
                case QUESTION:
                case RANGE:
                case READ:
                case REALLOCATE:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPEATABLE:
                case REPLACE:
                case REPORT:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDARY:
                case SECONDARIES:
                case SECONDS:
                case SEEK:
                case SERVER:
                case SERVERS:
                case SET:
                case SETTING:
                case SETTINGS:
                case SHORTEST_PATH:
                case SHORTEST:
                case SHOW:
                case SIGNED:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case STRING:
                case SUPPORTED:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TIME:
                case TIMES:
                case TIMESTAMP:
                case TIMEZONE:
                case TO:
                case TOPOLOGY:
                case TRAILING:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRIM:
                case TRUE:
                case TYPE:
                case TYPED:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNIQUENESS:
                case UNWIND:
                case URL:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VALUE:
                case VARCHAR:
                case VECTOR:
                case VERTEX:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WITHOUT:
                case WRITE:
                case XOR:
                case YIELD:
                case ZONE:
                case ZONED:
                case IDENTIFIER:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(3132);
                        globRecursive();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GlobRecursiveContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public GlobPartContext globPart() {
            return getRuleContext(GlobPartContext.class, 0);
        }

        public GlobRecursiveContext globRecursive() {
            return getRuleContext(GlobRecursiveContext.class, 0);
        }

        public GlobRecursiveContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_globRecursive;
        }
    }

    public final GlobRecursiveContext globRecursive() throws RecognitionException {
        GlobRecursiveContext _localctx = new GlobRecursiveContext(_ctx, getState());
        enterRule(_localctx, 528, RULE_globRecursive);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3135);
                globPart();
                setState(3137);
                _errHandler.sync(this);
                switch (getInterpreter().adaptivePredict(_input, 375, _ctx)) {
                    case 1:
                        {
                            setState(3136);
                            globRecursive();
                        }
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GlobPartContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DOT() {
            return getToken(Cypher6Parser.DOT, 0);
        }

        public EscapedSymbolicNameStringContext escapedSymbolicNameString() {
            return getRuleContext(EscapedSymbolicNameStringContext.class, 0);
        }

        public TerminalNode QUESTION() {
            return getToken(Cypher6Parser.QUESTION, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public UnescapedSymbolicNameStringContext unescapedSymbolicNameString() {
            return getRuleContext(UnescapedSymbolicNameStringContext.class, 0);
        }

        public GlobPartContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_globPart;
        }
    }

    public final GlobPartContext globPart() throws RecognitionException {
        GlobPartContext _localctx = new GlobPartContext(_ctx, getState());
        enterRule(_localctx, 530, RULE_globPart);
        int _la;
        try {
            setState(3146);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case DOT:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(3139);
                        match(DOT);
                        setState(3141);
                        _errHandler.sync(this);
                        _la = _input.LA(1);
                        if (_la == ESCAPED_SYMBOLIC_NAME) {
                            {
                                setState(3140);
                                escapedSymbolicNameString();
                            }
                        }
                    }
                    break;
                case QUESTION:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(3143);
                        match(QUESTION);
                    }
                    break;
                case TIMES:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(3144);
                        match(TIMES);
                    }
                    break;
                case ACCESS:
                case ACTIVE:
                case ADMIN:
                case ADMINISTRATOR:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATHS:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case ARRAY:
                case AS:
                case ASC:
                case ASCENDING:
                case ASSIGN:
                case AT:
                case AUTH:
                case BINDINGS:
                case BOOL:
                case BOOLEAN:
                case BOOSTED:
                case BOTH:
                case BREAK:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CHANGE:
                case CIDR:
                case COLLECT:
                case COMMAND:
                case COMMANDS:
                case COMPOSITE:
                case CONCURRENT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case CONTINUE:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DATE:
                case DATETIME:
                case DBMS:
                case DEALLOCATE:
                case DEFAULT:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESCENDING:
                case DESTROY:
                case DETACH:
                case DIFFERENT:
                case DISTINCT:
                case DRIVER:
                case DROP:
                case DRYRUN:
                case DUMP:
                case DURATION:
                case EACH:
                case EDGE:
                case ENABLE:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXECUTE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case ERROR:
                case FAIL:
                case FALSE:
                case FIELDTERMINATOR:
                case FINISH:
                case FLOAT:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case GROUP:
                case GROUPS:
                case HEADERS:
                case HOME:
                case ID:
                case IF:
                case IMPERSONATE:
                case IMMUTABLE:
                case IN:
                case INDEX:
                case INDEXES:
                case INF:
                case INFINITY:
                case INSERT:
                case INT:
                case INTEGER:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LEADING:
                case LIMITROWS:
                case LIST:
                case LOAD:
                case LOCAL:
                case LOOKUP:
                case MANAGEMENT:
                case MAP:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NAN:
                case NFC:
                case NFD:
                case NFKC:
                case NFKD:
                case NEW:
                case NODE:
                case NODETACH:
                case NODES:
                case NONE:
                case NORMALIZE:
                case NORMALIZED:
                case NOT:
                case NOTHING:
                case NOWAIT:
                case NULL:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OPTION:
                case OR:
                case ORDER:
                case PASSWORD:
                case PASSWORDS:
                case PATH:
                case PATHS:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIMARY:
                case PRIMARIES:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTIES:
                case PROPERTY:
                case PROVIDER:
                case PROVIDERS:
                case RANGE:
                case READ:
                case REALLOCATE:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPEATABLE:
                case REPLACE:
                case REPORT:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDARY:
                case SECONDARIES:
                case SECONDS:
                case SEEK:
                case SERVER:
                case SERVERS:
                case SET:
                case SETTING:
                case SETTINGS:
                case SHORTEST_PATH:
                case SHORTEST:
                case SHOW:
                case SIGNED:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case STRING:
                case SUPPORTED:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TIME:
                case TIMESTAMP:
                case TIMEZONE:
                case TO:
                case TOPOLOGY:
                case TRAILING:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRIM:
                case TRUE:
                case TYPE:
                case TYPED:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNIQUENESS:
                case UNWIND:
                case URL:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VALUE:
                case VARCHAR:
                case VECTOR:
                case VERTEX:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WITHOUT:
                case WRITE:
                case XOR:
                case YIELD:
                case ZONE:
                case ZONED:
                case IDENTIFIER:
                    enterOuterAlt(_localctx, 4);
                    {
                        setState(3145);
                        unescapedSymbolicNameString();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class QualifiedGraphPrivilegesWithPropertyContext
            extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public GraphScopeContext graphScope() {
            return getRuleContext(GraphScopeContext.class, 0);
        }

        public GraphQualifierContext graphQualifier() {
            return getRuleContext(GraphQualifierContext.class, 0);
        }

        public TerminalNode TRAVERSE() {
            return getToken(Cypher6Parser.TRAVERSE, 0);
        }

        public PropertiesResourceContext propertiesResource() {
            return getRuleContext(PropertiesResourceContext.class, 0);
        }

        public TerminalNode READ() {
            return getToken(Cypher6Parser.READ, 0);
        }

        public TerminalNode MATCH() {
            return getToken(Cypher6Parser.MATCH, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public QualifiedGraphPrivilegesWithPropertyContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_qualifiedGraphPrivilegesWithProperty;
        }
    }

    public final QualifiedGraphPrivilegesWithPropertyContext qualifiedGraphPrivilegesWithProperty()
            throws RecognitionException {
        QualifiedGraphPrivilegesWithPropertyContext _localctx =
                new QualifiedGraphPrivilegesWithPropertyContext(_ctx, getState());
        enterRule(_localctx, 532, RULE_qualifiedGraphPrivilegesWithProperty);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3151);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case TRAVERSE:
                        {
                            setState(3148);
                            match(TRAVERSE);
                        }
                        break;
                    case MATCH:
                    case READ:
                        {
                            setState(3149);
                            _la = _input.LA(1);
                            if (!(_la == MATCH || _la == READ)) {
                                _errHandler.recoverInline(this);
                            } else {
                                if (_input.LA(1) == Token.EOF) matchedEOF = true;
                                _errHandler.reportMatch(this);
                                consume();
                            }
                            setState(3150);
                            propertiesResource();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(3153);
                match(ON);
                setState(3154);
                graphScope();
                setState(3155);
                graphQualifier();
                setState(3159);
                _errHandler.sync(this);
                _la = _input.LA(1);
                if (_la == LPAREN) {
                    {
                        setState(3156);
                        match(LPAREN);
                        setState(3157);
                        match(TIMES);
                        setState(3158);
                        match(RPAREN);
                    }
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class QualifiedGraphPrivilegesContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ON() {
            return getToken(Cypher6Parser.ON, 0);
        }

        public GraphScopeContext graphScope() {
            return getRuleContext(GraphScopeContext.class, 0);
        }

        public GraphQualifierContext graphQualifier() {
            return getRuleContext(GraphQualifierContext.class, 0);
        }

        public TerminalNode DELETE() {
            return getToken(Cypher6Parser.DELETE, 0);
        }

        public TerminalNode MERGE() {
            return getToken(Cypher6Parser.MERGE, 0);
        }

        public PropertiesResourceContext propertiesResource() {
            return getRuleContext(PropertiesResourceContext.class, 0);
        }

        public QualifiedGraphPrivilegesContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_qualifiedGraphPrivileges;
        }
    }

    public final QualifiedGraphPrivilegesContext qualifiedGraphPrivileges() throws RecognitionException {
        QualifiedGraphPrivilegesContext _localctx = new QualifiedGraphPrivilegesContext(_ctx, getState());
        enterRule(_localctx, 534, RULE_qualifiedGraphPrivileges);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3164);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case DELETE:
                        {
                            setState(3161);
                            match(DELETE);
                        }
                        break;
                    case MERGE:
                        {
                            setState(3162);
                            match(MERGE);
                            setState(3163);
                            propertiesResource();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(3166);
                match(ON);
                setState(3167);
                graphScope();
                setState(3168);
                graphQualifier();
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class LabelsResourceContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public NonEmptyStringListContext nonEmptyStringList() {
            return getRuleContext(NonEmptyStringListContext.class, 0);
        }

        public LabelsResourceContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_labelsResource;
        }
    }

    public final LabelsResourceContext labelsResource() throws RecognitionException {
        LabelsResourceContext _localctx = new LabelsResourceContext(_ctx, getState());
        enterRule(_localctx, 536, RULE_labelsResource);
        try {
            setState(3172);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case TIMES:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(3170);
                        match(TIMES);
                    }
                    break;
                case ESCAPED_SYMBOLIC_NAME:
                case ACCESS:
                case ACTIVE:
                case ADMIN:
                case ADMINISTRATOR:
                case ALIAS:
                case ALIASES:
                case ALL_SHORTEST_PATHS:
                case ALL:
                case ALTER:
                case AND:
                case ANY:
                case ARRAY:
                case AS:
                case ASC:
                case ASCENDING:
                case ASSIGN:
                case AT:
                case AUTH:
                case BINDINGS:
                case BOOL:
                case BOOLEAN:
                case BOOSTED:
                case BOTH:
                case BREAK:
                case BTREE:
                case BUILT:
                case BY:
                case CALL:
                case CASE:
                case CHANGE:
                case CIDR:
                case COLLECT:
                case COMMAND:
                case COMMANDS:
                case COMPOSITE:
                case CONCURRENT:
                case CONSTRAINT:
                case CONSTRAINTS:
                case CONTAINS:
                case COPY:
                case CONTINUE:
                case COUNT:
                case CREATE:
                case CSV:
                case CURRENT:
                case DATA:
                case DATABASE:
                case DATABASES:
                case DATE:
                case DATETIME:
                case DBMS:
                case DEALLOCATE:
                case DEFAULT:
                case DEFINED:
                case DELETE:
                case DENY:
                case DESC:
                case DESCENDING:
                case DESTROY:
                case DETACH:
                case DIFFERENT:
                case DISTINCT:
                case DRIVER:
                case DROP:
                case DRYRUN:
                case DUMP:
                case DURATION:
                case EACH:
                case EDGE:
                case ENABLE:
                case ELEMENT:
                case ELEMENTS:
                case ELSE:
                case ENCRYPTED:
                case END:
                case ENDS:
                case EXECUTABLE:
                case EXECUTE:
                case EXIST:
                case EXISTENCE:
                case EXISTS:
                case ERROR:
                case FAIL:
                case FALSE:
                case FIELDTERMINATOR:
                case FINISH:
                case FLOAT:
                case FOR:
                case FOREACH:
                case FROM:
                case FULLTEXT:
                case FUNCTION:
                case FUNCTIONS:
                case GRANT:
                case GRAPH:
                case GRAPHS:
                case GROUP:
                case GROUPS:
                case HEADERS:
                case HOME:
                case ID:
                case IF:
                case IMPERSONATE:
                case IMMUTABLE:
                case IN:
                case INDEX:
                case INDEXES:
                case INF:
                case INFINITY:
                case INSERT:
                case INT:
                case INTEGER:
                case IS:
                case JOIN:
                case KEY:
                case LABEL:
                case LABELS:
                case LEADING:
                case LIMITROWS:
                case LIST:
                case LOAD:
                case LOCAL:
                case LOOKUP:
                case MANAGEMENT:
                case MAP:
                case MATCH:
                case MERGE:
                case NAME:
                case NAMES:
                case NAN:
                case NFC:
                case NFD:
                case NFKC:
                case NFKD:
                case NEW:
                case NODE:
                case NODETACH:
                case NODES:
                case NONE:
                case NORMALIZE:
                case NORMALIZED:
                case NOT:
                case NOTHING:
                case NOWAIT:
                case NULL:
                case OF:
                case ON:
                case ONLY:
                case OPTIONAL:
                case OPTIONS:
                case OPTION:
                case OR:
                case ORDER:
                case PASSWORD:
                case PASSWORDS:
                case PATH:
                case PATHS:
                case PLAINTEXT:
                case POINT:
                case POPULATED:
                case PRIMARY:
                case PRIMARIES:
                case PRIVILEGE:
                case PRIVILEGES:
                case PROCEDURE:
                case PROCEDURES:
                case PROPERTIES:
                case PROPERTY:
                case PROVIDER:
                case PROVIDERS:
                case RANGE:
                case READ:
                case REALLOCATE:
                case REDUCE:
                case RENAME:
                case REL:
                case RELATIONSHIP:
                case RELATIONSHIPS:
                case REMOVE:
                case REPEATABLE:
                case REPLACE:
                case REPORT:
                case REQUIRE:
                case REQUIRED:
                case RETURN:
                case REVOKE:
                case ROLE:
                case ROLES:
                case ROW:
                case ROWS:
                case SCAN:
                case SEC:
                case SECOND:
                case SECONDARY:
                case SECONDARIES:
                case SECONDS:
                case SEEK:
                case SERVER:
                case SERVERS:
                case SET:
                case SETTING:
                case SETTINGS:
                case SHORTEST_PATH:
                case SHORTEST:
                case SHOW:
                case SIGNED:
                case SINGLE:
                case SKIPROWS:
                case START:
                case STARTS:
                case STATUS:
                case STOP:
                case STRING:
                case SUPPORTED:
                case SUSPENDED:
                case TARGET:
                case TERMINATE:
                case TEXT:
                case THEN:
                case TIME:
                case TIMESTAMP:
                case TIMEZONE:
                case TO:
                case TOPOLOGY:
                case TRAILING:
                case TRANSACTION:
                case TRANSACTIONS:
                case TRAVERSE:
                case TRIM:
                case TRUE:
                case TYPE:
                case TYPED:
                case TYPES:
                case UNION:
                case UNIQUE:
                case UNIQUENESS:
                case UNWIND:
                case URL:
                case USE:
                case USER:
                case USERS:
                case USING:
                case VALUE:
                case VARCHAR:
                case VECTOR:
                case VERTEX:
                case WAIT:
                case WHEN:
                case WHERE:
                case WITH:
                case WITHOUT:
                case WRITE:
                case XOR:
                case YIELD:
                case ZONE:
                case ZONED:
                case IDENTIFIER:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(3171);
                        nonEmptyStringList();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class PropertiesResourceContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode LCURLY() {
            return getToken(Cypher6Parser.LCURLY, 0);
        }

        public TerminalNode RCURLY() {
            return getToken(Cypher6Parser.RCURLY, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public NonEmptyStringListContext nonEmptyStringList() {
            return getRuleContext(NonEmptyStringListContext.class, 0);
        }

        public PropertiesResourceContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_propertiesResource;
        }
    }

    public final PropertiesResourceContext propertiesResource() throws RecognitionException {
        PropertiesResourceContext _localctx = new PropertiesResourceContext(_ctx, getState());
        enterRule(_localctx, 538, RULE_propertiesResource);
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3174);
                match(LCURLY);
                setState(3177);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case TIMES:
                        {
                            setState(3175);
                            match(TIMES);
                        }
                        break;
                    case ESCAPED_SYMBOLIC_NAME:
                    case ACCESS:
                    case ACTIVE:
                    case ADMIN:
                    case ADMINISTRATOR:
                    case ALIAS:
                    case ALIASES:
                    case ALL_SHORTEST_PATHS:
                    case ALL:
                    case ALTER:
                    case AND:
                    case ANY:
                    case ARRAY:
                    case AS:
                    case ASC:
                    case ASCENDING:
                    case ASSIGN:
                    case AT:
                    case AUTH:
                    case BINDINGS:
                    case BOOL:
                    case BOOLEAN:
                    case BOOSTED:
                    case BOTH:
                    case BREAK:
                    case BTREE:
                    case BUILT:
                    case BY:
                    case CALL:
                    case CASE:
                    case CHANGE:
                    case CIDR:
                    case COLLECT:
                    case COMMAND:
                    case COMMANDS:
                    case COMPOSITE:
                    case CONCURRENT:
                    case CONSTRAINT:
                    case CONSTRAINTS:
                    case CONTAINS:
                    case COPY:
                    case CONTINUE:
                    case COUNT:
                    case CREATE:
                    case CSV:
                    case CURRENT:
                    case DATA:
                    case DATABASE:
                    case DATABASES:
                    case DATE:
                    case DATETIME:
                    case DBMS:
                    case DEALLOCATE:
                    case DEFAULT:
                    case DEFINED:
                    case DELETE:
                    case DENY:
                    case DESC:
                    case DESCENDING:
                    case DESTROY:
                    case DETACH:
                    case DIFFERENT:
                    case DISTINCT:
                    case DRIVER:
                    case DROP:
                    case DRYRUN:
                    case DUMP:
                    case DURATION:
                    case EACH:
                    case EDGE:
                    case ENABLE:
                    case ELEMENT:
                    case ELEMENTS:
                    case ELSE:
                    case ENCRYPTED:
                    case END:
                    case ENDS:
                    case EXECUTABLE:
                    case EXECUTE:
                    case EXIST:
                    case EXISTENCE:
                    case EXISTS:
                    case ERROR:
                    case FAIL:
                    case FALSE:
                    case FIELDTERMINATOR:
                    case FINISH:
                    case FLOAT:
                    case FOR:
                    case FOREACH:
                    case FROM:
                    case FULLTEXT:
                    case FUNCTION:
                    case FUNCTIONS:
                    case GRANT:
                    case GRAPH:
                    case GRAPHS:
                    case GROUP:
                    case GROUPS:
                    case HEADERS:
                    case HOME:
                    case ID:
                    case IF:
                    case IMPERSONATE:
                    case IMMUTABLE:
                    case IN:
                    case INDEX:
                    case INDEXES:
                    case INF:
                    case INFINITY:
                    case INSERT:
                    case INT:
                    case INTEGER:
                    case IS:
                    case JOIN:
                    case KEY:
                    case LABEL:
                    case LABELS:
                    case LEADING:
                    case LIMITROWS:
                    case LIST:
                    case LOAD:
                    case LOCAL:
                    case LOOKUP:
                    case MANAGEMENT:
                    case MAP:
                    case MATCH:
                    case MERGE:
                    case NAME:
                    case NAMES:
                    case NAN:
                    case NFC:
                    case NFD:
                    case NFKC:
                    case NFKD:
                    case NEW:
                    case NODE:
                    case NODETACH:
                    case NODES:
                    case NONE:
                    case NORMALIZE:
                    case NORMALIZED:
                    case NOT:
                    case NOTHING:
                    case NOWAIT:
                    case NULL:
                    case OF:
                    case ON:
                    case ONLY:
                    case OPTIONAL:
                    case OPTIONS:
                    case OPTION:
                    case OR:
                    case ORDER:
                    case PASSWORD:
                    case PASSWORDS:
                    case PATH:
                    case PATHS:
                    case PLAINTEXT:
                    case POINT:
                    case POPULATED:
                    case PRIMARY:
                    case PRIMARIES:
                    case PRIVILEGE:
                    case PRIVILEGES:
                    case PROCEDURE:
                    case PROCEDURES:
                    case PROPERTIES:
                    case PROPERTY:
                    case PROVIDER:
                    case PROVIDERS:
                    case RANGE:
                    case READ:
                    case REALLOCATE:
                    case REDUCE:
                    case RENAME:
                    case REL:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                    case REMOVE:
                    case REPEATABLE:
                    case REPLACE:
                    case REPORT:
                    case REQUIRE:
                    case REQUIRED:
                    case RETURN:
                    case REVOKE:
                    case ROLE:
                    case ROLES:
                    case ROW:
                    case ROWS:
                    case SCAN:
                    case SEC:
                    case SECOND:
                    case SECONDARY:
                    case SECONDARIES:
                    case SECONDS:
                    case SEEK:
                    case SERVER:
                    case SERVERS:
                    case SET:
                    case SETTING:
                    case SETTINGS:
                    case SHORTEST_PATH:
                    case SHORTEST:
                    case SHOW:
                    case SIGNED:
                    case SINGLE:
                    case SKIPROWS:
                    case START:
                    case STARTS:
                    case STATUS:
                    case STOP:
                    case STRING:
                    case SUPPORTED:
                    case SUSPENDED:
                    case TARGET:
                    case TERMINATE:
                    case TEXT:
                    case THEN:
                    case TIME:
                    case TIMESTAMP:
                    case TIMEZONE:
                    case TO:
                    case TOPOLOGY:
                    case TRAILING:
                    case TRANSACTION:
                    case TRANSACTIONS:
                    case TRAVERSE:
                    case TRIM:
                    case TRUE:
                    case TYPE:
                    case TYPED:
                    case TYPES:
                    case UNION:
                    case UNIQUE:
                    case UNIQUENESS:
                    case UNWIND:
                    case URL:
                    case USE:
                    case USER:
                    case USERS:
                    case USING:
                    case VALUE:
                    case VARCHAR:
                    case VECTOR:
                    case VERTEX:
                    case WAIT:
                    case WHEN:
                    case WHERE:
                    case WITH:
                    case WITHOUT:
                    case WRITE:
                    case XOR:
                    case YIELD:
                    case ZONE:
                    case ZONED:
                    case IDENTIFIER:
                        {
                            setState(3176);
                            nonEmptyStringList();
                        }
                        break;
                    default:
                        throw new NoViableAltException(this);
                }
                setState(3179);
                match(RCURLY);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NonEmptyStringListContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public List<TerminalNode> COMMA() {
            return getTokens(Cypher6Parser.COMMA);
        }

        public TerminalNode COMMA(int i) {
            return getToken(Cypher6Parser.COMMA, i);
        }

        public NonEmptyStringListContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_nonEmptyStringList;
        }
    }

    public final NonEmptyStringListContext nonEmptyStringList() throws RecognitionException {
        NonEmptyStringListContext _localctx = new NonEmptyStringListContext(_ctx, getState());
        enterRule(_localctx, 540, RULE_nonEmptyStringList);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3181);
                symbolicNameString();
                setState(3186);
                _errHandler.sync(this);
                _la = _input.LA(1);
                while (_la == COMMA) {
                    {
                        {
                            setState(3182);
                            match(COMMA);
                            setState(3183);
                            symbolicNameString();
                        }
                    }
                    setState(3188);
                    _errHandler.sync(this);
                    _la = _input.LA(1);
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GraphQualifierContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public GraphQualifierTokenContext graphQualifierToken() {
            return getRuleContext(GraphQualifierTokenContext.class, 0);
        }

        public TerminalNode FOR() {
            return getToken(Cypher6Parser.FOR, 0);
        }

        public TerminalNode LPAREN() {
            return getToken(Cypher6Parser.LPAREN, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public NonEmptyStringListContext nonEmptyStringList() {
            return getRuleContext(NonEmptyStringListContext.class, 0);
        }

        public TerminalNode RPAREN() {
            return getToken(Cypher6Parser.RPAREN, 0);
        }

        public TerminalNode WHERE() {
            return getToken(Cypher6Parser.WHERE, 0);
        }

        public ExpressionContext expression() {
            return getRuleContext(ExpressionContext.class, 0);
        }

        public VariableContext variable() {
            return getRuleContext(VariableContext.class, 0);
        }

        public TerminalNode COLON() {
            return getToken(Cypher6Parser.COLON, 0);
        }

        public List<SymbolicNameStringContext> symbolicNameString() {
            return getRuleContexts(SymbolicNameStringContext.class);
        }

        public SymbolicNameStringContext symbolicNameString(int i) {
            return getRuleContext(SymbolicNameStringContext.class, i);
        }

        public MapContext map() {
            return getRuleContext(MapContext.class, 0);
        }

        public List<TerminalNode> BAR() {
            return getTokens(Cypher6Parser.BAR);
        }

        public TerminalNode BAR(int i) {
            return getToken(Cypher6Parser.BAR, i);
        }

        public GraphQualifierContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_graphQualifier;
        }
    }

    public final GraphQualifierContext graphQualifier() throws RecognitionException {
        GraphQualifierContext _localctx = new GraphQualifierContext(_ctx, getState());
        enterRule(_localctx, 542, RULE_graphQualifier);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3222);
                _errHandler.sync(this);
                switch (_input.LA(1)) {
                    case ELEMENT:
                    case ELEMENTS:
                    case NODE:
                    case NODES:
                    case RELATIONSHIP:
                    case RELATIONSHIPS:
                        {
                            setState(3189);
                            graphQualifierToken();
                            setState(3192);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case TIMES:
                                    {
                                        setState(3190);
                                        match(TIMES);
                                    }
                                    break;
                                case ESCAPED_SYMBOLIC_NAME:
                                case ACCESS:
                                case ACTIVE:
                                case ADMIN:
                                case ADMINISTRATOR:
                                case ALIAS:
                                case ALIASES:
                                case ALL_SHORTEST_PATHS:
                                case ALL:
                                case ALTER:
                                case AND:
                                case ANY:
                                case ARRAY:
                                case AS:
                                case ASC:
                                case ASCENDING:
                                case ASSIGN:
                                case AT:
                                case AUTH:
                                case BINDINGS:
                                case BOOL:
                                case BOOLEAN:
                                case BOOSTED:
                                case BOTH:
                                case BREAK:
                                case BTREE:
                                case BUILT:
                                case BY:
                                case CALL:
                                case CASE:
                                case CHANGE:
                                case CIDR:
                                case COLLECT:
                                case COMMAND:
                                case COMMANDS:
                                case COMPOSITE:
                                case CONCURRENT:
                                case CONSTRAINT:
                                case CONSTRAINTS:
                                case CONTAINS:
                                case COPY:
                                case CONTINUE:
                                case COUNT:
                                case CREATE:
                                case CSV:
                                case CURRENT:
                                case DATA:
                                case DATABASE:
                                case DATABASES:
                                case DATE:
                                case DATETIME:
                                case DBMS:
                                case DEALLOCATE:
                                case DEFAULT:
                                case DEFINED:
                                case DELETE:
                                case DENY:
                                case DESC:
                                case DESCENDING:
                                case DESTROY:
                                case DETACH:
                                case DIFFERENT:
                                case DISTINCT:
                                case DRIVER:
                                case DROP:
                                case DRYRUN:
                                case DUMP:
                                case DURATION:
                                case EACH:
                                case EDGE:
                                case ENABLE:
                                case ELEMENT:
                                case ELEMENTS:
                                case ELSE:
                                case ENCRYPTED:
                                case END:
                                case ENDS:
                                case EXECUTABLE:
                                case EXECUTE:
                                case EXIST:
                                case EXISTENCE:
                                case EXISTS:
                                case ERROR:
                                case FAIL:
                                case FALSE:
                                case FIELDTERMINATOR:
                                case FINISH:
                                case FLOAT:
                                case FOR:
                                case FOREACH:
                                case FROM:
                                case FULLTEXT:
                                case FUNCTION:
                                case FUNCTIONS:
                                case GRANT:
                                case GRAPH:
                                case GRAPHS:
                                case GROUP:
                                case GROUPS:
                                case HEADERS:
                                case HOME:
                                case ID:
                                case IF:
                                case IMPERSONATE:
                                case IMMUTABLE:
                                case IN:
                                case INDEX:
                                case INDEXES:
                                case INF:
                                case INFINITY:
                                case INSERT:
                                case INT:
                                case INTEGER:
                                case IS:
                                case JOIN:
                                case KEY:
                                case LABEL:
                                case LABELS:
                                case LEADING:
                                case LIMITROWS:
                                case LIST:
                                case LOAD:
                                case LOCAL:
                                case LOOKUP:
                                case MANAGEMENT:
                                case MAP:
                                case MATCH:
                                case MERGE:
                                case NAME:
                                case NAMES:
                                case NAN:
                                case NFC:
                                case NFD:
                                case NFKC:
                                case NFKD:
                                case NEW:
                                case NODE:
                                case NODETACH:
                                case NODES:
                                case NONE:
                                case NORMALIZE:
                                case NORMALIZED:
                                case NOT:
                                case NOTHING:
                                case NOWAIT:
                                case NULL:
                                case OF:
                                case ON:
                                case ONLY:
                                case OPTIONAL:
                                case OPTIONS:
                                case OPTION:
                                case OR:
                                case ORDER:
                                case PASSWORD:
                                case PASSWORDS:
                                case PATH:
                                case PATHS:
                                case PLAINTEXT:
                                case POINT:
                                case POPULATED:
                                case PRIMARY:
                                case PRIMARIES:
                                case PRIVILEGE:
                                case PRIVILEGES:
                                case PROCEDURE:
                                case PROCEDURES:
                                case PROPERTIES:
                                case PROPERTY:
                                case PROVIDER:
                                case PROVIDERS:
                                case RANGE:
                                case READ:
                                case REALLOCATE:
                                case REDUCE:
                                case RENAME:
                                case REL:
                                case RELATIONSHIP:
                                case RELATIONSHIPS:
                                case REMOVE:
                                case REPEATABLE:
                                case REPLACE:
                                case REPORT:
                                case REQUIRE:
                                case REQUIRED:
                                case RETURN:
                                case REVOKE:
                                case ROLE:
                                case ROLES:
                                case ROW:
                                case ROWS:
                                case SCAN:
                                case SEC:
                                case SECOND:
                                case SECONDARY:
                                case SECONDARIES:
                                case SECONDS:
                                case SEEK:
                                case SERVER:
                                case SERVERS:
                                case SET:
                                case SETTING:
                                case SETTINGS:
                                case SHORTEST_PATH:
                                case SHORTEST:
                                case SHOW:
                                case SIGNED:
                                case SINGLE:
                                case SKIPROWS:
                                case START:
                                case STARTS:
                                case STATUS:
                                case STOP:
                                case STRING:
                                case SUPPORTED:
                                case SUSPENDED:
                                case TARGET:
                                case TERMINATE:
                                case TEXT:
                                case THEN:
                                case TIME:
                                case TIMESTAMP:
                                case TIMEZONE:
                                case TO:
                                case TOPOLOGY:
                                case TRAILING:
                                case TRANSACTION:
                                case TRANSACTIONS:
                                case TRAVERSE:
                                case TRIM:
                                case TRUE:
                                case TYPE:
                                case TYPED:
                                case TYPES:
                                case UNION:
                                case UNIQUE:
                                case UNIQUENESS:
                                case UNWIND:
                                case URL:
                                case USE:
                                case USER:
                                case USERS:
                                case USING:
                                case VALUE:
                                case VARCHAR:
                                case VECTOR:
                                case VERTEX:
                                case WAIT:
                                case WHEN:
                                case WHERE:
                                case WITH:
                                case WITHOUT:
                                case WRITE:
                                case XOR:
                                case YIELD:
                                case ZONE:
                                case ZONED:
                                case IDENTIFIER:
                                    {
                                        setState(3191);
                                        nonEmptyStringList();
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                        }
                        break;
                    case FOR:
                        {
                            setState(3194);
                            match(FOR);
                            setState(3195);
                            match(LPAREN);
                            setState(3197);
                            _errHandler.sync(this);
                            switch (getInterpreter().adaptivePredict(_input, 385, _ctx)) {
                                case 1:
                                    {
                                        setState(3196);
                                        variable();
                                    }
                                    break;
                            }
                            setState(3208);
                            _errHandler.sync(this);
                            _la = _input.LA(1);
                            if (_la == COLON) {
                                {
                                    setState(3199);
                                    match(COLON);
                                    setState(3200);
                                    symbolicNameString();
                                    setState(3205);
                                    _errHandler.sync(this);
                                    _la = _input.LA(1);
                                    while (_la == BAR) {
                                        {
                                            {
                                                setState(3201);
                                                match(BAR);
                                                setState(3202);
                                                symbolicNameString();
                                            }
                                        }
                                        setState(3207);
                                        _errHandler.sync(this);
                                        _la = _input.LA(1);
                                    }
                                }
                            }

                            setState(3220);
                            _errHandler.sync(this);
                            switch (_input.LA(1)) {
                                case RPAREN:
                                    {
                                        setState(3210);
                                        match(RPAREN);
                                        setState(3211);
                                        match(WHERE);
                                        setState(3212);
                                        expression();
                                    }
                                    break;
                                case LCURLY:
                                case WHERE:
                                    {
                                        setState(3216);
                                        _errHandler.sync(this);
                                        switch (_input.LA(1)) {
                                            case WHERE:
                                                {
                                                    setState(3213);
                                                    match(WHERE);
                                                    setState(3214);
                                                    expression();
                                                }
                                                break;
                                            case LCURLY:
                                                {
                                                    setState(3215);
                                                    map();
                                                }
                                                break;
                                            default:
                                                throw new NoViableAltException(this);
                                        }
                                        setState(3218);
                                        match(RPAREN);
                                    }
                                    break;
                                default:
                                    throw new NoViableAltException(this);
                            }
                        }
                        break;
                    case FROM:
                    case LPAREN:
                    case TO:
                        break;
                    default:
                        break;
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class GraphQualifierTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public RelTokenContext relToken() {
            return getRuleContext(RelTokenContext.class, 0);
        }

        public NodeTokenContext nodeToken() {
            return getRuleContext(NodeTokenContext.class, 0);
        }

        public ElementTokenContext elementToken() {
            return getRuleContext(ElementTokenContext.class, 0);
        }

        public GraphQualifierTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_graphQualifierToken;
        }
    }

    public final GraphQualifierTokenContext graphQualifierToken() throws RecognitionException {
        GraphQualifierTokenContext _localctx = new GraphQualifierTokenContext(_ctx, getState());
        enterRule(_localctx, 544, RULE_graphQualifierToken);
        try {
            setState(3227);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case RELATIONSHIP:
                case RELATIONSHIPS:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(3224);
                        relToken();
                    }
                    break;
                case NODE:
                case NODES:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(3225);
                        nodeToken();
                    }
                    break;
                case ELEMENT:
                case ELEMENTS:
                    enterOuterAlt(_localctx, 3);
                    {
                        setState(3226);
                        elementToken();
                    }
                    break;
                default:
                    throw new NoViableAltException(this);
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class RelTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode RELATIONSHIP() {
            return getToken(Cypher6Parser.RELATIONSHIP, 0);
        }

        public TerminalNode RELATIONSHIPS() {
            return getToken(Cypher6Parser.RELATIONSHIPS, 0);
        }

        public RelTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_relToken;
        }
    }

    public final RelTokenContext relToken() throws RecognitionException {
        RelTokenContext _localctx = new RelTokenContext(_ctx, getState());
        enterRule(_localctx, 546, RULE_relToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3229);
                _la = _input.LA(1);
                if (!(_la == RELATIONSHIP || _la == RELATIONSHIPS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class ElementTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode ELEMENT() {
            return getToken(Cypher6Parser.ELEMENT, 0);
        }

        public TerminalNode ELEMENTS() {
            return getToken(Cypher6Parser.ELEMENTS, 0);
        }

        public ElementTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_elementToken;
        }
    }

    public final ElementTokenContext elementToken() throws RecognitionException {
        ElementTokenContext _localctx = new ElementTokenContext(_ctx, getState());
        enterRule(_localctx, 548, RULE_elementToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3231);
                _la = _input.LA(1);
                if (!(_la == ELEMENT || _la == ELEMENTS)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class NodeTokenContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode NODE() {
            return getToken(Cypher6Parser.NODE, 0);
        }

        public TerminalNode NODES() {
            return getToken(Cypher6Parser.NODES, 0);
        }

        public NodeTokenContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_nodeToken;
        }
    }

    public final NodeTokenContext nodeToken() throws RecognitionException {
        NodeTokenContext _localctx = new NodeTokenContext(_ctx, getState());
        enterRule(_localctx, 550, RULE_nodeToken);
        int _la;
        try {
            enterOuterAlt(_localctx, 1);
            {
                setState(3233);
                _la = _input.LA(1);
                if (!(_la == NODE || _la == NODES)) {
                    _errHandler.recoverInline(this);
                } else {
                    if (_input.LA(1) == Token.EOF) matchedEOF = true;
                    _errHandler.reportMatch(this);
                    consume();
                }
            }
        } catch (RecognitionException re) {
            _localctx.exception = re;
            _errHandler.reportError(this, re);
            _errHandler.recover(this, re);
        } finally {
            exitRule();
        }
        return _localctx;
    }

    @SuppressWarnings("CheckReturnValue")
    public static class DatabaseScopeContext extends org.neo4j.cypher.internal.parser.AstRuleCtx {
        public TerminalNode DATABASE() {
            return getToken(Cypher6Parser.DATABASE, 0);
        }

        public TerminalNode DEFAULT() {
            return getToken(Cypher6Parser.DEFAULT, 0);
        }

        public TerminalNode HOME() {
            return getToken(Cypher6Parser.HOME, 0);
        }

        public TerminalNode DATABASES() {
            return getToken(Cypher6Parser.DATABASES, 0);
        }

        public TerminalNode TIMES() {
            return getToken(Cypher6Parser.TIMES, 0);
        }

        public SymbolicAliasNameListContext symbolicAliasNameList() {
            return getRuleContext(SymbolicAliasNameListContext.class, 0);
        }

        public DatabaseScopeContext(ParserRuleContext parent, int invokingState) {
            super(parent, invokingState);
        }

        @Override
        public int getRuleIndex() {
            return RULE_databaseScope;
        }
    }

    public final DatabaseScopeContext databaseScope() throws RecognitionException {
        DatabaseScopeContext _localctx = new DatabaseScopeContext(_ctx, getState());
        enterRule(_localctx, 552, RULE_databaseScope);
        int _la;
        try {
            setState(3242);
            _errHandler.sync(this);
            switch (_input.LA(1)) {
                case DEFAULT:
                case HOME:
                    enterOuterAlt(_localctx, 1);
                    {
                        setState(3235);
                        _la = _input.LA(1);
                        if (!(_la == DEFAULT || _la == HOME)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(3236);
                        match(DATABASE);
                    }
                    break;
                case DATABASE:
                case DATABASES:
                    enterOuterAlt(_localctx, 2);
                    {
                        setState(3237);
                        _la = _input.LA(1);
                        if (!(_la == DATABASE || _la == DATABASES)) {
                            _errHandler.recoverInline(this);
                        } else {
                            if (_input.LA(1) == Token.EOF) matchedEOF = true;
                            _errHandler.reportMatch(this);
                            consume();
                        }
                        setState(3240);
                        _errHandler.sync(this);
                        switch (_input.LA(1)) {
                            case TIMES:
                                {
                                    setState(3238);
                                    match(TIMES);
                                }
                                break;
                            case ESCAPED_SYMBOLIC_NAME:
                            case ACCESS:
                            case ACTIVE:
                            case ADMIN:
                            case ADMINISTRATOR:
                            case ALIAS:
                            case ALIASES:
                            case ALL_SHORTEST_PATHS:
                            case ALL:
                            case ALTER:
                            case AND:
                            case ANY:
                            case ARRAY:
                            case AS:
                            case ASC:
                            case ASCENDING:
                            case ASSIGN:
                            case AT:
                            case AUTH:
                            case BINDINGS:
                            case BOOL:
                            case BOOLEAN:
                            case BOOSTED:
                            case BOTH:
                            case BREAK:
                            case BTREE:
                            case BUILT:
                            case BY:
                            case CALL:
                            case CASE:
                            case CHANGE:
                            case CIDR:
                            case COLLECT:
                            case COMMAND:
                            case COMMANDS:
                            case COMPOSITE:
                            case CONCURRENT:
                            case CONSTRAINT:
                            case CONSTRAINTS:
                            case CONTAINS:
                            case COPY:
                            case CONTINUE:
                            case COUNT:
                            case CREATE:
                            case CSV:
                            case CURRENT:
                            case DATA:
                            case DATABASE:
                            case DATABASES:
                            case DATE:
                            case DATETIME:
                            case DBMS:
                            case DEALLOCATE:
                            case DEFAULT:
                            case DEFINED:
                            case DELETE:
                            case DENY:
                            case DESC:
                            case DESCENDING:
                            case DESTROY:
                            case DETACH:
                            case DIFFERENT:
                            case DOLLAR:
                            case DISTINCT:
                            case DRIVER:
                            case DROP:
                            case DRYRUN:
                            case DUMP:
                            case DURATION:
                            case EACH:
                            case EDGE:
                            case ENABLE:
                            case ELEMENT:
                            case ELEMENTS:
                            case ELSE:
                            case ENCRYPTED:
                            case END:
                            case ENDS:
                            case EXECUTABLE:
                            case EXECUTE:
                            case EXIST:
                            case EXISTENCE:
          