/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.shaded.reactor.adapter.JdkFlowAdapter;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxSink;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.summary.ResultSummary;

public class InternalReactiveResult
implements ReactiveResult {
    private final RxResultCursor cursor;

    public InternalReactiveResult(RxResultCursor cursor) {
        this.cursor = cursor;
    }

    @Override
    public List<String> keys() {
        return this.cursor.keys();
    }

    @Override
    public Flow.Publisher<Record> records() {
        return JdkFlowAdapter.publisherToFlowPublisher(Flux.create(sink -> {
            if (this.cursor.isDone()) {
                sink.error(ErrorUtil.newResultConsumedError());
            } else {
                this.cursor.installRecordConsumer(this.createRecordConsumer((FluxSink<Record>)sink));
                sink.onCancel(() -> ((RxResultCursor)this.cursor).cancel());
                sink.onRequest(arg_0 -> ((RxResultCursor)this.cursor).request(arg_0));
            }
        }, FluxSink.OverflowStrategy.IGNORE));
    }

    @Override
    public Flow.Publisher<ResultSummary> consume() {
        return JdkFlowAdapter.publisherToFlowPublisher(Mono.create(sink -> this.cursor.summaryAsync().whenComplete((summary, summaryCompletionError) -> {
            Throwable error = Futures.completionExceptionCause(summaryCompletionError);
            if (summary != null) {
                sink.success(summary);
            } else {
                sink.error(error);
            }
        })));
    }

    @Override
    public Flow.Publisher<Boolean> isOpen() {
        return JdkFlowAdapter.publisherToFlowPublisher(Mono.just(!this.cursor.isDone()));
    }

    private BiConsumer<Record, Throwable> createRecordConsumer(FluxSink<Record> sink) {
        return (r, e) -> {
            if (r != null) {
                sink.next((Record)r);
            } else if (e != null) {
                sink.error((Throwable)e);
            } else {
                sink.complete();
            }
        };
    }
}

