/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.reactive.AbstractReactiveTransaction;
import org.neo4j.driver.internal.reactive.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactive.InternalReactiveResult;
import org.neo4j.driver.internal.shaded.reactor.adapter.JdkFlowAdapter;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveTransaction;

public class InternalReactiveTransaction
extends AbstractReactiveTransaction
implements ReactiveTransaction,
BaseReactiveQueryRunner {
    protected InternalReactiveTransaction(UnmanagedTransaction tx) {
        super(tx);
    }

    @Override
    public Flow.Publisher<ReactiveResult> run(Query query) {
        CompletionStage<RxResultCursor> cursorStage;
        try {
            cursorStage = this.tx.runRx(query);
        }
        catch (Throwable t) {
            cursorStage = Futures.failedFuture(t);
        }
        return JdkFlowAdapter.publisherToFlowPublisher(Mono.fromCompletionStage(cursorStage).flatMap(cursor -> {
            Mono<Object> publisher;
            Throwable runError = cursor.getRunError();
            if (runError != null) {
                publisher = Mono.error(runError);
                this.tx.markTerminated(runError);
            } else {
                publisher = Mono.just(cursor);
            }
            return publisher;
        }).map(InternalReactiveResult::new));
    }

    public Flow.Publisher<Void> interrupt() {
        return JdkFlowAdapter.publisherToFlowPublisher(Mono.fromCompletionStage(this.tx.interruptAsync()));
    }

    @Override
    public <T> Flow.Publisher<T> commit() {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doCommit());
    }

    @Override
    public <T> Flow.Publisher<T> rollback() {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doRollback());
    }

    @Override
    public Flow.Publisher<Void> close() {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doClose());
    }

    @Override
    public Flow.Publisher<Boolean> isOpen() {
        return JdkFlowAdapter.publisherToFlowPublisher(this.doIsOpen());
    }
}

