/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactivestreams;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.reactive.AbstractReactiveTransaction;
import org.neo4j.driver.internal.reactivestreams.BaseReactiveQueryRunner;
import org.neo4j.driver.internal.reactivestreams.InternalReactiveResult;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactivestreams.ReactiveResult;
import org.neo4j.driver.reactivestreams.ReactiveTransaction;
import org.reactivestreams.Publisher;

public class InternalReactiveTransaction
extends AbstractReactiveTransaction
implements ReactiveTransaction,
BaseReactiveQueryRunner {
    protected InternalReactiveTransaction(UnmanagedTransaction tx) {
        super(tx);
    }

    @Override
    public Publisher<ReactiveResult> run(Query query) {
        CompletionStage<RxResultCursor> cursorStage;
        try {
            cursorStage = this.tx.runRx(query);
        }
        catch (Throwable t) {
            cursorStage = Futures.failedFuture(t);
        }
        return Mono.fromCompletionStage(cursorStage).flatMap(cursor -> {
            Mono<Object> publisher;
            Throwable runError = cursor.getRunError();
            if (runError != null) {
                publisher = Mono.error(runError);
                this.tx.markTerminated(runError);
            } else {
                publisher = Mono.just(cursor);
            }
            return publisher;
        }).map(InternalReactiveResult::new);
    }

    public Publisher<Void> interrupt() {
        return Mono.fromCompletionStage(this.tx.interruptAsync());
    }

    @Override
    public <T> Publisher<T> commit() {
        return this.doCommit();
    }

    @Override
    public <T> Publisher<T> rollback() {
        return this.doRollback();
    }

    @Override
    public Publisher<Void> close() {
        return this.doClose();
    }

    @Override
    public Publisher<Boolean> isOpen() {
        return this.doIsOpen();
    }
}

