/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.StringValue;

class AuthTokensTest {
    AuthTokensTest() {
    }

    @Test
    void basicAuthWithoutRealm() {
        InternalAuthToken basic = (InternalAuthToken)AuthTokens.basic((String)"foo", (String)"bar");
        Map map = basic.toMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)IsEqual.equalTo((Object)3));
        MatcherAssert.assertThat(map.get("scheme"), (Matcher)IsEqual.equalTo((Object)new StringValue("basic")));
        MatcherAssert.assertThat(map.get("principal"), (Matcher)IsEqual.equalTo((Object)new StringValue("foo")));
        MatcherAssert.assertThat(map.get("credentials"), (Matcher)IsEqual.equalTo((Object)new StringValue("bar")));
    }

    @Test
    void basicAuthWithRealm() {
        InternalAuthToken basic = (InternalAuthToken)AuthTokens.basic((String)"foo", (String)"bar", (String)"baz");
        Map map = basic.toMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)IsEqual.equalTo((Object)4));
        MatcherAssert.assertThat(map.get("scheme"), (Matcher)IsEqual.equalTo((Object)new StringValue("basic")));
        MatcherAssert.assertThat(map.get("principal"), (Matcher)IsEqual.equalTo((Object)new StringValue("foo")));
        MatcherAssert.assertThat(map.get("credentials"), (Matcher)IsEqual.equalTo((Object)new StringValue("bar")));
        MatcherAssert.assertThat(map.get("realm"), (Matcher)IsEqual.equalTo((Object)new StringValue("baz")));
    }

    @Test
    void customAuthWithoutParameters() {
        InternalAuthToken basic = (InternalAuthToken)AuthTokens.custom((String)"foo", (String)"bar", (String)"baz", (String)"my_scheme");
        Map map = basic.toMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)IsEqual.equalTo((Object)4));
        MatcherAssert.assertThat(map.get("scheme"), (Matcher)IsEqual.equalTo((Object)new StringValue("my_scheme")));
        MatcherAssert.assertThat(map.get("principal"), (Matcher)IsEqual.equalTo((Object)new StringValue("foo")));
        MatcherAssert.assertThat(map.get("credentials"), (Matcher)IsEqual.equalTo((Object)new StringValue("bar")));
        MatcherAssert.assertThat(map.get("realm"), (Matcher)IsEqual.equalTo((Object)new StringValue("baz")));
    }

    @Test
    void customAuthParameters() {
        HashMap<String, List<Integer>> parameters = new HashMap<String, List<Integer>>();
        parameters.put("list", Arrays.asList(1, 2, 3));
        InternalAuthToken basic = (InternalAuthToken)AuthTokens.custom((String)"foo", (String)"bar", (String)"baz", (String)"my_scheme", parameters);
        HashMap<String, ListValue> expectedParameters = new HashMap<String, ListValue>();
        expectedParameters.put("list", new ListValue(Values.values((Object[])new Object[]{1, 2, 3})));
        Map map = basic.toMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)IsEqual.equalTo((Object)5));
        MatcherAssert.assertThat(map.get("scheme"), (Matcher)IsEqual.equalTo((Object)new StringValue("my_scheme")));
        MatcherAssert.assertThat(map.get("principal"), (Matcher)IsEqual.equalTo((Object)new StringValue("foo")));
        MatcherAssert.assertThat(map.get("credentials"), (Matcher)IsEqual.equalTo((Object)new StringValue("bar")));
        MatcherAssert.assertThat(map.get("realm"), (Matcher)IsEqual.equalTo((Object)new StringValue("baz")));
        MatcherAssert.assertThat(map.get("parameters"), (Matcher)IsEqual.equalTo((Object)new MapValue(expectedParameters)));
    }

    @Test
    void shouldSupportBearerAuth() {
        String tokenStr = "token";
        InternalAuthToken token = (InternalAuthToken)AuthTokens.bearer((String)tokenStr);
        Map map = token.toMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)IsEqual.equalTo((Object)2));
        MatcherAssert.assertThat(map.get("scheme"), (Matcher)IsEqual.equalTo((Object)new StringValue("bearer")));
        MatcherAssert.assertThat(map.get("credentials"), (Matcher)IsEqual.equalTo((Object)new StringValue(tokenStr)));
    }

    @Test
    void basicKerberosAuthWithRealm() {
        InternalAuthToken token = (InternalAuthToken)AuthTokens.kerberos((String)"base64");
        Map map = token.toMap();
        MatcherAssert.assertThat((Object)map.size(), (Matcher)IsEqual.equalTo((Object)3));
        MatcherAssert.assertThat(map.get("scheme"), (Matcher)IsEqual.equalTo((Object)new StringValue("kerberos")));
        MatcherAssert.assertThat(map.get("principal"), (Matcher)IsEqual.equalTo((Object)new StringValue("")));
        MatcherAssert.assertThat(map.get("credentials"), (Matcher)IsEqual.equalTo((Object)new StringValue("base64")));
    }

    @Test
    void shouldNotAllowBasicAuthTokenWithNullUsername() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.basic(null, (String)"password"));
        Assertions.assertEquals((Object)"Username can't be null", (Object)e.getMessage());
    }

    @Test
    void shouldNotAllowBasicAuthTokenWithNullPassword() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.basic((String)"username", null));
        Assertions.assertEquals((Object)"Password can't be null", (Object)e.getMessage());
    }

    @Test
    void shouldAllowBasicAuthTokenWithNullRealm() {
        AuthToken token = AuthTokens.basic((String)"username", (String)"password", null);
        Map map = ((InternalAuthToken)token).toMap();
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"basic", (Object)((Value)map.get("scheme")).asString());
        Assertions.assertEquals((Object)"username", (Object)((Value)map.get("principal")).asString());
        Assertions.assertEquals((Object)"password", (Object)((Value)map.get("credentials")).asString());
    }

    @Test
    void shouldNotAllowBearerAuthTokenWithNullToken() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.bearer(null));
        Assertions.assertEquals((Object)"Token can't be null", (Object)e.getMessage());
    }

    @Test
    void shouldNotAllowKerberosAuthTokenWithNullTicket() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.kerberos(null));
        Assertions.assertEquals((Object)"Ticket can't be null", (Object)e.getMessage());
    }

    @Test
    void shouldNotAllowCustomAuthTokenWithNullPrincipal() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.custom(null, (String)"credentials", (String)"realm", (String)"scheme"));
        Assertions.assertEquals((Object)"Principal can't be null", (Object)e.getMessage());
    }

    @Test
    void shouldNotAllowCustomAuthTokenWithNullCredentials() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.custom((String)"principal", null, (String)"realm", (String)"scheme"));
        Assertions.assertEquals((Object)"Credentials can't be null", (Object)e.getMessage());
    }

    @Test
    void shouldAllowCustomAuthTokenWithNullRealm() {
        AuthToken token = AuthTokens.custom((String)"principal", (String)"credentials", null, (String)"scheme");
        Map map = ((InternalAuthToken)token).toMap();
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"scheme", (Object)((Value)map.get("scheme")).asString());
        Assertions.assertEquals((Object)"principal", (Object)((Value)map.get("principal")).asString());
        Assertions.assertEquals((Object)"credentials", (Object)((Value)map.get("credentials")).asString());
    }

    @Test
    void shouldNotAllowCustomAuthTokenWithNullScheme() {
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> AuthTokens.custom((String)"principal", (String)"credentials", (String)"realm", null));
        Assertions.assertEquals((Object)"Scheme can't be null", (Object)e.getMessage());
    }
}

