/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.mockito.Mockito;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.RevocationCheckingStrategy;
import org.neo4j.driver.internal.RevocationStrategy;
import org.neo4j.driver.internal.logging.ConsoleLogging;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.internal.logging.Slf4jLogging;
import org.neo4j.driver.net.ServerAddressResolver;
import org.neo4j.driver.util.TestUtil;

class ConfigTest {
    ConfigTest() {
    }

    @Test
    void shouldDefaultToKnownCerts() {
        Config config = Config.defaultConfig();
        Config.TrustStrategy authConfig = config.trustStrategy();
        Assertions.assertEquals((Object)authConfig.strategy(), (Object)Config.TrustStrategy.Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES);
    }

    @Test
    void shouldChangeToTrustedCert() {
        File trustedCert = new File("trusted_cert");
        Config config = Config.builder().withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{trustedCert})).build();
        Config.TrustStrategy authConfig = config.trustStrategy();
        Assertions.assertEquals((Object)authConfig.strategy(), (Object)Config.TrustStrategy.Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES);
        Assertions.assertEquals((Object)trustedCert.getAbsolutePath(), (Object)((File)authConfig.certFiles().get(0)).getAbsolutePath());
    }

    @Test
    void shouldSupportLivenessCheckTimeoutSetting() {
        Config config = Config.builder().withConnectionLivenessCheckTimeout(42L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(42L), (long)config.idleTimeBeforeConnectionTest());
    }

    @Test
    void shouldAllowZeroConnectionLivenessCheckTimeout() {
        Config config = Config.builder().withConnectionLivenessCheckTimeout(0L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)0L, (long)config.idleTimeBeforeConnectionTest());
    }

    @Test
    void shouldAllowNegativeConnectionLivenessCheckTimeout() {
        Config config = Config.builder().withConnectionLivenessCheckTimeout(-42L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(-42L), (long)config.idleTimeBeforeConnectionTest());
    }

    @Test
    void shouldHaveCorrectMaxConnectionLifetime() {
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)Config.defaultConfig().maxConnectionLifetimeMillis());
    }

    @Test
    void shouldSupportMaxConnectionLifetimeSetting() {
        Config config = Config.builder().withMaxConnectionLifetime(42L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(42L), (long)config.maxConnectionLifetimeMillis());
    }

    @Test
    void shouldAllowZeroConnectionMaxConnectionLifetime() {
        Config config = Config.builder().withMaxConnectionLifetime(0L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)0L, (long)config.maxConnectionLifetimeMillis());
    }

    @Test
    void shouldAllowNegativeConnectionMaxConnectionLifetime() {
        Config config = Config.builder().withMaxConnectionLifetime(-42L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(-42L), (long)config.maxConnectionLifetimeMillis());
    }

    @Test
    void shouldTurnOnLeakedSessionsLogging() {
        Assertions.assertFalse((boolean)Config.builder().build().logLeakedSessions());
        Assertions.assertTrue((boolean)Config.builder().withLeakedSessionsLogging().build().logLeakedSessions());
    }

    @Test
    void shouldHaveDefaultConnectionTimeout() {
        Config defaultConfig = Config.defaultConfig();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(30L), (long)defaultConfig.connectionTimeoutMillis());
    }

    @Test
    void shouldRespectConfiguredConnectionTimeout() {
        Config config = Config.builder().withConnectionTimeout(42L, TimeUnit.HOURS).build();
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(42L), (long)config.connectionTimeoutMillis());
    }

    @Test
    void shouldAllowConnectionTimeoutOfZero() {
        Config config = Config.builder().withConnectionTimeout(0L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((int)0, (int)config.connectionTimeoutMillis());
    }

    @Test
    void shouldThrowForNegativeConnectionTimeout() {
        Config.ConfigBuilder builder = Config.builder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.withConnectionTimeout(-42L, TimeUnit.SECONDS));
    }

    @Test
    void shouldThrowForTooLargeConnectionTimeout() {
        Config.ConfigBuilder builder = Config.builder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.withConnectionTimeout(9223372036854775765L, TimeUnit.SECONDS));
    }

    @Test
    void shouldNotAllowNegativeMaxRetryTimeMs() {
        Config.ConfigBuilder builder = Config.builder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.withMaxTransactionRetryTime(-42L, TimeUnit.SECONDS));
    }

    @Test
    void shouldAllowZeroMaxRetryTimeMs() {
        Config config = Config.builder().withMaxTransactionRetryTime(0L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)0L, (long)config.retrySettings().maxRetryTimeMs());
    }

    @Test
    void shouldAllowPositiveRetryAttempts() {
        Config config = Config.builder().withMaxTransactionRetryTime(42L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(42L), (long)config.retrySettings().maxRetryTimeMs());
    }

    @Test
    void shouldHaveCorrectDefaultMaxConnectionPoolSize() {
        Assertions.assertEquals((int)100, (int)Config.defaultConfig().maxConnectionPoolSize());
    }

    @Test
    void shouldAllowPositiveMaxConnectionPoolSize() {
        Config config = Config.builder().withMaxConnectionPoolSize(42).build();
        Assertions.assertEquals((int)42, (int)config.maxConnectionPoolSize());
    }

    @Test
    void shouldAllowNegativeMaxConnectionPoolSize() {
        Config config = Config.builder().withMaxConnectionPoolSize(-42).build();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)config.maxConnectionPoolSize());
    }

    @Test
    void shouldDisallowZeroMaxConnectionPoolSize() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Config.builder().withMaxConnectionPoolSize(0).build());
        Assertions.assertEquals((Object)"Zero value is not supported", (Object)e.getMessage());
    }

    @Test
    void shouldHaveCorrectDefaultConnectionAcquisitionTimeout() {
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(60L), (long)Config.defaultConfig().connectionAcquisitionTimeoutMillis());
    }

    @Test
    void shouldAllowPositiveConnectionAcquisitionTimeout() {
        Config config = Config.builder().withConnectionAcquisitionTimeout(42L, TimeUnit.SECONDS).build();
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMillis(42L), (long)config.connectionAcquisitionTimeoutMillis());
    }

    @Test
    void shouldAllowNegativeConnectionAcquisitionTimeout() {
        Config config = Config.builder().withConnectionAcquisitionTimeout(-42L, TimeUnit.HOURS).build();
        Assertions.assertEquals((long)-1L, (long)config.connectionAcquisitionTimeoutMillis());
    }

    @Test
    void shouldAllowConnectionAcquisitionTimeoutOfZero() {
        Config config = Config.builder().withConnectionAcquisitionTimeout(0L, TimeUnit.DAYS).build();
        Assertions.assertEquals((long)0L, (long)config.connectionAcquisitionTimeoutMillis());
    }

    @Test
    void shouldEnableAndDisableHostnameVerificationOnTrustStrategy() {
        Config.TrustStrategy trustStrategy = Config.TrustStrategy.trustSystemCertificates();
        Assertions.assertTrue((boolean)trustStrategy.isHostnameVerificationEnabled());
        Assertions.assertSame((Object)trustStrategy, (Object)trustStrategy.withHostnameVerification());
        Assertions.assertTrue((boolean)trustStrategy.isHostnameVerificationEnabled());
        Assertions.assertSame((Object)trustStrategy, (Object)trustStrategy.withoutHostnameVerification());
        Assertions.assertFalse((boolean)trustStrategy.isHostnameVerificationEnabled());
    }

    @Test
    void shouldEnableAndDisableCertificateRevocationChecksOnTestStrategy() {
        Config.TrustStrategy trustStrategy = Config.TrustStrategy.trustSystemCertificates();
        Assertions.assertEquals((Object)RevocationCheckingStrategy.NO_CHECKS, (Object)trustStrategy.revocationCheckingStrategy());
        Assertions.assertEquals((Object)RevocationStrategy.NO_CHECKS, (Object)trustStrategy.revocationStrategy());
        Assertions.assertSame((Object)trustStrategy, (Object)trustStrategy.withoutCertificateRevocationChecks());
        Assertions.assertEquals((Object)RevocationCheckingStrategy.NO_CHECKS, (Object)trustStrategy.revocationCheckingStrategy());
        Assertions.assertEquals((Object)RevocationStrategy.NO_CHECKS, (Object)trustStrategy.revocationStrategy());
        Assertions.assertSame((Object)trustStrategy, (Object)trustStrategy.withStrictRevocationChecks());
        Assertions.assertEquals((Object)RevocationCheckingStrategy.STRICT, (Object)trustStrategy.revocationCheckingStrategy());
        Assertions.assertEquals((Object)RevocationStrategy.STRICT, (Object)trustStrategy.revocationStrategy());
        Assertions.assertSame((Object)trustStrategy, (Object)trustStrategy.withVerifyIfPresentRevocationChecks());
        Assertions.assertEquals((Object)RevocationCheckingStrategy.VERIFY_IF_PRESENT, (Object)trustStrategy.revocationCheckingStrategy());
        Assertions.assertEquals((Object)RevocationStrategy.VERIFY_IF_PRESENT, (Object)trustStrategy.revocationStrategy());
    }

    @Test
    void shouldAllowToConfigureResolver() {
        ServerAddressResolver resolver = (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class);
        Config config = Config.builder().withResolver(resolver).build();
        Assertions.assertEquals((Object)resolver, (Object)config.resolver());
    }

    @Test
    void shouldNotAllowNullResolver() {
        Assertions.assertThrows(NullPointerException.class, () -> Config.builder().withResolver(null));
    }

    @Test
    void shouldDefaultToDefaultFetchSize() {
        Config config = Config.defaultConfig();
        Assertions.assertEquals((long)1000L, (long)config.fetchSize());
    }

    @ParameterizedTest
    @ValueSource(longs={100L, 1L, 1000L, 0x7FFFFFFFFFFFFFFFL, -1L})
    void shouldChangeFetchSize(long value) {
        Config config = Config.builder().withFetchSize(value).build();
        Assertions.assertEquals((long)value, (long)config.fetchSize());
    }

    @ParameterizedTest
    @ValueSource(longs={0L, -100L, -2L})
    void shouldErrorWithIllegalFetchSize(long value) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Config.builder().withFetchSize(value).build());
    }

    @ParameterizedTest
    @ValueSource(ints={100, 1, 1000, 0x7FFFFFFF})
    void shouldChangeEventLoopThreads(int value) {
        Config config = Config.builder().withEventLoopThreads(value).build();
        Assertions.assertEquals((int)value, (int)config.eventLoopThreads());
    }

    @ParameterizedTest
    @ValueSource(ints={0, -100, -2})
    void shouldErrorWithIllegalEventLoopThreadsSize(int value) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Config.builder().withEventLoopThreads(value).build());
    }

    @Test
    void shouldChangeUserAgent() {
        Config config = Config.builder().withUserAgent("AwesomeDriver").build();
        Assertions.assertEquals((Object)"AwesomeDriver", (Object)config.userAgent());
    }

    @Test
    void shouldErrorWithInvalidUserAgent() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Config.builder().withUserAgent(null).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Config.builder().withUserAgent("").build());
    }

    @Test
    void shouldNotHaveMeterRegistryByDefault() {
        Config config = Config.builder().build();
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        Assertions.assertEquals((Object)MetricsAdapter.DEV_NULL, (Object)metricsAdapter);
        Assertions.assertFalse((boolean)config.isMetricsEnabled());
    }

    @Test
    void shouldNotAcceptNullMeterRegistry() {
        Config.ConfigBuilder builder = Config.builder();
        Assertions.assertThrows(NullPointerException.class, () -> builder.withMetricsAdapter(null));
    }

    @Test
    void shouldSetMetricsAdapter() {
        Config config = Config.builder().withMetricsAdapter(MetricsAdapter.DEFAULT).build();
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        Assertions.assertEquals((Object)MetricsAdapter.DEFAULT, (Object)metricsAdapter);
        Assertions.assertTrue((boolean)config.isMetricsEnabled());
    }

    @Nested
    class SerializationTest {
        SerializationTest() {
        }

        @Test
        void shouldSerialize() throws Exception {
            Config config = Config.builder().withMaxConnectionPoolSize(123).withConnectionTimeout(6543L, TimeUnit.MILLISECONDS).withConnectionAcquisitionTimeout(5432L, TimeUnit.MILLISECONDS).withConnectionLivenessCheckTimeout(4321L, TimeUnit.MILLISECONDS).withMaxConnectionLifetime(4711L, TimeUnit.MILLISECONDS).withMaxTransactionRetryTime(3210L, TimeUnit.MILLISECONDS).withFetchSize(9876L).withEventLoopThreads(4).withoutEncryption().withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File("doesntMatter")})).withUserAgent("user-agent").withDriverMetrics().withRoutingTablePurgeDelay(50000L, TimeUnit.MILLISECONDS).withLeakedSessionsLogging().withMetricsAdapter(MetricsAdapter.MICROMETER).build();
            Config verify = TestUtil.serializeAndReadBack(config, Config.class);
            Assertions.assertEquals((int)config.maxConnectionPoolSize(), (int)verify.maxConnectionPoolSize());
            Assertions.assertEquals((int)config.connectionTimeoutMillis(), (int)verify.connectionTimeoutMillis());
            Assertions.assertEquals((long)config.connectionAcquisitionTimeoutMillis(), (long)verify.connectionAcquisitionTimeoutMillis());
            Assertions.assertEquals((long)config.idleTimeBeforeConnectionTest(), (long)verify.idleTimeBeforeConnectionTest());
            Assertions.assertEquals((long)config.maxConnectionLifetimeMillis(), (long)verify.maxConnectionLifetimeMillis());
            Assertions.assertNotNull((Object)verify.retrySettings());
            Assertions.assertSame((Object)DevNullLogging.DEV_NULL_LOGGING, (Object)verify.logging());
            Assertions.assertEquals((long)config.retrySettings().maxRetryTimeMs(), (long)verify.retrySettings().maxRetryTimeMs());
            Assertions.assertEquals((long)config.fetchSize(), (long)verify.fetchSize());
            Assertions.assertEquals((int)config.eventLoopThreads(), (int)verify.eventLoopThreads());
            Assertions.assertEquals((Object)config.encrypted(), (Object)verify.encrypted());
            Assertions.assertEquals((Object)config.trustStrategy().strategy(), (Object)verify.trustStrategy().strategy());
            Assertions.assertEquals((Object)config.trustStrategy().certFiles(), (Object)verify.trustStrategy().certFiles());
            Assertions.assertEquals((Object)config.trustStrategy().isHostnameVerificationEnabled(), (Object)verify.trustStrategy().isHostnameVerificationEnabled());
            Assertions.assertEquals((Object)config.trustStrategy().revocationStrategy(), (Object)verify.trustStrategy().revocationStrategy());
            Assertions.assertEquals((Object)config.userAgent(), (Object)verify.userAgent());
            Assertions.assertEquals((Object)config.isMetricsEnabled(), (Object)verify.isMetricsEnabled());
            Assertions.assertEquals((Object)config.metricsAdapter(), (Object)verify.metricsAdapter());
            Assertions.assertEquals((long)config.routingSettings().routingTablePurgeDelayMs(), (long)verify.routingSettings().routingTablePurgeDelayMs());
            Assertions.assertEquals((Object)config.logLeakedSessions(), (Object)verify.logLeakedSessions());
        }

        @Test
        void shouldSerializeSerializableLogging() throws IOException, ClassNotFoundException {
            Config config = Config.builder().withLogging(Logging.javaUtilLogging((Level)Level.ALL)).build();
            Config verify = TestUtil.serializeAndReadBack(config, Config.class);
            Logging logging = verify.logging();
            Assertions.assertInstanceOf(JULogging.class, (Object)logging);
            List loggingLevelFields = ReflectionSupport.findFields(JULogging.class, f -> "loggingLevel".equals(f.getName()), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
            Assertions.assertFalse((boolean)loggingLevelFields.isEmpty());
            loggingLevelFields.forEach(field -> {
                try {
                    field.setAccessible(true);
                    Assertions.assertEquals((Object)Level.ALL, (Object)field.get(logging));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        @ParameterizedTest
        @ValueSource(classes={DevNullLogging.class, JULogging.class, ConsoleLogging.class, Slf4jLogging.class})
        void officialLoggingProvidersShouldBeSerializable(Class<? extends Logging> loggingClass) {
            Assertions.assertTrue((boolean)Serializable.class.isAssignableFrom(loggingClass));
        }
    }
}

