/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.util.TestUtil;

class GraphDatabaseTest {
    private static final Config INSECURE_CONFIG = Config.builder().withoutEncryption().withLogging(Logging.none()).build();

    GraphDatabaseTest() {
    }

    @Test
    void throwsWhenBoltSchemeUsedWithRoutingParams() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GraphDatabase.driver((String)"bolt://localhost:7687/?policy=my_policy"));
    }

    @Test
    void shouldLogWhenUnableToCreateRoutingDriver() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        InternalDriver driver = (InternalDriver)Mockito.mock(InternalDriver.class);
        ((InternalDriver)Mockito.doThrow(ServiceUnavailableException.class).when((Object)driver)).verifyConnectivity();
        MockSupplyingDriverFactory driverFactory = new MockSupplyingDriverFactory(Arrays.asList(driver, driver));
        Config config = Config.builder().withLogging(logging).build();
        List<URI> routingUris = Arrays.asList(URI.create("neo4j://localhost:9001"), URI.create("neo4j://localhost:9002"));
        Assertions.assertThrows(ServiceUnavailableException.class, () -> GraphDatabase.routingDriver((Iterable)routingUris, (AuthToken)AuthTokens.none(), (Config)config, (DriverFactory)driverFactory));
        ((Logger)Mockito.verify((Object)logger)).warn((String)ArgumentMatchers.eq((Object)"Unable to create routing driver for URI: neo4j://localhost:9001"), (Throwable)ArgumentMatchers.any(Throwable.class));
        ((Logger)Mockito.verify((Object)logger)).warn((String)ArgumentMatchers.eq((Object)"Unable to create routing driver for URI: neo4j://localhost:9002"), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    void shouldNotFailRoutingDriverWhenThereIsWorkingUri() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        InternalDriver failingDriver = (InternalDriver)Mockito.mock(InternalDriver.class);
        ((InternalDriver)Mockito.doThrow(ServiceUnavailableException.class).when((Object)failingDriver)).verifyConnectivity();
        InternalDriver workingDriver = (InternalDriver)Mockito.mock(InternalDriver.class);
        MockSupplyingDriverFactory driverFactory = new MockSupplyingDriverFactory(Arrays.asList(failingDriver, workingDriver));
        Config config = Config.builder().withLogging(logging).build();
        List<URI> routingUris = Arrays.asList(URI.create("neo4j://localhost:9001"), URI.create("neo4j://localhost:9002"));
        Driver driver = GraphDatabase.routingDriver(routingUris, (AuthToken)AuthTokens.none(), (Config)config, (DriverFactory)driverFactory);
        ((Logger)Mockito.verify((Object)logger)).warn((String)ArgumentMatchers.eq((Object)"Unable to create routing driver for URI: neo4j://localhost:9001"), (Throwable)ArgumentMatchers.any(Throwable.class));
        Assertions.assertEquals((Object)driver, (Object)workingDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldRespondToInterruptsWhenConnectingToUnresponsiveServer() throws Exception {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            TestUtil.interruptWhenInWaitingState(Thread.currentThread());
            Driver driver = GraphDatabase.driver((String)("bolt://localhost:" + serverSocket.getLocalPort()));
            try {
                Assertions.assertThrows(ServiceUnavailableException.class, () -> ((Driver)driver).verifyConnectivity());
            }
            finally {
                Thread.interrupted();
            }
        }
    }

    @Test
    void shouldPrintNiceErrorWhenConnectingToUnresponsiveServer() throws Exception {
        int localPort = -1;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            localPort = serverSocket.getLocalPort();
        }
        Driver driver = GraphDatabase.driver((String)("bolt://localhost:" + localPort), (Config)INSECURE_CONFIG);
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> ((Driver)driver).verifyConnectivity());
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Unable to connect to"));
    }

    @Test
    void shouldPrintNiceRoutingErrorWhenConnectingToUnresponsiveServer() throws Exception {
        int localPort = -1;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            localPort = serverSocket.getLocalPort();
        }
        Driver driver = GraphDatabase.driver((String)("neo4j://localhost:" + localPort), (Config)INSECURE_CONFIG);
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> ((Driver)driver).verifyConnectivity());
        error.printStackTrace();
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Unable to connect to"));
    }

    @Test
    void shouldFailToCreateUnencryptedDriverWhenServerDoesNotRespond() throws IOException {
        GraphDatabaseTest.testFailureWhenServerDoesNotRespond(false);
    }

    @Test
    void shouldFailToCreateEncryptedDriverWhenServerDoesNotRespond() throws IOException {
        GraphDatabaseTest.testFailureWhenServerDoesNotRespond(true);
    }

    private static void testFailureWhenServerDoesNotRespond(boolean encrypted) throws IOException {
        try (ServerSocket server = new ServerSocket(0);){
            int connectionTimeoutMillis = 1000;
            Config config = GraphDatabaseTest.createConfig(encrypted, connectionTimeoutMillis);
            Driver driver = GraphDatabase.driver((URI)URI.create("bolt://localhost:" + server.getLocalPort()), (Config)config);
            ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> ((Driver)driver).verifyConnectivity());
            Assertions.assertEquals((Object)e.getMessage(), (Object)("Unable to establish connection in " + connectionTimeoutMillis + "ms"));
        }
    }

    private static Config createConfig(boolean encrypted, int timeoutMillis) {
        Config.ConfigBuilder configBuilder = Config.builder().withConnectionTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).withLogging(DevNullLogging.DEV_NULL_LOGGING);
        if (encrypted) {
            configBuilder.withEncryption();
        } else {
            configBuilder.withoutEncryption();
        }
        return configBuilder.build();
    }

    private static class MockSupplyingDriverFactory
    extends DriverFactory {
        private final Iterator<InternalDriver> driverIterator;

        private MockSupplyingDriverFactory(List<InternalDriver> drivers) {
            this.driverIterator = drivers.iterator();
        }

        protected InternalDriver createRoutingDriver(SecurityPlan securityPlan, BoltServerAddress address, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config) {
            return this.driverIterator.next();
        }
    }
}

