/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.util.BookmarkUtil;
import org.neo4j.driver.internal.util.DisabledOnNeo4jWith;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;

@ParallelizableIT
class BookmarkIT {
    @RegisterExtension
    static final SessionExtension sessionRule = new SessionExtension();
    private Driver driver;
    private Session session;

    BookmarkIT() {
    }

    @BeforeEach
    void assumeBookmarkSupport() {
        this.driver = sessionRule.driver();
        this.session = sessionRule;
    }

    @Test
    @DisabledOnNeo4jWith(value=Neo4jFeature.BOLT_V4)
    void shouldReceiveBookmarkOnSuccessfulCommit() throws Throwable {
        BookmarkUtil.assertBookmarkIsEmpty(this.session.lastBookmark());
        BookmarkIT.createNodeInTx(this.session);
        BookmarkUtil.assertBookmarkContainsSingleValue(this.session.lastBookmark(), (Matcher<String>)Matchers.startsWith((String)"neo4j:bookmark:v1:tx"));
    }

    @Test
    @EnabledOnNeo4jWith(value=Neo4jFeature.BOLT_V4)
    void shouldReceiveNewBookmarkOnSuccessfulCommit() throws Throwable {
        Bookmark initialBookmark = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkIsEmpty(initialBookmark);
        BookmarkIT.createNodeInTx(this.session);
        BookmarkUtil.assertBookmarkContainsSingleValue(this.session.lastBookmark());
        Assertions.assertNotEquals((Object)initialBookmark, (Object)this.session.lastBookmark());
    }

    @Test
    void shouldThrowForInvalidBookmark() {
        Bookmark invalidBookmark = InternalBookmark.parse((String)"hi, this is an invalid bookmark");
        try (Session session = this.driver.session(SessionConfig.builder().withBookmarks(new Bookmark[]{invalidBookmark}).build());){
            Assertions.assertThrows(ClientException.class, () -> ((Session)session).beginTransaction());
        }
    }

    @Test
    void bookmarkRemainsAfterRolledBackTx() {
        BookmarkUtil.assertBookmarkIsEmpty(this.session.lastBookmark());
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark);
        try (Transaction tx = this.session.beginTransaction();){
            tx.run("CREATE (a:Person)");
            tx.rollback();
        }
        Assertions.assertEquals((Object)bookmark, (Object)this.session.lastBookmark());
    }

    @Test
    void bookmarkRemainsAfterTxFailure() {
        BookmarkUtil.assertBookmarkIsEmpty(this.session.lastBookmark());
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark);
        Transaction tx = this.session.beginTransaction();
        Assertions.assertThrows(ClientException.class, () -> tx.run("RETURN"));
        Assertions.assertEquals((Object)bookmark, (Object)this.session.lastBookmark());
    }

    @Test
    void bookmarkRemainsAfterSuccessfulSessionRun() {
        BookmarkUtil.assertBookmarkIsEmpty(this.session.lastBookmark());
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark);
        this.session.run("RETURN 1").consume();
        Assertions.assertEquals((Object)bookmark, (Object)this.session.lastBookmark());
    }

    @Test
    void bookmarkRemainsAfterFailedSessionRun() {
        BookmarkUtil.assertBookmarkIsEmpty(this.session.lastBookmark());
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark);
        Assertions.assertThrows(ClientException.class, () -> this.session.run("RETURN").consume());
        Assertions.assertEquals((Object)bookmark, (Object)this.session.lastBookmark());
    }

    @Test
    void bookmarkIsUpdatedOnEveryCommittedTx() {
        BookmarkUtil.assertBookmarkIsEmpty(this.session.lastBookmark());
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark1 = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark1);
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark2 = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark2);
        BookmarkIT.createNodeInTx(this.session);
        Bookmark bookmark3 = this.session.lastBookmark();
        BookmarkUtil.assertBookmarkContainsSingleValue(bookmark3);
        BookmarkUtil.assertBookmarksContainsSingleUniqueValues(bookmark1, bookmark2, bookmark3);
    }

    @Test
    void createSessionWithInitialBookmark() {
        Bookmark bookmark = InternalBookmark.parse((String)"TheBookmark");
        try (Session session = this.driver.session(SessionConfig.builder().withBookmarks(new Bookmark[]{bookmark}).build());){
            Assertions.assertEquals((Object)bookmark, (Object)session.lastBookmark());
        }
    }

    @Test
    void createSessionWithAccessModeAndInitialBookmark() {
        Bookmark bookmark = InternalBookmark.parse((String)"TheBookmark");
        try (Session session = this.driver.session(SessionConfig.builder().withBookmarks(new Bookmark[]{bookmark}).build());){
            Assertions.assertEquals((Object)bookmark, (Object)session.lastBookmark());
        }
    }

    private static void createNodeInTx(Session session) {
        try (Transaction tx = session.beginTransaction();){
            tx.run("CREATE (a:Person)");
            tx.commit();
        }
    }

    private static boolean isUuid(String string) {
        try {
            UUID.fromString(string);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String string) {
        try {
            Long.parseLong(string);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }
}

