/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.netty.channel.Channel;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.io.ChannelTrackingDriverFactory;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class ConnectionPoolIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Driver driver;
    private SessionGrabber sessionGrabber;

    ConnectionPoolIT() {
    }

    @AfterEach
    void cleanup() throws Exception {
        if (this.driver != null) {
            this.driver.close();
        }
        if (this.sessionGrabber != null) {
            this.sessionGrabber.stop();
        }
    }

    @Test
    void shouldRecoverFromDownedServer() throws Throwable {
        this.driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken());
        this.sessionGrabber = new SessionGrabber(this.driver);
        this.sessionGrabber.start();
        neo4j.stopProxy();
        neo4j.startProxy();
        this.sessionGrabber.assertSessionsAvailableWithin(120);
    }

    @Test
    void shouldDisposeChannelsBasedOnMaxLifetime() throws Exception {
        FakeClock clock = new FakeClock();
        ChannelTrackingDriverFactory driverFactory = new ChannelTrackingDriverFactory(clock);
        int maxConnLifetimeHours = 3;
        Config config = Config.builder().withMaxConnectionLifetime((long)maxConnLifetimeHours, TimeUnit.HOURS).build();
        this.driver = driverFactory.newInstance(neo4j.uri(), neo4j.authToken(), RoutingSettings.DEFAULT, RetrySettings.DEFAULT, config, SecurityPlanImpl.insecure());
        ConnectionPoolIT.startAndCloseTransactions(this.driver, 1);
        List<Channel> channels1 = driverFactory.channels();
        Assertions.assertEquals((int)1, (int)channels1.size());
        Assertions.assertTrue((boolean)channels1.get(0).isActive());
        this.awaitNoActiveChannels(driverFactory, 20L, TimeUnit.SECONDS);
        clock.progress(TimeUnit.HOURS.toMillis(maxConnLifetimeHours + 1));
        ConnectionPoolIT.startAndCloseTransactions(this.driver, 1);
        List<Channel> channels2 = driverFactory.channels();
        Assertions.assertEquals((int)2, (int)channels2.size());
        Channel channel1 = channels2.get(0);
        Channel channel2 = channels2.get(1);
        Assertions.assertTrue((boolean)channel1.closeFuture().await(20L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)channel1.isActive());
        Assertions.assertTrue((boolean)channel2.isActive());
    }

    @Test
    void shouldRespectMaxConnectionPoolSize() {
        int maxPoolSize = 3;
        Config config = Config.builder().withMaxConnectionPoolSize(maxPoolSize).withConnectionAcquisitionTimeout(542L, TimeUnit.MILLISECONDS).withEventLoopThreads(1).build();
        this.driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)config);
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ConnectionPoolIT.startAndCloseTransactions(this.driver, maxPoolSize + 1));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.connectionAcquisitionTimeoutError(542)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAndCloseTransactions(Driver driver, int txCount) {
        ArrayList<Session> sessions = new ArrayList<Session>(txCount);
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(txCount);
        ArrayList<Result> results = new ArrayList<Result>(txCount);
        try {
            for (int i = 0; i < txCount; ++i) {
                Session session = driver.session();
                sessions.add(session);
                Transaction tx = session.beginTransaction();
                transactions.add(tx);
                Result result = tx.run("RETURN 1");
                results.add(result);
            }
        }
        finally {
            for (Result result : results) {
                result.consume();
            }
            for (Transaction tx : transactions) {
                tx.commit();
            }
            for (Session session : sessions) {
                session.close();
            }
        }
    }

    private void awaitNoActiveChannels(ChannelTrackingDriverFactory driverFactory, long value, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(value);
        int activeChannels = -1;
        while (System.currentTimeMillis() < deadline) {
            activeChannels = driverFactory.activeChannels(neo4j.address());
            if (activeChannels == 0) {
                return;
            }
            Thread.sleep(100L);
        }
        throw new AssertionError((Object)("Active channels present: " + activeChannels));
    }

    private class SessionGrabber
    implements Runnable {
        private final Driver driver;
        private final CountDownLatch stopped = new CountDownLatch(1);
        private volatile boolean sessionsAreAvailable = false;
        private volatile boolean run = true;
        private volatile Throwable lastExceptionFromDriver;
        private final int sleepTimeout = 100;

        SessionGrabber(Driver driver) {
            this.driver = driver;
        }

        public void start() {
            new Thread(this).start();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (this.run) {
                    try {
                        ConnectionPoolIT.startAndCloseTransactions(this.driver, 8);
                        this.sessionsAreAvailable = true;
                    }
                    catch (Throwable e) {
                        this.lastExceptionFromDriver = e;
                        this.sessionsAreAvailable = false;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                        return;
                    }
                }
            }
            finally {
                this.stopped.countDown();
            }
        }

        void assertSessionsAvailableWithin(int timeoutSeconds) throws InterruptedException {
            long deadline = System.currentTimeMillis() + (long)(1000 * timeoutSeconds);
            while (System.currentTimeMillis() < deadline) {
                if (this.sessionsAreAvailable) {
                    return;
                }
                Thread.sleep(100L);
            }
            this.lastExceptionFromDriver.printStackTrace();
            Assertions.fail((String)("sessions did not become available from the driver after the db restart within the specified timeout. Last failure was: " + this.lastExceptionFromDriver.getMessage()));
        }

        public void stop() throws InterruptedException {
            this.run = false;
            this.stopped.await(10L, TimeUnit.SECONDS);
        }
    }
}

