/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class CredentialsIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    CredentialsIT() {
    }

    @Test
    void basicCredentialsShouldWork() {
        try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)AuthTokens.basic((String)"neo4j", (String)neo4j.adminPassword()));
             Session session = driver.session();){
            Value single = session.run("RETURN 1").single().get(0);
            MatcherAssert.assertThat((Object)single.asLong(), (Matcher)Matchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldGetHelpfulErrorOnInvalidCredentials() {
        SecurityException e = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> {
            try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)AuthTokens.basic((String)"thisisnotthepassword", (String)neo4j.adminPassword()));
                 Session session = driver.session();){
                session.run("RETURN 1");
            }
        });
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"The client is unauthorized due to authentication failure."));
    }

    @Test
    void shouldBeAbleToProvideRealmWithBasicAuth() {
        try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)AuthTokens.basic((String)"neo4j", (String)neo4j.adminPassword(), (String)"native"));
             Session session = driver.session();){
            Value single = session.run("CREATE () RETURN 1").single().get(0);
            MatcherAssert.assertThat((Object)single.asLong(), (Matcher)Matchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldBeAbleToConnectWithCustomToken() {
        try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)AuthTokens.custom((String)"neo4j", (String)neo4j.adminPassword(), (String)"native", (String)"basic"));
             Session session = driver.session();){
            Value single = session.run("CREATE () RETURN 1").single().get(0);
            MatcherAssert.assertThat((Object)single.asLong(), (Matcher)Matchers.equalTo((Object)1L));
        }
    }

    @Test
    void shouldBeAbleToConnectWithCustomTokenWithAdditionalParameters() {
        Map<String, Integer> params = Collections.singletonMap("secret", 16);
        try (Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)AuthTokens.custom((String)"neo4j", (String)neo4j.adminPassword(), (String)"native", (String)"basic", params));
             Session session = driver.session();){
            Value single = session.run("CREATE () RETURN 1").single().get(0);
            MatcherAssert.assertThat((Object)single.asLong(), (Matcher)Matchers.equalTo((Object)1L));
        }
    }

    @Test
    void directDriverShouldFailEarlyOnWrongCredentials() {
        this.testDriverFailureOnWrongCredentials(neo4j.uri().toString());
    }

    @Test
    void routingDriverShouldFailEarlyOnWrongCredentials() {
        this.testDriverFailureOnWrongCredentials(neo4j.uri().toString());
    }

    private void testDriverFailureOnWrongCredentials(String uri) {
        Config config = Config.builder().withLogging(DevNullLogging.DEV_NULL_LOGGING).build();
        AuthToken authToken = AuthTokens.basic((String)"neo4j", (String)"wrongSecret");
        Driver driver = GraphDatabase.driver((String)uri, (AuthToken)authToken, (Config)config);
        Assertions.assertThrows(AuthenticationException.class, () -> ((Driver)driver).verifyConnectivity());
    }
}

