/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class DriverCloseIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    DriverCloseIT() {
    }

    @Test
    void isEncryptedThrowsForClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Driver)driver).isEncrypted());
    }

    @Test
    void sessionThrowsForClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((Driver)driver).session());
    }

    @Test
    void sessionWithModeThrowsForClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> driver.session(SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build()));
    }

    @Test
    void closeClosedDriver() {
        Driver driver = DriverCloseIT.createDriver();
        driver.close();
        driver.close();
        driver.close();
    }

    @Test
    void useSessionAfterDriverIsClosed() {
        Driver driver = DriverCloseIT.createDriver();
        Session session = driver.session();
        driver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> session.run("CREATE ()"));
    }

    @Test
    void shouldInterruptStreamConsumptionAndEndRetriesOnDriverClosure() {
        int fetchSize = 5;
        Config config = Config.builder().withFetchSize((long)fetchSize).build();
        Driver driver = GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)config);
        Session session = driver.session();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
            List cfr_ignored_0 = (List)session.readTransaction(tx -> {
                HashMap<String, Integer> parameters = new HashMap<String, Integer>();
                parameters.put("limit", fetchSize * 3);
                Result result = tx.run("UNWIND range(0, $limit) AS x RETURN x", parameters);
                CompletableFuture.runAsync(() -> ((Driver)driver).close());
                return result.list();
            });
        });
        Assertions.assertEquals((Object)"Pool closed", (Object)exception.getMessage());
    }

    private static Driver createDriver() {
        return GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken());
    }
}

