/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.Neo4jSettings;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class EncryptionIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    EncryptionIT() {
    }

    @Test
    void shouldOperateWithNoEncryptionWhenItIsOptionalInTheDatabase() {
        this.testMatchingEncryption(Neo4jSettings.BoltTlsLevel.OPTIONAL, false, neo4j.uri().getScheme());
    }

    @Test
    void shouldOperateWithEncryptionWhenItIsOptionalInTheDatabase() {
        this.testMatchingEncryption(Neo4jSettings.BoltTlsLevel.OPTIONAL, true, neo4j.uri().getScheme());
    }

    @Test
    void shouldFailWithoutEncryptionWhenItIsRequiredInTheDatabase() {
        this.testMismatchingEncryption(Neo4jSettings.BoltTlsLevel.REQUIRED, false);
    }

    @Test
    void shouldOperateWithEncryptionWhenItIsAlsoRequiredInTheDatabase() {
        this.testMatchingEncryption(Neo4jSettings.BoltTlsLevel.REQUIRED, true, neo4j.uri().getScheme());
    }

    @Test
    void shouldOperateWithEncryptionWhenConfiguredUsingBoltSscURI() {
        this.testMatchingEncryption(Neo4jSettings.BoltTlsLevel.REQUIRED, true, "bolt+ssc");
    }

    @Test
    void shouldFailWithEncryptionWhenItIsDisabledInTheDatabase() {
        this.testMismatchingEncryption(Neo4jSettings.BoltTlsLevel.DISABLED, true);
    }

    @Test
    void shouldOperateWithoutEncryptionWhenItIsAlsoDisabledInTheDatabase() {
        this.testMatchingEncryption(Neo4jSettings.BoltTlsLevel.DISABLED, false, neo4j.uri().getScheme());
    }

    private void testMatchingEncryption(Neo4jSettings.BoltTlsLevel tlsLevel, boolean driverEncrypted, String scheme) {
        HashMap<String, String> tlsConfig = new HashMap<String, String>();
        tlsConfig.put("dbms.connector.bolt.tls_level", tlsLevel.toString());
        neo4j.deleteAndStartNeo4j(tlsConfig);
        Config config = scheme.equals("bolt+ssc") ? Config.builder().build() : EncryptionIT.newConfig(driverEncrypted);
        URI uri = URI.create(String.format("%s://%s:%s", scheme, neo4j.uri().getHost(), neo4j.uri().getPort()));
        try (Driver driver = GraphDatabase.driver((URI)uri, (AuthToken)neo4j.authToken(), (Config)config);){
            MatcherAssert.assertThat((Object)driver.isEncrypted(), (Matcher)CoreMatchers.equalTo((Object)driverEncrypted));
            try (Session session = driver.session();){
                Result result = session.run("RETURN 1");
                Record record = result.next();
                int value = record.get(0).asInt();
                MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)1));
            }
        }
    }

    private void testMismatchingEncryption(Neo4jSettings.BoltTlsLevel tlsLevel, boolean driverEncrypted) {
        HashMap<String, String> tlsConfig = new HashMap<String, String>();
        tlsConfig.put("dbms.connector.bolt.tls_level", tlsLevel.toString());
        neo4j.deleteAndStartNeo4j(tlsConfig);
        Config config = EncryptionIT.newConfig(driverEncrypted);
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)config).verifyConnectivity());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Connection to the database terminated"));
    }

    private static Config newConfig(boolean withEncryption) {
        return withEncryption ? EncryptionIT.configWithEncryption() : EncryptionIT.configWithoutEncryption();
    }

    private static Config configWithEncryption() {
        return Config.builder().withEncryption().withTrustStrategy(Config.TrustStrategy.trustAllCertificates()).build();
    }

    private static Config configWithoutEncryption() {
        return Config.builder().withoutEncryption().build();
    }
}

