/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Result;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;

@ParallelizableIT
class EntityTypeIT {
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    EntityTypeIT() {
    }

    @Test
    void shouldReturnIdentitiesOfNodes() {
        Result cursor = session.run("CREATE (n) RETURN n");
        Node node = cursor.single().get("n").asNode();
        MatcherAssert.assertThat((Object)node.id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
    }

    @Test
    void shouldReturnIdentitiesOfRelationships() {
        Result cursor = session.run("CREATE ()-[r:T]->() RETURN r");
        Relationship rel = cursor.single().get("r").asRelationship();
        MatcherAssert.assertThat((Object)rel.startNodeId(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
        MatcherAssert.assertThat((Object)rel.endNodeId(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
        MatcherAssert.assertThat((Object)rel.id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
    }

    @Test
    void shouldReturnIdentitiesOfPaths() {
        Result cursor = session.run("CREATE p=()-[r:T]->() RETURN p");
        Path path = cursor.single().get("p").asPath();
        MatcherAssert.assertThat((Object)path.start().id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
        MatcherAssert.assertThat((Object)path.end().id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
        Path.Segment segment = (Path.Segment)path.iterator().next();
        MatcherAssert.assertThat((Object)segment.start().id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
        MatcherAssert.assertThat((Object)segment.relationship().id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
        MatcherAssert.assertThat((Object)segment.end().id(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(-1L)));
    }
}

