/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ResultConsumedException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class QueryRunnerCloseIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Driver driver;
    private ExecutorService executor;

    QueryRunnerCloseIT() {
    }

    @AfterEach
    void tearDown() {
        if (this.driver != null) {
            this.driver.close();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test
    void shouldErrorToAccessRecordsAfterConsume() {
        Result result = neo4j.driver().session().run("UNWIND [1,2] AS a RETURN a");
        result.consume();
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).hasNext());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).next());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).list());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).single());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).peek());
        Assertions.assertThrows(ResultConsumedException.class, () -> result.stream().toArray());
        Assertions.assertThrows(ResultConsumedException.class, () -> result.forEachRemaining(record -> {}));
        Assertions.assertThrows(ResultConsumedException.class, () -> result.list(record -> record));
    }

    @Test
    void shouldErrorToAccessRecordsAfterClose() {
        Session session = neo4j.driver().session();
        Result result = session.run("UNWIND [1,2] AS a RETURN a");
        session.close();
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).hasNext());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).next());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).list());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).single());
        Assertions.assertThrows(ResultConsumedException.class, () -> ((Result)result).peek());
        Assertions.assertThrows(ResultConsumedException.class, () -> result.stream().toArray());
        Assertions.assertThrows(ResultConsumedException.class, () -> result.forEachRemaining(record -> {}));
        Assertions.assertThrows(ResultConsumedException.class, () -> result.list(record -> record));
    }

    @Test
    void shouldAllowConsumeAndKeysAfterConsume() {
        Result result = neo4j.driver().session().run("UNWIND [1,2] AS a RETURN a");
        List keys = result.keys();
        ResultSummary summary = result.consume();
        ResultSummary summary1 = result.consume();
        List keys1 = result.keys();
        Assertions.assertEquals((Object)summary, (Object)summary1);
        Assertions.assertEquals((Object)keys, (Object)keys1);
    }

    @Test
    void shouldAllowSummaryAndKeysAfterClose() {
        Session session = neo4j.driver().session();
        Result result = session.run("UNWIND [1,2] AS a RETURN a");
        List keys = result.keys();
        ResultSummary summary = result.consume();
        session.close();
        ResultSummary summary1 = result.consume();
        List keys1 = result.keys();
        Assertions.assertEquals((Object)summary, (Object)summary1);
        Assertions.assertEquals((Object)keys, (Object)keys1);
    }

    @Test
    void shouldErrorToAccessRecordsAfterConsumeAsync() {
        AsyncSession session = neo4j.driver().asyncSession();
        ResultCursor result = (ResultCursor)TestUtil.await(session.runAsync("UNWIND [1,2] AS a RETURN a"));
        TestUtil.await(result.consumeAsync());
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(result.nextAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(result.peekAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(result.singleAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            ResultSummary cfr_ignored_0 = (ResultSummary)TestUtil.await(result.forEachAsync(record -> {}));
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            List cfr_ignored_0 = (List)TestUtil.await(result.listAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            List cfr_ignored_0 = (List)TestUtil.await(result.listAsync(record -> record));
        });
    }

    @Test
    void shouldErrorToAccessRecordsAfterCloseAsync() {
        AsyncSession session = neo4j.driver().asyncSession();
        ResultCursor result = (ResultCursor)TestUtil.await(session.runAsync("UNWIND [1,2] AS a RETURN a"));
        TestUtil.await(session.closeAsync());
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(result.nextAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(result.peekAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(result.singleAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            ResultSummary cfr_ignored_0 = (ResultSummary)TestUtil.await(result.forEachAsync(record -> {}));
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            List cfr_ignored_0 = (List)TestUtil.await(result.listAsync());
        });
        Assertions.assertThrows(ResultConsumedException.class, () -> {
            List cfr_ignored_0 = (List)TestUtil.await(result.listAsync(record -> record));
        });
    }

    @Test
    void shouldAllowConsumeAndKeysAfterConsumeAsync() {
        AsyncSession session = neo4j.driver().asyncSession();
        ResultCursor result = (ResultCursor)TestUtil.await(session.runAsync("UNWIND [1,2] AS a RETURN a"));
        List keys = result.keys();
        ResultSummary summary = (ResultSummary)TestUtil.await(result.consumeAsync());
        ResultSummary summary1 = (ResultSummary)TestUtil.await(result.consumeAsync());
        List keys1 = result.keys();
        Assertions.assertEquals((Object)summary, (Object)summary1);
        Assertions.assertEquals((Object)keys, (Object)keys1);
    }

    @Test
    void shouldAllowConsumeAndKeysAfterCloseAsync() {
        AsyncSession session = neo4j.driver().asyncSession();
        ResultCursor result = (ResultCursor)TestUtil.await(session.runAsync("UNWIND [1,2] AS a RETURN a"));
        List keys = result.keys();
        ResultSummary summary = (ResultSummary)TestUtil.await(result.consumeAsync());
        TestUtil.await(session.closeAsync());
        List keys1 = result.keys();
        ResultSummary summary1 = (ResultSummary)TestUtil.await(result.consumeAsync());
        Assertions.assertEquals((Object)summary, (Object)summary1);
        Assertions.assertEquals((Object)keys, (Object)keys1);
    }
}

