/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.SessionExtension;

@ParallelizableIT
class ResultStreamIT {
    @RegisterExtension
    static final SessionExtension session = new SessionExtension();

    ResultStreamIT() {
    }

    @Test
    void shouldAllowIteratingOverResultStream() {
        Result res = session.run("UNWIND [1,2,3,4] AS a RETURN a");
        int idx = 1;
        while (res.hasNext()) {
            Assertions.assertEquals((long)idx++, (long)res.next().get("a").asLong());
        }
    }

    @Test
    void shouldHaveFieldNamesInResult() {
        Result res = session.run("CREATE (n:TestNode {name:'test'}) RETURN n");
        Assertions.assertEquals((Object)"[n]", (Object)res.keys().toString());
        Assertions.assertNotNull((Object)res.single());
        Assertions.assertEquals((Object)"[n]", (Object)res.keys().toString());
    }

    @Test
    void shouldGiveHelpfulFailureMessageWhenAccessNonExistingField() {
        Result rs = session.run("CREATE (n:Person {name:$name}) RETURN n", Values.parameters((Object[])new Object[]{"name", "Tom Hanks"}));
        Record single = rs.single();
        Assertions.assertTrue((boolean)single.get("m").isNull());
    }

    @Test
    void shouldGiveHelpfulFailureMessageWhenAccessNonExistingPropertyOnNode() {
        Result rs = session.run("CREATE (n:Person {name:$name}) RETURN n", Values.parameters((Object[])new Object[]{"name", "Tom Hanks"}));
        Record record = rs.single();
        Assertions.assertTrue((boolean)record.get("n").get("age").isNull());
    }

    @Test
    void shouldNotReturnNullKeysOnEmptyResult() {
        Result rs = session.run("CREATE (n:Person {name:$name})", Values.parameters((Object[])new Object[]{"name", "Tom Hanks"}));
        Assertions.assertNotNull((Object)rs.keys());
    }

    @Test
    void shouldBeAbleToReuseSessionAfterFailure() {
        Assertions.assertThrows(Exception.class, () -> session.run("INVALID"));
        Result res2 = session.run("RETURN 1");
        Assertions.assertTrue((boolean)res2.hasNext());
        Assertions.assertEquals((long)res2.next().get("1").asLong(), (long)1L);
    }

    @Test
    void shouldBeAbleToAccessSummaryAfterTransactionFailure() {
        AtomicReference resultRef = new AtomicReference();
        Assertions.assertThrows(ClientException.class, () -> {
            try (Transaction tx = session.beginTransaction();){
                Result result = tx.run("UNWIND [1,2,0] AS x RETURN 10/x");
                resultRef.set(result);
                tx.commit();
            }
        });
        Result result = (Result)resultRef.get();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.consume().counters().nodesCreated());
    }

    @Test
    void shouldConvertEmptyResultToStream() {
        long count = session.run("MATCH (n:WrongLabel) RETURN n").stream().count();
        Assertions.assertEquals((long)0L, (long)count);
        Optional anyRecord = session.run("MATCH (n:OtherWrongLabel) RETURN n").stream().findAny();
        Assertions.assertFalse((boolean)anyRecord.isPresent());
    }

    @Test
    void shouldConvertResultToStream() {
        List receivedList = session.run("UNWIND range(1, 10) AS x RETURN x").stream().map(record -> record.get(0)).map(Value::asInt).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10), receivedList);
    }

    @Test
    void shouldConvertImmediatelyFailingResultToStream() {
        ArrayList seen = new ArrayList();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> session.run("RETURN 10 / 0").stream().forEach(record -> seen.add(record.get(0).asInt())));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"/ by zero"));
        Assertions.assertEquals(Collections.emptyList(), seen);
    }

    @Test
    void shouldConvertEventuallyFailingResultToStream() {
        ArrayList seen = new ArrayList();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> session.run("CYPHER runtime=interpreted UNWIND range(5, 0, -1) AS x RETURN x / x").stream().forEach(record -> seen.add(record.get(0).asInt())));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"/ by zero"));
        Assertions.assertEquals(Arrays.asList(1, 1, 1, 1, 1), seen);
    }

    @Test
    void shouldEmptyResultWhenConvertedToStream() {
        Result result = session.run("UNWIND range(1, 10) AS x RETURN x");
        Assertions.assertTrue((boolean)result.hasNext());
        Assertions.assertEquals((int)1, (int)result.next().get(0).asInt());
        Assertions.assertTrue((boolean)result.hasNext());
        Assertions.assertEquals((int)2, (int)result.next().get(0).asInt());
        List list = result.stream().map(record -> record.get(0).asInt()).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(3, 4, 5, 6, 7, 8, 9, 10), list);
        Assertions.assertFalse((boolean)result.hasNext());
        Assertions.assertThrows(NoSuchRecordException.class, () -> ((Result)result).next());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.list());
        Assertions.assertEquals((long)0L, (long)result.stream().count());
    }

    @Test
    void shouldConsumeLargeResultAsParallelStream() {
        List receivedList = ((Stream)session.run("UNWIND range(1, 200000) AS x RETURN 'value-' + x").stream().parallel()).map(record -> record.get(0)).map(Value::asString).collect(Collectors.toList());
        List expectedList = IntStream.range(1, 200001).mapToObj(i -> "value-" + i).collect(Collectors.toList());
        Assertions.assertEquals(expectedList, receivedList);
    }
}

