/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
@EnabledOnNeo4jWith(value=Neo4jFeature.BOLT_V4)
class RoutingDriverIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    RoutingDriverIT() {
    }

    @Test
    void shouldBeAbleToConnectSingleInstanceWithNeo4jScheme() throws Throwable {
        URI uri = URI.create(String.format("neo4j://%s:%s", neo4j.uri().getHost(), neo4j.uri().getPort()));
        try (Driver driver = GraphDatabase.driver((URI)uri, (AuthToken)neo4j.authToken());
             Session session = driver.session();){
            MatcherAssert.assertThat((Object)driver, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.clusterDriver()));
            Result result = session.run("RETURN 1");
            MatcherAssert.assertThat((Object)result.single().get(0).asInt(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    void shouldBeAbleToRunQueryOnNeo4j() throws Throwable {
        URI uri = URI.create(String.format("neo4j://%s:%s", neo4j.uri().getHost(), neo4j.uri().getPort()));
        try (Driver driver = GraphDatabase.driver((URI)uri, (AuthToken)neo4j.authToken());
             Session session = driver.session(SessionConfig.forDatabase((String)"neo4j"));){
            MatcherAssert.assertThat((Object)driver, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.clusterDriver()));
            Result result = session.run("RETURN 1");
            MatcherAssert.assertThat((Object)result.single().get(0).asInt(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }
}

