/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.QueryType;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class SummaryIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private Session session;

    SummaryIT() {
    }

    @BeforeEach
    void setup() {
        this.session = neo4j.driver().session();
    }

    @AfterEach
    void tearDown() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
        this.session = null;
    }

    @Test
    void shouldContainBasicMetadata() {
        Value parameters = Values.parameters((Object[])new Object[]{"limit", 10});
        String query = "UNWIND [1, 2, 3, 4] AS n RETURN n AS number LIMIT $limit";
        Result result = this.session.run(query, parameters);
        Assertions.assertTrue((boolean)result.hasNext());
        ResultSummary summary = result.consume();
        MatcherAssert.assertThat((Object)summary.queryType(), (Matcher)Matchers.equalTo((Object)QueryType.READ_ONLY));
        MatcherAssert.assertThat((Object)summary.query().text(), (Matcher)Matchers.equalTo((Object)query));
        MatcherAssert.assertThat((Object)summary.query().parameters(), (Matcher)Matchers.equalTo((Object)parameters));
        Assertions.assertFalse((boolean)summary.hasPlan());
        Assertions.assertFalse((boolean)summary.hasProfile());
        MatcherAssert.assertThat((Object)summary, (Matcher)Matchers.equalTo((Object)result.consume()));
    }

    @Test
    void shouldContainTimeInformation() {
        ResultSummary summary = this.session.run("UNWIND range(1,1000) AS n RETURN n AS number").consume();
        MatcherAssert.assertThat((Object)summary.resultAvailableAfter(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)summary.resultConsumedAfter(TimeUnit.MILLISECONDS), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
    }

    @Test
    void shouldContainCorrectStatistics() {
        if (neo4j.isNeo4j44OrEarlier()) {
            MatcherAssert.assertThat((Object)this.session.run("CREATE (n)").consume().counters().nodesCreated(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("MATCH (n) DELETE (n)").consume().counters().nodesDeleted(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("CREATE ()-[:KNOWS]->()").consume().counters().relationshipsCreated(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("MATCH ()-[r:KNOWS]->() DELETE r").consume().counters().relationshipsDeleted(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("CREATE (n:ALabel)").consume().counters().labelsAdded(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("CREATE (n {magic: 42})").consume().counters().propertiesSet(), (Matcher)Matchers.equalTo((Object)1));
            Assertions.assertTrue((boolean)this.session.run("CREATE (n {magic: 42})").consume().counters().containsUpdates());
            MatcherAssert.assertThat((Object)this.session.run("MATCH (n:ALabel) REMOVE n:ALabel ").consume().counters().labelsRemoved(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("CREATE INDEX ON :ALabel(prop)").consume().counters().indexesAdded(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("DROP INDEX ON :ALabel(prop)").consume().counters().indexesRemoved(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("CREATE CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE").consume().counters().constraintsAdded(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)this.session.run("DROP CONSTRAINT ON (book:Book) ASSERT book.isbn IS UNIQUE").consume().counters().constraintsRemoved(), (Matcher)Matchers.equalTo((Object)1));
        }
    }

    @Test
    @EnabledOnNeo4jWith(value=Neo4jFeature.BOLT_V4)
    void shouldGetSystemUpdates() throws Throwable {
        try (Session session = neo4j.driver().session(SessionConfig.forDatabase((String)"system"));){
            Result result = session.run("CREATE USER foo SET PASSWORD 'Testing5'");
            MatcherAssert.assertThat((Object)result.consume().counters().containsUpdates(), (Matcher)Matchers.equalTo((Object)false));
            MatcherAssert.assertThat((Object)result.consume().counters().containsSystemUpdates(), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    @Test
    void shouldContainCorrectQueryType() {
        Assumptions.assumeTrue((boolean)neo4j.isNeo4j44OrEarlier());
        MatcherAssert.assertThat((Object)this.session.run("MATCH (n) RETURN 1").consume().queryType(), (Matcher)Matchers.equalTo((Object)QueryType.READ_ONLY));
        MatcherAssert.assertThat((Object)this.session.run("CREATE (n)").consume().queryType(), (Matcher)Matchers.equalTo((Object)QueryType.WRITE_ONLY));
        MatcherAssert.assertThat((Object)this.session.run("CREATE (n) RETURN (n)").consume().queryType(), (Matcher)Matchers.equalTo((Object)QueryType.READ_WRITE));
        MatcherAssert.assertThat((Object)this.session.run("CREATE INDEX ON :User(p)").consume().queryType(), (Matcher)Matchers.equalTo((Object)QueryType.SCHEMA_WRITE));
    }

    @Test
    void shouldContainCorrectPlan() {
        ResultSummary summary = this.session.run("EXPLAIN MATCH (n) RETURN 1").consume();
        Assertions.assertTrue((boolean)summary.hasPlan());
        Plan plan = summary.plan();
        MatcherAssert.assertThat((Object)plan.operatorType(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)plan.identifiers().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)plan.arguments().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)plan.children().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    void shouldContainProfile() {
        ResultSummary summary = this.session.run("PROFILE RETURN 1").consume();
        Assertions.assertTrue((boolean)summary.hasProfile());
        Assertions.assertTrue((boolean)summary.hasPlan());
        Assertions.assertEquals((Object)summary.plan(), (Object)summary.profile());
        ProfiledPlan profile = summary.profile();
        Assertions.assertEquals((long)0L, (long)profile.time());
        Assertions.assertEquals((long)0L, (long)profile.dbHits());
        Assertions.assertEquals((long)1L, (long)profile.records());
    }

    @Test
    void shouldContainNotifications() {
        ResultSummary summary = this.session.run("EXPLAIN MATCH (n:ThisLabelDoesNotExist) RETURN n").consume();
        List notifications = summary.notifications();
        Assertions.assertNotNull((Object)notifications);
        MatcherAssert.assertThat((Object)notifications.size(), (Matcher)Matchers.equalTo((Object)1));
        Notification notification = (Notification)notifications.get(0);
        MatcherAssert.assertThat((Object)notification.code(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)notification.title(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)notification.description(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)notification.severity(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)notification.position(), (Matcher)Matchers.notNullValue());
    }

    @Test
    void shouldContainNoNotifications() throws Throwable {
        ResultSummary summary = this.session.run("RETURN 1").consume();
        MatcherAssert.assertThat((Object)summary.notifications().size(), (Matcher)Matchers.equalTo((Object)0));
    }
}

