/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.util.EnabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.util.DriverExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@EnabledOnNeo4jWith(value=Neo4jFeature.BOLT_V3)
@ParallelizableIT
class TransactionBoltV3IT {
    @RegisterExtension
    static final DriverExtension driver = new DriverExtension();

    TransactionBoltV3IT() {
    }

    @Test
    void shouldSetTransactionMetadata() {
        if (driver.isNeo4j44OrEarlier()) {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("key1", "value1");
            metadata.put("key2", 42L);
            metadata.put("key3", false);
            TransactionConfig config = TransactionConfig.builder().withMetadata(metadata).build();
            try (Transaction tx = driver.session().beginTransaction(config);){
                tx.run("RETURN 1").consume();
                TransactionBoltV3IT.verifyTransactionMetadata(metadata);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldSetTransactionMetadataAsync() {
        if (driver.isNeo4j44OrEarlier()) {
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("hello", "world");
            metadata.put("key", ZonedDateTime.now());
            TransactionConfig config = TransactionConfig.builder().withMetadata(metadata).build();
            CompletionStage txFuture = driver.asyncSession().beginTransactionAsync(config).thenCompose(tx -> tx.runAsync("RETURN 1").thenCompose(ResultCursor::consumeAsync).thenApply(ignore -> tx));
            AsyncTransaction transaction = (AsyncTransaction)TestUtil.await(txFuture);
            try {
                TransactionBoltV3IT.verifyTransactionMetadata(metadata);
            }
            finally {
                TestUtil.await(transaction.rollbackAsync());
            }
        }
    }

    @Test
    void shouldSetTransactionTimeout() {
        Session session = driver.session();
        session.run("CREATE (:Node)").consume();
        try (Session otherSession = driver.driver().session();
             Transaction otherTx = otherSession.beginTransaction();){
            otherTx.run("MATCH (n:Node) SET n.prop = 1").consume();
            Assertions.assertTimeoutPreemptively((Duration)TestUtil.TX_TIMEOUT_TEST_TIMEOUT, () -> {
                TransactionConfig config = TransactionConfig.builder().withTimeout(Duration.ofMillis(1L)).build();
                Exception error = (Exception)Assertions.assertThrows(Exception.class, () -> {
                    try (Transaction tx = session.beginTransaction(config);){
                        tx.run("MATCH (n:Node) SET n.prop = 2");
                        tx.commit();
                    }
                });
                TransactionBoltV3IT.verifyValidException(error);
            });
        }
    }

    @Test
    void shouldSetTransactionTimeoutAsync() {
        Session session = driver.session();
        AsyncSession asyncSession = driver.asyncSession();
        session.run("CREATE (:Node)").consume();
        try (Session otherSession = driver.driver().session();
             Transaction otherTx = otherSession.beginTransaction();){
            otherTx.run("MATCH (n:Node) SET n.prop = 1").consume();
            Assertions.assertTimeoutPreemptively((Duration)TestUtil.TX_TIMEOUT_TEST_TIMEOUT, () -> {
                TransactionConfig config = TransactionConfig.builder().withTimeout(Duration.ofMillis(1L)).build();
                CompletionStage txCommitFuture = asyncSession.beginTransactionAsync(config).thenCompose(tx -> tx.runAsync("MATCH (n:Node) SET n.prop = 2").thenCompose(ignore -> tx.commitAsync()));
                Exception error = (Exception)Assertions.assertThrows(Exception.class, () -> {
                    Void cfr_ignored_0 = (Void)TestUtil.await(txCommitFuture);
                });
                TransactionBoltV3IT.verifyValidException(error);
            });
        }
    }

    private static void verifyValidException(Exception error) {
        if (error instanceof TransientException || error instanceof ClientException) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"terminated"));
        } else {
            Assertions.fail((String)"Expected either a TransientException or ClientException", (Throwable)error);
        }
    }

    private static void verifyTransactionMetadata(Map<String, Object> metadata) {
        try (Session session = driver.driver().session();){
            Result result = session.run("CALL dbms.listTransactions()");
            Map receivedMetadata = result.list().stream().map(record -> record.get("metaData")).map(MapAccessor::asMap).filter(map -> !map.isEmpty()).findFirst().orElseThrow(IllegalStateException::new);
            Assertions.assertEquals(metadata, (Object)receivedMetadata);
        }
    }
}

