/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.io.File;
import java.net.URI;
import java.util.function.Supplier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.util.CertificateUtil;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;

@ParallelizableIT
class TrustCustomCertificateIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();

    TrustCustomCertificateIT() {
    }

    @Test
    void shouldAcceptServerWithCertificateSignedByDriverCertificate() throws Throwable {
        CertificateUtil.CertificateKeyPair<File, File> root = CertificateUtil.createNewCertificateAndKey(new GeneralName[0]);
        CertificateUtil.CertificateKeyPair<File, File> server = CertificateUtil.createNewCertificateAndKeySignedBy(root, DatabaseExtension.getDockerHostGeneralName());
        neo4j.updateEncryptionKeyAndCert(server.key(), server.cert());
        this.shouldBeAbleToRunCypher(() -> this.createDriverWithCustomCertificate((File)root.cert()));
    }

    @Test
    void shouldAcceptServerWithSameCertificate() {
        this.shouldBeAbleToRunCypher(() -> this.createDriverWithCustomCertificate(neo4j.tlsCertFile()));
    }

    @Test
    void shouldRejectServerWithUntrustedCertificate() throws Throwable {
        CertificateUtil.CertificateKeyPair<File, File> certificateAndKey = CertificateUtil.createNewCertificateAndKey(new GeneralName[0]);
        Driver driver = this.createDriverWithCustomCertificate(certificateAndKey.cert());
        Assertions.assertThrows(SecurityException.class, () -> ((Driver)driver).verifyConnectivity());
    }

    private void shouldBeAbleToRunCypher(Supplier<Driver> driverSupplier) {
        try (Driver driver = driverSupplier.get();
             Session session = driver.session();){
            Result result = session.run("RETURN 1 as n");
            MatcherAssert.assertThat((Object)result.single().get("n").asInt(), (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    private Driver createDriverWithCustomCertificate(File cert) {
        return GraphDatabase.driver((URI)neo4j.uri(), (AuthToken)neo4j.authToken(), (Config)Config.builder().withEncryption().withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{cert})).build());
    }
}

