/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.Result;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.util.DisabledOnNeo4jWith;
import org.neo4j.driver.internal.util.Neo4jFeature;
import org.neo4j.driver.util.DriverExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@DisabledOnNeo4jWith(value=Neo4jFeature.BOLT_V3)
@ParallelizableIT
class UnsupportedBoltV3IT {
    @RegisterExtension
    static final DriverExtension driver = new DriverExtension();
    private final TransactionConfig txConfig = TransactionConfig.builder().withTimeout(Duration.ofSeconds(4L)).withMetadata(Collections.singletonMap("key", "value")).build();

    UnsupportedBoltV3IT() {
    }

    @Test
    void shouldNotSupportAutoCommitQueriesWithTransactionConfig() {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(() -> driver.session().run("RETURN 42", this.txConfig));
    }

    @Test
    void shouldNotSupportAsyncAutoCommitQueriesWithTransactionConfig() {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(driver.asyncSession().runAsync("RETURN 42", this.txConfig));
    }

    @Test
    void shouldNotSupportTransactionFunctionsWithTransactionConfig() {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(() -> {
            Result cfr_ignored_0 = (Result)driver.session().readTransaction(tx -> tx.run("RETURN 42"), this.txConfig);
        });
    }

    @Test
    void shouldNotSupportAsyncTransactionFunctionsWithTransactionConfig() {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(driver.asyncSession().readTransactionAsync(tx -> tx.runAsync("RETURN 42"), this.txConfig));
    }

    @Test
    void shouldNotSupportUnmanagedTransactionsWithTransactionConfig() {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(() -> driver.session().beginTransaction(this.txConfig));
    }

    @Test
    void shouldNotSupportAsyncUnmanagedTransactionsWithTransactionConfig() {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(driver.asyncSession().beginTransactionAsync(this.txConfig));
    }

    private static void assertTxConfigNotSupported(CompletionStage<?> stage) {
        UnsupportedBoltV3IT.assertTxConfigNotSupported(() -> TestUtil.await(stage));
    }

    private static void assertTxConfigNotSupported(Executable executable) {
        ClientException error = (ClientException)Assertions.assertThrows(ClientException.class, (Executable)executable);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Driver is connected to the database that does not support transaction configuration"));
    }
}

