/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration.async;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ParallelizableIT
public class AsyncQueryIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private AsyncSession session;

    @BeforeEach
    void setUp() {
        this.session = neo4j.driver().asyncSession();
    }

    @AfterEach
    void tearDown() {
        this.session.closeAsync();
    }

    @Test
    void shouldBeAbleToLogSemanticWrongExceptions() throws ExecutionException, InterruptedException {
        ((CompletableFuture)this.session.writeTransactionAsync(tx -> Flux.from((Publisher)Mono.fromCompletionStage((CompletionStage)tx.runAsync("MATCH (n:Element) WHERE n.name = {param} RETURN n", Values.parameters((Object[])new Object[]{"param", "Luke"})))).collectList().toFuture()).toCompletableFuture().exceptionally(ex -> {
            TestUtil.assertNoCircularReferences(ex);
            return new ArrayList();
        })).get();
    }
}

