/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletableFuture;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Config;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class InternalDriverTest {
    InternalDriverTest() {
    }

    @Test
    void shouldCloseSessionFactory() {
        SessionFactory sessionFactory = InternalDriverTest.sessionFactoryMock();
        InternalDriver driver = InternalDriverTest.newDriver(sessionFactory);
        Assertions.assertNull(TestUtil.await(driver.closeAsync()));
        ((SessionFactory)Mockito.verify((Object)sessionFactory)).close();
    }

    @Test
    void shouldNotCloseSessionFactoryMultipleTimes() {
        SessionFactory sessionFactory = InternalDriverTest.sessionFactoryMock();
        InternalDriver driver = InternalDriverTest.newDriver(sessionFactory);
        Assertions.assertNull(TestUtil.await(driver.closeAsync()));
        Assertions.assertNull(TestUtil.await(driver.closeAsync()));
        Assertions.assertNull(TestUtil.await(driver.closeAsync()));
        ((SessionFactory)Mockito.verify((Object)sessionFactory)).close();
    }

    @Test
    void shouldVerifyConnectivity() {
        SessionFactory sessionFactory = InternalDriverTest.sessionFactoryMock();
        CompletableFuture connectivityStage = Futures.completedWithNull();
        Mockito.when((Object)sessionFactory.verifyConnectivity()).thenReturn((Object)connectivityStage);
        InternalDriver driver = InternalDriverTest.newDriver(sessionFactory);
        Assertions.assertEquals((Object)connectivityStage, (Object)driver.verifyConnectivityAsync());
    }

    @Test
    void shouldThrowWhenUnableToVerifyConnectivity() {
        SessionFactory sessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        ServiceUnavailableException error = new ServiceUnavailableException("Hello");
        Mockito.when((Object)sessionFactory.verifyConnectivity()).thenReturn((Object)Futures.failedFuture((Throwable)error));
        InternalDriver driver = InternalDriverTest.newDriver(sessionFactory);
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(driver.verifyConnectivityAsync());
        });
        Assertions.assertEquals((Object)e.getMessage(), (Object)"Hello");
    }

    @Test
    void shouldThrowClientExceptionIfMetricsNotEnabled() throws Throwable {
        InternalDriver driver = InternalDriverTest.newDriver(false);
        ClientException error = (ClientException)Assertions.assertThrows(ClientException.class, () -> ((InternalDriver)driver).metrics());
        Assert.assertTrue((boolean)error.getMessage().contains("Driver metrics are not enabled."));
    }

    @Test
    void shouldReturnMetricsIfMetricsEnabled() {
        InternalDriver driver = InternalDriverTest.newDriver(true);
        Metrics metrics = driver.metrics();
        Assertions.assertNotNull((Object)metrics);
    }

    private static InternalDriver newDriver(SessionFactory sessionFactory) {
        return new InternalDriver(SecurityPlanImpl.insecure(), sessionFactory, (MetricsProvider)DevNullMetricsProvider.INSTANCE, DevNullLogging.DEV_NULL_LOGGING);
    }

    private static SessionFactory sessionFactoryMock() {
        SessionFactory sessionFactory = (SessionFactory)Mockito.mock(SessionFactory.class);
        Mockito.when((Object)sessionFactory.close()).thenReturn((Object)Futures.completedWithNull());
        return sessionFactory;
    }

    private static InternalDriver newDriver(boolean isMetricsEnabled) {
        SessionFactory sessionFactory = InternalDriverTest.sessionFactoryMock();
        Config config = Config.defaultConfig();
        if (isMetricsEnabled) {
            config = Config.builder().withDriverMetrics().build();
        }
        MetricsProvider metricsProvider = DriverFactory.getOrCreateMetricsProvider((Config)config, (Clock)Clock.SYSTEM);
        return new InternalDriver(SecurityPlanImpl.insecure(), sessionFactory, metricsProvider, DevNullLogging.DEV_NULL_LOGGING);
    }
}

