/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

class InternalMapAccessorWithDefaultValueTest {
    private static final String wrongKey = "wrong_key";

    InternalMapAccessorWithDefaultValueTest() {
    }

    @Test
    void shouldGetValueFromRecord() {
        Record record = this.createRecord();
        MatcherAssert.assertThat((Object)record.get("NullValue", NullValue.NULL), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
        MatcherAssert.assertThat((Object)record.get(wrongKey, NullValue.NULL), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
        MatcherAssert.assertThat((Object)record.get("BooleanValue", (Value)BooleanValue.FALSE), (Matcher)CoreMatchers.equalTo((Object)BooleanValue.TRUE));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)BooleanValue.FALSE), (Matcher)CoreMatchers.equalTo((Object)BooleanValue.FALSE));
        MatcherAssert.assertThat((Object)record.get("StringValue", (Value)new StringValue("")), (Matcher)CoreMatchers.equalTo((Object)new StringValue("hello world")));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)new StringValue("")), (Matcher)CoreMatchers.equalTo((Object)new StringValue("")));
        MatcherAssert.assertThat((Object)record.get("IntegerValue", (Value)new IntegerValue(-1L)), (Matcher)CoreMatchers.equalTo((Object)new IntegerValue(11L)));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)new IntegerValue(-1L)), (Matcher)CoreMatchers.equalTo((Object)new IntegerValue(-1L)));
        MatcherAssert.assertThat((Object)record.get("FloatValue", (Value)new FloatValue(1.1)), (Matcher)CoreMatchers.equalTo((Object)new FloatValue(2.2)));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)new FloatValue(1.1)), (Matcher)CoreMatchers.equalTo((Object)new FloatValue(1.1)));
        MatcherAssert.assertThat((Object)record.get("ListValue", (Value)new ListValue(new Value[0])), (Matcher)CoreMatchers.equalTo((Object)new ListValue(new Value[]{new IntegerValue(1L), new IntegerValue(2L)})));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)new ListValue(new Value[0])), (Matcher)CoreMatchers.equalTo((Object)new ListValue(new Value[0])));
        MapValue defaultMapValue = new MapValue(new HashMap());
        MapValue realMapValue = new MapValue(this.createMap());
        MatcherAssert.assertThat((Object)record.get("MapValue", (Value)defaultMapValue), (Matcher)CoreMatchers.equalTo((Object)realMapValue));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)defaultMapValue), (Matcher)CoreMatchers.equalTo((Object)defaultMapValue));
        PathValue defaultPathValue = new PathValue((Path)new InternalPath(new Entity[]{new InternalNode(0L), new InternalRelationship(0L, 0L, 1L, "T"), new InternalNode(1L)}));
        PathValue realPathValue = new PathValue(this.createPath());
        MatcherAssert.assertThat((Object)record.get("PathValue", (Value)defaultPathValue), (Matcher)CoreMatchers.equalTo((Object)realPathValue));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)defaultPathValue), (Matcher)CoreMatchers.equalTo((Object)defaultPathValue));
        NodeValue defaultNodeValue = new NodeValue((Node)new InternalNode(0L));
        NodeValue realNodeValue = new NodeValue(this.createNode());
        MatcherAssert.assertThat((Object)record.get("NodeValue", (Value)defaultNodeValue), (Matcher)CoreMatchers.equalTo((Object)realNodeValue));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)defaultNodeValue), (Matcher)CoreMatchers.equalTo((Object)defaultNodeValue));
        RelationshipValue defaultRelValue = new RelationshipValue((Relationship)new InternalRelationship(0L, 0L, 1L, "T"));
        RelationshipValue realRelValue = new RelationshipValue(this.createRel());
        MatcherAssert.assertThat((Object)record.get("RelValue", (Value)defaultRelValue), (Matcher)CoreMatchers.equalTo((Object)realRelValue));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Value)defaultRelValue), (Matcher)CoreMatchers.equalTo((Object)defaultRelValue));
    }

    @Test
    void shouldGetObjectFromRecord() {
        Record record = this.createRecord();
        MatcherAssert.assertThat((Object)record.get("IntegerValue", (Object)3), (Matcher)CoreMatchers.equalTo((Object)11L));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Object)3), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    void shouldGetNumberFromRecord() {
        Record record = this.createRecord();
        MatcherAssert.assertThat((Object)record.get("IntegerValue", (Number)3), (Matcher)CoreMatchers.equalTo((Object)11L));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Number)3), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    void shouldGetEntityFromRecord() {
        Record record = this.createRecord();
        InternalNode defaultNodeEntity = new InternalNode(0L);
        MatcherAssert.assertThat((Object)record.get("NodeValue", (Entity)defaultNodeEntity), (Matcher)CoreMatchers.equalTo((Object)this.createNode()));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Entity)defaultNodeEntity), (Matcher)CoreMatchers.equalTo((Object)defaultNodeEntity));
        InternalRelationship defaultRelEntity = new InternalRelationship(0L, 0L, 1L, "T");
        MatcherAssert.assertThat((Object)record.get("RelValue", (Entity)defaultRelEntity), (Matcher)CoreMatchers.equalTo((Object)this.createRel()));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Entity)defaultRelEntity), (Matcher)CoreMatchers.equalTo((Object)defaultRelEntity));
    }

    @Test
    void shouldGetNodeFromRecord() {
        Record record = this.createRecord();
        InternalNode defaultNode = new InternalNode(0L);
        MatcherAssert.assertThat((Object)record.get("NodeValue", (Node)defaultNode), (Matcher)CoreMatchers.equalTo((Object)this.createNode()));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Node)defaultNode), (Matcher)CoreMatchers.equalTo((Object)defaultNode));
    }

    @Test
    void shouldGetRelFromRecord() {
        Record record = this.createRecord();
        InternalRelationship defaultRel = new InternalRelationship(0L, 0L, 1L, "T");
        MatcherAssert.assertThat((Object)record.get("RelValue", (Relationship)defaultRel), (Matcher)CoreMatchers.equalTo((Object)this.createRel()));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Relationship)defaultRel), (Matcher)CoreMatchers.equalTo((Object)defaultRel));
    }

    @Test
    void shouldGetPathFromRecord() {
        Record record = this.createRecord();
        InternalPath defaultPath = new InternalPath(new Entity[]{new InternalNode(0L), new InternalRelationship(0L, 0L, 1L, "T"), new InternalNode(1L)});
        MatcherAssert.assertThat((Object)record.get("PathValue", (Path)defaultPath), (Matcher)CoreMatchers.equalTo((Object)this.createPath()));
        MatcherAssert.assertThat((Object)record.get(wrongKey, (Path)defaultPath), (Matcher)CoreMatchers.equalTo((Object)defaultPath));
    }

    @Test
    void shouldGetListOfObjectsFromRecord() {
        Record record = this.createRecord();
        ArrayList defaultValue = new ArrayList();
        MatcherAssert.assertThat((Object)record.get("ListValue", defaultValue), (Matcher)CoreMatchers.equalTo(Arrays.asList(1L, 2L)));
        MatcherAssert.assertThat((Object)record.get(wrongKey, defaultValue), (Matcher)CoreMatchers.equalTo(defaultValue));
    }

    @Test
    void shouldGetListOfTFromRecord() {
        Record record = this.createRecord();
        ArrayList defaultValue = new ArrayList();
        MatcherAssert.assertThat((Object)record.get("ListValue", defaultValue, Values.ofInteger()), (Matcher)CoreMatchers.equalTo(Arrays.asList(1, 2)));
        MatcherAssert.assertThat((Object)record.get(wrongKey, defaultValue, Values.ofInteger()), (Matcher)CoreMatchers.equalTo(defaultValue));
    }

    @Test
    void shouldGetMapOfStringObjectFromRecord() {
        Record record = this.createRecord();
        HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("key1", 1L);
        expected.put("key2", 2L);
        HashMap defaultValue = new HashMap();
        MatcherAssert.assertThat((Object)record.get("MapValue", defaultValue), (Matcher)CoreMatchers.equalTo(expected));
        MatcherAssert.assertThat((Object)record.get(wrongKey, defaultValue), (Matcher)CoreMatchers.equalTo(defaultValue));
    }

    @Test
    void shouldGetMapOfStringTFromRecord() {
        Record record = this.createRecord();
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("key1", 1);
        expected.put("key2", 2);
        HashMap defaultValue = new HashMap();
        MatcherAssert.assertThat((Object)record.get("MapValue", defaultValue, Values.ofInteger()), (Matcher)CoreMatchers.equalTo(expected));
        MatcherAssert.assertThat((Object)record.get(wrongKey, defaultValue, Values.ofInteger()), (Matcher)CoreMatchers.equalTo(defaultValue));
    }

    @Test
    void shouldGetPrimitiveTypesFromRecord() {
        Record record = this.createRecord();
        MatcherAssert.assertThat((Object)record.get("BooleanValue", false), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)record.get(wrongKey, false), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)record.get("StringValue", ""), (Matcher)CoreMatchers.equalTo((Object)"hello world"));
        MatcherAssert.assertThat((Object)record.get(wrongKey, ""), (Matcher)CoreMatchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)record.get("IntegerValue", 3), (Matcher)CoreMatchers.equalTo((Object)11));
        MatcherAssert.assertThat((Object)record.get(wrongKey, 3), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)record.get("IntegerValue", 4L), (Matcher)CoreMatchers.equalTo((Object)11L));
        MatcherAssert.assertThat((Object)record.get(wrongKey, 4L), (Matcher)CoreMatchers.equalTo((Object)4L));
        MatcherAssert.assertThat((Object)Float.valueOf(record.get("float", 1.0f)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(0.1f)));
        MatcherAssert.assertThat((Object)Float.valueOf(record.get(wrongKey, 1.0f)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)record.get("FloatValue", 1.1), (Matcher)CoreMatchers.equalTo((Object)2.2));
        MatcherAssert.assertThat((Object)record.get(wrongKey, 1.1), (Matcher)CoreMatchers.equalTo((Object)1.1));
    }

    @Test
    void shouldGetFromMap() {
        MapValue mapValue = new MapValue(this.createMap());
        MatcherAssert.assertThat((Object)mapValue.get("key1", 0L), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)mapValue.get("key2", 0), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)mapValue.get(wrongKey, ""), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    void shouldGetFromNode() {
        HashMap<String, Value> props = new HashMap<String, Value>();
        props.put("k1", Values.value((int)43));
        props.put("k2", Values.value((String)"hello world"));
        NodeValue nodeValue = new NodeValue((Node)new InternalNode(42L, Collections.singletonList("L"), props));
        MatcherAssert.assertThat((Object)nodeValue.get("k1", 0), (Matcher)CoreMatchers.equalTo((Object)43));
        MatcherAssert.assertThat((Object)nodeValue.get("k2", ""), (Matcher)CoreMatchers.equalTo((Object)"hello world"));
        MatcherAssert.assertThat((Object)nodeValue.get(wrongKey, 0L), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    void shouldGetFromRel() {
        HashMap<String, Value> props = new HashMap<String, Value>();
        props.put("k1", Values.value((int)43));
        props.put("k2", Values.value((String)"hello world"));
        RelationshipValue relValue = new RelationshipValue((Relationship)new InternalRelationship(0L, 0L, 1L, "T", props));
        MatcherAssert.assertThat((Object)relValue.get("k1", 0), (Matcher)CoreMatchers.equalTo((Object)43));
        MatcherAssert.assertThat((Object)relValue.get("k2", ""), (Matcher)CoreMatchers.equalTo((Object)"hello world"));
        MatcherAssert.assertThat((Object)relValue.get(wrongKey, 0L), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    private Path createPath() {
        return new InternalPath(new Entity[]{new InternalNode(42L), new InternalRelationship(43L, 42L, 44L, "T"), new InternalNode(44L)});
    }

    private Node createNode() {
        return new InternalNode(1L);
    }

    private Relationship createRel() {
        return new InternalRelationship(1L, 1L, 2L, "T");
    }

    private Map<String, Value> createMap() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("key1", (Value)new IntegerValue(1L));
        map.put("key2", (Value)new IntegerValue(2L));
        return map;
    }

    private Record createRecord() {
        Map<String, Value> map = this.createMap();
        Path path = this.createPath();
        Node node = this.createNode();
        Relationship rel = this.createRel();
        List<String> keys = Arrays.asList("NullValue", "BooleanValue", "StringValue", "IntegerValue", "FloatValue", "ListValue", "MapValue", "PathValue", "NodeValue", "RelValue", "float");
        Value[] values = new Value[]{NullValue.NULL, BooleanValue.TRUE, new StringValue("hello world"), new IntegerValue(11L), new FloatValue(2.2), new ListValue(new Value[]{new IntegerValue(1L), new IntegerValue(2L)}), new MapValue(map), new PathValue(path), new NodeValue(node), new RelationshipValue(rel), Values.value((double)0.1f)};
        InternalRecord record = new InternalRecord(keys, values);
        return record;
    }
}

