/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.TestUtil;

class InternalTransactionTest {
    private Connection connection;
    private Transaction tx;

    InternalTransactionTest() {
    }

    @BeforeEach
    void setUp() {
        this.connection = TestUtil.connectionMock(BoltProtocolV4.INSTANCE);
        ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProvider.acquireConnection((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn(CompletableFuture.completedFuture(this.connection));
        InternalSession session = new InternalSession(TestUtil.newSession(connectionProvider));
        this.tx = session.beginTransaction();
    }

    private static Stream<Function<Transaction, Result>> allSessionRunMethods() {
        return Stream.of(tx -> tx.run("RETURN 1"), tx -> tx.run("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1})), tx -> tx.run("RETURN $x", Collections.singletonMap("x", 1)), tx -> tx.run("RETURN $x", (Record)new InternalRecord(Collections.singletonList("x"), new Value[]{new IntegerValue(1L)})), tx -> tx.run(new Query("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1}))));
    }

    @ParameterizedTest
    @MethodSource(value={"allSessionRunMethods"})
    void shouldFlushOnRun(Function<Transaction, Result> runReturnOne) {
        TestUtil.setupSuccessfulRunAndPull(this.connection);
        Result result = runReturnOne.apply(this.tx);
        ResultSummary summary = result.consume();
        TestUtil.verifyRunAndPull(this.connection, summary.query().text());
    }

    @Test
    void shouldCommit() {
        this.tx.commit();
        this.tx.close();
        TestUtil.verifyCommitTx(this.connection);
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldRollbackByDefault() {
        this.tx.close();
        TestUtil.verifyRollbackTx(this.connection);
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldRollback() {
        this.tx.rollback();
        this.tx.close();
        TestUtil.verifyRollbackTx(this.connection);
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldRollbackWhenFailedRun() {
        TestUtil.setupFailingRun(this.connection, new RuntimeException("Bang!"));
        Assertions.assertThrows(RuntimeException.class, () -> this.tx.run("RETURN 1"));
        this.tx.close();
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldReleaseConnectionWhenFailedToCommit() {
        TestUtil.setupFailingCommit(this.connection);
        Assertions.assertThrows(Exception.class, () -> this.tx.commit());
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldReleaseConnectionWhenFailedToRollback() {
        this.shouldReleaseConnectionWhenFailedToAction(Transaction::rollback);
    }

    @Test
    void shouldReleaseConnectionWhenFailedToClose() {
        this.shouldReleaseConnectionWhenFailedToAction(Transaction::close);
    }

    private void shouldReleaseConnectionWhenFailedToAction(Consumer<Transaction> txAction) {
        TestUtil.setupFailingRollback(this.connection);
        Assertions.assertThrows(Exception.class, () -> txAction.accept(this.tx));
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }
}

