/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.platform.commons.support.ReflectionSupport;
import org.neo4j.driver.Config;
import org.neo4j.driver.RevocationCheckingStrategy;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.util.TestUtil;

class SecuritySettingsTest {
    SecuritySettingsTest() {
    }

    private static Stream<String> selfSignedSchemes() {
        return Stream.of("bolt+ssc", "neo4j+ssc");
    }

    private static Stream<String> systemCertSchemes() {
        return Stream.of("neo4j+s", "bolt+s");
    }

    private static Stream<String> unencryptedSchemes() {
        return Stream.of("neo4j", "bolt");
    }

    private static Stream<String> allSecureSchemes() {
        return Stream.concat(SecuritySettingsTest.selfSignedSchemes(), SecuritySettingsTest.systemCertSchemes());
    }

    @ParameterizedTest
    @MethodSource(value={"allSecureSchemes"})
    void testEncryptionSchemeEnablesEncryption(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertTrue((boolean)securityPlan.requiresEncryption());
    }

    @ParameterizedTest
    @MethodSource(value={"systemCertSchemes"})
    void testSystemCertCompatibleConfiguration(String scheme) throws Exception {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertTrue((boolean)securityPlan.requiresEncryption());
        Assertions.assertTrue((boolean)securityPlan.requiresHostnameVerification());
        Assertions.assertEquals((Object)RevocationCheckingStrategy.NO_CHECKS, (Object)securityPlan.revocationCheckingStrategy());
    }

    @ParameterizedTest
    @MethodSource(value={"selfSignedSchemes"})
    void testSelfSignedCertConfigDisablesHostnameVerification(String scheme) throws Exception {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertTrue((boolean)securityPlan.requiresEncryption());
        Assertions.assertFalse((boolean)securityPlan.requiresHostnameVerification());
    }

    @ParameterizedTest
    @MethodSource(value={"allSecureSchemes"})
    void testThrowsOnUserCustomizedEncryption(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withEncryption().build();
        ClientException ex = (ClientException)Assertions.assertThrows(ClientException.class, () -> securitySettings.createSecurityPlan(scheme));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Scheme %s is not configurable with manual encryption and trust settings", scheme)));
    }

    @ParameterizedTest
    @MethodSource(value={"allSecureSchemes"})
    void testThrowsOnUserCustomizedTrustConfiguration(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withTrustStrategy(Config.TrustStrategy.trustAllCertificates()).build();
        ClientException ex = (ClientException)Assertions.assertThrows(ClientException.class, () -> securitySettings.createSecurityPlan(scheme));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Scheme %s is not configurable with manual encryption and trust settings", scheme)));
    }

    @ParameterizedTest
    @MethodSource(value={"allSecureSchemes"})
    void testThrowsOnUserCustomizedTrustConfigurationAndEncryption(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withTrustStrategy(Config.TrustStrategy.trustSystemCertificates()).withEncryption().build();
        ClientException ex = (ClientException)Assertions.assertThrows(ClientException.class, () -> securitySettings.createSecurityPlan(scheme));
        Assertions.assertTrue((boolean)ex.getMessage().contains(String.format("Scheme %s is not configurable with manual encryption and trust settings", scheme)));
    }

    @ParameterizedTest
    @MethodSource(value={"unencryptedSchemes"})
    void testNoEncryption(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertFalse((boolean)securityPlan.requiresEncryption());
    }

    @ParameterizedTest
    @MethodSource(value={"unencryptedSchemes"})
    void testConfiguredEncryption(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withEncryption().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertTrue((boolean)securityPlan.requiresEncryption());
    }

    @ParameterizedTest
    @MethodSource(value={"unencryptedSchemes"})
    void testConfiguredAllCertificates(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withEncryption().withTrustStrategy(Config.TrustStrategy.trustAllCertificates()).build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertTrue((boolean)securityPlan.requiresEncryption());
    }

    @ParameterizedTest
    @MethodSource(value={"unencryptedSchemes"})
    void testConfigureStrictRevocationChecking(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withTrustStrategy(Config.TrustStrategy.trustSystemCertificates().withStrictRevocationChecks()).withEncryption().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertEquals((Object)RevocationCheckingStrategy.STRICT, (Object)securityPlan.revocationCheckingStrategy());
    }

    @ParameterizedTest
    @MethodSource(value={"unencryptedSchemes"})
    void testConfigureVerifyIfPresentRevocationChecking(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withTrustStrategy(Config.TrustStrategy.trustSystemCertificates().withVerifyIfPresentRevocationChecks()).withEncryption().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertEquals((Object)RevocationCheckingStrategy.VERIFY_IF_PRESENT, (Object)securityPlan.revocationCheckingStrategy());
    }

    @ParameterizedTest
    @MethodSource(value={"unencryptedSchemes"})
    void testRevocationCheckingDisabledByDefault(String scheme) {
        SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withTrustStrategy(Config.TrustStrategy.trustSystemCertificates()).withEncryption().build();
        SecurityPlan securityPlan = securitySettings.createSecurityPlan(scheme);
        Assertions.assertEquals((Object)RevocationCheckingStrategy.NO_CHECKS, (Object)securityPlan.revocationCheckingStrategy());
    }

    @Nested
    class SerializationTests {
        Method isCustomized = (Method)ReflectionSupport.findMethod(SecuritySettings.class, (String)"isCustomized", (Class[])new Class[0]).orElseThrow(() -> new RuntimeException("This test requires isCustomized to be present."));

        SerializationTests() {
        }

        boolean isCustomized(SecuritySettings securitySettings) {
            this.isCustomized.setAccessible(true);
            try {
                return (Boolean)this.isCustomized.invoke((Object)securitySettings, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Test
        void defaultSettingsShouldNotBeCustomizedWhenReadBack() throws IOException, ClassNotFoundException {
            SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().build();
            Assertions.assertFalse((boolean)this.isCustomized(securitySettings));
            SecuritySettings verify = TestUtil.serializeAndReadBack(securitySettings, SecuritySettings.class);
            Assertions.assertFalse((boolean)this.isCustomized(verify));
        }

        @Test
        void defaultsShouldBeCheckCorrect() throws IOException, ClassNotFoundException {
            SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withoutEncryption().withTrustStrategy(Config.TrustStrategy.trustSystemCertificates()).build();
            Assertions.assertFalse((boolean)this.isCustomized(securitySettings));
            SecuritySettings verify = TestUtil.serializeAndReadBack(securitySettings, SecuritySettings.class);
            Assertions.assertFalse((boolean)this.isCustomized(verify));
        }

        @Test
        void shouldReadBackChangedEncryption() throws IOException, ClassNotFoundException {
            SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withEncryption().withTrustStrategy(Config.TrustStrategy.trustSystemCertificates()).build();
            Assertions.assertTrue((boolean)this.isCustomized(securitySettings));
            Assertions.assertTrue((boolean)securitySettings.encrypted());
            SecuritySettings verify = TestUtil.serializeAndReadBack(securitySettings, SecuritySettings.class);
            Assertions.assertTrue((boolean)this.isCustomized(verify));
            Assertions.assertTrue((boolean)securitySettings.encrypted());
        }

        @Test
        void shouldReadBackChangedStrategey() throws IOException, ClassNotFoundException {
            SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withoutEncryption().withTrustStrategy(Config.TrustStrategy.trustAllCertificates()).build();
            Assertions.assertTrue((boolean)this.isCustomized(securitySettings));
            Assertions.assertFalse((boolean)securitySettings.encrypted());
            Assertions.assertEquals((Object)Config.TrustStrategy.trustAllCertificates().strategy(), (Object)securitySettings.trustStrategy().strategy());
            SecuritySettings verify = TestUtil.serializeAndReadBack(securitySettings, SecuritySettings.class);
            Assertions.assertTrue((boolean)this.isCustomized(verify));
            Assertions.assertFalse((boolean)securitySettings.encrypted());
            Assertions.assertEquals((Object)Config.TrustStrategy.trustAllCertificates().strategy(), (Object)securitySettings.trustStrategy().strategy());
        }

        @Test
        void shouldReadBackChangedCertFile() throws IOException, ClassNotFoundException {
            SecuritySettings securitySettings = new SecuritySettings.SecuritySettingsBuilder().withoutEncryption().withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File("some.cert")})).build();
            Assertions.assertTrue((boolean)this.isCustomized(securitySettings));
            Assertions.assertFalse((boolean)securitySettings.encrypted());
            Assertions.assertEquals((Object)Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File("some.cert")}).strategy(), (Object)securitySettings.trustStrategy().strategy());
            SecuritySettings verify = TestUtil.serializeAndReadBack(securitySettings, SecuritySettings.class);
            Assertions.assertTrue((boolean)this.isCustomized(verify));
            Assertions.assertFalse((boolean)securitySettings.encrypted());
            Assertions.assertEquals((Object)Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File("some.cert")}).strategy(), (Object)securitySettings.trustStrategy().strategy());
        }
    }
}

