/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.util.ValueFactory;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.DateValue;
import org.neo4j.driver.internal.value.DurationValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.LocalDateTimeValue;
import org.neo4j.driver.internal.value.LocalTimeValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.internal.value.TimeValue;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.Relationship;

class ValuesTest {
    ValuesTest() {
    }

    @Test
    void shouldConvertPrimitiveArrays() {
        MatcherAssert.assertThat((Object)Values.value((short[])new short[]{1, 2, 3}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1, 2, 3}))));
        MatcherAssert.assertThat((Object)Values.value((int[])new int[]{1, 2, 3}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1, 2, 3}))));
        MatcherAssert.assertThat((Object)Values.value((long[])new long[]{1L, 2L, 3L}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1, 2, 3}))));
        MatcherAssert.assertThat((Object)Values.value((float[])new float[]{1.1f, 2.2f, 3.3f}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)}))));
        MatcherAssert.assertThat((Object)Values.value((double[])new double[]{1.1, 2.2, 3.3}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1.1, 2.2, 3.3}))));
        MatcherAssert.assertThat((Object)Values.value((boolean[])new boolean[]{true, false, true}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{true, false, true}))));
        MatcherAssert.assertThat((Object)Values.value((char[])new char[]{'a', 'b', 'c'}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}))));
        MatcherAssert.assertThat((Object)Values.value((String[])new String[]{"a", "b", "c"}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{"a", "b", "c"}))));
    }

    @Test
    void shouldConvertPrimitiveArraysFromObject() {
        MatcherAssert.assertThat((Object)Values.value((Object)new short[]{1, 2, 3}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1, 2, 3}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new int[]{1, 2, 3}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1, 2, 3}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new long[]{1L, 2L, 3L}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1, 2, 3}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new float[]{1.1f, 2.2f, 3.3f}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f)}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new double[]{1.1, 2.2, 3.3}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{1.1, 2.2, 3.3}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new boolean[]{true, false, true}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{true, false, true}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new char[]{'a', 'b', 'c'}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}))));
        MatcherAssert.assertThat((Object)Values.value((Object)new String[]{"a", "b", "c"}), (Matcher)CoreMatchers.equalTo((Object)new ListValue(Values.values((Object[])new Object[]{"a", "b", "c"}))));
    }

    @Test
    void shouldComplainAboutStrangeTypes() {
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> Values.value((Object)new Object()));
        Assertions.assertEquals((Object)"Unable to convert java.lang.Object to Neo4j Value.", (Object)e.getMessage());
    }

    @Test
    void equalityRules() {
        Assertions.assertEquals((Object)Values.value((int)1), (Object)Values.value((int)1));
        Assertions.assertEquals((Object)Values.value((long)Long.MAX_VALUE), (Object)Values.value((long)Long.MAX_VALUE));
        Assertions.assertEquals((Object)Values.value((long)Long.MIN_VALUE), (Object)Values.value((long)Long.MIN_VALUE));
        Assertions.assertNotEquals((Object)Values.value((int)1), (Object)Values.value((int)2));
        Assertions.assertEquals((Object)Values.value((double)1.1337), (Object)Values.value((double)1.1337));
        Assertions.assertEquals((Object)Values.value((double)Double.MAX_VALUE), (Object)Values.value((double)Double.MAX_VALUE));
        Assertions.assertEquals((Object)Values.value((double)Double.MIN_VALUE), (Object)Values.value((double)Double.MIN_VALUE));
        Assertions.assertEquals((Object)Values.value((boolean)true), (Object)Values.value((boolean)true));
        Assertions.assertEquals((Object)Values.value((boolean)false), (Object)Values.value((boolean)false));
        Assertions.assertNotEquals((Object)Values.value((boolean)true), (Object)Values.value((boolean)false));
        Assertions.assertEquals((Object)Values.value((String)"Hello"), (Object)Values.value((String)"Hello"));
        Assertions.assertEquals((Object)Values.value((String)"This \u00e5\u00e4\u00f6 string ?? contains strange \u00dc"), (Object)Values.value((String)"This \u00e5\u00e4\u00f6 string ?? contains strange \u00dc"));
        Assertions.assertEquals((Object)Values.value((String)""), (Object)Values.value((String)""));
        Assertions.assertNotEquals((Object)Values.value((String)"Hello"), (Object)Values.value((String)"hello"));
        Assertions.assertNotEquals((Object)Values.value((String)"This \u00e5\u00e4\u00f6 string ?? contains strange "), (Object)Values.value((String)"This \u00e5\u00e4\u00f6 string ?? contains strange \u00dc"));
        Assertions.assertEquals((Object)Values.value((char)'A'), (Object)Values.value((char)'A'));
        Assertions.assertEquals((Object)Values.value((char)'A'), (Object)Values.value((String)"A"));
    }

    @Test
    void shouldMapDriverComplexTypesToListOfJavaPrimitiveTypes() {
        HashMap<String, ListValue> map = new HashMap<String, ListValue>();
        map.put("Cat", new ListValue(Values.values((Object[])new Object[]{"meow", "miaow"})));
        map.put("Dog", new ListValue(Values.values((Object[])new Object[]{"wow"})));
        map.put("Wrong", new ListValue(Values.values((Object[])new Object[]{-1})));
        MapValue mapValue = new MapValue(map);
        Iterable list = mapValue.values(Values.ofList((Function)Values.ofToString()));
        Assertions.assertEquals((int)3, (int)mapValue.size());
        Iterator listIterator = list.iterator();
        HashSet<String> setA = new HashSet<String>(3);
        HashSet<String> setB = new HashSet<String>(3);
        for (Value value : mapValue.values()) {
            String a = value.get(0).toString();
            String b = (String)((List)listIterator.next()).get(0);
            setA.add(a);
            setB.add(b);
        }
        MatcherAssert.assertThat(setA, (Matcher)CoreMatchers.equalTo(setB));
    }

    @Test
    void shouldMapDriverMapsToJavaMaps() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("Cat", Values.value((int)1));
        map.put("Dog", Values.value((int)2));
        MapValue values = new MapValue(map);
        Map result = values.asMap(Values.ofToString());
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(result.get("Dog"), (Matcher)CoreMatchers.equalTo((Object)"2"));
        MatcherAssert.assertThat(result.get("Cat"), (Matcher)CoreMatchers.equalTo((Object)"1"));
    }

    @Test
    void shouldNotBeAbleToGetKeysFromNonKeyedValue() {
        Assertions.assertThrows(ClientException.class, () -> Values.value((String)"asd").get(1));
    }

    @Test
    void shouldNotBeAbleToDoCrazyCoercions() {
        Assertions.assertThrows(ClientException.class, () -> Values.value((int)1).asPath());
    }

    @Test
    void shouldNotBeAbleToGetSizeOnNonSizedValues() {
        Assertions.assertThrows(ClientException.class, () -> Values.value((int)1).size());
    }

    @Test
    void shouldMapInteger() {
        Value val = Values.value((int[])new int[]{1, 2, 3});
        MatcherAssert.assertThat((Object)val.asList(Values.ofInteger()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Integer[]{1, 2, 3}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofLong()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Long[]{1L, 2L, 3L}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofNumber()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Number[]{1L, 2L, 3L}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofObject()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Object[]{1L, 2L, 3L}));
    }

    @Test
    void shouldMapFloat() {
        Value val = Values.value((double[])new double[]{1.0, 1.2, 3.2});
        MatcherAssert.assertThat((Object)val.asList(Values.ofDouble()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Double[]{1.0, 1.2, 3.2}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofNumber()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Number[]{1.0, 1.2, 3.2}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofObject()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Object[]{1.0, 1.2, 3.2}));
    }

    @Test
    void shouldMapFloatToJavaFloat() {
        Value val = Values.value((double[])new double[]{1.0, 2.0, 3.0});
        MatcherAssert.assertThat((Object)val.asList(Values.ofFloat()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}));
    }

    @Test
    void shouldMapString() {
        Value val = Values.value((String[])new String[]{"hello", "world"});
        MatcherAssert.assertThat((Object)val.asList(Values.ofString()), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"hello", "world"}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofObject()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Object[]{"hello", "world"}));
    }

    @Test
    void shouldMapMapOfString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hello", "world");
        Value val = Values.value(Arrays.asList(map, map));
        MatcherAssert.assertThat((Object)val.asList(Values.ofMap()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Map[]{map, map}));
        MatcherAssert.assertThat((Object)val.asList(Values.ofObject()), (Matcher)IsIterableContainingInOrder.contains((Object[])new Object[]{map, map}));
    }

    @Test
    void shouldHandleCollection() {
        ArrayDeque<String> collection = new ArrayDeque<String>();
        collection.add("hello");
        collection.add("world");
        Value val = Values.value(collection);
        MatcherAssert.assertThat((Object)val.asList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"hello", "world"}));
    }

    @Test
    void shouldHandleIterator() {
        Iterator<String> iterator = Arrays.asList("hello", "world").iterator();
        Value val = Values.value(iterator);
        MatcherAssert.assertThat((Object)val.asList(), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"hello", "world"}));
    }

    @Test
    void shouldCreateDateValueFromLocalDate() {
        LocalDate localDate = LocalDate.now();
        Value value = Values.value((LocalDate)localDate);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(DateValue.class));
        Assertions.assertEquals((Object)localDate, (Object)value.asLocalDate());
    }

    @Test
    void shouldCreateDateValue() {
        LocalDate localDate = LocalDate.now();
        Value value = Values.value((Object)localDate);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(DateValue.class));
        Assertions.assertEquals((Object)localDate, (Object)value.asObject());
    }

    @Test
    void shouldCreateTimeValueFromOffsetTime() {
        OffsetTime offsetTime = OffsetTime.now();
        Value value = Values.value((OffsetTime)offsetTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(TimeValue.class));
        Assertions.assertEquals((Object)offsetTime, (Object)value.asOffsetTime());
    }

    @Test
    void shouldCreateTimeValue() {
        OffsetTime offsetTime = OffsetTime.now();
        Value value = Values.value((OffsetTime)offsetTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(TimeValue.class));
        Assertions.assertEquals((Object)offsetTime, (Object)value.asObject());
    }

    @Test
    void shouldCreateLocalTimeValueFromLocalTime() {
        LocalTime localTime = LocalTime.now();
        Value value = Values.value((LocalTime)localTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(LocalTimeValue.class));
        Assertions.assertEquals((Object)localTime, (Object)value.asLocalTime());
    }

    @Test
    void shouldCreateLocalTimeValue() {
        LocalTime localTime = LocalTime.now();
        Value value = Values.value((LocalTime)localTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(LocalTimeValue.class));
        Assertions.assertEquals((Object)localTime, (Object)value.asObject());
    }

    @Test
    void shouldCreateLocalDateTimeValueFromLocalDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        Value value = Values.value((LocalDateTime)localDateTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(LocalDateTimeValue.class));
        Assertions.assertEquals((Object)localDateTime, (Object)value.asLocalDateTime());
    }

    @Test
    void shouldCreateLocalDateTimeValue() {
        LocalDateTime localDateTime = LocalDateTime.now();
        Value value = Values.value((LocalDateTime)localDateTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(LocalDateTimeValue.class));
        Assertions.assertEquals((Object)localDateTime, (Object)value.asObject());
    }

    @Test
    void shouldCreateDateTimeValueFromOffsetDateTime() {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Value value = Values.value((OffsetDateTime)offsetDateTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(DateTimeValue.class));
        Assertions.assertEquals((Object)offsetDateTime, (Object)value.asOffsetDateTime());
        Assertions.assertEquals((Object)offsetDateTime.toZonedDateTime(), (Object)value.asZonedDateTime());
        Assertions.assertEquals((Object)offsetDateTime.toZonedDateTime(), (Object)value.asObject());
    }

    @Test
    void shouldCreateDateTimeValueFromZonedDateTime() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Value value = Values.value((ZonedDateTime)zonedDateTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(DateTimeValue.class));
        Assertions.assertEquals((Object)zonedDateTime, (Object)value.asZonedDateTime());
    }

    @Test
    void shouldCreateDateTimeValue() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Value value = Values.value((ZonedDateTime)zonedDateTime);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(DateTimeValue.class));
        Assertions.assertEquals((Object)zonedDateTime, (Object)value.asObject());
    }

    @Test
    void shouldCreateIsoDurationValue() {
        Value value = Values.isoDuration((long)421L, (long)422L, (long)423L, (int)424);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.instanceOf(DurationValue.class));
        IsoDuration duration = value.asIsoDuration();
        Assertions.assertEquals((long)421L, (long)duration.months());
        Assertions.assertEquals((long)422L, (long)duration.days());
        Assertions.assertEquals((long)423L, (long)duration.seconds());
        Assertions.assertEquals((int)424, (int)duration.nanoseconds());
    }

    @Test
    void shouldCreateValueFromIsoDuration() {
        Value durationValue1 = Values.isoDuration((long)1L, (long)2L, (long)3L, (int)4);
        IsoDuration duration = durationValue1.asIsoDuration();
        Value durationValue2 = Values.value((Object)duration);
        Assertions.assertEquals((Object)duration, (Object)durationValue1.asIsoDuration());
        Assertions.assertEquals((Object)duration, (Object)durationValue2.asIsoDuration());
        Assertions.assertEquals((Object)durationValue1, (Object)durationValue2);
    }

    @Test
    void shouldCreateValueFromPeriod() {
        Period period = Period.of(5, 11, 190);
        Value value = Values.value((Period)period);
        IsoDuration isoDuration = value.asIsoDuration();
        Assertions.assertEquals((long)period.toTotalMonths(), (long)isoDuration.months());
        Assertions.assertEquals((long)period.getDays(), (long)isoDuration.days());
        Assertions.assertEquals((long)0L, (long)isoDuration.seconds());
        Assertions.assertEquals((int)0, (int)isoDuration.nanoseconds());
    }

    @Test
    void shouldCreateValueFromDuration() {
        Duration duration = Duration.ofSeconds(183951L, 4384718937L);
        Value value = Values.value((Duration)duration);
        IsoDuration isoDuration = value.asIsoDuration();
        Assertions.assertEquals((long)0L, (long)isoDuration.months());
        Assertions.assertEquals((long)0L, (long)isoDuration.days());
        Assertions.assertEquals((long)duration.getSeconds(), (long)isoDuration.seconds());
        Assertions.assertEquals((int)duration.getNano(), (int)isoDuration.nanoseconds());
    }

    @Test
    void shouldCreateValueFromPoint2D() {
        Value point2DValue1 = Values.point((int)1, (double)2.0, (double)3.0);
        Point point2D = point2DValue1.asPoint();
        Value point2DValue2 = Values.value((Object)point2D);
        Assertions.assertEquals((Object)point2D, (Object)point2DValue1.asPoint());
        Assertions.assertEquals((Object)point2D, (Object)point2DValue2.asPoint());
        Assertions.assertEquals((Object)point2DValue1, (Object)point2DValue2);
    }

    @Test
    void shouldCreateValueFromPoint3D() {
        Value point3DValue1 = Values.point((int)1, (double)2.0, (double)3.0, (double)4.0);
        Point point3D = point3DValue1.asPoint();
        Value point3DValue2 = Values.value((Object)point3D);
        Assertions.assertEquals((Object)point3D, (Object)point3DValue1.asPoint());
        Assertions.assertEquals((Object)point3D, (Object)point3DValue2.asPoint());
        Assertions.assertEquals((Object)point3DValue1, (Object)point3DValue2);
    }

    @Test
    void shouldCreateValueFromNodeValue() {
        NodeValue node = ValueFactory.emptyNodeValue();
        Value value = Values.value((Object)node);
        Assertions.assertEquals((Object)node, (Object)value);
    }

    @Test
    void shouldCreateValueFromNode() {
        Node node = ValueFactory.emptyNodeValue().asNode();
        Value value = Values.value((Object)node);
        Assertions.assertEquals((Object)node, (Object)value.asNode());
    }

    @Test
    void shouldCreateValueFromRelationshipValue() {
        RelationshipValue rel = ValueFactory.emptyRelationshipValue();
        Value value = Values.value((Object)rel);
        Assertions.assertEquals((Object)rel, (Object)value);
    }

    @Test
    void shouldCreateValueFromRelationship() {
        Relationship rel = ValueFactory.emptyRelationshipValue().asRelationship();
        Value value = Values.value((Object)rel);
        Assertions.assertEquals((Object)rel, (Object)value.asRelationship());
    }

    @Test
    void shouldCreateValueFromPathValue() {
        PathValue path = ValueFactory.filledPathValue();
        Value value = Values.value((Object)path);
        Assertions.assertEquals((Object)path, (Object)value);
    }

    @Test
    void shouldCreateValueFromPath() {
        Path path = ValueFactory.filledPathValue().asPath();
        Value value = Values.value((Object)path);
        Assertions.assertEquals((Object)path, (Object)value.asPath());
    }

    @Test
    void shouldCreateValueFromStream() {
        Stream<String> stream = Stream.of("foo", "bar", "baz", "qux");
        Value value = Values.value(stream);
        Assertions.assertEquals(Arrays.asList("foo", "bar", "baz", "qux"), (Object)value.asObject());
    }

    @Test
    void shouldFailToConvertStreamOfUnsupportedTypeToValue() {
        Stream<Object> stream = Stream.of(new Object(), new Object());
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> Values.value((Stream)stream));
        Assertions.assertEquals((Object)"Unable to convert java.lang.Object to Neo4j Value.", (Object)e.getMessage());
    }

    @Test
    void shouldCreateValueFromStreamOfStreams() {
        Stream<Stream> stream = Stream.of(Stream.of("foo", "bar"), Stream.of("baz", "qux"));
        Value value = Values.value(stream);
        Assertions.assertEquals(Arrays.asList(Arrays.asList("foo", "bar"), Arrays.asList("baz", "qux")), (Object)value.asObject());
    }

    @Test
    void shouldCreateValueFromStreamOfNulls() {
        Stream<Object> stream = Stream.of(null, null, null);
        Value value = Values.value(stream);
        Assertions.assertEquals(Arrays.asList(null, null, null), (Object)value.asObject());
    }
}

