/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.cursor.AsyncResultCursorImpl;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.InternalDatabaseInfo;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.internal.summary.InternalServerInfo;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.summary.QueryType;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.ServerInfo;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.util.TestUtil;

class AsyncResultCursorImplTest {
    AsyncResultCursorImplTest() {
    }

    @Test
    void shouldReturnQueryKeys() {
        RunResponseHandler runHandler = AsyncResultCursorImplTest.newRunResponseHandler();
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        List<String> keys = Arrays.asList("key1", "key2", "key3");
        runHandler.onSuccess(Collections.singletonMap("fields", Values.value(keys)));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(runHandler, pullAllHandler);
        Assertions.assertEquals(keys, (Object)cursor.keys());
    }

    @Test
    void shouldReturnSummary() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalResultSummary summary = new InternalResultSummary(new Query("RETURN 42"), (ServerInfo)new InternalServerInfo("Neo4j/4.2.5", BoltServerAddress.LOCAL_DEFAULT, TestUtil.anyServerVersion(), BoltProtocolV43.VERSION), InternalDatabaseInfo.DEFAULT_DATABASE_INFO, QueryType.SCHEMA_WRITE, (SummaryCounters)new InternalSummaryCounters(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0), null, null, Collections.emptyList(), 42L, 42L);
        Mockito.when((Object)pullAllHandler.consumeAsync()).thenReturn(CompletableFuture.completedFuture(summary));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals((Object)summary, TestUtil.await(cursor.consumeAsync()));
    }

    @Test
    void shouldReturnNextExistingRecord() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{1, 2}));
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn(CompletableFuture.completedFuture(record));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals((Object)record, TestUtil.await(cursor.nextAsync()));
    }

    @Test
    void shouldReturnNextNonExistingRecord() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn((Object)Futures.completedWithNull());
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertNull(TestUtil.await(cursor.nextAsync()));
    }

    @Test
    void shouldPeekExistingRecord() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{3, 2, 1}));
        Mockito.when((Object)pullAllHandler.peekAsync()).thenReturn(CompletableFuture.completedFuture(record));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals((Object)record, TestUtil.await(cursor.peekAsync()));
    }

    @Test
    void shouldPeekNonExistingRecord() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        Mockito.when((Object)pullAllHandler.peekAsync()).thenReturn((Object)Futures.completedWithNull());
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertNull(TestUtil.await(cursor.peekAsync()));
    }

    @Test
    void shouldReturnSingleRecord() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{42, 42}));
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn(CompletableFuture.completedFuture(record)).thenReturn((Object)Futures.completedWithNull());
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals((Object)record, TestUtil.await(cursor.singleAsync()));
    }

    @Test
    void shouldFailWhenAskedForSingleRecordButResultIsEmpty() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn((Object)Futures.completedWithNull());
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        NoSuchRecordException e = (NoSuchRecordException)Assertions.assertThrows(NoSuchRecordException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(cursor.singleAsync());
        });
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"result is empty"));
    }

    @Test
    void shouldFailWhenAskedForSingleRecordButResultContainsMore() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record1 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{1, 1}));
        InternalRecord record2 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{2, 2}));
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn(CompletableFuture.completedFuture(record1)).thenReturn(CompletableFuture.completedFuture(record2));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        NoSuchRecordException e = (NoSuchRecordException)Assertions.assertThrows(NoSuchRecordException.class, () -> {
            Record cfr_ignored_0 = (Record)TestUtil.await(cursor.singleAsync());
        });
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Ensure your query returns only one record"));
    }

    @Test
    void shouldForEachAsyncWhenResultContainsMultipleRecords() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record1 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{1, 1, 1}));
        InternalRecord record2 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{2, 2, 2}));
        InternalRecord record3 = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{3, 3, 3}));
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn(CompletableFuture.completedFuture(record1)).thenReturn(CompletableFuture.completedFuture(record2)).thenReturn(CompletableFuture.completedFuture(record3)).thenReturn((Object)Futures.completedWithNull());
        ResultSummary summary = (ResultSummary)Mockito.mock(ResultSummary.class);
        Mockito.when((Object)pullAllHandler.consumeAsync()).thenReturn(CompletableFuture.completedFuture(summary));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        CopyOnWriteArrayList records = new CopyOnWriteArrayList();
        CompletionStage summaryStage = cursor.forEachAsync(records::add);
        Assertions.assertEquals((Object)summary, TestUtil.await(summaryStage));
        Assertions.assertEquals(Arrays.asList(record1, record2, record3), records);
    }

    @Test
    void shouldForEachAsyncWhenResultContainsOneRecords() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record = new InternalRecord(Arrays.asList("key1", "key2", "key3"), Values.values((Object[])new Object[]{1, 1, 1}));
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn(CompletableFuture.completedFuture(record)).thenReturn((Object)Futures.completedWithNull());
        ResultSummary summary = (ResultSummary)Mockito.mock(ResultSummary.class);
        Mockito.when((Object)pullAllHandler.consumeAsync()).thenReturn(CompletableFuture.completedFuture(summary));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        CopyOnWriteArrayList records = new CopyOnWriteArrayList();
        CompletionStage summaryStage = cursor.forEachAsync(records::add);
        Assertions.assertEquals((Object)summary, TestUtil.await(summaryStage));
        Assertions.assertEquals(Collections.singletonList(record), records);
    }

    @Test
    void shouldForEachAsyncWhenResultContainsNoRecords() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn((Object)Futures.completedWithNull());
        ResultSummary summary = (ResultSummary)Mockito.mock(ResultSummary.class);
        Mockito.when((Object)pullAllHandler.consumeAsync()).thenReturn(CompletableFuture.completedFuture(summary));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        CopyOnWriteArrayList records = new CopyOnWriteArrayList();
        CompletionStage summaryStage = cursor.forEachAsync(records::add);
        Assertions.assertEquals((Object)summary, TestUtil.await(summaryStage));
        Assertions.assertEquals((int)0, (int)records.size());
    }

    @Test
    void shouldFailForEachWhenGivenActionThrows() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record1 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{1, 1}));
        InternalRecord record2 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{2, 2}));
        InternalRecord record3 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{3, 3}));
        Mockito.when((Object)pullAllHandler.nextAsync()).thenReturn(CompletableFuture.completedFuture(record1)).thenReturn(CompletableFuture.completedFuture(record2)).thenReturn(CompletableFuture.completedFuture(record3)).thenReturn((Object)Futures.completedWithNull());
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        AtomicInteger recordsProcessed = new AtomicInteger();
        RuntimeException error = new RuntimeException("Hello");
        CompletionStage stage = cursor.forEachAsync(record -> {
            if (record.get("key2").asInt() == 2) {
                throw error;
            }
            recordsProcessed.incrementAndGet();
        });
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            ResultSummary cfr_ignored_0 = (ResultSummary)TestUtil.await(stage);
        });
        Assertions.assertEquals((Object)error, (Object)e);
        Assertions.assertEquals((int)1, (int)recordsProcessed.get());
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler, (VerificationMode)Mockito.times((int)2))).nextAsync();
    }

    @Test
    void shouldReturnFailureWhenExists() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        ServiceUnavailableException error = new ServiceUnavailableException("Hi");
        Mockito.when((Object)pullAllHandler.pullAllFailureAsync()).thenReturn(CompletableFuture.completedFuture(error));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals((Object)error, TestUtil.await(cursor.pullAllFailureAsync()));
    }

    @Test
    void shouldReturnNullFailureWhenDoesNotExist() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        Mockito.when((Object)pullAllHandler.pullAllFailureAsync()).thenReturn((Object)Futures.completedWithNull());
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertNull(TestUtil.await(cursor.pullAllFailureAsync()));
    }

    @Test
    void shouldListAsyncWithoutMapFunction() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        InternalRecord record1 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{1, 1}));
        InternalRecord record2 = new InternalRecord(Arrays.asList("key1", "key2"), Values.values((Object[])new Object[]{2, 2}));
        List<Record> records = Arrays.asList(record1, record2);
        Mockito.when((Object)pullAllHandler.listAsync(Function.identity())).thenReturn(CompletableFuture.completedFuture(records));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals(records, TestUtil.await(cursor.listAsync()));
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler)).listAsync(Function.identity());
    }

    @Test
    void shouldListAsyncWithMapFunction() {
        Function<Record, String> mapFunction = record -> record.get(0).asString();
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        List<String> values = Arrays.asList("a", "b", "c", "d", "e");
        Mockito.when((Object)pullAllHandler.listAsync(mapFunction)).thenReturn(CompletableFuture.completedFuture(values));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals(values, TestUtil.await(cursor.listAsync(mapFunction)));
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler)).listAsync(mapFunction);
    }

    @Test
    void shouldPropagateFailureFromListAsyncWithoutMapFunction() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        RuntimeException error = new RuntimeException("Hi");
        Mockito.when((Object)pullAllHandler.listAsync(Function.identity())).thenReturn((Object)Futures.failedFuture((Throwable)error));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            List cfr_ignored_0 = (List)TestUtil.await(cursor.listAsync());
        });
        Assertions.assertEquals((Object)error, (Object)e);
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler)).listAsync(Function.identity());
    }

    @Test
    void shouldPropagateFailureFromListAsyncWithMapFunction() {
        Function<Record, String> mapFunction = record -> record.get(0).asString();
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        RuntimeException error = new RuntimeException("Hi");
        Mockito.when((Object)pullAllHandler.listAsync(mapFunction)).thenReturn((Object)Futures.failedFuture((Throwable)error));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            List cfr_ignored_0 = (List)TestUtil.await(cursor.listAsync(mapFunction));
        });
        Assertions.assertEquals((Object)error, (Object)e);
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler)).listAsync(mapFunction);
    }

    @Test
    void shouldConsumeAsync() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        ResultSummary summary = (ResultSummary)Mockito.mock(ResultSummary.class);
        Mockito.when((Object)pullAllHandler.consumeAsync()).thenReturn(CompletableFuture.completedFuture(summary));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        Assertions.assertEquals((Object)summary, TestUtil.await(cursor.consumeAsync()));
    }

    @Test
    void shouldPropagateFailureInConsumeAsync() {
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        RuntimeException error = new RuntimeException("Hi");
        Mockito.when((Object)pullAllHandler.consumeAsync()).thenReturn((Object)Futures.failedFuture((Throwable)error));
        AsyncResultCursorImpl cursor = AsyncResultCursorImplTest.newCursor(pullAllHandler);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            ResultSummary cfr_ignored_0 = (ResultSummary)TestUtil.await(cursor.consumeAsync());
        });
        Assertions.assertEquals((Object)error, (Object)e);
    }

    private static AsyncResultCursorImpl newCursor(PullAllResponseHandler pullAllHandler) {
        return new AsyncResultCursorImpl(null, AsyncResultCursorImplTest.newRunResponseHandler(), pullAllHandler);
    }

    private static AsyncResultCursorImpl newCursor(RunResponseHandler runHandler, PullAllResponseHandler pullAllHandler) {
        return new AsyncResultCursorImpl(null, runHandler, pullAllHandler);
    }

    private static RunResponseHandler newRunResponseHandler() {
        return new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
    }
}

