/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.InternalAsyncSession;
import org.neo4j.driver.internal.async.InternalAsyncTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.util.TestUtil;

class InternalAsyncTransactionTest {
    private Connection connection;
    private NetworkSession networkSession;
    private InternalAsyncTransaction tx;

    InternalAsyncTransactionTest() {
    }

    @BeforeEach
    void setUp() {
        this.connection = TestUtil.connectionMock(BoltProtocolV4.INSTANCE);
        ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProvider.acquireConnection((ConnectionContext)ArgumentMatchers.any(ConnectionContext.class))).thenReturn(CompletableFuture.completedFuture(this.connection));
        this.networkSession = TestUtil.newSession(connectionProvider);
        InternalAsyncSession session = new InternalAsyncSession(this.networkSession);
        this.tx = (InternalAsyncTransaction)TestUtil.await(session.beginTransactionAsync());
    }

    private static Stream<Function<AsyncTransaction, CompletionStage<ResultCursor>>> allSessionRunMethods() {
        return Stream.of(tx -> tx.runAsync("RETURN 1"), tx -> tx.runAsync("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1})), tx -> tx.runAsync("RETURN $x", Collections.singletonMap("x", 1)), tx -> tx.runAsync("RETURN $x", (Record)new InternalRecord(Collections.singletonList("x"), new Value[]{new IntegerValue(1L)})), tx -> tx.runAsync(new Query("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1}))));
    }

    @ParameterizedTest
    @MethodSource(value={"allSessionRunMethods"})
    void shouldFlushOnRun(Function<AsyncTransaction, CompletionStage<ResultCursor>> runReturnOne) {
        TestUtil.setupSuccessfulRunAndPull(this.connection);
        ResultCursor result = (ResultCursor)TestUtil.await(runReturnOne.apply((AsyncTransaction)this.tx));
        ResultSummary summary = (ResultSummary)TestUtil.await(result.consumeAsync());
        TestUtil.verifyRunAndPull(this.connection, summary.query().text());
    }

    @Test
    void shouldCommit() {
        TestUtil.await(this.tx.commitAsync());
        TestUtil.verifyCommitTx(this.connection);
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldRollback() {
        TestUtil.await(this.tx.rollbackAsync());
        TestUtil.verifyRollbackTx(this.connection);
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldRollbackWhenFailedRun() {
        Futures.blockingGet((CompletionStage)this.networkSession.resetAsync());
        ClientException clientException = (ClientException)Assertions.assertThrows(ClientException.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(this.tx.commitAsync());
        });
        Assert.assertThat((Object)clientException.getMessage(), (Matcher)CoreMatchers.containsString((String)"It has been rolled back either because of an error or explicit termination"));
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldReleaseConnectionWhenFailedToCommit() {
        TestUtil.setupFailingCommit(this.connection);
        Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(this.tx.commitAsync());
        });
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }

    @Test
    void shouldReleaseConnectionWhenFailedToRollback() {
        TestUtil.setupFailingRollback(this.connection);
        Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)TestUtil.await(this.tx.rollbackAsync());
        });
        ((Connection)Mockito.verify((Object)this.connection)).release();
        Assert.assertFalse((boolean)this.tx.isOpen());
    }
}

