/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoop;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.NetworkConnection;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.request.RunWithMetadataMessage;
import org.neo4j.driver.internal.metrics.DevNullMetricsListener;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.util.DaemonThreadFactory;
import org.neo4j.driver.util.TestUtil;

class NetworkConnectionTest {
    private static final NoOpResponseHandler NO_OP_HANDLER = NoOpResponseHandler.INSTANCE;
    private ExecutorService executor;
    private EventLoop eventLoop;

    NetworkConnectionTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        this.shutdownEventLoop();
    }

    @Test
    void shouldBeOpenAfterCreated() {
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        Assertions.assertTrue((boolean)connection.isOpen());
    }

    @Test
    void shouldNotBeOpenAfterRelease() {
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.release();
        Assertions.assertFalse((boolean)connection.isOpen());
    }

    @Test
    void shouldSendResetOnRelease() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)ResetMessage.RESET, (Object)channel.readOutbound());
    }

    @Test
    void shouldWriteInEventLoopThread() throws Exception {
        this.testWriteInEventLoop("WriteSingleMessage", connection -> connection.write((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), (ResponseHandler)NO_OP_HANDLER));
        this.testWriteInEventLoop("WriteMultipleMessages", connection -> connection.write((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), (ResponseHandler)NO_OP_HANDLER, (Message)PullAllMessage.PULL_ALL, (ResponseHandler)NO_OP_HANDLER));
    }

    @Test
    void shouldWriteAndFlushInEventLoopThread() throws Exception {
        this.testWriteInEventLoop("WriteAndFlushSingleMessage", connection -> connection.writeAndFlush((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), (ResponseHandler)NO_OP_HANDLER));
        this.testWriteInEventLoop("WriteAndFlushMultipleMessages", connection -> connection.writeAndFlush((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), (ResponseHandler)NO_OP_HANDLER, (Message)PullAllMessage.PULL_ALL, (ResponseHandler)NO_OP_HANDLER));
    }

    @Test
    void shouldWriteForceReleaseInEventLoopThread() throws Exception {
        this.testWriteInEventLoop("ReleaseTestEventLoop", NetworkConnection::release);
    }

    @Test
    void shouldFlushInEventLoopThread() throws Exception {
        EmbeddedChannel channel = (EmbeddedChannel)Mockito.spy((Object)new EmbeddedChannel());
        this.initializeEventLoop((Channel)channel, "Flush");
        ChannelAttributes.setProtocolVersion((Channel)channel, (BoltProtocolVersion)TestUtil.DEFAULT_TEST_PROTOCOL_VERSION);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.flush();
        this.shutdownEventLoop();
        ((EmbeddedChannel)Mockito.verify((Object)channel)).flush();
    }

    @Test
    void shouldEnableAutoReadWhenReleased() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        channel.config().setAutoRead(false);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        channel.runPendingTasks();
        Assertions.assertTrue((boolean)channel.config().isAutoRead());
    }

    @Test
    void shouldNotDisableAutoReadWhenReleased() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        channel.config().setAutoRead(true);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        connection.disableAutoRead();
        Assertions.assertTrue((boolean)channel.config().isAutoRead());
    }

    @Test
    void shouldWriteSingleMessage() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.write((Message)PullAllMessage.PULL_ALL, (ResponseHandler)NO_OP_HANDLER);
        Assertions.assertEquals((int)0, (int)channel.outboundMessages().size());
        channel.flushOutbound();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)PullAllMessage.PULL_ALL, (Object)Iterables.single((Iterable)channel.outboundMessages()));
    }

    @Test
    void shouldWriteMultipleMessage() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.write((Message)PullAllMessage.PULL_ALL, (ResponseHandler)NO_OP_HANDLER, (Message)ResetMessage.RESET, (ResponseHandler)NO_OP_HANDLER);
        Assertions.assertEquals((int)0, (int)channel.outboundMessages().size());
        channel.flushOutbound();
        Assertions.assertEquals((int)2, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)PullAllMessage.PULL_ALL, channel.outboundMessages().poll());
        Assertions.assertEquals((Object)ResetMessage.RESET, channel.outboundMessages().poll());
    }

    @Test
    void shouldWriteAndFlushSingleMessage() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.writeAndFlush((Message)PullAllMessage.PULL_ALL, (ResponseHandler)NO_OP_HANDLER);
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)PullAllMessage.PULL_ALL, (Object)Iterables.single((Iterable)channel.outboundMessages()));
    }

    @Test
    void shouldWriteAndFlushMultipleMessage() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.writeAndFlush((Message)PullAllMessage.PULL_ALL, (ResponseHandler)NO_OP_HANDLER, (Message)ResetMessage.RESET, (ResponseHandler)NO_OP_HANDLER);
        channel.runPendingTasks();
        Assertions.assertEquals((int)2, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)PullAllMessage.PULL_ALL, channel.outboundMessages().poll());
        Assertions.assertEquals((Object)ResetMessage.RESET, channel.outboundMessages().poll());
    }

    @Test
    void shouldNotWriteSingleMessageWhenReleased() {
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.release();
        connection.write((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), handler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)handler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionReleasedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteMultipleMessagesWhenReleased() {
        ResponseHandler runHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        ResponseHandler pullAllHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.release();
        connection.write((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), runHandler, (Message)PullAllMessage.PULL_ALL, pullAllHandler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)runHandler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionReleasedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteAndFlushSingleMessageWhenReleased() {
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.release();
        connection.writeAndFlush((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), handler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)handler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionReleasedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteAndFlushMultipleMessagesWhenReleased() {
        ResponseHandler runHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        ResponseHandler pullAllHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.release();
        connection.writeAndFlush((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), runHandler, (Message)PullAllMessage.PULL_ALL, pullAllHandler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)runHandler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionReleasedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteSingleMessageWhenTerminated() {
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.terminateAndRelease("42");
        connection.write((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), handler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)handler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionTerminatedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteMultipleMessagesWhenTerminated() {
        ResponseHandler runHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        ResponseHandler pullAllHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.terminateAndRelease("42");
        connection.write((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), runHandler, (Message)PullAllMessage.PULL_ALL, pullAllHandler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)runHandler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionTerminatedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteAndFlushSingleMessageWhenTerminated() {
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.terminateAndRelease("42");
        connection.writeAndFlush((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), handler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)handler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionTerminatedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldNotWriteAndFlushMultipleMessagesWhenTerminated() {
        ResponseHandler runHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        ResponseHandler pullAllHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)NetworkConnectionTest.newChannel());
        connection.terminateAndRelease("42");
        connection.writeAndFlush((Message)RunWithMetadataMessage.unmanagedTxRunMessage((Query)new Query("RETURN 1")), runHandler, (Message)PullAllMessage.PULL_ALL, pullAllHandler);
        ArgumentCaptor failureCaptor = ArgumentCaptor.forClass(IllegalStateException.class);
        ((ResponseHandler)Mockito.verify((Object)runHandler)).onFailure((Throwable)failureCaptor.capture());
        NetworkConnectionTest.assertConnectionTerminatedError((IllegalStateException)failureCaptor.getValue());
    }

    @Test
    void shouldReturnServerAgentWhenCreated() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        String agent = "Neo4j/4.2.5";
        ChannelAttributes.setServerAgent((Channel)channel, (String)agent);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        Assertions.assertEquals((Object)agent, (Object)connection.serverAgent());
    }

    @Test
    void shouldReturnServerAgentWhenReleased() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        String agent = "Neo4j/4.2.5";
        ChannelAttributes.setServerAgent((Channel)channel, (String)agent);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        Assertions.assertEquals((Object)agent, (Object)connection.serverAgent());
    }

    @Test
    void shouldReturnServerAddressWhenReleased() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        BoltServerAddress address = new BoltServerAddress("host", 4242);
        ChannelAttributes.setServerAddress((Channel)channel, (BoltServerAddress)address);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        Assertions.assertEquals((Object)address, (Object)connection.serverAddress());
    }

    @Test
    void shouldReturnServerVersionWhenReleased() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        ServerVersion version = TestUtil.anyServerVersion();
        ChannelAttributes.setServerVersion((Channel)channel, (ServerVersion)version);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        Assertions.assertEquals((Object)version, (Object)connection.serverVersion());
    }

    @Test
    void shouldReturnSameCompletionStageFromRelease() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        CompletionStage releaseStage1 = connection.release();
        CompletionStage releaseStage2 = connection.release();
        CompletionStage releaseStage3 = connection.release();
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)ResetMessage.RESET, channel.outboundMessages().poll());
        Assertions.assertEquals((Object)releaseStage1, (Object)releaseStage2);
        Assertions.assertEquals((Object)releaseStage2, (Object)releaseStage3);
    }

    @Test
    void shouldEnableAutoRead() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        channel.config().setAutoRead(false);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.enableAutoRead();
        Assertions.assertTrue((boolean)channel.config().isAutoRead());
    }

    @Test
    void shouldDisableAutoRead() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        channel.config().setAutoRead(true);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.disableAutoRead();
        Assertions.assertFalse((boolean)channel.config().isAutoRead());
    }

    @Test
    void shouldSetTerminationReasonOnChannelWhenTerminated() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        String reason = "Something really bad has happened";
        connection.terminateAndRelease(reason);
        Assertions.assertEquals((Object)reason, (Object)ChannelAttributes.terminationReason((Channel)channel));
    }

    @Test
    void shouldCloseChannelWhenTerminated() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        Assertions.assertTrue((boolean)channel.isActive());
        connection.terminateAndRelease("test");
        Assertions.assertFalse((boolean)channel.isActive());
    }

    @Test
    void shouldReleaseChannelWhenTerminated() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        ExtendedChannelPool pool = (ExtendedChannelPool)Mockito.mock(ExtendedChannelPool.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel, pool);
        ((ExtendedChannelPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.never())).release((Channel)ArgumentMatchers.any());
        connection.terminateAndRelease("test");
        ((ExtendedChannelPool)Mockito.verify((Object)pool)).release((Channel)channel);
    }

    @Test
    void shouldNotReleaseChannelMultipleTimesWhenTerminatedMultipleTimes() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        ExtendedChannelPool pool = (ExtendedChannelPool)Mockito.mock(ExtendedChannelPool.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel, pool);
        ((ExtendedChannelPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.never())).release((Channel)ArgumentMatchers.any());
        connection.terminateAndRelease("reason 1");
        connection.terminateAndRelease("reason 2");
        connection.terminateAndRelease("reason 3");
        Assertions.assertEquals((Object)"reason 1", (Object)ChannelAttributes.terminationReason((Channel)channel));
        ((ExtendedChannelPool)Mockito.verify((Object)pool)).release((Channel)channel);
    }

    @Test
    void shouldNotReleaseAfterTermination() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        ExtendedChannelPool pool = (ExtendedChannelPool)Mockito.mock(ExtendedChannelPool.class);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel, pool);
        ((ExtendedChannelPool)Mockito.verify((Object)pool, (VerificationMode)Mockito.never())).release((Channel)ArgumentMatchers.any());
        connection.terminateAndRelease("test");
        CompletionStage releaseStage = connection.release();
        Assertions.assertTrue((boolean)releaseStage.toCompletableFuture().isDone());
        ((ExtendedChannelPool)Mockito.verify((Object)pool)).release((Channel)channel);
    }

    @Test
    void shouldSendResetMessageWhenReset() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.reset();
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)ResetMessage.RESET, (Object)channel.readOutbound());
    }

    @Test
    void shouldCompleteResetFutureWhenSuccessResponseArrives() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        CompletableFuture resetFuture = connection.reset().toCompletableFuture();
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)resetFuture.isDone());
        ChannelAttributes.messageDispatcher((Channel)channel).handleSuccessMessage(Collections.emptyMap());
        Assertions.assertTrue((boolean)resetFuture.isDone());
        Assertions.assertFalse((boolean)resetFuture.isCompletedExceptionally());
    }

    @Test
    void shouldCompleteResetFutureWhenFailureResponseArrives() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        CompletableFuture resetFuture = connection.reset().toCompletableFuture();
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)resetFuture.isDone());
        ChannelAttributes.messageDispatcher((Channel)channel).handleFailureMessage("Neo.TransientError.Transaction.Terminated", "Message");
        Assertions.assertTrue((boolean)resetFuture.isDone());
        Assertions.assertFalse((boolean)resetFuture.isCompletedExceptionally());
    }

    @Test
    void shouldDoNothingInResetWhenClosed() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.release();
        channel.runPendingTasks();
        CompletableFuture resetFuture = connection.reset().toCompletableFuture();
        channel.runPendingTasks();
        Assertions.assertEquals((int)1, (int)channel.outboundMessages().size());
        Assertions.assertEquals((Object)ResetMessage.RESET, (Object)channel.readOutbound());
        Assertions.assertTrue((boolean)resetFuture.isDone());
        Assertions.assertFalse((boolean)resetFuture.isCompletedExceptionally());
    }

    @Test
    void shouldEnableAutoReadWhenDoingReset() {
        EmbeddedChannel channel = NetworkConnectionTest.newChannel();
        channel.config().setAutoRead(false);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        connection.reset();
        channel.runPendingTasks();
        Assertions.assertTrue((boolean)channel.config().isAutoRead());
    }

    private void testWriteInEventLoop(String threadName, Consumer<NetworkConnection> action) throws Exception {
        EmbeddedChannel channel = (EmbeddedChannel)Mockito.spy((Object)new EmbeddedChannel());
        this.initializeEventLoop((Channel)channel, threadName);
        ThreadTrackingInboundMessageDispatcher dispatcher = new ThreadTrackingInboundMessageDispatcher((Channel)channel);
        ChannelAttributes.setProtocolVersion((Channel)channel, (BoltProtocolVersion)TestUtil.DEFAULT_TEST_PROTOCOL_VERSION);
        ChannelAttributes.setMessageDispatcher((Channel)channel, (InboundMessageDispatcher)dispatcher);
        NetworkConnection connection = NetworkConnectionTest.newConnection((Channel)channel);
        action.accept(connection);
        this.shutdownEventLoop();
        MatcherAssert.assertThat((Object)Iterables.single(dispatcher.queueThreadNames), (Matcher)Matchers.startsWith((String)threadName));
    }

    private void initializeEventLoop(Channel channel, String namePrefix) {
        this.executor = Executors.newSingleThreadExecutor(DaemonThreadFactory.daemon(namePrefix));
        this.eventLoop = new DefaultEventLoop((Executor)this.executor);
        Mockito.when((Object)channel.eventLoop()).thenReturn((Object)this.eventLoop);
    }

    private void shutdownEventLoop() throws Exception {
        if (this.eventLoop != null) {
            this.eventLoop.shutdownGracefully();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            Assertions.assertTrue((boolean)this.executor.awaitTermination(30L, TimeUnit.SECONDS));
        }
    }

    private static EmbeddedChannel newChannel() {
        EmbeddedChannel channel = new EmbeddedChannel();
        InboundMessageDispatcher messageDispatcher = new InboundMessageDispatcher((Channel)channel, DevNullLogging.DEV_NULL_LOGGING);
        ChannelAttributes.setProtocolVersion((Channel)channel, (BoltProtocolVersion)TestUtil.DEFAULT_TEST_PROTOCOL_VERSION);
        ChannelAttributes.setMessageDispatcher((Channel)channel, (InboundMessageDispatcher)messageDispatcher);
        return channel;
    }

    private static NetworkConnection newConnection(Channel channel) {
        return NetworkConnectionTest.newConnection(channel, (ExtendedChannelPool)Mockito.mock(ExtendedChannelPool.class));
    }

    private static NetworkConnection newConnection(Channel channel, ExtendedChannelPool pool) {
        return new NetworkConnection(channel, pool, (Clock)new FakeClock(), (MetricsListener)DevNullMetricsListener.INSTANCE, DevNullLogging.DEV_NULL_LOGGING);
    }

    private static void assertConnectionReleasedError(IllegalStateException e) {
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Connection has been released"));
    }

    private static void assertConnectionTerminatedError(IllegalStateException e) {
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Connection has been terminated"));
    }

    private static class ThreadTrackingInboundMessageDispatcher
    extends InboundMessageDispatcher {
        final Set<String> queueThreadNames = ConcurrentHashMap.newKeySet();

        ThreadTrackingInboundMessageDispatcher(Channel channel) {
            super(channel, DevNullLogging.DEV_NULL_LOGGING);
        }

        public void enqueue(ResponseHandler handler) {
            this.queueThreadNames.add(Thread.currentThread().getName());
            super.enqueue(handler);
        }
    }
}

