/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.cursor.AsyncResultCursorImpl;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class ResultCursorsHolderTest {
    ResultCursorsHolderTest() {
    }

    @Test
    void shouldReturnNoErrorWhenNoCursorStages() {
        ResultCursorsHolder holder = new ResultCursorsHolder();
        Throwable error = (Throwable)TestUtil.await(holder.retrieveNotConsumedError());
        Assertions.assertNull((Object)error);
    }

    @Test
    void shouldFailToAddNullCursorStage() {
        ResultCursorsHolder holder = new ResultCursorsHolder();
        Assertions.assertThrows(NullPointerException.class, () -> holder.add(null));
    }

    @Test
    void shouldReturnNoErrorWhenCursorStagesHaveNoErrors() {
        ResultCursorsHolder holder = new ResultCursorsHolder();
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        Throwable error = (Throwable)TestUtil.await(holder.retrieveNotConsumedError());
        Assertions.assertNull((Object)error);
    }

    @Test
    void shouldNotReturnStageErrors() {
        ResultCursorsHolder holder = new ResultCursorsHolder();
        holder.add((CompletionStage)Futures.failedFuture((Throwable)new RuntimeException("Failed to acquire a connection")));
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add((CompletionStage)Futures.failedFuture((Throwable)new IOException("Failed to do IO")));
        Throwable error = (Throwable)TestUtil.await(holder.retrieveNotConsumedError());
        Assertions.assertNull((Object)error);
    }

    @Test
    void shouldReturnErrorWhenOneCursorFailed() {
        IOException error = new IOException("IO failed");
        ResultCursorsHolder holder = new ResultCursorsHolder();
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithError(error));
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        Throwable retrievedError = (Throwable)TestUtil.await(holder.retrieveNotConsumedError());
        Assertions.assertEquals((Object)error, (Object)retrievedError);
    }

    @Test
    void shouldReturnFirstError() {
        RuntimeException error1 = new RuntimeException("Error 1");
        IOException error2 = new IOException("Error 2");
        TimeoutException error3 = new TimeoutException("Error 3");
        ResultCursorsHolder holder = new ResultCursorsHolder();
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithError(error1));
        holder.add(ResultCursorsHolderTest.cursorWithError(error2));
        holder.add(ResultCursorsHolderTest.cursorWithError(error3));
        Assertions.assertEquals((Object)error1, TestUtil.await(holder.retrieveNotConsumedError()));
    }

    @Test
    void shouldWaitForAllFailuresToArrive() {
        RuntimeException error1 = new RuntimeException("Error 1");
        CompletableFuture<Throwable> error2Future = new CompletableFuture<Throwable>();
        ResultCursorsHolder holder = new ResultCursorsHolder();
        holder.add(ResultCursorsHolderTest.cursorWithoutError());
        holder.add(ResultCursorsHolderTest.cursorWithError(error1));
        holder.add(ResultCursorsHolderTest.cursorWithFailureFuture(error2Future));
        CompletableFuture failureFuture = holder.retrieveNotConsumedError().toCompletableFuture();
        Assertions.assertFalse((boolean)failureFuture.isDone());
        error2Future.complete(null);
        Assertions.assertTrue((boolean)failureFuture.isDone());
        Assertions.assertEquals((Object)error1, TestUtil.await(failureFuture));
    }

    private static CompletionStage<AsyncResultCursorImpl> cursorWithoutError() {
        return ResultCursorsHolderTest.cursorWithError(null);
    }

    private static CompletionStage<AsyncResultCursorImpl> cursorWithError(Throwable error) {
        return ResultCursorsHolderTest.cursorWithFailureFuture(CompletableFuture.completedFuture(error));
    }

    private static CompletionStage<AsyncResultCursorImpl> cursorWithFailureFuture(CompletableFuture<Throwable> future) {
        AsyncResultCursorImpl cursor = (AsyncResultCursorImpl)Mockito.mock(AsyncResultCursorImpl.class);
        Mockito.when((Object)cursor.discardAllFailureAsync()).thenReturn(future);
        return CompletableFuture.completedFuture(cursor);
    }
}

