/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.util.TestUtil;

class BoltProtocolUtilTest {
    BoltProtocolUtilTest() {
    }

    @Test
    void shouldReturnHandshakeBuf() {
        TestUtil.assertByteBufContains(BoltProtocolUtil.handshakeBuf(), 1616949271, 0x20000 | BoltProtocolV44.VERSION.toInt(), BoltProtocolV41.VERSION.toInt(), BoltProtocolV4.VERSION.toInt(), BoltProtocolV3.VERSION.toInt());
    }

    @Test
    void shouldReturnHandshakeString() {
        Assertions.assertEquals((Object)"[0x6060b017, 132100, 260, 4, 3]", (Object)BoltProtocolUtil.handshakeString());
    }

    @Test
    void shouldWriteMessageBoundary() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(1);
        buf.writeInt(2);
        buf.writeInt(3);
        BoltProtocolUtil.writeMessageBoundary((ByteBuf)buf);
        TestUtil.assertByteBufContains(buf, 1, 2, 3, (byte)0, (byte)0);
    }

    @Test
    void shouldWriteEmptyChunkHeader() {
        ByteBuf buf = Unpooled.buffer();
        BoltProtocolUtil.writeEmptyChunkHeader((ByteBuf)buf);
        buf.writeInt(1);
        buf.writeInt(2);
        buf.writeInt(3);
        TestUtil.assertByteBufContains(buf, (byte)0, (byte)0, 1, 2, 3);
    }

    @Test
    void shouldWriteChunkHeader() {
        ByteBuf buf = Unpooled.buffer();
        BoltProtocolUtil.writeEmptyChunkHeader((ByteBuf)buf);
        buf.writeInt(1);
        buf.writeInt(2);
        buf.writeInt(3);
        BoltProtocolUtil.writeChunkHeader((ByteBuf)buf, (int)0, (int)42);
        TestUtil.assertByteBufContains(buf, (short)42, 1, 2, 3);
    }
}

