/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.net.ServerAddress;

class DecoratedConnectionTest {
    DecoratedConnectionTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"true", "false"})
    void shouldDelegateIsOpen(String open) {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)mockConnection.isOpen()).thenReturn((Object)Boolean.valueOf(open));
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Assertions.assertEquals((Object)Boolean.valueOf(open), (Object)connection.isOpen());
        ((Connection)Mockito.verify((Object)mockConnection)).isOpen();
    }

    @Test
    void shouldDelegateEnableAutoRead() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        connection.enableAutoRead();
        ((Connection)Mockito.verify((Object)mockConnection)).enableAutoRead();
    }

    @Test
    void shouldDelegateDisableAutoRead() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        connection.disableAutoRead();
        ((Connection)Mockito.verify((Object)mockConnection)).disableAutoRead();
    }

    @Test
    void shouldDelegateWrite() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Message message = (Message)Mockito.mock(Message.class);
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        connection.write(message, handler);
        ((Connection)Mockito.verify((Object)mockConnection)).write(message, handler);
    }

    @Test
    void shouldDelegateWriteTwoMessages() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Message message1 = (Message)Mockito.mock(Message.class);
        ResponseHandler handler1 = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        Message message2 = (Message)Mockito.mock(Message.class);
        ResponseHandler handler2 = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        connection.write(message1, handler1, message2, handler2);
        ((Connection)Mockito.verify((Object)mockConnection)).write(message1, handler1, message2, handler2);
    }

    @Test
    void shouldDelegateWriteAndFlush() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Message message = (Message)Mockito.mock(Message.class);
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        connection.writeAndFlush(message, handler);
        ((Connection)Mockito.verify((Object)mockConnection)).writeAndFlush(message, handler);
    }

    @Test
    void shouldDelegateWriteAndFlush1() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Message message1 = (Message)Mockito.mock(Message.class);
        ResponseHandler handler1 = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        Message message2 = (Message)Mockito.mock(Message.class);
        ResponseHandler handler2 = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        connection.writeAndFlush(message1, handler1, message2, handler2);
        ((Connection)Mockito.verify((Object)mockConnection)).writeAndFlush(message1, handler1, message2, handler2);
    }

    @Test
    void shouldDelegateReset() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        connection.reset();
        ((Connection)Mockito.verify((Object)mockConnection)).reset();
    }

    @Test
    void shouldDelegateRelease() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        connection.release();
        ((Connection)Mockito.verify((Object)mockConnection)).release();
    }

    @Test
    void shouldDelegateTerminateAndRelease() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        connection.terminateAndRelease("a reason");
        ((Connection)Mockito.verify((Object)mockConnection)).terminateAndRelease("a reason");
    }

    @Test
    void shouldDelegateServerAddress() {
        BoltServerAddress address = BoltServerAddress.from((ServerAddress)ServerAddress.of((String)"localhost", (int)9999));
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)mockConnection.serverAddress()).thenReturn((Object)address);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Assertions.assertSame((Object)address, (Object)connection.serverAddress());
        ((Connection)Mockito.verify((Object)mockConnection)).serverAddress();
    }

    @Test
    void shouldDelegateServerVersion() {
        ServerVersion version = ServerVersion.version((String)"Neo4j/3.5.3");
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)mockConnection.serverVersion()).thenReturn((Object)version);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Assertions.assertSame((Object)version, (Object)connection.serverVersion());
        ((Connection)Mockito.verify((Object)mockConnection)).serverVersion();
    }

    @Test
    void shouldDelegateProtocol() {
        BoltProtocol protocol = (BoltProtocol)Mockito.mock(BoltProtocol.class);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)mockConnection.protocol()).thenReturn((Object)protocol);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Assertions.assertSame((Object)protocol, (Object)connection.protocol());
        ((Connection)Mockito.verify((Object)mockConnection)).protocol();
    }

    @ParameterizedTest
    @EnumSource(value=AccessMode.class)
    void shouldReturnModeFromConstructor(AccessMode mode) {
        DirectConnection connection = new DirectConnection((Connection)Mockito.mock(Connection.class), DatabaseNameUtil.defaultDatabase(), mode, null);
        Assertions.assertEquals((Object)mode, (Object)connection.mode());
    }

    @Test
    void shouldReturnConnection() {
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DirectConnection connection = DecoratedConnectionTest.newConnection(mockConnection);
        Assertions.assertSame((Object)mockConnection, (Object)connection.connection());
    }

    private static DirectConnection newConnection(Connection connection) {
        return new DirectConnection(connection, DatabaseNameUtil.defaultDatabase(), AccessMode.READ, null);
    }
}

